/*****************************************************************************
 *
 * (c) Copyright 1996, KL GROUP INC.
 * ALL RIGHTS RESERVED
 *
 *  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED
 * AND COPIED ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND
 * WITH THE INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR
 * ANY OTHER COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE
 * AVAILABLE TO ANY OTHER PERSON.  NO TITLE TO AND OWNERSHIP OF THE
 * SOFTWARE IS HEREBY TRANSFERRED.
 *
 *  THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT
 * NOTICE AND SHOULD NOT BE CONSTRUED AS A COMMITMENT BY KL GROUP INC.
 * OR ITS THIRD PARTY SUPPLIERS.
 *
 *  KL GROUP INC. AND ITS THIRD PARTY SUPPLIERS, ASSUME NO RESPONSIBILITY
 * FOR THE USE OR INABILITY TO USE ANY OF ITS SOFTWARE.   THIS SOFTWARE IS
 * PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, AND KL GROUP INC. EXPRESSLY
 * DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Notice:  Notwithstanding any other lease or license that may pertain to,
 * or accompany the delivery of, this computer software, the rights of the
 * Government regarding its use, reproduction and disclosure are as set
 * forth in Section 52.227-19 of the FARS Computer Software-Restricted
 * Rights clause.
 *
 * (c) Copyright 1996 KL Group Inc.  Unpublished - all
 * rights reserved under the Copyright laws of the United States.
 *
 * RESTRICTED RIGHTS NOTICE:  Use, duplication, or disclosure by the
 * Government is subject to the restrictions as set forth in subparagraph
 * (c)(1)(ii) of the Rights in Technical Data and Computer Software clause
 * at DFARS 52.227-7013.
 *
 * KL Group Inc.
 * 260 King Street East
 * Suite 300
 * Toronto, Ontario
 * Canada M5A 1K3
 * (416) 594-1026
 * (416) 594-1919 (FAX)
 *
 * RESTRICTED RIGHTS LEGEND:  This computer software is submitted with
 * "restricted rights."  Use, duplication or disclosure is subject to the
 * restrictions as set forth in NASA FAR SUP 18-52.227-79 (April 1985)
 * "Commercial Computer Software- Restricted Rights (April 1985)."  KL Group
 * Inc., 300-260 King Street E., Toronto, Ontario, Canada M5A 1K3.  If
 * the contract contains the Clause at 18-52.227-74 "Rights in Data General"
 * then the "Alternate III" clause applies.
 *
 * (c) Copyright 1996 KL Group Inc.
 * ALL RIGHTS RESERVED
 *
 *****************************************************************************/

//   RCSID -- $RCSfile: JCRetrieve.java $ $Revision: 2.1 $
//            $Date: 1997/10/14 14:43:21 $  $Locker: $  KL Group Inc.

package jclass.contrib;

import java.net.*;
import java.io.*;
import java.util.Vector;
import jclass.util.JCCache;

public abstract class JCRetrieve {

	/** The host name for the cgi-bin script. */
private String host;
	/** The port for connecting to the cgi-bin script. */
private int port;
	/** The name of cgi-bin script. */
private String script;

	/** This local cache is used to minimize the number of times the
	 * cgi-bin script is accessed. */
protected JCCache cache = new JCCache(30, 30);

	/**
	 * The constructor. It must specify a URL to the
	 * cgi-bin script and the name of the script to be run.
	 */
public JCRetrieve(String url, String script) {
    setURL(url, script);
}

	/**
	 * Changes the host, port number and cgi-bin script according to
	 * the data provided.
	 */
public boolean setURL(String url, String script) {
	try {
		URL theURL = new URL(url);
		host = theURL.getHost();
		port = theURL.getPort();
		if (port == -1) {
			port = 80;
		}
		this.script = script;
		return true;
	}
	catch(Throwable t) {
	}
	return false;
}

	/**
	 * parseReturnData() uses the array of text lines to
	 * fill up the cache. The user is expected to override
	 * this to parse the data based on their cgi-bin script.
	 * Each element in the Vector input represents a (key, value)
	 * pair returned by the cgi-bin script.
	 */
abstract public void parseReturnData(Vector input);

	/**
	 * Retrieves the item specified by "key" from the cgi-bin
	 * script. Note that toString() is used to send the request
	 * to the cgi-bin script. Override toString() to produce useful
	 * results with your key class.
	 */
private void cgiComm(Object key) {
	Socket sock = null;
	String ostr = key.toString();
	try {
		InputStream inconn = null;
		OutputStream outconn = null;
		DataInputStream indata = null;
		DataOutputStream outdata = null;
		String line;

		sock = new Socket(host, port);

		outconn = sock.getOutputStream();
		inconn = sock.getInputStream();
		outdata = new DataOutputStream(outconn);
		indata = new DataInputStream(inconn);

		outdata.writeBytes("POST " + script + " HTTP/1.0\n");
		outdata.writeBytes("Content-type: text/html\n");
		outdata.writeBytes("Content-length: " + ostr.length() + "\n");
		outdata.writeBytes("\n");
		outdata.writeBytes(ostr);
		outdata.flush();

		// ATTN SLOW CODE
		Vector input = new Vector();
		while ((line = indata.readLine()) != null) {
			input.addElement(new String(line));
		}

		parseReturnData(input);

		sock.close();
		sock = null;
	}
	catch (Throwable t) {
		t.printStackTrace(System.out);
	}
}

	/**
	 * Retrieves the value for "key". It checks the local cache first,
	 * then goes out to the cgi-bin. It returns null if the data is
	 * not found.
	 */
public Object getData(Object key) {
	Object val = cache.getFromCache(key);
	if (val == null) {
		cgiComm(key);  // Go to back-end cgi-bin script
		val = cache.getFromCache(key);  // Look in the cache again.
		System.out.print(cache.toString());
	}
	return val;
}

}












