/*
 * (c) Copyright 1996, KL GROUP INC.
 * ALL RIGHTS RESERVED
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES
 * RELATING TO THE USE OF THIS SOFTWARE.
 */

//   RCSID -- $RCSfile: JCColorUtil.java $ $Revision: 2.0 $
//            $Date: 1997/06/09 18:21:55 $  $Locker: $  KL Group Inc.

package jclass.contrib;
import java.awt.Color;

/**
 * The JCColorUtil class contains a collection of color-related utilities
 * for applications.
 */
public class JCColorUtil {

/**
 * An array of default colors.
 */
public static Color colors[] = { Color.white, Color.lightGray,
								  Color.gray, Color.darkGray, Color.black,
								  Color.red, Color.pink, Color.orange,
								  Color.yellow, Color.green, Color.magenta,
								  Color.cyan, Color.blue };

/**
 * An array of color strings matching the default colors.
 */
public static String colorStrings[] = { "White", "LightGray", "Gray",
										"DarkGray", "Black", "Red", "Pink",
										"Orange", "Yellow", "Green",
										"Magenta", "Cyan", "Blue" };

/**
 * When provided with an instance of an AWT Color object, this
 * returns the index in the colors array that matches the color.
 * This can be used to translate a color into a color string.
 */
public static int colorIndex(Color c) {
	if (c == null) return -1;
	for (int i = 0; i < colors.length; i++) {
		if (colors[i].getRGB() == c.getRGB()) {
			return i;
		}
	}
	return -1;
}

/**
 * When provided with an instance of an AWT Color object, this
 * returns a string representation of the object.  It uses the
 * colorStrings and colors arrays for translation purposes. If no match
 * is found, it uses toString().
 */
public static String colorToString(Color c) {
    if (c == null) {
        return "";
    }
	int indx = colorIndex(c);
	if (indx >= 0 && indx < colorStrings.length) {
		return colorStrings[indx];
	}
	return c.toString();
}

}

