/*
 * (c) Copyright 1997, KL GROUP INC.  
 * ALL RIGHTS RESERVED 
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES 
 * RELATING TO THE USE OF THIS SOFTWARE.
 */
// RCSID -- $RCSfile: spinBox.java $ $Revision: 2.0 $ $Date: 1997/06/09 19:09:00 $ $Locker: $  KL Group Inc.

package jclass.bwt.examples;
import jclass.bwt.BWTEnum;
import jclass.bwt.JCAlignerLayout;
import jclass.bwt.JCLabel;
import jclass.bwt.JCSpinBox;
import jclass.bwt.JCSpinBoxEvent;
import jclass.bwt.JCSpinBoxListener;
import jclass.bwt.JCSpinBoxString;
import jclass.contrib.ContribFrame;
import jclass.util.JCString;
import jclass.util.JCUtilConverter;
import java.awt.*;

/**
 * This example demonstrates various types of JCSpinBoxes and events
 */
public class spinBox extends java.applet.Applet implements JCSpinBoxListener {

public void spinBoxChangeBegin(JCSpinBoxEvent ev) {}
public void spinBoxChangeEnd(JCSpinBoxEvent ev) {}

public void init() {
	JCSpinBox box1, box2;
	JCSpinBoxString box3;
	setBackground(Color.lightGray);
	setLayout(new JCAlignerLayout());

	add(new JCLabel("Integer:"));
	add(box1 = new JCSpinBox(5));
	box1.setMaximum(10);

	add(new JCLabel("Float:"));
	add(box2 = new JCSpinBox(5));
	box2.setMinimum(-100);
	box2.setMaximum(100);
	box2.setDecimalPlaces(2);

	add(new JCLabel("String:"));
	add(box3 = new JCSpinBoxString(10));
	box3.getTextField().setEditable(false);
	box3.getTextField().setShowCursorPosition(false);
	box3.setStringList(getToolkit().getFontList());
}

public static void main(String args[]) {
	ContribFrame frame = new ContribFrame("SpinBox");
	spinBox s = new spinBox();

	s.init();
	frame.add(s);
	frame.pack();
	frame.show();
}
}

