/*
 * (c) Copyright 1997, KL GROUP INC.  
 * ALL RIGHTS RESERVED 
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES 
 * RELATING TO THE USE OF THIS SOFTWARE.
 */
//   RCSID -- $RCSfile: preferences.java $ $Revision: 2.0 $
//            $Date: 1997/06/09 19:10:01 $  $Locker: $  KL Group Inc.

package jclass.bwt.demos.colorpicker;

import jclass.bwt.BWTEnum;
import jclass.bwt.JCCheckbox;
import jclass.bwt.JCCheckboxGroup;
import jclass.bwt.JCContainer;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;
import java.awt.*;
import java.applet.*;

public class preferences extends JCContainer implements JCItemListener {

static String colorMode_labels[] = {
	"RGB", "HSB" 
};

static String displayFormat_labels[] = {
	"Display color list", "Display RGB color in HEX" 
};

JCCheckbox		rgb, hsb, dispColorList, dispColorInHEX;
colorSample		theColorSample;

public void itemStateChanged(JCItemEvent ev) {
	if (ev.getSource() == rgb) {
		theColorSample.useRGB = true;
		theColorSample.setLabels();
		theColorSample.updateDisplay(theColorSample.theColor);
		dispColorInHEX.enable();
		theColorSample.forceLayout();
	}

	if (ev.getSource() == hsb) {
		theColorSample.useRGB = false;
		theColorSample.setLabels();
		theColorSample.updateDisplay(theColorSample.theColor);
		dispColorInHEX.disable();
		theColorSample.forceLayout();
	}

	if (ev.getSource() == dispColorList) {
		int stateNum = dispColorList.getState();
		boolean state = (stateNum != BWTEnum.OFF);
		theColorSample.displayColorList = state;
		if (state)
			theColorSample.colorList.show();
		else
			theColorSample.colorList.hide();
	}

	if (ev.getSource() == dispColorInHEX)  {
		int stateNum = dispColorInHEX.getState();
		theColorSample.displayRGBinHEX = (stateNum != BWTEnum.OFF); 
		theColorSample.updateDisplay(theColorSample.theColor);
	}
}

public preferences(Applet parent, colorSample newColorSample) {
	theColorSample = newColorSample;	
	setBackground(Color.lightGray);

	JCCheckboxGroup radios = JCCheckbox.makeGroup(colorMode_labels, null, true);
	radios.setTitle("Color Mode");
	radios.addItemListener(this); 
	rgb = radios.getCheckbox(0);
	hsb = radios.getCheckbox(1);
	add(radios);

	JCCheckboxGroup checks = JCCheckbox.makeGroup(displayFormat_labels, null, false);
	checks.setTitle("Display Format");
	checks.addItemListener(this); 
	dispColorList 	= checks.getCheckbox(0);
	dispColorInHEX 	= checks.getCheckbox(1);
	dispColorList.setState(BWTEnum.ON);
	add(checks);
}
 
}
