/*
 * Decompiled with CFR 0.152.
 */
package jclass.beans;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.beans.Customizer;
import java.beans.FeatureDescriptor;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import jclass.beans.BeanError;
import jclass.beans.JCEditedAdaptor;
import jclass.beans.JCPropertyCanvas;
import jclass.beans.JCPropertySelector;
import jclass.beans.JCPropertyText;
import jclass.bwt.JCAlignerLayout;
import jclass.bwt.JCContainer;
import jclass.bwt.JCScrolledWindow;
import jclass.bwt.JCTabManager;
import jclass.util.JCSortInterface;
import jclass.util.JCqsort;

public class JCPropertyEditor
extends JCContainer
implements PropertyEditor,
Customizer,
JCSortInterface {
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected Object target;
    private boolean show_error = true;
    private PropertyDescriptor[] properties;
    private PropertyEditor[] editors;
    private Object[] values;
    private Component[] views;
    private JCEditedAdaptor adaptor;
    private boolean processEvents;
    private boolean sort_properties = true;
    private JCScrolledWindow scrollPane;
    private JCTabManager tabManager;
    private Panel panel;
    Dimension pref;

    public JCPropertyEditor() {
        this.setLayout(new GridLayout(1, 1));
        this.tabManager = new JCTabManager();
        this.tabManager.setBackground(Color.lightGray);
        this.scrollPane = new JCScrolledWindow();
        this.panel = new Panel();
        this.scrollPane.add(this.panel);
        this.scrollPane.getVertScrollbar().setUnitIncrement(10);
        this.scrollPane.getVertScrollbar().setBlockIncrement(30);
        this.tabManager.addPage("General", this.scrollPane);
        this.panel.setLayout(new JCAlignerLayout());
        this.panel.setBackground(Color.lightGray);
        this.add(this.tabManager);
        this.adaptor = new JCEditedAdaptor(this);
    }

    public void setObject(Object object) {
        this.setTarget(object);
    }

    public void setShowError(boolean bl) {
        this.show_error = bl;
    }

    public boolean getShowError() {
        return this.show_error;
    }

    public void setSortProperties(boolean bl) {
        this.sort_properties = bl;
    }

    public boolean getSortProperties() {
        return this.sort_properties;
    }

    public boolean compare(Object object, Object object2) {
        return ((PropertyDescriptor)object).getName().compareTo(((PropertyDescriptor)object2).getName()) > 0;
    }

    public synchronized void setTarget(Object object) {
        Object object2;
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = bl = this.editors != null;
        if (object == null) {
            this.target = null;
            if (!bl) {
                this.panel.add(new Label("Null value specified for property"));
                this.doLayout();
                this.tabManager.removeTab(0, false);
            }
            return;
        }
        if (this.target == object) {
            return;
        }
        Object object3 = this.target;
        this.target = object;
        this.setCursor(3);
        try {
            object2 = Introspector.getBeanInfo(this.target.getClass());
            this.properties = object2.getPropertyDescriptors();
        }
        catch (Exception exception) {
            this.error("PropertySheet: Couldn't introspect", exception);
            return;
        }
        if (this.sort_properties) {
            object2 = new Vector(this.properties.length);
            int n = 0;
            while (n < this.properties.length) {
                ((Vector)object2).addElement(this.properties[n]);
                ++n;
            }
            new JCqsort((Vector)object2, this).sort(0);
            int n2 = 0;
            while (n2 < this.properties.length) {
                this.properties[n2] = (PropertyDescriptor)((Vector)object2).elementAt(n2);
                ++n2;
            }
        }
        if (!bl) {
            this.editors = new PropertyEditor[this.properties.length];
        }
        this.values = new Object[this.properties.length];
        if (!bl) {
            this.views = new Component[this.properties.length];
        }
        int n = 0;
        while (n < this.properties.length) {
            block31: {
                if (!this.properties[n].isHidden() && !this.properties[n].isExpert()) {
                    String string = this.properties[n].getDisplayName();
                    Class<?> clazz = this.properties[n].getPropertyType();
                    Method method = this.properties[n].getReadMethod();
                    this.properties[n].getWriteMethod();
                    if (method != null) {
                        Component component = null;
                        try {
                            Object object4;
                            Object[] objectArray = new Object[]{};
                            this.values[n] = object4 = method.invoke(this.target, objectArray);
                            PropertyEditor propertyEditor = this.editors[n];
                            if (propertyEditor == null) {
                                Class<?> clazz2 = this.properties[n].getPropertyEditorClass();
                                if (clazz2 != null) {
                                    try {
                                        propertyEditor = (PropertyEditor)clazz2.newInstance();
                                    }
                                    catch (Exception exception) {}
                                }
                                if (propertyEditor == null) {
                                    propertyEditor = PropertyEditorManager.findEditor(clazz);
                                }
                                this.editors[n] = propertyEditor;
                                if (propertyEditor == null) break block31;
                            }
                            if ((!propertyEditor.isPaintable() || !propertyEditor.supportsCustomEditor()) && propertyEditor.getTags() == null && propertyEditor.getAsText() == null) break block31;
                            if (bl) {
                                propertyEditor.setValue(object4);
                                break block31;
                            }
                            if (propertyEditor.isPaintable() && propertyEditor.supportsCustomEditor()) {
                                propertyEditor.setValue(object4);
                                this.views[n] = component = propertyEditor.getCustomEditor();
                                if (propertyEditor instanceof JCContainer) {
                                    this.tabManager.addPage(string, component);
                                    this.handleCustomEditor(propertyEditor, this.properties[n]);
                                    bl2 = true;
                                    break block31;
                                }
                                this.handleCustomEditor(propertyEditor, this.properties[n]);
                            } else if (propertyEditor.getTags() != null) {
                                propertyEditor.setValue(object4);
                                component = new JCPropertySelector(propertyEditor);
                            } else {
                                if (propertyEditor.getAsText() == null) break block31;
                                propertyEditor.setValue(object4);
                                component = new JCPropertyText(propertyEditor);
                            }
                            this.panel.add(new Label(string, 2));
                            this.views[n] = component;
                            this.panel.add(this.views[n]);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace(System.out);
                        }
                    }
                }
            }
            ++n;
        }
        this.doLayout();
        if (!bl2 && !bl) {
            this.tabManager.removeTab(0, false);
        }
        if (!bl) {
            int n3 = 0;
            while (n3 < this.editors.length) {
                if (this.editors[n3] != null) {
                    this.editors[n3].addPropertyChangeListener(this.adaptor);
                }
                ++n3;
            }
        }
        this.processEvents = true;
        this.setCursor(0);
        this.support.firePropertyChange(null, object3, this.target);
    }

    protected void handleCustomEditor(PropertyEditor propertyEditor, PropertyDescriptor propertyDescriptor) {
    }

    synchronized void setCustomizer(Customizer customizer) {
        customizer.addPropertyChangeListener(new JCEditedAdaptor(this));
    }

    public boolean handleEvent(Event event) {
        if (event.id == 1001 && this.getParent() != null) {
            this.getParent().postEvent(new Event(this, 501, null));
        }
        return false;
    }

    synchronized void wasModified(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        Object object2;
        if (!this.processEvents) {
            return;
        }
        if (propertyChangeEvent.getSource() instanceof PropertyEditor) {
            PropertyEditor propertyEditor = (PropertyEditor)propertyChangeEvent.getSource();
            int n = 0;
            while (n < this.editors.length) {
                if (this.editors[n] == propertyEditor) {
                    object2 = this.properties[n];
                    this.values[n] = object = propertyEditor.getValue();
                    Method method = ((PropertyDescriptor)object2).getWriteMethod();
                    if (method != null) {
                        try {
                            Object[] objectArray = new Object[]{object};
                            objectArray[0] = object;
                            method.invoke(this.target, objectArray);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            if (invocationTargetException.getTargetException() instanceof PropertyVetoException) {
                                this.warning("Vetoed; reason is: " + invocationTargetException.getTargetException().getMessage());
                            } else {
                                Throwable throwable = invocationTargetException.getTargetException();
                                this.error("Error updating " + ((FeatureDescriptor)object2).getName() + ": " + throwable, throwable);
                            }
                        }
                        catch (Exception exception) {
                            this.error("Unexpected exception while updating " + ((FeatureDescriptor)object2).getName(), exception);
                        }
                        if (this.views[n] == null || !(this.views[n] instanceof JCPropertyCanvas)) break;
                        this.views[n].repaint();
                        break;
                    }
                }
                ++n;
            }
        }
        int n = 0;
        while (n < this.properties.length) {
            Object object3;
            try {
                object2 = this.properties[n].getReadMethod();
                object = new Object[]{};
                object3 = ((Method)object2).invoke(this.target, object);
            }
            catch (Exception exception) {
                this.error("Could not get value for property " + this.properties[n].getName(), exception);
                object3 = null;
            }
            if (!(object3 == this.values[n] || object3 != null && object3.equals(this.values[n]))) {
                this.values[n] = object3;
                if (this.editors[n] != null) {
                    this.editors[n].setValue(object3);
                    if (this.views[n] != null) {
                        this.views[n].repaint();
                    }
                }
            }
            ++n;
        }
        if (this.target != null && this.target instanceof Component) {
            ((Component)this.target).repaint();
        }
    }

    private void warning(String string) {
        if (this.show_error) {
            System.out.println("Warning: " + string);
        }
    }

    private void error(String string, Throwable throwable) {
        if (this.show_error) {
            BeanError.raise(string);
            System.err.println(string);
            throwable.printStackTrace();
        }
    }

    public Dimension preferredSize() {
        if (this.pref == null) {
            Dimension dimension = this.tabManager.getPreferredSize();
            this.pref = new Dimension(dimension.width, Math.min(dimension.height, 200));
        }
        return this.pref;
    }

    public boolean isPaintable() {
        return true;
    }

    public void setValue(Object object) {
        this.setTarget(object);
    }

    public Object getValue() {
        return this.target;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        graphics.drawString("hit me to see stuff...", 0, 0);
    }

    public String getJavaInitializationString() {
        return "JClass Property Editor...";
    }

    public String getAsText() {
        return null;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException(string);
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        return this;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }
}

