/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tpf.installHandler;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.update.core.IFeature;

public class InstallHandlerUtil {
    public static final String copyright = "(c) Copyright IBM Corporation 2003, 2005.";
    protected static final String LOG_FOLDER = "backup";
    protected static final String LOG_FILE = "TPFToolkitInstallHandlerLog.txt";
    protected PrintWriter logWriter;

    protected void initializeWriters(IFeature feature) {
        try {
            File productFolder = new File(feature.getSite().getURL().getPath()).getParentFile();
            File logDir = new File(productFolder, LOG_FOLDER);
            if (!logDir.exists()) {
                logDir.mkdirs();
            }
            File logFile = new File(logDir, LOG_FILE);
            this.logWriter = new PrintWriter(new BufferedWriter(new FileWriter(logFile.getAbsolutePath(), true)));
            this.logWriter.println("----------------------------------------------------------");
            this.logWriter.println("CommonInstallHandler: " + feature.getVersionedIdentifier());
            DateFormat fmt = DateFormat.getDateTimeInstance(1, 1);
            this.logWriter.println("Date:    " + fmt.format(new Date()));
            this.logWriter.println("OS/Arch: " + System.getProperty("os.name") + " / " + System.getProperty("os.arch"));
            this.logWriter.println("Feature: " + feature.getVersionedIdentifier());
            this.logWriter.println("----------------------------------------------------------");
        }
        catch (Exception e) {
            this.log("initializeWriters", "Exception occured", e);
        }
    }

    protected void log(String action, String message, Throwable t) {
        try {
            this.logWriter.println(String.valueOf(action) + ": " + message);
            if (t != null) {
                t.printStackTrace(this.logWriter);
            }
            this.logWriter.flush();
        }
        catch (Exception e) {
            System.err.println("Could not log: " + e.getMessage());
        }
    }

    protected void log(String action, String message) {
        this.log(action, message, null);
    }
}

