/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tpf.installHandler;

import com.ibm.tpf.installHandler.InstallHandlerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class FileUtility {
    public static final String FORWARD_SLASH = "/";
    public static final String BACKWARD_SLASH = "\\";

    public static boolean copy(String itemToCopy, String defaultSource, String destination, InstallHandlerUtil util) {
        boolean success;
        block15: {
            success = false;
            boolean isFeatureXML = false;
            if (itemToCopy != null) {
                File source = new File(itemToCopy);
                if (!source.isAbsolute() && defaultSource != null) {
                    File defaultSourceFolder = new File(defaultSource);
                    source = new File(defaultSourceFolder, itemToCopy);
                }
                if (source.getName().equals("feature.xml")) {
                    File parentFolder = null;
                    if (source.isAbsolute()) {
                        parentFolder = source.getParentFile();
                    } else if (defaultSource != null) {
                        parentFolder = new File(defaultSource);
                        parentFolder = new File(defaultSource, itemToCopy);
                        parentFolder = parentFolder.getParentFile();
                    }
                    if (parentFolder != null && parentFolder.exists() && parentFolder.isDirectory()) {
                        File[] files = parentFolder.listFiles();
                        int i = 0;
                        while (i < files.length) {
                            if (files[i].getName().startsWith("feature") && files[i].getName().endsWith(".xml")) {
                                util.log("Copy File:", "  The file '" + files[i].getName() + "' is being used as a match for '" + source.getAbsolutePath() + "'");
                                source = files[i];
                                isFeatureXML = true;
                            }
                            ++i;
                        }
                    }
                }
                if (source.exists()) {
                    try {
                        if (source.isFile()) {
                            success = FileUtility.copyFile(source, destination, util);
                            if (success && isFeatureXML) {
                                FileUtility.renameFeatureXML(source, destination, util);
                            }
                            break block15;
                        }
                        success = FileUtility.copyFolder(source, destination, util);
                    }
                    catch (Exception e) {
                        util.log("Copy failed.", "ERROR", e);
                    }
                } else {
                    util.log("Copy failed.", "Source '" + source.getAbsolutePath() + "' does not exist.");
                }
            }
        }
        return success;
    }

    private static boolean renameFeatureXML(File source, String destination, InstallHandlerUtil util) {
        boolean success = false;
        File copyResult = new File(destination);
        copyResult = new File(copyResult, source.getName());
        String originalName = copyResult.getAbsolutePath();
        String ourNumberedFeature = copyResult.getName();
        String thierNumberedFeature = "feature.xml";
        File[] destinationFiles = new File(destination).listFiles();
        int i = 0;
        while (i < destinationFiles.length) {
            if (destinationFiles[i].getName().startsWith("feature") && destinationFiles[i].getName().endsWith(".xml") && !destinationFiles[i].getName().equals(ourNumberedFeature) && !destinationFiles[i].getName().equals("feature.xml")) {
                thierNumberedFeature = destinationFiles[i].getName();
                break;
            }
            ++i;
        }
        File fixedResult = new File(destination, thierNumberedFeature);
        if (fixedResult.exists()) {
            fixedResult.delete();
        }
        if (success = copyResult.renameTo(fixedResult)) {
            util.log("Copy Renamed", "  The file '" + originalName + "' was successfully renamed to '" + fixedResult.getAbsolutePath() + "'.");
        } else {
            util.log("Copy Rename Failed", "  The file '" + originalName + "' could not be renamed to '" + fixedResult.getAbsolutePath() + "'.");
        }
        return success;
    }

    public static boolean delete(String itemName, InstallHandlerUtil util) {
        boolean success = false;
        if (itemName != null) {
            File toDelete = new File(itemName);
            if (toDelete.exists()) {
                if (toDelete.isDirectory()) {
                    String[] children = toDelete.list();
                    success = true;
                    int i = 0;
                    while (i < children.length) {
                        File next = new File(toDelete, children[i]);
                        success = FileUtility.delete(next.getAbsolutePath(), util);
                        if (!success) break;
                        ++i;
                    }
                    if (success) {
                        toDelete.delete();
                        util.log("Delete success.", "The folder '" + itemName + "' and it's contents were successfully deleted.");
                    }
                } else {
                    success = toDelete.delete();
                    util.log("Delete success.", "The file '" + itemName + "' was successfully deleted.");
                }
            } else {
                util.log("Delete failed.", "The file " + itemName + " does not exist.");
            }
        }
        return success;
    }

    private static boolean copyFile(File sf, String destPath, InstallHandlerUtil util) throws Exception {
        boolean success = false;
        if (sf.exists()) {
            FileOutputStream fo;
            FileInputStream fi;
            File dp = new File(destPath);
            File df = new File(dp, sf.getName());
            if (!dp.exists()) {
                dp.mkdirs();
            } else if (df.exists()) {
                df.delete();
            }
            boolean cc = df.createNewFile();
            if (cc) {
                fi = new FileInputStream(sf);
                fo = new FileOutputStream(df);
                byte[] content = new byte[20000];
                int read = 0;
                while ((read = fi.read(content)) > -1) {
                    fo.write(content, 0, read);
                }
            } else {
                Exception tt = new Exception("File: " + df.toString() + " could not be created.");
                throw tt;
            }
            fo.flush();
            fo.close();
            fi.close();
            df.setLastModified(sf.lastModified());
            success = true;
            util.log("File copied", String.valueOf(sf.getAbsolutePath()) + " copied to " + df.getAbsolutePath());
        } else {
            util.log("Source File ", String.valueOf(sf.getAbsolutePath()) + " does not exist.");
        }
        return success;
    }

    private static boolean copyFolder(File sf, String destPath, InstallHandlerUtil util) throws Exception {
        boolean success = false;
        if (sf.exists()) {
            boolean dirs;
            File dp = new File(destPath);
            File df = new File(dp, sf.getName());
            if (df.exists()) {
                FileUtility.delete(df.getAbsolutePath(), util);
            }
            if (dirs = df.mkdirs()) {
                String[] children = sf.list();
                int i = 0;
                while (i < children.length) {
                    File next = new File(sf, children[i]);
                    if (next.isFile()) {
                        FileUtility.copyFile(next, df.getAbsolutePath(), util);
                    } else {
                        FileUtility.copyFolder(next, df.getAbsolutePath(), util);
                    }
                    ++i;
                }
                success = true;
                util.log("Folder copied", String.valueOf(sf.getAbsolutePath()) + " copied to " + df.getAbsolutePath());
            } else {
                util.log("Folder Copy Failed.", "Could not create '" + df.getAbsolutePath() + "'");
            }
        } else {
            util.log("Source Folder ", String.valueOf(sf.getAbsolutePath()) + " does not exist.");
        }
        return success;
    }

    public static boolean isQualifiedName(String name) {
        boolean qualified = false;
        if (name != null && (name.indexOf(FORWARD_SLASH) >= 0 || name.indexOf(BACKWARD_SLASH) >= 0)) {
            qualified = true;
        }
        return qualified;
    }
}

