/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tpf.installHandler;

import com.ibm.tpf.installHandler.ConfigFileEntry;
import com.ibm.tpf.installHandler.ConfigurationFileUtility;
import com.ibm.tpf.installHandler.EnvVarResolver;
import com.ibm.tpf.installHandler.FileUtility;
import com.ibm.tpf.installHandler.InstallHandlerUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;

public class ClassicToolsInstaller {
    public static final String copyright = "(c) Copyright IBM Corporation 2003, 2005.";
    private String rootPath;
    private String sourcePath;
    private String refreshPath;
    private String tmp = null;
    boolean isMainTPFToolkitFeatureInstall = true;
    private static final String COMMENT_PREFIX = "#";
    private static final String IBM_WORKSTATION_TRANSFER_FILE_NAME = "\\IBM_workstation_copy_list.txt";
    private static final String ENT_WORKSTATION_TRANSFER_FILE_NAME = "\\ENT_workstation_copy_list.txt";
    private static final String IBM_HOST_TRANSFER_FILE_NAME = "\\IBM_host_copy_list.txt";
    private static final String ENT_HOST_TRANSFER_FILE_NAME = "\\ENT_host_copy_list.txt";
    private static final String IBM_DELETE_FILE_NAME = "\\IBM_delete_list.txt";
    private static final String ENT_DELETE_FILE_NAME = "\\ENT_delete_list.txt";
    private static final String ENT_FEATURE_DELETE_FILE_NAME = "\\ENT_feature_delete_list.txt";
    private static final String S_LPEX_PREFERNCE_FILE_NAME = "Editor.properties";
    private static final String S_OLD_LPEX_PREFERENCE_FILE_NAME = "Profile.properties";
    private static final String S_AUTO_COMMENT_FILE_NAME = "auto_comment.properties";
    private static IPath workspaceLocation;

    public ClassicToolsInstaller(IFeature feature) {
        try {
            File siteFile = new File(feature.getSite().getURL().getFile());
            File featuresFile = new File(siteFile, "features");
            File sourceFilePath = new File(featuresFile, String.valueOf(feature.getVersionedIdentifier().getIdentifier()) + "_" + feature.getVersionedIdentifier().getVersion().toString());
            this.sourcePath = sourceFilePath.getAbsolutePath();
            File rootFilePath = new File(String.valueOf(siteFile.toString()) + "\\..");
            this.rootPath = rootFilePath.getCanonicalPath();
            File refreshFilePath = new File(String.valueOf(this.rootPath) + "\\refresh");
            this.refreshPath = refreshFilePath.getAbsolutePath();
            try {
                Class<?> resourcesPlugin = Platform.getPlugin((String)"org.eclipse.core.resources").getDescriptor().getPluginClassLoader().loadClass("org.eclipse.core.resources.ResourcesPlugin");
                Object workspace = resourcesPlugin.getMethod("getWorkspace", null).invoke(null, null);
                workspace = workspace.getClass().getMethod("getRoot", null).invoke(workspace, null);
                workspace = workspace.getClass().getMethod("getLocation", null).invoke(workspace, null);
                workspaceLocation = (IPath)workspace;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        catch (Exception exception) {}
        String featureID = feature.getVersionedIdentifier().getIdentifier();
        if (featureID.compareTo("com.ibm.tpf.installHandler") != 0) {
            this.isMainTPFToolkitFeatureInstall = false;
        }
    }

    public void go(InstallHandlerUtil util, ISite site) {
        try {
            String IBMWorkstationTransferFilePath = String.valueOf(this.sourcePath) + IBM_WORKSTATION_TRANSFER_FILE_NAME;
            String ENTWorkstationTransferFilePath = String.valueOf(this.sourcePath) + ENT_WORKSTATION_TRANSFER_FILE_NAME;
            String IBMHostTransferFilePath = String.valueOf(this.sourcePath) + IBM_HOST_TRANSFER_FILE_NAME;
            String ENTHostTransferFilePath = String.valueOf(this.sourcePath) + ENT_HOST_TRANSFER_FILE_NAME;
            if (this.isMainTPFToolkitFeatureInstall) {
                this.transferFilesInList(IBMWorkstationTransferFilePath, util);
            }
            this.transferFilesInList(ENTWorkstationTransferFilePath, util);
            if (this.isMainTPFToolkitFeatureInstall) {
                this.transferFilesInList(IBMHostTransferFilePath, util);
            }
            this.transferFilesInList(ENTHostTransferFilePath, util);
            String IBMDeleteFilePath = String.valueOf(this.sourcePath) + IBM_DELETE_FILE_NAME;
            String ENTDeleteFilePath = String.valueOf(this.sourcePath) + ENT_DELETE_FILE_NAME;
            if (this.isMainTPFToolkitFeatureInstall) {
                this.deleteFilesInList(IBMDeleteFilePath, util);
            }
            this.deleteFilesInList(ENTDeleteFilePath, util);
            String ENTFeatureDeletePath = String.valueOf(this.sourcePath) + ENT_FEATURE_DELETE_FILE_NAME;
            ClassicToolsInstaller.deleteFeaturesInList(ENTFeatureDeletePath, util, site);
            if (this.isMainTPFToolkitFeatureInstall) {
                this.migrateMenuManagerConfig(util);
                this.migrateLPEXPreferences(util);
            }
        }
        catch (Exception e) {
            util.log("runtime", "ERROR", e);
        }
    }

    private void doDeletions(InstallHandlerUtil util) {
        String IBMDeleteFilePath = String.valueOf(this.sourcePath) + IBM_DELETE_FILE_NAME;
        String ENTDeleteFilePath = String.valueOf(this.sourcePath) + ENT_DELETE_FILE_NAME;
        if (this.isMainTPFToolkitFeatureInstall) {
            this.deleteFilesInList(IBMDeleteFilePath, util);
        }
        this.deleteFilesInList(ENTDeleteFilePath, util);
    }

    private boolean transferFilesInList(String transferFilePath, InstallHandlerUtil util) {
        try {
            File transferFile = new File(transferFilePath);
            BufferedReader btReader = new BufferedReader(new FileReader(transferFile));
            String nextLine = btReader.readLine();
            while (nextLine != null) {
                int equalIndex;
                if (!nextLine.startsWith(COMMENT_PREFIX) && nextLine.length() != 0 && (equalIndex = (nextLine = this.resolveEnvironmentVariables(nextLine, util)).indexOf(61)) > 0) {
                    String fileToCopy = nextLine.substring(0, equalIndex);
                    fileToCopy = fileToCopy.trim();
                    if (nextLine.length() >= equalIndex) {
                        String destinationFolder = nextLine.substring(equalIndex + 1);
                        destinationFolder = destinationFolder.trim();
                        FileUtility.copy(fileToCopy, this.sourcePath, destinationFolder, util);
                    }
                }
                nextLine = btReader.readLine();
            }
        }
        catch (FileNotFoundException e) {
            util.log("Copy", "ERROR", e);
            return false;
        }
        catch (IOException e) {
            util.log("Copy", "ERROR", e);
            return false;
        }
        return true;
    }

    private boolean deleteFilesInList(String deleteFilePath, InstallHandlerUtil util) {
        try {
            File deleteFile = new File(deleteFilePath);
            BufferedReader bdReader = new BufferedReader(new FileReader(deleteFile));
            String nextLine = bdReader.readLine();
            while (nextLine != null) {
                if (!nextLine.startsWith(COMMENT_PREFIX) && nextLine.length() != 0) {
                    nextLine = this.resolveEnvironmentVariables(nextLine, util);
                    FileUtility.delete(nextLine, util);
                }
                nextLine = bdReader.readLine();
            }
        }
        catch (IOException e) {
            util.log("Deletions Skipped", "ERROR", e);
            return false;
        }
        return true;
    }

    private String resolveEnvironmentVariables(String original, InstallHandlerUtil util) {
        String resolved = null;
        if (original != null) {
            resolved = EnvVarResolver.getInstance().resolveAllVariables(original, util);
        }
        return resolved;
    }

    private void migrateLPEXPreferences(InstallHandlerUtil util) {
        String newAutoCommentPreferencesName;
        File newAutoCommentPreferences;
        util.log("Start LPEX preferences migration.", "  Migrating Profile.properties and auto_comment.properties.");
        String lpexPreferences = ClassicToolsInstaller.getLPEXPreferencesFolder(util).append(S_LPEX_PREFERNCE_FILE_NAME).toOSString();
        File lpexPreferencesFile = new File(lpexPreferences);
        if (!lpexPreferencesFile.exists()) {
            File oldPreferencesFile = new File(String.valueOf(ClassicToolsInstaller.getLPEXUserHomeFolder(util)) + File.separator + S_OLD_LPEX_PREFERENCE_FILE_NAME);
            if (oldPreferencesFile.exists()) {
                boolean success = FileUtility.copy(oldPreferencesFile.getAbsolutePath(), "", lpexPreferencesFile.getParentFile().getAbsolutePath(), util);
                if (success) {
                    String migratedFileName = ClassicToolsInstaller.getLPEXPreferencesFolder(util).append(S_OLD_LPEX_PREFERENCE_FILE_NAME).toOSString();
                    File migratedFile = new File(migratedFileName);
                    success = migratedFile.renameTo(lpexPreferencesFile);
                    if (success) {
                        util.log("Successfully migrated Profile.properties.", "  The file '" + oldPreferencesFile.getAbsolutePath() + "' was successfully migrated to '" + lpexPreferencesFile.getAbsolutePath() + "'.");
                    } else {
                        util.log("Failed migrating Profile.properties.", "  Profile.properties could not be renamed to Editor.properties.");
                    }
                }
            } else {
                util.log("Skip Profile.properties migration.", "  The file '" + oldPreferencesFile.getAbsolutePath() + "' does not exist and cannot be migrated.");
            }
        } else {
            util.log("Skip Profile.properties migration.", "  The file '" + lpexPreferencesFile.getAbsolutePath() + "' already exists.");
        }
        if (!(newAutoCommentPreferences = new File(newAutoCommentPreferencesName = ClassicToolsInstaller.getLPEXPreferencesFolder(util).append(S_AUTO_COMMENT_FILE_NAME).toOSString())).exists()) {
            File oldAutoCommentPreferences = new File(String.valueOf(ClassicToolsInstaller.getLPEXUserHomeFolder(util)) + File.separator + S_AUTO_COMMENT_FILE_NAME);
            if (oldAutoCommentPreferences.exists()) {
                boolean success = FileUtility.copy(oldAutoCommentPreferences.getAbsolutePath(), "", newAutoCommentPreferences.getParentFile().getAbsolutePath(), util);
                if (success) {
                    util.log("Successfully migrated auto_comment.properties.", "  The file '" + oldAutoCommentPreferences.getAbsolutePath() + "' was successfully migrated to '" + newAutoCommentPreferences.getAbsolutePath() + "'.");
                }
            } else {
                util.log("Skip auto_comment.properties migration.", "  The file '" + oldAutoCommentPreferences.getAbsolutePath() + "' does not exist.");
            }
        } else {
            util.log("Skip auto_comment.properties migration.", "  The file '" + newAutoCommentPreferences.getAbsolutePath() + "' already exists.");
        }
    }

    private boolean migrateMenuManagerConfig(InstallHandlerUtil util) {
        boolean migrated = false;
        String menuPluginStart = String.valueOf(this.rootPath) + "\\eclipse\\plugins\\com.ibm.tpf.menumanager_";
        String[] versionsToCheck = new String[]{"2.0.3.5", "2.0.3.4", "2.0.3.3", "2.0.3.2", "2.0.3.1", "2.0.3", "2.0.2", "2.0.2.1", "2.0.2.2", "2.0.2.3", "2.0.2.4", "2.0.2.5", "2.0.1", "2.0.0"};
        int versionIndex = 0;
        File menuManagerPlugin = new File(String.valueOf(menuPluginStart) + versionsToCheck[versionIndex++]);
        boolean foundMenuManager = menuManagerPlugin.exists();
        while (!foundMenuManager && versionIndex < versionsToCheck.length) {
            util.log("NOT INSTALLED.", "  Plugin: '" + menuManagerPlugin.getAbsolutePath() + "' not found.");
            menuManagerPlugin = new File(String.valueOf(menuPluginStart) + versionsToCheck[versionIndex++]);
            foundMenuManager = menuManagerPlugin.exists();
        }
        if (foundMenuManager) {
            File oldConfigFile = new File(menuManagerPlugin, "\\config\\menumanagerconfig.xml");
            if (oldConfigFile.exists()) {
                util.log("Config migration started.", "  Configuration file '" + oldConfigFile.getAbsolutePath() + "' found.");
                ConfigFileEntry[] allFiles = ConfigurationFileUtility.extractEntriesFromLocalFile(oldConfigFile);
                if (allFiles != null) {
                    int numEntries = allFiles.length;
                    util.log("Config migration continues.", "  Number of files mentioned in menumanagerconfig.xml: " + numEntries);
                }
                File ibmConfigFile = new File(EnvVarResolver.getInstance().resolveAllVariables("%TPFSHARE%\\IBMActionFiles.xml", util));
                ConfigFileEntry[] ibmFiles = ConfigurationFileUtility.extractEntriesFromLocalFile(ibmConfigFile);
                Vector<ConfigFileEntry> removedEntries = new Vector<ConfigFileEntry>();
                int i = 0;
                while (ibmFiles != null && i < ibmFiles.length) {
                    boolean found = false;
                    int j = 0;
                    while (allFiles != null && j < allFiles.length) {
                        if (allFiles[j].fileName.compareToIgnoreCase(ibmFiles[i].fileName) == 0) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        removedEntries.addElement(ibmFiles[i]);
                        util.log("Removed IBM Configuration.", "  File: '" + ibmFiles[i].fileName + "' not included in configuration list.");
                    }
                    ++i;
                }
                if (removedEntries.size() > 0) {
                    ConfigFileEntry[] removals = new ConfigFileEntry[removedEntries.size()];
                    removedEntries.toArray(removals);
                    File entRemovalFile = new File(EnvVarResolver.getInstance().resolveAllVariables("%TPFSHARE%\\ENTActionFileRemovals.xml", util));
                    if (ConfigurationFileUtility.writeConfigurationLocalFile(entRemovalFile, removals)) {
                        util.log("Successfully created configuration file.", "  File '" + entRemovalFile.getAbsolutePath() + "' created.");
                    } else {
                        util.log("Failed writing configuration file.", "  File '" + entRemovalFile.getAbsolutePath() + "' could not be created.");
                    }
                }
                Vector<ConfigFileEntry> newEntries = new Vector<ConfigFileEntry>();
                int i2 = 0;
                while (allFiles != null && i2 < allFiles.length) {
                    boolean found = false;
                    int j = 0;
                    while (j < ibmFiles.length) {
                        if (allFiles[i2].fileName.compareToIgnoreCase(ibmFiles[j].fileName) == 0) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        newEntries.addElement(allFiles[i2]);
                        util.log("Added user configuration.", "  File: '" + allFiles[i2].fileName + "' added to user configuration file.");
                    }
                    ++i2;
                }
                if (newEntries.size() > 0) {
                    IPath workspacePath = workspaceLocation;
                    File newEntriesFile = new File(workspacePath.append(".metadata\\.plugins\\com.ibm.tpf.menumanager").toOSString());
                    newEntriesFile.mkdirs();
                    newEntriesFile = new File(newEntriesFile, "menumanagerconfig.xml");
                    ConfigFileEntry[] newFiles = new ConfigFileEntry[newEntries.size()];
                    newEntries.toArray(newFiles);
                    if (ConfigurationFileUtility.writeConfigurationLocalFile(newEntriesFile, newFiles)) {
                        util.log("Successfully created configuration file.", "  File '" + newEntriesFile.getAbsolutePath() + "' created.");
                    } else {
                        util.log("Failed writing configuration file.", "  File '" + newEntriesFile.getAbsolutePath() + "' could not be created.");
                    }
                }
                FileUtility.delete(oldConfigFile.getAbsolutePath(), util);
                util.log("Configuration migration complete.", "  Successfully migrated configuration file '" + oldConfigFile.getAbsolutePath() + "'.");
                migrated = true;
            } else {
                util.log("Config migration skipped.", "  Configuration file '" + oldConfigFile.getAbsolutePath() + "' not found.");
            }
        } else {
            util.log("SKIP CONFIGURATION MIGRATION", "  " + menuManagerPlugin.getAbsolutePath() + " does not contain a configuration file. Migration may already be done.");
        }
        FileUtility.delete(String.valueOf(this.rootPath) + "\\eclipse\\config.dtd", util);
        return migrated;
    }

    private static IPath getLPEXPreferencesFolder(InstallHandlerUtil util) {
        IPath path = workspaceLocation.append(".metadata\\.plugins\\com.ibm.lpex");
        return path;
    }

    private static String getLPEXUserHomeFolder(InstallHandlerUtil util) {
        String path = EnvVarResolver.getInstance().resolveAllVariables("%USERPROFILE%\\Application Data\\IBM\\LpexEditor", util);
        return path;
    }

    private static boolean deleteFeaturesInList(String featureDeleteFilePath, InstallHandlerUtil util, ISite site) {
        try {
            File deleteFile = new File(featureDeleteFilePath);
            BufferedReader bdReader = new BufferedReader(new FileReader(deleteFile));
            String nextLine = bdReader.readLine();
            while (nextLine != null) {
                if (!nextLine.startsWith(COMMENT_PREFIX) && nextLine.length() != 0) {
                    boolean found = true;
                    ISiteFeatureReference[] featureReferences = site.getFeatureReferences();
                    int i = 0;
                    while (featureReferences != null && i < featureReferences.length) {
                        try {
                            IFeature feature = featureReferences[i].getFeature((IProgressMonitor)new NullProgressMonitor());
                            String nextID = feature.getVersionedIdentifier().getIdentifier();
                            if (nextLine.trim().compareToIgnoreCase(nextID) == 0) {
                                found = true;
                                IConfiguredSite configuredSite = site.getCurrentConfiguredSite();
                                if (configuredSite != null) {
                                    boolean success = configuredSite.unconfigure(feature);
                                    if (success) {
                                        util.log("Feature Remove Success", "  The feature " + nextID + " was successfully unconfigured.");
                                    } else {
                                        util.log("Feature Remove Error", "  The feature " + nextID + " could not be unconfigured.");
                                    }
                                }
                                site.remove(feature, (IProgressMonitor)new NullProgressMonitor());
                                util.log("Feature Remove Success.", "  The feature " + nextID + " was successfully removed.");
                                break;
                            }
                        }
                        catch (CoreException e1) {
                            util.log("Error deleting feature.", "  Error occured:", e1);
                        }
                        ++i;
                    }
                    if (!found) {
                        util.log("Error removing feature.", "  The feature " + nextLine + " is not installed.");
                    }
                }
                nextLine = bdReader.readLine();
            }
        }
        catch (IOException e) {
            util.log("Feature Deletions Skipped", "ERROR", e);
            return false;
        }
        return true;
    }
}

