/*
 * Created on Nov 10, 2004
 */
package com.example.mytoolbarbuttons.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

/**
 * @author Andrea Rice
 *
 * This is a utility class that will run external tools actions.  
 */
public class ExternalToolsUtility {

	private static final String LAUNCHEXTENSION = ".launch";

	public static boolean runExternalToolsAction(String name) {
		boolean runSuccess = false;
		String availableActions = "";

		try {
			
			// Get a list of all the external tools actions that exist.
			ILaunchConfiguration[] externalToolsActions =
				DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(
					DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(
						"org.eclipse.ui.externaltools.ProgramLaunchConfigurationType"));
			
			// Find the action that has the name of the action we want to run.
			for (int i = 0; externalToolsActions != null && i < externalToolsActions.length; i++) {
				
				// Extract the name of this external tools action
				IPath location = externalToolsActions[i].getLocation();
				String fileName = location.lastSegment();

				if (fileName != null && fileName.endsWith(LAUNCHEXTENSION)) {
					if (fileName.length() > LAUNCHEXTENSION.length()) {
						String actionName = fileName.substring(0, fileName.length() - LAUNCHEXTENSION.length());
						availableActions += actionName + "\n";
						if (actionName.equals(name)) {
							
							// This is the action we want to run
							System.out.println("Running action: " + actionName);
							ILaunch result = externalToolsActions[i].launch("run", new NullProgressMonitor());
							runSuccess = true;
							break;
						}
					}

				}

			}

		} catch (CoreException e) {
			e.printStackTrace();
		}

		if (!runSuccess) {
			System.out.println("Action: " + name + " could not be found.  Available actions are: " + availableActions);
		}

		return runSuccess;
	}

}
