#!/usr/bin/ksh
#
# NAME: do-build.ksh driverName [ debug | beta ]
# 
# SAMPLE USAGES:
#   do-build.ksh  driver1
#   do-build.ksh  2001-03-01 debug
#
# PURPOSE:
#  This is the top level script to build the application "myapp".
#

#******************************************************************



# * You need to handle the appropriate processing of input arguments.
#   For example, the DEBUG and BETA options are set.

if [ $# -ge 1 ]
then
  typeset -u DRIVER_NAME=$1
  if [ $# -eq 2 ]
  then
    typeset -u OPTION=$2
    case "$OPTION" in
    BETA|beta)
       print "**********ERROR**********"
       print "Set the BETA variable in the java source code for myapp "
       print "to 'true' and then call this script without the beta parameter."
       print ""
       print "./do-build.ksh driverName"
       exit 1

      ;;
    DEBUG|debug)
     print "**********ERROR**********"
     print "Set the DEBUG variable in the java source code for myapp "
     print "to 'true' and then call this script without the debug  parameter:"
     print ""
     print "./do-build.ksh driverName"
     exit 1

      ;;
    *)
      print "Unrecognized option: $OPTION"
      ;;
    esac
  fi
fi

# * Invoke your make file

make -f myapp-x.mak all FLAGS="$FLAGS"

# end of file

