# NAME: myApp-w.mak
#
# PURPOSE:
#   This is the makefile for building the myApp application in Windows.
#
# NOTES:
# * To build the application using Windows 32-bit (VisualAge C++):
#      nmake -f myApp-w.mak myApp.exe
# * The generation of the what-info* files is done by do-what.cmd
#
#***********************************************************************

COMPILER=icc

all:    myApp.exe myAppLevel.exe

myApp.exe: what-info.h myApp.obj
        $(COMPILER) /Fe myApp.exe myApp.obj

myAppLevel.exe: what-info.h myAppLevel.obj
        $(COMPILER) /Fe myAppLevel.exe myAppLevel.obj

myApp.obj: myApp.c
        $(COMPILER) $(FLAGS) /C+ myApp.c

myAppLevel.obj: myAppLevel.c
        $(COMPILER) $(FLAGS) /C+ myAppLevel.c

what-info.h:
        rexx .\do-what.cmd master.list what-info

# end of file
