REM Usage:   prepareListPartsWithParser.bat
REM Purpose: 
REM   To prepare files with lists with parts that are associated with a parser.
REM   From the original files, a set of smaller files will be obtained, which
REM   can be used by other scripts. 
REM Customization Notes:   
REM   You may need to customize this script to fit your needs.
REM   The release is "dfarel1" and the workarea is "ibm-mig-0".
REM   The 3 parsers are: asmparse, cobparse and pliparse.
REM
REM Obtaining the list of parts associated with the parser: asmparse
teamc Report -raw -view PartView -where "parserName in ('asmparse')" -release dfarel1 -workarea ibm-mig-0 > dfa-asmparse.lst
REM
REM Obtaining the list of parts associated with the parser: cobparse
teamc Report -raw -view PartView -where "parserName in ('cobparse')" -release dfarel1 -workarea ibm-mig-0 > dfa-cobparse.lst
REM
REM Obtaining the list of parts associated with the parser: pliparse
teamc Report -raw -view PartView -where "parserName in ('pliparse')" -release dfarel1 -workarea ibm-mig-0 > dfa-pliparse.lst
REM
REM Splitting into smaller files, the file: dfa-asmparse.lst
rexx splitFile.rex dfa-asmparse.lst  2>&1 | tee split-asm.out
REM
REM Splitting into smaller files, the file: dfa-cobparse.lst
rexx splitFile.rex dfa-cobparse.lst  2>&1 | tee split-cob.out
REM
REM Splitting into smaller files, the file: dfa-pliparse.lst
rexx splitFile.rex dfa-pliparse.lst  2>&1 | tee split-pli.out
REM
REM done!