/*
****************************************************************************

NAME: filterInputToParts.rex inputFile outputFile

EXAMPLE USAGE:

* To filter all entries from the inputFile "dfa-lkd.lst" that have 
  a build relationship of "InputTo" and to store the filtered entries 
  in the outputFile "input-to.lst" and to simultaneously see the messages 
  in the screen and capture them into a file for later viewing, 
  you can invoke the command as follows:

  rexx filterInputToParts.rex dfa-lkd.lst input-to-lkd.lst 2>&1 | tee filter-2.out

ENVIRONMENT VARIABLES:
      TC_FAMILY
      TC_BECOME

DESCRIPTION:
  This sample script reads all the entries from the inputFile and writes 
  into the outputFile only those parts that have a build relationship
  of "InputTo".
  
NOTES:
  None
  
****************************************************************************
*
*           NOTICE TO USERS OF THE SOURCE CODE EXAMPLES
*
* INTERNATIONAL BUSINESS MACHINES CORPORATION PROVIDES THE SOURCE CODE
* EXAMPLES, BOTH INDIVIDUALLY AND AS ONE OR MORE GROUPS, "AS IS" WITHOUT
* WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
* PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE
* OF THE SOURCE CODE EXAMPLES, BOTH INDIVIDUALLY AND AS ONE OR MORE GROUPS,
* IS WITH YOU.  SHOULD ANY PART OF THE SOURCE CODE EXAMPLES PROVE
* DEFECTIVE, YOU (AND NOT IBM OR AN AUTHORIZED DEALER) ASSUME THE ENTIRE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
****************************************************************************
*/

/* This block of code gets the name of the command, for later use. */

parse source . . cmdName
cmdName = filespec("name",cmdName)
cmdName = substr(cmdName,1,lastPos('.',cmdName)-1)

/* Parse the command line and display usage, if needed. */

parse arg inputFile outputFile .
if (inputFile = '') | (outputFile ='') then
do
  say 'usage: 'cmdName' inputFile outputFile'
  say 'This sample script reads all the entries from the inputFile and writes'
  say 'into the outputFile only those parts that have a build relationship'
  say 'of "InputTo".'
  exit 1
end

say 'Executing:    ' cmdName
say 'inputFile:    ' inputFile
say 'outputFile:   ' outputFile

rc_file =  STREAM( inputFile, C, 'open read' )
if ( rc_file \= "READY:" ) then
do
  say "Error while trying to open input file:      " inputFile
  say "the return code from opening the stream is: " rc_file
  say "Exiting due to error."
  exit 1
end

rc_file =  STREAM( outputFile, C, 'open write' )
if ( rc_file \= "READY:" ) then do
  say "Error while trying to open outputFile:      " outputFile
  say "the return code from opening the stream is: " rc_file
  say "Exiting due to error."
  exit 1
end

counterTotal = 0      /* Total lines in inputFile */
counterFiltered = 0   /* Total lines written into the outputFile */
do until ( lines(inputFile) = 0 )  /* Read until the end of the input file */
  inputLine = LINEIN(inputFile)
  parse var inputLine baseName '|' releaseName '|' compName '|' committedVersion '|' ,
    addDate '|' dropDate '|' lastUpdate '|' pathName '|' currentVersion '|' ,
    nuAddDate '|' nuDropDate '|' nuPathName '|' userLogin '|' fmode '|' ,
    fileType '|' changeType '|' waName '|' partType '|' temporary '|' ,
    builderName '|' parserName '|' parentName '|' hasChildren '|',
    buildStatus '|' typeOfRelation '|' parameters '|',
    workareAreaChange '|' translation '|' transState '|' restricted .
  counterTotal = counterTotal + 1

  if (typeOfRelation = 'InputTo') then
  do
    say "Filtering part ("counterTotal"): " pathName
    temp = LINEOUT(outputFile, inputLine)  
    counterFiltered = counterFiltered + 1
  end

end

say ""
say "Total number of parts read from inputFile:     " counterTotal
say "Total number of parts written into outputFile: " counterFiltered

rc = STREAM( inputFile, C, 'close' )
rc = STREAM( outputFile, C, 'close' )

exit 0

/*                                                                   */
/*-------  the end  -------------------------------------------------*/

