/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcadmin;

import com.ibm.vatc.tcadmin.CopyFile;
import com.ibm.vatc.tcadmin.ErrorDialog;
import com.ibm.vatc.tcadmin.ProcessMonitor;
import com.ibm.vatc.tcadmin.ProgressDialog;
import com.ibm.vatc.tcadmin.SpinButton;
import com.ibm.vatc.tcadmin.SplitBorder;
import com.ibm.vatc.tcadmin.TextLimit;
import com.ibm.vatc.tcadmin.tcadmin;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ListResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class ReqdPage
extends JPanel
implements AdjustmentListener,
ItemListener,
DocumentListener {
    private ListResourceBundle locResource = tcadmin.locResource;
    private JPanel Family;
    private JPanel Security;
    private JPanel SuperUser;
    private JTextField FamNameEntry;
    private JTextField PathEntry;
    private JTextField PortEntry;
    private JTextField MailerEntry;
    private JTextField LoginEntry;
    private JTextField UseridEntry;
    private JTextField HostEntry;
    private JPasswordField PasswordEntry;
    private JPasswordField VerifyPasswordEntry;
    private JComboBox SecLevelChoice;
    private JLabel FamName;
    private JLabel Path;
    private JLabel Port;
    private JLabel Mailer;
    private JLabel Login;
    private JLabel Userid;
    private JLabel Host;
    private JLabel Password;
    private JLabel VerifyPassword;
    private JLabel SecLevel;
    private JLabel PasswordMinLabel;
    private JLabel MaxInvalidLabel;
    private SpinButton PasswordMin;
    private SpinButton MaxInvalid;
    private boolean writeRequired = false;
    private boolean suUpdateRequired = false;
    private String savUserid;
    private String savHost;
    private String savLogin;
    private String savPassword;

    public ReqdPage() {
        this.setLayout(this.getgridlayout());
        this.add("family", this.getFamily());
        this.add("security", this.getSecurity());
        this.add("superuser", this.getSuperUser());
        this.writeRequired = false;
        this.suUpdateRequired = false;
        this.getPasswordMin().addAdjustmentListener(this);
        this.getMaxInvalid().addAdjustmentListener(this);
        this.getSecLevelChoice().addItemListener(this);
        this.getLoginEntry().getDocument().addDocumentListener(this);
        this.getUseridEntry().getDocument().addDocumentListener(this);
        this.getHostEntry().getDocument().addDocumentListener(this);
        this.getPasswordEntry().getDocument().addDocumentListener(this);
        this.getVerifyPasswordEntry().getDocument().addDocumentListener(this);
    }

    public void setUserid(String string) {
        this.savUserid = string;
        this.UseridEntry.setText(string);
    }

    public void setHost(String string) {
        this.savHost = string;
        this.HostEntry.setText(string);
    }

    public void setLogin(String string) {
        this.savLogin = string;
        this.LoginEntry.setText(string);
    }

    public void setPassword(String string) {
        this.savPassword = string;
        ((JTextComponent)this.PasswordEntry).setText(string);
        ((JTextComponent)this.VerifyPasswordEntry).setText(string);
    }

    public boolean verifyPasswordLength(Frame frame) {
        boolean bl = true;
        if ((this.SecLevelChoice.getSelectedItem().equals((String)this.locResource.handleGetObject("STR_PASSWORD_ONLY")) || this.SecLevelChoice.getSelectedItem().equals((String)this.locResource.handleGetObject("STR_PASSWORD_OR_HOST"))) && this.getPasswordEntry().getText().length() < this.PasswordMin.getValue()) {
            ErrorDialog errorDialog = ErrorDialog.getErrorDialog(frame, (String)tcadmin.locResource.handleGetObject("STR_WARN"), (String)tcadmin.locResource.handleGetObject("STR_ERR_MIN_PW_LEN"));
            ((Component)errorDialog).setVisible(true);
            bl = false;
        } else if (!this.getPasswordEntry().getText().equals(this.getVerifyPasswordEntry().getText())) {
            ErrorDialog errorDialog = ErrorDialog.getErrorDialog(frame, (String)tcadmin.locResource.handleGetObject("STR_WARN"), (String)tcadmin.locResource.handleGetObject("STR_ERR_PW_VPW_MISMATCH"));
            ((Component)errorDialog).setVisible(true);
            bl = false;
        }
        return bl;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Object object = adjustmentEvent.getSource();
        if (object == this.getPasswordMin() || object == this.getMaxInvalid()) {
            this.writeRequired = true;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.getSecLevelChoice()) {
            this.writeRequired = true;
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.textValueChanged(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.textValueChanged(documentEvent);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.textValueChanged(documentEvent);
    }

    private void textValueChanged(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        if (document == this.getLoginEntry().getDocument() && !this.savLogin.equals(this.getLoginEntry().getText())) {
            this.suUpdateRequired = true;
            this.savLogin = this.getLoginEntry().getText();
        }
        if (document == this.getUseridEntry().getDocument() && !this.savUserid.equals(this.getUseridEntry().getText())) {
            this.suUpdateRequired = true;
            this.savLogin = this.getUseridEntry().getText();
        }
        if (document == this.getHostEntry().getDocument() && !this.savHost.equals(this.getHostEntry().getText())) {
            this.suUpdateRequired = true;
            this.savHost = this.getHostEntry().getText();
        }
        if (document == this.getPasswordEntry().getDocument() && !this.savPassword.equals(this.getPasswordEntry().getText())) {
            this.suUpdateRequired = true;
            this.savPassword = this.getPasswordEntry().getText();
        }
    }

    private GridLayout getgridlayout() {
        GridLayout gridLayout = null;
        gridLayout = new GridLayout();
        gridLayout.setVgap(3);
        gridLayout.setHgap(5);
        gridLayout.setColumns(1);
        gridLayout.setRows(3);
        return gridLayout;
    }

    private JLabel getFamName() {
        if (this.FamName == null) {
            this.FamName = new JLabel((String)this.locResource.handleGetObject("STR_NAME"), 2);
            this.FamName.setFont(tcadmin.getDefaultFont());
        }
        return this.FamName;
    }

    public JTextField getFamNameEntry() {
        if (this.FamNameEntry == null) {
            this.FamNameEntry = new JTextField("");
            this.FamNameEntry.setFont(tcadmin.getDefaultFont());
            TextLimit.limit(this.FamNameEntry, 8);
        }
        return this.FamNameEntry;
    }

    private JLabel getPath() {
        if (this.Path == null) {
            this.Path = new JLabel((String)this.locResource.handleGetObject("STR_PATH"), 2);
            this.Path.setFont(tcadmin.getDefaultFont());
        }
        return this.Path;
    }

    public JTextField getPathEntry() {
        if (this.PathEntry == null) {
            this.PathEntry = new JTextField("");
            this.PathEntry.setFont(tcadmin.getDefaultFont());
        }
        return this.PathEntry;
    }

    private JLabel getPort() {
        if (this.Port == null) {
            this.Port = new JLabel((String)this.locResource.handleGetObject("STR_PORT"), 2);
            this.Port.setFont(tcadmin.getDefaultFont());
        }
        return this.Port;
    }

    public JTextField getPortEntry() {
        if (this.PortEntry == null) {
            this.PortEntry = new JTextField();
            this.PortEntry.setFont(tcadmin.getDefaultFont());
        }
        return this.PortEntry;
    }

    private JLabel getMailer() {
        if (this.Mailer == null) {
            this.Mailer = new JLabel((String)this.locResource.handleGetObject("STR_MAILER"), 2);
            this.Mailer.setFont(tcadmin.getDefaultFont());
        }
        return this.Mailer;
    }

    public JTextField getMailerEntry() {
        if (this.MailerEntry == null) {
            this.MailerEntry = new JTextField("");
            this.MailerEntry.setFont(tcadmin.getDefaultFont());
        }
        return this.MailerEntry;
    }

    private JLabel getLogin() {
        if (this.Login == null) {
            this.Login = new JLabel((String)this.locResource.handleGetObject("STR_LOGIN"), 2);
            this.Login.setFont(tcadmin.getDefaultFont());
        }
        return this.Login;
    }

    public JTextField getLoginEntry() {
        if (this.LoginEntry == null) {
            this.LoginEntry = new JTextField("");
            this.LoginEntry.setFont(tcadmin.getDefaultFont());
        }
        return this.LoginEntry;
    }

    private JLabel getUserid() {
        if (this.Userid == null) {
            this.Userid = new JLabel((String)this.locResource.handleGetObject("STR_USERID"), 2);
            this.Userid.setFont(tcadmin.getDefaultFont());
        }
        return this.Userid;
    }

    public JTextField getUseridEntry() {
        if (this.UseridEntry == null) {
            this.UseridEntry = new JTextField("");
            this.UseridEntry.setFont(tcadmin.getDefaultFont());
        }
        return this.UseridEntry;
    }

    private JLabel getHost() {
        if (this.Host == null) {
            this.Host = new JLabel((String)this.locResource.handleGetObject("STR_HOST"), 2);
            this.Host.setFont(tcadmin.getDefaultFont());
        }
        return this.Host;
    }

    public JTextField getHostEntry() {
        if (this.HostEntry == null) {
            this.HostEntry = new JTextField("");
            this.HostEntry.setFont(tcadmin.getDefaultFont());
        }
        return this.HostEntry;
    }

    private JLabel getPassword() {
        if (this.Password == null) {
            this.Password = new JLabel((String)this.locResource.handleGetObject("STR_PASSWORD"), 2);
            this.Password.setFont(tcadmin.getDefaultFont());
        }
        return this.Password;
    }

    public JPasswordField getPasswordEntry() {
        if (this.PasswordEntry == null) {
            this.PasswordEntry = new JPasswordField("");
            this.PasswordEntry.setFont(tcadmin.getDefaultFont());
        }
        return this.PasswordEntry;
    }

    private JLabel getVerifyPassword() {
        if (this.VerifyPassword == null) {
            this.VerifyPassword = new JLabel((String)this.locResource.handleGetObject("STR_VERIFYPASSWORD"), 2);
            this.VerifyPassword.setFont(tcadmin.getDefaultFont());
        }
        return this.VerifyPassword;
    }

    public JPasswordField getVerifyPasswordEntry() {
        if (this.VerifyPasswordEntry == null) {
            this.VerifyPasswordEntry = new JPasswordField("");
            this.VerifyPasswordEntry.setFont(tcadmin.getDefaultFont());
        }
        return this.VerifyPasswordEntry;
    }

    private SpinButton getPasswordMin() {
        if (this.PasswordMin == null) {
            this.PasswordMin = new SpinButton(2, 1, 32);
            this.PasswordMin.setFont(tcadmin.getDefaultFont());
            this.PasswordMin.setValue(8);
        }
        return this.PasswordMin;
    }

    private SpinButton getMaxInvalid() {
        if (this.MaxInvalid == null) {
            this.MaxInvalid = new SpinButton(3, 0, 255);
            this.MaxInvalid.setFont(tcadmin.getDefaultFont());
            this.MaxInvalid.setValue(0);
        }
        return this.MaxInvalid;
    }

    public JComboBox getSecLevelChoice() {
        if (this.SecLevelChoice == null) {
            this.SecLevelChoice = new JComboBox();
            this.SecLevelChoice.setFont(tcadmin.getDefaultFont());
            this.SecLevelChoice.addItem((String)this.locResource.handleGetObject("STR_HOST_ONLY"));
            this.SecLevelChoice.addItem((String)this.locResource.handleGetObject("STR_PASSWORD_ONLY"));
            this.SecLevelChoice.addItem((String)this.locResource.handleGetObject("STR_PASSWORD_OR_HOST"));
            this.SecLevelChoice.addItem((String)this.locResource.handleGetObject("STR_NONE"));
        }
        return this.SecLevelChoice;
    }

    private JLabel getSecLevel() {
        if (this.SecLevel == null) {
            this.SecLevel = new JLabel((String)this.locResource.handleGetObject("STR_AUTHENTICATIONLBL"), 0);
            this.SecLevel.setFont(tcadmin.getDefaultFont());
        }
        return this.SecLevel;
    }

    private JLabel getPasswordMinLabel() {
        if (this.PasswordMinLabel == null) {
            this.PasswordMinLabel = new JLabel((String)this.locResource.handleGetObject("STR_PASSWORDLENGTHLBL"), 0);
            this.PasswordMinLabel.setFont(tcadmin.getDefaultFont());
        }
        return this.PasswordMinLabel;
    }

    private JLabel getMaxInvalidLabel() {
        if (this.MaxInvalidLabel == null) {
            this.MaxInvalidLabel = new JLabel((String)this.locResource.handleGetObject("STR_INVALIDATTEMPTSLBL"), 0);
            this.MaxInvalidLabel.setFont(tcadmin.getDefaultFont());
        }
        return this.MaxInvalidLabel;
    }

    private JPanel getFamily() {
        if (this.Family == null) {
            this.Family = new JPanel();
            SplitBorder splitBorder = new SplitBorder((String)this.locResource.handleGetObject("STR_FAMILY"), tcadmin.getDefaultFont());
            this.Family.setBorder(splitBorder);
            this.Family.setFont(tcadmin.getDefaultFont());
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.Family.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 50.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(4, 2, 4, 10);
            gridBagLayout.setConstraints(this.getFamName(), gridBagConstraints);
            this.Family.add(this.getFamName());
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 150.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(4, 2, 4, 80);
            gridBagLayout.setConstraints(this.getFamNameEntry(), gridBagConstraints);
            this.Family.add(this.getFamNameEntry());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(4, 2, 4, 10);
            gridBagLayout.setConstraints(this.getPath(), gridBagConstraints);
            this.Family.add(this.getPath());
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(4, 2, 4, 80);
            gridBagLayout.setConstraints(this.getPathEntry(), gridBagConstraints);
            this.Family.add(this.getPathEntry());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(4, 2, 4, 10);
            gridBagLayout.setConstraints(this.getPort(), gridBagConstraints);
            this.Family.add(this.getPort());
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(4, 2, 4, 80);
            gridBagLayout.setConstraints(this.getPortEntry(), gridBagConstraints);
            this.Family.add(this.getPortEntry());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(4, 2, 4, 10);
            gridBagLayout.setConstraints(this.getMailer(), gridBagConstraints);
            this.Family.add(this.getMailer());
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(4, 2, 4, 80);
            gridBagLayout.setConstraints(this.getMailerEntry(), gridBagConstraints);
            this.Family.add(this.getMailerEntry());
        }
        return this.Family;
    }

    private JPanel getSuperUser() {
        if (this.SuperUser == null) {
            this.SuperUser = new JPanel();
            SplitBorder splitBorder = new SplitBorder((String)this.locResource.handleGetObject("STR_SUPERUSER"), tcadmin.getDefaultFont());
            this.SuperUser.setBorder(splitBorder);
            this.SuperUser.setFont(tcadmin.getDefaultFont());
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.SuperUser.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 50.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(4, 2, 4, 10);
            gridBagLayout.setConstraints(this.getLogin(), gridBagConstraints);
            this.SuperUser.add(this.getLogin());
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 150.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(4, 2, 4, 80);
            gridBagLayout.setConstraints(this.getLoginEntry(), gridBagConstraints);
            this.SuperUser.add(this.getLoginEntry());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(4, 2, 4, 10);
            gridBagLayout.setConstraints(this.getUserid(), gridBagConstraints);
            this.SuperUser.add(this.getUserid());
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(4, 2, 4, 80);
            gridBagLayout.setConstraints(this.getUseridEntry(), gridBagConstraints);
            this.SuperUser.add(this.getUseridEntry());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(4, 2, 4, 10);
            gridBagLayout.setConstraints(this.getHost(), gridBagConstraints);
            this.SuperUser.add(this.getHost());
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(4, 2, 4, 80);
            gridBagLayout.setConstraints(this.getHostEntry(), gridBagConstraints);
            this.SuperUser.add(this.getHostEntry());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(4, 2, 4, 10);
            gridBagLayout.setConstraints(this.getPassword(), gridBagConstraints);
            this.SuperUser.add(this.getPassword());
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(4, 2, 4, 80);
            gridBagLayout.setConstraints(this.getPasswordEntry(), gridBagConstraints);
            this.SuperUser.add(this.getPasswordEntry());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(4, 2, 4, 10);
            gridBagLayout.setConstraints(this.getVerifyPassword(), gridBagConstraints);
            this.SuperUser.add(this.getVerifyPassword());
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(4, 2, 4, 80);
            gridBagLayout.setConstraints(this.getVerifyPasswordEntry(), gridBagConstraints);
            this.SuperUser.add(this.getVerifyPasswordEntry());
        }
        return this.SuperUser;
    }

    private JPanel getSecurity() {
        if (this.Security == null) {
            this.Security = new JPanel();
            SplitBorder splitBorder = new SplitBorder((String)this.locResource.handleGetObject("STR_SECURITYTITLE"), tcadmin.getDefaultFont());
            this.Security.setBorder(splitBorder);
            this.Security.setFont(tcadmin.getDefaultFont());
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.Security.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(4, 2, 4, 20);
            gridBagLayout.setConstraints(this.getSecLevel(), gridBagConstraints);
            this.Security.add(this.getSecLevel());
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(4, 2, 4, 2);
            gridBagLayout.setConstraints(this.getPasswordMinLabel(), gridBagConstraints);
            this.Security.add(this.getPasswordMinLabel());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(4, 2, 4, 20);
            gridBagConstraints.ipadx = 25;
            gridBagConstraints.ipady = 0;
            gridBagLayout.setConstraints(this.getSecLevelChoice(), gridBagConstraints);
            this.Security.add(this.getSecLevelChoice());
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(4, 2, 4, 2);
            gridBagConstraints.ipadx = 25;
            gridBagConstraints.ipady = 0;
            gridBagLayout.setConstraints(this.getPasswordMin(), gridBagConstraints);
            this.Security.add(this.getPasswordMin());
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(4, 2, 4, 20);
            gridBagConstraints.ipadx = 25;
            gridBagConstraints.ipady = 0;
            gridBagLayout.setConstraints(this.getMaxInvalidLabel(), gridBagConstraints);
            this.Security.add(this.getMaxInvalidLabel());
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(4, 2, 4, 2);
            gridBagConstraints.ipadx = 25;
            gridBagConstraints.ipady = 0;
            gridBagLayout.setConstraints(this.getMaxInvalid(), gridBagConstraints);
            this.Security.add(this.getMaxInvalid());
        }
        return this.Security;
    }

    public boolean readSettings(File file, Frame frame) {
        boolean bl = false;
        try {
            File file2 = new File(file, "config");
            File file3 = new File(file2, "security");
            if (file3.exists()) {
                FileReader fileReader = new FileReader(file3);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                String string = bufferedReader.readLine();
                while (string != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string.trim().toUpperCase());
                    if (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        if (string2.equals("AUTHENTICATION")) {
                            string2 = stringTokenizer.nextToken();
                            if (string2.equals("LEVEL")) {
                                string2 = stringTokenizer.nextToken();
                                string2 = stringTokenizer.nextToken();
                                if (string2.equals("HOST_ONLY")) {
                                    this.SecLevelChoice.setSelectedItem((String)this.locResource.handleGetObject("STR_HOST_ONLY"));
                                } else if (string2.equals("PASSWORD_ONLY")) {
                                    this.SecLevelChoice.setSelectedItem((String)this.locResource.handleGetObject("STR_PASSWORD_ONLY"));
                                } else if (string2.equals("PASSWORD_OR_HOST")) {
                                    this.SecLevelChoice.setSelectedItem((String)this.locResource.handleGetObject("STR_PASSWORD_OR_HOST"));
                                } else if (string2.equals("NONE")) {
                                    this.SecLevelChoice.setSelectedItem((String)this.locResource.handleGetObject("STR_NONE"));
                                }
                            }
                        } else if (string2.equals("MINIMUM")) {
                            string2 = stringTokenizer.nextToken();
                            if (string2.equals("PASSWORD") && (string2 = stringTokenizer.nextToken()).equals("LENGTH")) {
                                string2 = stringTokenizer.nextToken();
                                string2 = stringTokenizer.nextToken();
                                this.PasswordMin.setValue(Integer.parseInt(string2));
                            }
                        } else if (string2.equals("MAXIMUM") && (string2 = stringTokenizer.nextToken()).equals("INVALID") && (string2 = stringTokenizer.nextToken()).equals("ATTEMPTS")) {
                            string2 = stringTokenizer.nextToken();
                            string2 = stringTokenizer.nextToken();
                            this.MaxInvalid.setValue(Integer.parseInt(string2));
                        }
                    }
                    string = bufferedReader.readLine();
                }
                bufferedReader.close();
                bl = true;
                this.writeRequired = false;
            } else {
                this.writeRequired = true;
            }
        }
        catch (Throwable throwable) {
            ErrorDialog errorDialog = ErrorDialog.getErrorDialog(frame, (String)this.locResource.handleGetObject("STR_WARN"), (String)this.locResource.handleGetObject("STR_WARN_NO_SECURITY"));
            ((Component)errorDialog).setVisible(true);
            this.writeRequired = true;
        }
        return bl;
    }

    public static boolean copySettings(File file, File file2, Frame frame) {
        boolean bl;
        block2: {
            bl = false;
            if (file == null || file2 == null) break block2;
            File file3 = new File(file, "config");
            File file4 = new File(file2, "config");
            try {
                new CopyFile(new File(file3, "security"), file4);
                bl = true;
            }
            catch (Throwable throwable) {
                ErrorDialog errorDialog = ErrorDialog.getErrorDialog(frame, (String)tcadmin.locResource.handleGetObject("STR_ERR"), (String)tcadmin.locResource.handleGetObject("STR_ERR_COPY_REQD"));
                ((Component)errorDialog).setVisible(true);
            }
        }
        return bl;
    }

    public static boolean applySettings(File file, String[] stringArray, String string, String string2, String string3, String string4, String string5, ProgressDialog progressDialog) {
        boolean bl = true;
        if (string3 == null || string3.length() == 0) {
            ErrorDialog errorDialog = ErrorDialog.getErrorDialog(progressDialog.getFrame(), (String)tcadmin.locResource.handleGetObject("STR_ERR"), (String)tcadmin.locResource.handleGetObject("STR_ERR_INVALID_FAMILY_NAME"));
            ((Component)errorDialog).setVisible(true);
            bl = false;
            progressDialog.dispose();
        } else {
            progressDialog.setMessage((String)tcadmin.locResource.handleGetObject("STR_MSG_CREATE_SU"));
            progressDialog.increment();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("fhchdf -create -login ");
            stringBuffer.append(string);
            if (string2 != null && string2.length() > 0) {
                stringBuffer.append(" -address ");
                stringBuffer.append(string2);
            }
            stringBuffer.append(" -family ");
            stringBuffer.append(string3);
            stringBuffer.append(" -user ");
            stringBuffer.append(string4);
            StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.toString());
            if (string5 != null && string5.length() > 0) {
                stringBuffer.append(" -password ");
                stringBuffer.append(string5);
                stringBuffer2.append(" -password ******");
            }
            if (tcadmin.errLog != null) {
                tcadmin.errLog.println(stringBuffer2.toString());
            }
            ProcessMonitor processMonitor = new ProcessMonitor(stringBuffer.toString(), stringArray);
            processMonitor.addIoListener(progressDialog);
            int n = processMonitor.waitFor();
            if (n != 0) {
                ErrorDialog errorDialog = ErrorDialog.getErrorDialog(progressDialog.getFrame(), (String)tcadmin.locResource.handleGetObject("STR_ERR"), (String)tcadmin.locResource.handleGetObject("STR_ERR_CREATE_SU"));
                errorDialog.setOutput(progressDialog.getOutput());
                ((Component)errorDialog).setVisible(true);
                bl = false;
                progressDialog.dispose();
            } else {
                progressDialog.clearOutput();
            }
        }
        return bl;
    }

    public boolean writeSecurityInfo(File file, Frame frame) {
        boolean bl;
        block9: {
            bl = true;
            if (!bl || !this.writeRequired) break block9;
            try {
                File file2 = new File(file, "config");
                File file3 = new File(file2, "security");
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                PrintWriter printWriter = new PrintWriter(fileOutputStream);
                printWriter.print(" authentication level   = ");
                String string = (String)this.SecLevelChoice.getSelectedItem();
                if (string.equals((String)this.locResource.handleGetObject("STR_HOST_ONLY"))) {
                    printWriter.println("HOST_ONLY");
                } else if (string.equals((String)this.locResource.handleGetObject("STR_PASSWORD_ONLY"))) {
                    printWriter.println("PASSWORD_ONLY");
                } else if (string.equals((String)this.locResource.handleGetObject("STR_PASSWORD_OR_HOST"))) {
                    printWriter.println("PASSWORD_OR_HOST");
                } else if (string.equals((String)this.locResource.handleGetObject("STR_NONE"))) {
                    printWriter.println("NONE");
                }
                printWriter.print(" minimum password length   = ");
                int n = this.PasswordMin.getValue();
                printWriter.println(n);
                printWriter.print(" maximum invalid attempts  = ");
                int n2 = this.MaxInvalid.getValue();
                printWriter.println(n2);
                printWriter.flush();
                printWriter.close();
                fileOutputStream.close();
                bl = true;
                this.writeRequired = false;
            }
            catch (Throwable throwable) {
                ErrorDialog errorDialog = ErrorDialog.getErrorDialog(frame, (String)this.locResource.handleGetObject("STR_ERR"), (String)this.locResource.handleGetObject("STR_ERR_SECURITY"));
                ((Component)errorDialog).setVisible(true);
                bl = false;
            }
        }
        return bl;
    }

    public boolean writeSettings(File file, String[] stringArray, ProgressDialog progressDialog) {
        boolean bl = true;
        bl = this.writeSecurityInfo(file, progressDialog.getFrame());
        if (bl && this.suUpdateRequired && !(bl = this.verifyPasswordLength(progressDialog.getFrame()))) {
            progressDialog.dispose();
        }
        if (bl && this.suUpdateRequired) {
            progressDialog.setMessage((String)tcadmin.locResource.handleGetObject("STR_MSG_CREATE_SU"));
            progressDialog.increment();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("fhchdf -create -login ");
            stringBuffer.append(this.getLoginEntry().getText());
            if (this.getHostEntry().getText().length() > 0) {
                stringBuffer.append(" -address ");
                stringBuffer.append(this.getHostEntry().getText());
            }
            stringBuffer.append(" -family ");
            stringBuffer.append(this.getFamNameEntry().getText());
            stringBuffer.append(" -user ");
            stringBuffer.append(this.getUseridEntry().getText());
            StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.toString());
            if (this.getPasswordEntry().getText().length() > 0) {
                stringBuffer.append(" -password ");
                stringBuffer.append(this.getPasswordEntry().getText());
                stringBuffer2.append(" -password ******");
            }
            if (tcadmin.errLog != null) {
                tcadmin.errLog.println(stringBuffer2.toString());
            }
            ProcessMonitor processMonitor = new ProcessMonitor(stringBuffer.toString(), stringArray);
            processMonitor.addIoListener(progressDialog);
            int n = processMonitor.waitFor();
            if (n != 0) {
                ErrorDialog errorDialog = ErrorDialog.getErrorDialog(progressDialog.getFrame(), (String)tcadmin.locResource.handleGetObject("STR_ERR"), (String)tcadmin.locResource.handleGetObject("STR_ERR_CREATE_SU"));
                errorDialog.setOutput(progressDialog.getOutput());
                ((Component)errorDialog).setVisible(true);
                bl = false;
                progressDialog.dispose();
            } else {
                this.suUpdateRequired = false;
                progressDialog.clearOutput();
            }
        }
        return bl;
    }

    public static void deleteSettings(File file) {
    }
}

