/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcmerge;

import com.ibm.vatc.reuse.awt.ButtonPanel;
import com.ibm.vatc.reuse.awt.GridTools;
import com.ibm.vatc.tcmerge.StringTools;
import com.ibm.vatc.tcmerge.TCMergeException;
import com.ibm.vatc.tcmerge.TCMergeHelp;
import com.ibm.vatc.tcmerge.WarningDialog;
import com.ibm.vatc.tcmerge.tcmerge;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

class GoToDifferenceDialog
extends Dialog {
    String action;
    int differenceNumber;
    int numberOfDifferences;
    Frame parentFrame;
    TextField textField;
    boolean modalOn;

    public GoToDifferenceDialog(Frame frame, int n) {
        super(frame, tcmerge.locResource.getString("TITLE_GOTO_DIFF"), true);
        this.parentFrame = frame;
        this.numberOfDifferences = n;
        this.setLayout(new GridBagLayout());
        ((Component)this).setSize(265, 130);
        ((Component)this).setFont(tcmerge.getDefaultFont());
        this.modalOn = false;
        DialogListener dialogListener = new DialogListener();
        this.addWindowListener(dialogListener);
        KeyboardListener keyboardListener = new KeyboardListener();
        this.addKeyListener(keyboardListener);
        String[][] stringArray = new String[][]{{tcmerge.locResource.getString("STR_GO_TO"), "Go To"}, {tcmerge.locResource.getString("STR_CANCEL"), "Cancel"}, {tcmerge.locResource.getString("STR_HELP"), "Help"}};
        ButtonPanel buttonPanel = new ButtonPanel(stringArray, new ButtonListener());
        buttonPanel.addKeyListener(keyboardListener);
        GridTools.constrain(this, buttonPanel, 2, 4, 3, 1, 0, 0, 13, 0);
        GridTools.constrain(this, new Label(tcmerge.locResource.getString("TITLE_GOTO_DIFF")), 2, 2, 1, 1);
        this.textField = new TextField("", 3);
        this.textField.setFont(tcmerge.getDefaultFont());
        this.textField.addKeyListener(keyboardListener);
        this.textField.addKeyListener(new TextFieldKeyListener("Go To"));
        GridTools.constrain(this, this.textField, 3, 2, 1, 1);
        String string = " " + tcmerge.locResource.getString("STR_OF") + " " + new Integer(n).toString();
        GridTools.constrain(this, new Label(string), 4, 2, 1, 1, 0, 0, 13, 0);
        Canvas canvas = new Canvas();
        canvas.setSize(15, 15);
        GridTools.constrain(this, canvas, 5, 5, 1, 1);
        Canvas canvas2 = new Canvas();
        canvas2.setSize(15, 15);
        GridTools.constrain(this, canvas2, 1, 1, 1, 1);
        Canvas canvas3 = new Canvas();
        canvas3.setSize(1, 15);
        GridTools.constrain(this, canvas3, 1, 3, 1, 1);
        this.pack();
        Dimension dimension = frame.getSize();
        Dimension dimension2 = this.getSize();
        Point point = frame.getLocationOnScreen();
        ((Component)this).setLocation(point.x + (dimension.width - dimension2.width) / 2, point.y + (dimension.height - dimension2.height) / 2);
    }

    public String getAction() {
        return this.action;
    }

    public int getDifferenceNumber() {
        return this.differenceNumber;
    }

    public void goToEvent() {
        if (this.modalOn) {
            return;
        }
        try {
            Integer n;
            String string = this.textField.getText();
            try {
                string = StringTools.stripChar(string, ' ');
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new TCMergeException(6, string, String.valueOf(this.numberOfDifferences));
            }
            if (n > this.numberOfDifferences || n < 1) {
                throw new TCMergeException(6, string, String.valueOf(this.numberOfDifferences));
            }
            this.differenceNumber = n;
            this.action = "GOTO";
            ((Component)this).setVisible(false);
            return;
        }
        catch (TCMergeException tCMergeException) {
            WarningDialog warningDialog = new WarningDialog(this.parentFrame, tCMergeException.toString());
            this.modalOn = true;
            warningDialog.show();
            this.modalOn = false;
            warningDialog.dispose();
            return;
        }
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("GoToDifferenceDialog Test");
        ((Component)frame).setSize(200, 100);
        ((Component)frame).setVisible(true);
        GoToDifferenceDialog goToDifferenceDialog = new GoToDifferenceDialog(frame, 10);
        goToDifferenceDialog.show();
        System.out.println("Action: " + goToDifferenceDialog.getAction());
        System.out.println("Difference Number: " + goToDifferenceDialog.getDifferenceNumber());
        goToDifferenceDialog.dispose();
        System.exit(0);
    }

    class DialogListener
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            if (GoToDifferenceDialog.this.modalOn) {
                return;
            }
            GoToDifferenceDialog.this.action = "CANCEL";
            ((Component)GoToDifferenceDialog.this).setVisible(false);
        }

        DialogListener() {
            GoToDifferenceDialog.this = GoToDifferenceDialog.this;
        }
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
            GoToDifferenceDialog.this = GoToDifferenceDialog.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Go To")) {
                GoToDifferenceDialog.this.goToEvent();
                return;
            }
            if (string.equals("Cancel")) {
                if (GoToDifferenceDialog.this.modalOn) {
                    return;
                }
                GoToDifferenceDialog.this.action = "CANCEL";
                ((Component)GoToDifferenceDialog.this).setVisible(false);
                return;
            }
            if (string.equals("Help")) {
                TCMergeHelp.showHelp(GoToDifferenceDialog.this.parentFrame, "HDRVIEW100");
            }
        }
    }

    class KeyboardListener
    extends KeyAdapter {
        KeyboardListener() {
            GoToDifferenceDialog.this = GoToDifferenceDialog.this;
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                if (GoToDifferenceDialog.this.modalOn) {
                    return;
                }
                GoToDifferenceDialog.this.action = "CANCEL";
                ((Component)GoToDifferenceDialog.this).setVisible(false);
            }
        }
    }

    class TextFieldKeyListener
    extends KeyAdapter {
        String action;

        TextFieldKeyListener(String string) {
            GoToDifferenceDialog.this = GoToDifferenceDialog.this;
            this.action = string;
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10 && this.action.equals("Go To")) {
                GoToDifferenceDialog.this.goToEvent();
            }
        }
    }
}

