/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcmerge;

import com.ibm.vatc.tcmerge.DiffInfoCommon;
import com.ibm.vatc.tcmerge.DiffInput;
import com.ibm.vatc.tcmerge.Editor;
import com.ibm.vatc.tcmerge.FileOneView;
import com.ibm.vatc.tcmerge.FileTwoView;
import com.ibm.vatc.tcmerge.FileZeroView;
import com.ibm.vatc.tcmerge.MakeViews;
import com.ibm.vatc.tcmerge.MergeGui;
import com.ibm.vatc.tcmerge.Navigate;
import com.ibm.vatc.tcmerge.Options;
import com.ibm.vatc.tcmerge.TextRefFiles;
import com.ibm.vatc.tcmerge.ViewParam;
import java.awt.Adjustable;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ScrollPane;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

public class NavigatorCanvas
extends Canvas {
    MergeGui mg;
    int prediffbartop;
    int prediffbarbottom;
    Image offImage;
    Graphics imageBuffer;
    Color lightergray = new Color(220, 220, 220);
    Color lightestgray = new Color(215, 215, 215);
    Dimension dimension;
    ScrollPane scroller;
    Adjustable verticalAdj;
    int initialHeight;
    int currDiff;
    Vector diffTableOutput;
    Vector tableOutput;
    Vector diffTableFileZero;
    Vector diffTableFileOne;
    Vector diffTableFileTwo;
    Vector tableFileZero;
    Vector tableFileOne;
    Vector tableFileTwo;
    FileZeroView fileZeroView;
    FileOneView fileOneView;
    FileTwoView fileTwoView;
    DiffInput diffInput;
    ViewParam viewParam;
    MakeViews makeView;
    Editor editor;
    int size;
    int totaldiffs;
    int differenceView = 1;
    boolean update = true;
    int toprec;
    int bottomrec;
    int grabber1left;
    int grabber1top;
    int grabber1right;
    int grabber1bottom;
    int grabber2left;
    int grabber2top;
    int grabber2right;
    int grabber2bottom;
    boolean dragged = false;
    boolean grabberUpdate = false;
    int topGrabber;
    Vector differenceQuards;
    Vector moveDiff1Quards;
    Vector moveDiff2Quards;
    Vector moveDiff3Quards;
    int input1Size;
    int input2Size;
    int input3Size;
    int totalLines;
    Options options;

    public NavigatorCanvas(ScrollPane scrollPane, MergeGui mergeGui) {
        this.mg = mergeGui;
        this.scroller = scrollPane;
        this.setBackground(Color.lightGray);
        this.getTableValues();
        this.differenceQuards = new Vector();
        this.moveDiff1Quards = new Vector();
        this.moveDiff2Quards = new Vector();
        this.moveDiff3Quards = new Vector();
        this.options = this.mg.getOptions();
        this.options.getEditor().getFontName();
    }

    public void addCanvasListener(MouseListener mouseListener) {
        this.addMouseListener(mouseListener);
    }

    public void getTableValues() {
        this.viewParam = this.mg.getViewParam();
        this.makeView = this.mg.getMakeViews();
        this.currDiff = this.viewParam.getCurrentDiff();
        this.diffTableOutput = this.makeView.getDiffTableOutput();
        this.tableOutput = this.makeView.getTableOutput();
        this.size = this.tableOutput.size();
        this.totaldiffs = this.makeView.totalDifferences;
        this.diffTableFileZero = this.makeView.getDiffTableFileZero();
        this.diffTableFileOne = this.makeView.getDiffTableFileOne();
        this.diffTableFileTwo = this.makeView.getDiffTableFileTwo();
        this.diffInput = this.mg.getDiffInput();
        this.tableFileZero = this.makeView.getTableFileZero();
        this.input1Size = this.tableFileZero.size();
        this.tableFileOne = this.makeView.getTableFileOne();
        this.input2Size = this.tableFileOne.size();
        this.tableFileTwo = this.makeView.getTableFileTwo();
        this.input3Size = this.tableFileTwo.size();
        Options options = this.mg.getOptions();
        this.editor = options.getEditor();
        if (this.input1Size > this.input2Size && this.input1Size > this.input3Size) {
            this.totalLines = this.input1Size;
            return;
        }
        if (this.input2Size > this.input1Size && this.input2Size > this.input3Size) {
            this.totalLines = this.input2Size;
            return;
        }
        this.totalLines = this.input3Size;
    }

    public void paint(Graphics graphics) {
        if (this.differenceView == 1) {
            this.paintContentView();
        } else {
            this.paintPlacementView();
        }
        graphics.drawImage(this.offImage, 0, 0, this);
    }

    public void paintContentView() {
        int n;
        int n2;
        DiffInfoCommon diffInfoCommon;
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        this.getTableValues();
        this.dimension = new Dimension(this.getSize());
        this.offImage = this.createImage(this.dimension.width, this.dimension.height);
        this.imageBuffer = this.offImage.getGraphics();
        this.differenceQuards.removeAllElements();
        while (n5 <= this.totaldiffs) {
            diffInfoCommon = (DiffInfoCommon)this.diffTableOutput.elementAt(n5 - 1);
            n2 = diffInfoCommon.getStartBlock();
            n = diffInfoCommon.getEndBlock();
            this.toprec = Math.round((float)n2 * (float)(this.dimension.height - 10) / (float)this.size);
            this.bottomrec = Math.round((float)(++n) * (float)(this.dimension.height - 10) / (float)this.size);
            if (this.bottomrec - this.toprec < 3) {
                --this.toprec;
                ++this.bottomrec;
            }
            if (n5 == 1) {
                if (n2 != 0) {
                    this.imageBuffer.setColor(this.editor.getNavigatorCommonBlock());
                    this.imageBuffer.fill3DRect(15, 0, this.dimension.width - 30, this.toprec + 1, true);
                } else {
                    this.imageBuffer.setColor(this.editor.getNavigatorCommonBlock());
                    this.imageBuffer.fill3DRect(15, 0, this.dimension.width - 30, this.bottomrec, true);
                }
            } else {
                this.imageBuffer.setColor(this.editor.getNavigatorCommonBlock());
                this.imageBuffer.fill3DRect(15, n3, this.dimension.width - 30, this.toprec, true);
            }
            if (n5 != this.currDiff + 1) {
                this.imageBuffer.setColor(this.editor.getNavigatorDifferenceBlock());
                this.imageBuffer.fill3DRect(15, this.toprec, this.dimension.width - 30, this.bottomrec, true);
            } else {
                this.imageBuffer.setColor(Color.gray);
                this.imageBuffer.fill3DRect(15, this.toprec, this.dimension.width - 30, this.bottomrec, true);
            }
            DifferenceLocations differenceLocations = new DifferenceLocations(this.toprec, this.bottomrec, 15, this.dimension.width - 30);
            this.differenceQuards.addElement(differenceLocations);
            n4 = this.toprec;
            n3 = this.bottomrec;
            ++n5;
        }
        this.imageBuffer.setColor(this.editor.getNavigatorCommonBlock());
        this.imageBuffer.fillRect(15, n3, this.dimension.width - 30, this.dimension.height - 20);
        this.imageBuffer.setColor(Color.lightGray);
        this.imageBuffer.fillRect(15, this.dimension.height - 19, this.dimension.width - 30, this.dimension.height);
        diffInfoCommon = (DiffInfoCommon)this.diffTableOutput.elementAt(this.currDiff);
        n2 = diffInfoCommon.getStartBlock();
        n = diffInfoCommon.getEndBlock();
        this.toprec = Math.round((float)n2 * (float)(this.dimension.height - 10) / (float)this.size);
        this.bottomrec = Math.round((float)(++n) * (float)(this.dimension.height - 10) / (float)this.size);
        this.imageBuffer.setColor(Color.black);
        this.imageBuffer.drawRect(15, 0, this.dimension.width - 30, this.dimension.height - 20);
        if (this.grabberUpdate) {
            this.toprec = this.topGrabber;
        }
        this.grabber1left = this.dimension.width - 19;
        this.grabber1top = this.toprec;
        this.grabber1right = this.dimension.width - 6;
        this.grabber1bottom = this.toprec + 21;
        this.grabber2left = this.dimension.width - 119;
        this.grabber2top = this.toprec;
        this.grabber2right = this.dimension.width - 106;
        this.grabber2bottom = this.toprec + 21;
        this.prediffbartop = this.toprec;
        this.prediffbarbottom = this.bottomrec;
        this.grabberUpdate = false;
    }

    public void paintPlacementView() {
        int n = 1;
        this.getTableValues();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (!this.makeView.isTwowayMerge) {
            n5 = 29;
            n6 = 61;
            n7 = 90;
        } else {
            n5 = 45;
            n6 = 78;
            n7 = 0;
        }
        this.offImage = this.createImage(this.dimension.width, this.dimension.height);
        this.imageBuffer = this.offImage.getGraphics();
        this.imageBuffer.setColor(Color.lightGray);
        this.imageBuffer.fillRect(15, 0, this.dimension.width - 30, this.dimension.height);
        this.imageBuffer.setColor(this.lightergray);
        this.imageBuffer.fillRect(15, 0, this.dimension.width - 30, this.dimension.height - 20);
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        this.moveDiff1Quards.removeAllElements();
        this.moveDiff2Quards.removeAllElements();
        this.moveDiff3Quards.removeAllElements();
        while (n <= this.totaldiffs) {
            int n11;
            int n12;
            DiffInfoCommon diffInfoCommon = (DiffInfoCommon)this.diffTableFileZero.elementAt(n - 1);
            int n13 = diffInfoCommon.getStartBlock();
            int n14 = diffInfoCommon.getEndBlock();
            ++n14;
            TextRefFiles textRefFiles = (TextRefFiles)this.tableFileZero.elementAt(n13);
            n8 = textRefFiles.line;
            diffInfoCommon = (DiffInfoCommon)this.diffTableFileOne.elementAt(n - 1);
            int n15 = diffInfoCommon.getStartBlock();
            int n16 = diffInfoCommon.getEndBlock();
            ++n16;
            textRefFiles = (TextRefFiles)this.tableFileOne.elementAt(n15);
            n9 = textRefFiles.line;
            int n17 = 0;
            int n18 = 0;
            if (!this.makeView.isTwowayMerge && this.diffInput.getInputFiles().size() == 3) {
                diffInfoCommon = (DiffInfoCommon)this.diffTableFileTwo.elementAt(n - 1);
                n17 = diffInfoCommon.getStartBlock();
                n18 = diffInfoCommon.getEndBlock();
                ++n18;
                textRefFiles = (TextRefFiles)this.tableFileTwo.elementAt(n17);
                n10 = textRefFiles.line;
            }
            int n19 = Math.round((float)n13 * (float)(this.dimension.height - 10) / (float)this.size);
            int n20 = Math.round((float)n14 * (float)(this.dimension.height - 10) / (float)this.size);
            DifferenceLocations differenceLocations = new DifferenceLocations(n19, n20, n5, n5 + 13);
            this.moveDiff1Quards.addElement(differenceLocations);
            int n21 = Math.round((float)n15 * (float)(this.dimension.height - 10) / (float)this.size);
            int n22 = Math.round((float)n16 * (float)(this.dimension.height - 10) / (float)this.size);
            differenceLocations = new DifferenceLocations(n21, n22, n6, n6 + 13);
            this.moveDiff2Quards.addElement(differenceLocations);
            int n23 = 0;
            int n24 = 0;
            if (!this.makeView.isTwowayMerge) {
                n23 = Math.round((float)n17 * (float)(this.dimension.height - 10) / (float)this.size);
                n24 = Math.round((float)n18 * (float)(this.dimension.height - 10) / (float)this.size);
                differenceLocations = new DifferenceLocations(n23, n24, n7, n7 + 13);
                this.moveDiff3Quards.addElement(differenceLocations);
            }
            this.imageBuffer.setColor(this.lightergray);
            this.imageBuffer.fill3DRect(n5, n2, 13, n19 + 1, true);
            this.imageBuffer.fill3DRect(n6, n3, 13, n21 + 1, true);
            if (!this.makeView.isTwowayMerge) {
                this.imageBuffer.fill3DRect(n7, n4, 13, n23 + 1, true);
            }
            if (n8 != -1) {
                if (n == this.currDiff + 1) {
                    this.imageBuffer.setColor(this.editor.getZerothDiffColor());
                } else {
                    this.imageBuffer.setColor(Color.white);
                }
                this.imageBuffer.fill3DRect(n5, n19, 13, n20, true);
            }
            if (n9 != -1) {
                if (n == this.currDiff + 1) {
                    this.imageBuffer.setColor(this.editor.getFirstDiffColor());
                } else {
                    this.imageBuffer.setColor(Color.white);
                }
                this.imageBuffer.fill3DRect(n6, n21, 13, n22, true);
            }
            if (!this.makeView.isTwowayMerge && n10 != -1) {
                if (n == this.currDiff + 1) {
                    this.imageBuffer.setColor(this.editor.getSecondDiffColor());
                } else {
                    this.imageBuffer.setColor(Color.white);
                }
                this.imageBuffer.fill3DRect(n7, n23, 13, n24, true);
            }
            if (n8 != -1 && n9 != -1) {
                n12 = Math.round((n20 - n19) / 2);
                n11 = Math.round((n22 - n21) / 2);
                this.imageBuffer.setColor(Color.gray);
                this.imageBuffer.drawLine(n5 + 13, n12 + n19, n6, n11 + n21);
            }
            if (!this.makeView.isTwowayMerge && n9 != -1 && n10 != -1) {
                n12 = Math.round((n22 - n21) / 2);
                n11 = Math.round((n24 - n23) / 2);
                this.imageBuffer.setColor(Color.gray);
                this.imageBuffer.drawLine(n6 + 13, n12 + n21, n7, n11 + n23);
            }
            if (n8 != -1) {
                n2 = n20;
            }
            if (n9 != -1) {
                n3 = n22;
            }
            if (!this.makeView.isTwowayMerge && n10 != -1) {
                n4 = n24;
            }
            ++n;
        }
        this.imageBuffer.setColor(this.lightergray);
        this.imageBuffer.fill3DRect(n5, n2, 13, this.dimension.height - 20, true);
        this.imageBuffer.fill3DRect(n6, n3, 13, this.dimension.height - 20, true);
        if (!this.makeView.isTwowayMerge) {
            this.imageBuffer.fill3DRect(n7, n4, 13, this.dimension.height - 20, true);
        }
        this.imageBuffer.setColor(Color.black);
        this.imageBuffer.drawRect(15, 0, this.dimension.width - 30, this.dimension.height - 20);
        this.imageBuffer.setColor(Color.lightGray);
        this.imageBuffer.fillRect(15, this.dimension.height - 19, this.dimension.width - 30, this.dimension.height);
    }

    public void updateDifference(int n) {
        this.differenceView = n;
        this.repaint();
    }

    public int GetTotalDiffs() {
        return this.totaldiffs;
    }

    public int GetCurrentSelection() {
        return this.viewParam.getCurrentDiff();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void addNotify() {
        super.addNotify();
    }

    public Dimension getPreferredSize() {
        return this.dimension;
    }

    public Dimension getMinimumSize() {
        return this.dimension;
    }

    private void DetermineIfContentDifference(int n, int n2) {
        int n3 = 0;
        Navigate navigate = new Navigate(this.mg);
        n3 = 0;
        while (n3 < this.differenceQuards.size()) {
            DifferenceLocations differenceLocations = (DifferenceLocations)this.differenceQuards.elementAt(n3);
            if (n >= differenceLocations.left && n <= differenceLocations.right && n2 >= differenceLocations.top && n2 <= differenceLocations.bottom) {
                navigate.gotoDifference(n3);
                this.viewParam.setCurrentDiff(n3);
                this.repaint();
                return;
            }
            ++n3;
        }
    }

    private void DetermineIfMovedDifference(int n, int n2) {
        DifferenceLocations differenceLocations;
        int n3 = 0;
        boolean bl = false;
        Navigate navigate = new Navigate(this.mg);
        n3 = 0;
        while (n3 < this.moveDiff1Quards.size()) {
            differenceLocations = (DifferenceLocations)this.moveDiff1Quards.elementAt(n3);
            if (n >= differenceLocations.left && n <= differenceLocations.right && n2 >= differenceLocations.top && n2 <= differenceLocations.bottom) {
                navigate.gotoDifference(n3);
                this.viewParam.setCurrentDiff(n3);
                bl = true;
                this.repaint();
                break;
            }
            ++n3;
        }
        if (!bl) {
            n3 = 0;
            while (n3 < this.moveDiff2Quards.size()) {
                differenceLocations = (DifferenceLocations)this.moveDiff2Quards.elementAt(n3);
                if (n >= differenceLocations.left && n <= differenceLocations.right && n2 >= differenceLocations.top && n2 <= differenceLocations.bottom) {
                    navigate.gotoDifference(n3);
                    this.viewParam.setCurrentDiff(n3);
                    bl = true;
                    this.repaint();
                    break;
                }
                ++n3;
            }
        }
        if (!bl) {
            n3 = 0;
            while (n3 < this.moveDiff3Quards.size()) {
                differenceLocations = (DifferenceLocations)this.moveDiff3Quards.elementAt(n3);
                if (n >= differenceLocations.left && n <= differenceLocations.right && n2 >= differenceLocations.top && n2 <= differenceLocations.bottom) {
                    navigate.gotoDifference(n3);
                    this.viewParam.setCurrentDiff(n3);
                    bl = true;
                    this.repaint();
                    return;
                }
                ++n3;
            }
        }
    }

    public void MouseClick(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 1) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (this.differenceView == 1) {
                this.DetermineIfContentDifference(n, n2);
                return;
            }
            this.DetermineIfMovedDifference(n, n2);
        }
    }

    public void MousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n >= this.grabber1left && n <= this.grabber1right && n2 >= this.grabber1top && n2 <= this.grabber1bottom) {
            this.dragged = true;
        }
        if (n >= this.grabber2left && n <= this.grabber2right && n2 >= this.grabber2top && n2 <= this.grabber2bottom) {
            this.dragged = true;
        }
    }

    public void MouseReleased(MouseEvent mouseEvent) {
        Navigate navigate = new Navigate(this.mg);
        if (this.dragged) {
            this.invalidate();
            this.topGrabber = mouseEvent.getY() - 7;
            if (mouseEvent.getY() > 530) {
                this.topGrabber = 510;
            }
            if (mouseEvent.getY() < 10) {
                this.topGrabber = 1;
            }
            int n = Math.round(this.totalLines * mouseEvent.getY() / (this.dimension.height - 20));
            navigate.alignWithNavigate(n);
            this.grabberUpdate = true;
            this.repaint();
            this.dragged = false;
            this.validate();
        }
    }

    public void MouseDragged(MouseEvent mouseEvent) {
        this.dragged = true;
    }

    public void MouseMoved(MouseEvent mouseEvent) {
    }

    class DifferenceLocations {
        int top;
        int bottom;
        int left;
        int right;

        DifferenceLocations(int n, int n2, int n3, int n4) {
            NavigatorCanvas.this = NavigatorCanvas.this;
            this.top = n;
            this.bottom = n2;
            this.left = n3;
            this.right = n4;
        }
    }
}

