/*+------------------------------------------------------------------------+*/
/*                                                                          */
/* PROGRAM NAME: FHBWCOMP.C                                                 */
/* -------------                                                            */
/*                                                                          */
/*  A TeamConnection Build Script for the Microsoft Visual C++ compiler     */
/*                                                                          */
/*                 IBM TeamConnection                                       */
/*                 Version 1 Release 1                                      */
/*                    5622-717                                              */
/*                                                                          */
/* COPYRIGHT:                                                               */
/* ----------                                                               */
/*        (C) Copyright, IBM Corp., 1996. All Rights Reserved.              */
/*                  Licensed Materials - Property of IBM                    */
/*                 US Government Users Restricted Rights                    */
/*           - Use, duplication or disclosure restricted by                 */
/*              GSA ADP Schedule Contract with IBM Corp.                    */
/*                                                                          */
/*                  IBM is a registered trademark of                        */
/*             International Business Machines Corporation                  */
/*                                                                          */
/* DISCLAIMER OF WARRANTIES:                                                */
/* -------------------------                                                */
/* The following [enclosed] code is sample code created by IBM              */
/* Corporation.  This sample code is not part of any standard IBM product   */
/* and is provided to you solely for the purpose of assisting you in the    */
/* development of your applications.  The code is provided "AS IS",         */
/* without warranty of any kind.  IBM shall not be liable for any damages   */
/* arising out of your use of the sample code, even if they have been       */
/* advised of the possibility of such damages.                              */
/*                                                                          */
/* WHAT THIS PROGRAM DOES:                                                  */
/* -----------------------                                                  */
/*  This program is a build script that invokes the Microsoft Visual C++    */
/*  Compiler.                                                               */
/*                                                                          */
/*+------------------------------------------------------------------------+*/
/*                                                                          */
/* Inputs from the environment                                              */
/*      TC_INPUT                                                            */
/*      TC_OUTPUT                                                           */
/*                                                                          */
/* Inputs from the argument list                                            */
/*      PARMS                                                               */
/*                                                                          */
/*  TC_INPUT contains inputs stored in the library that are input to the    */
/*   translator build step.                                                 */
/*  TC_OUTPUT contains outputs that are to be built by translator and that  */
/*   will be stored in the library.                                         */
/*  PARMS are translator options that are specified on the TeamConnection   */
/*   builder definition.                                                    */
/*                                                                          */
/* Outputs:                                                                 */
/*  files generated by the translator                                       */
/*                                                                          */
/* Returns:                                                                 */
/*  return code from the translator execution                               */
/*                                                                          */
/*+------------------------------------------------------------------------+*/


#include <string.h>
#include <stdio.h>
#include <stdlib.h>


/* Modify the next line to change the translator to invoke.       */
/* cl is the Microsoft Visual C++ compiler                        */
#define TRANSLATOR      "cl"

/* Modify the next line to change default parameters that should all be used       */
/* /c specified to do only a compile                                               */
#define DEF_PARMS       "/c"


int main (int argc, char       *argv[])
{

int count,rc=0;
char       *tc_input,       *tc_output;
char parms[1025];
char       *cmd=NULL;

parms[0]='\0';

 /* get the TeamConnection parameters from the environment       */
tc_input = getenv("TC_INPUT");
if (!tc_input)
{
   printf("ERROR - TC_INPUT has no value");
   return 20;
}
tc_output = getenv("TC_OUTPUT");
if (!tc_output)
{
   printf("ERROR - TC_OUTPUT has no value");
   return 20;
}

/* collect the builder parameters passed in when          */
/* the build script is executed                           */
for (count = 1; count < argc; count++)
{
   strcat(parms,argv[count]);
   strcat(parms," ");
}

/* build the command to be executed */
cmd  = (char       *) malloc((strlen(TRANSLATOR)+strlen(DEF_PARMS)+strlen(parms)+strlen(tc_output)+strlen(tc_input)+100)       *sizeof(char));
sprintf(cmd,"%s %s %s /Fo%s %s",TRANSLATOR,DEF_PARMS,parms,tc_output,tc_input);
printf("%s\n",cmd);
fflush(stdout);

/* execute the command */
rc = system(cmd);

free(cmd);

/* return the rc from the command invocation */
return rc;
}
