/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.undo;

import com.sun.java.swing.event.UndoableEditEvent;
import com.sun.java.swing.event.UndoableEditListener;
import com.sun.java.swing.undo.CannotRedoException;
import com.sun.java.swing.undo.CannotUndoException;
import com.sun.java.swing.undo.CompoundEdit;
import com.sun.java.swing.undo.UndoableEdit;
import java.util.Enumeration;
import java.util.Vector;

public class UndoManager
extends CompoundEdit
implements UndoableEditListener {
    int indexOfNextAdd = 0;
    int limit = 100;

    public UndoManager() {
        this.edits.ensureCapacity(this.limit);
    }

    public synchronized int getLimit() {
        return this.limit;
    }

    public synchronized void discardAllEdits() {
        Enumeration enumeration = this.edits.elements();
        while (enumeration.hasMoreElements()) {
            UndoableEdit undoableEdit = (UndoableEdit)enumeration.nextElement();
            undoableEdit.die();
        }
        this.edits = new Vector(this.limit);
        this.indexOfNextAdd = 0;
    }

    protected void trimForLimit() {
        int n;
        if (this.limit > 0 && (n = this.edits.size()) > this.limit) {
            int n2 = this.limit / 2;
            int n3 = this.indexOfNextAdd - 1 + n2;
            int n4 = this.indexOfNextAdd - 1 - n2;
            if (n3 - n4 + 1 > this.limit) {
                ++n4;
            }
            if (n4 < 0) {
                n3 -= n4;
                n4 = 0;
            }
            if (n3 >= n) {
                int n5 = n - n3 - 1;
                n3 += n5;
                n4 += n5;
            }
            this.trimEdits(n3 + 1, n - 1);
            this.trimEdits(0, n4 - 1);
        }
    }

    protected void trimEdits(int n, int n2) {
        if (n <= n2) {
            int n3 = n2;
            while (n <= n3) {
                UndoableEdit undoableEdit = (UndoableEdit)this.edits.elementAt(n3);
                undoableEdit.die();
                this.edits.removeElementAt(n3);
                --n3;
            }
            if (this.indexOfNextAdd > n2) {
                this.indexOfNextAdd -= n2 - n + 1;
                return;
            }
            if (this.indexOfNextAdd >= n) {
                this.indexOfNextAdd = n;
            }
        }
    }

    public synchronized void setLimit(int n) {
        this.limit = n;
        this.trimForLimit();
    }

    protected UndoableEdit editToBeUndone() {
        int n = this.indexOfNextAdd;
        while (n > 0) {
            UndoableEdit undoableEdit;
            if (!(undoableEdit = (UndoableEdit)this.edits.elementAt(--n)).isSignificant()) continue;
            return undoableEdit;
        }
        return null;
    }

    protected UndoableEdit editToBeRedone() {
        int n = this.edits.size();
        int n2 = this.indexOfNextAdd;
        while (n2 < n) {
            UndoableEdit undoableEdit;
            if (!(undoableEdit = (UndoableEdit)this.edits.elementAt(n2++)).isSignificant()) continue;
            return undoableEdit;
        }
        return null;
    }

    protected void undoTo(UndoableEdit undoableEdit) throws CannotUndoException {
        boolean bl = false;
        while (!bl) {
            UndoableEdit undoableEdit2 = (UndoableEdit)this.edits.elementAt(--this.indexOfNextAdd);
            undoableEdit2.undo();
            boolean bl2 = bl = undoableEdit2 == undoableEdit;
        }
    }

    protected void redoTo(UndoableEdit undoableEdit) throws CannotRedoException {
        boolean bl = false;
        while (!bl) {
            UndoableEdit undoableEdit2 = (UndoableEdit)this.edits.elementAt(this.indexOfNextAdd++);
            undoableEdit2.redo();
            boolean bl2 = bl = undoableEdit2 == undoableEdit;
        }
    }

    public synchronized void undoOrRedo() throws CannotRedoException, CannotUndoException {
        if (this.indexOfNextAdd == this.edits.size()) {
            this.undo();
            return;
        }
        this.redo();
    }

    public synchronized boolean canUndoOrRedo() {
        if (this.indexOfNextAdd == this.edits.size()) {
            return this.canUndo();
        }
        return this.canRedo();
    }

    public synchronized void undo() throws CannotUndoException {
        if (this.inProgress) {
            UndoableEdit undoableEdit = this.editToBeUndone();
            if (undoableEdit == null) {
                throw new CannotUndoException();
            }
            this.undoTo(undoableEdit);
            return;
        }
        super.undo();
    }

    public synchronized boolean canUndo() {
        if (this.inProgress) {
            UndoableEdit undoableEdit = this.editToBeUndone();
            return undoableEdit != null && undoableEdit.canUndo();
        }
        return super.canUndo();
    }

    public synchronized void redo() throws CannotRedoException {
        if (this.inProgress) {
            UndoableEdit undoableEdit = this.editToBeRedone();
            if (undoableEdit == null) {
                throw new CannotRedoException();
            }
            this.redoTo(undoableEdit);
            return;
        }
        super.redo();
    }

    public synchronized boolean canRedo() {
        if (this.inProgress) {
            UndoableEdit undoableEdit = this.editToBeRedone();
            return undoableEdit != null && undoableEdit.canRedo();
        }
        return super.canRedo();
    }

    public synchronized boolean addEdit(UndoableEdit undoableEdit) {
        this.trimEdits(this.indexOfNextAdd, this.edits.size() - 1);
        super.addEdit(undoableEdit);
        this.indexOfNextAdd = this.edits.size();
        this.trimForLimit();
        return true;
    }

    public synchronized String getUndoOrRedoPresentationName() {
        if (this.indexOfNextAdd == this.edits.size()) {
            return this.getUndoPresentationName();
        }
        return this.getRedoPresentationName();
    }

    public synchronized String getUndoPresentationName() {
        if (this.inProgress) {
            if (this.canUndo()) {
                return this.editToBeUndone().getUndoPresentationName();
            }
            return "Undo";
        }
        return super.getUndoPresentationName();
    }

    public synchronized String getRedoPresentationName() {
        if (this.inProgress) {
            if (this.canRedo()) {
                return ((UndoableEdit)this.edits.elementAt(this.indexOfNextAdd)).getRedoPresentationName();
            }
            return "Redo";
        }
        return super.getRedoPresentationName();
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        this.addEdit(undoableEditEvent.getEdit());
    }

    public String toString() {
        return String.valueOf(super.toString()) + " limit: " + this.limit + " indexOfNextAdd: " + this.indexOfNextAdd;
    }
}

