/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.AbstractListModel;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.event.ListDataEvent;
import com.sun.java.swing.preview.JFileChooser;
import com.sun.java.swing.preview.filechooser.FileSystemView;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Vector;

class BasicDirectoryModel
extends AbstractListModel
implements PropertyChangeListener {
    private JFileChooser filechooser;
    private Vector fileCache;
    private LoadFilesThread loadThread;
    private Vector files;
    private Vector directories;

    BasicDirectoryModel(JFileChooser jFileChooser) {
        this.filechooser = jFileChooser;
        this.validateFileCache();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "directoryChanged" || string == "fileViewChanged" || string == "fileFilterChanged" || string == "FileHidingChanged" || string == "fileSelectionChanged") {
            this.invalidateFileCache();
            this.validateFileCache();
        }
    }

    public void invalidateFileCache() {
        this.files = null;
        this.directories = null;
        this.fileCache = null;
    }

    public Vector getDirectories() {
        if (this.directories != null) {
            return this.directories;
        }
        this.getFiles();
        return this.directories;
    }

    public Vector getFiles() {
        if (this.files != null) {
            return this.files;
        }
        this.files = new Vector();
        this.directories = new Vector();
        this.directories.addElement(this.filechooser.getFileSystemView().createFileObject(this.filechooser.getCurrentDirectory(), ".."));
        int n = 0;
        while (n < this.fileCache.size()) {
            File file = (File)this.fileCache.elementAt(n);
            if (this.filechooser.isTraversable(file)) {
                this.directories.addElement(file);
            } else {
                this.files.addElement(file);
            }
            ++n;
        }
        return this.files;
    }

    public void validateFileCache() {
        File file = this.filechooser.getCurrentDirectory();
        if (file == null) {
            this.invalidateFileCache();
            return;
        }
        this.fileCache = new Vector(50);
        if (this.loadThread != null) {
            this.loadThread.interrupt();
        }
        this.loadThread = new LoadFilesThread(file);
        this.loadThread.start();
    }

    public void fireContentsChanged() {
        this.files = null;
        this.directories = null;
        this.fireContentsChanged(this, 0, this.fileCache.size() - 1);
    }

    public int getSize() {
        if (this.fileCache != null) {
            return this.fileCache.size();
        }
        return 0;
    }

    public boolean contains(Object object) {
        if (this.fileCache != null) {
            return this.fileCache.contains(object);
        }
        return false;
    }

    public int indexOf(Object object) {
        if (this.fileCache != null) {
            return this.fileCache.indexOf(object);
        }
        return 0;
    }

    public Object getElementAt(int n) {
        if (this.fileCache != null) {
            return this.fileCache.elementAt(n);
        }
        return null;
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    protected void sort(Vector vector) {
        this.quickSort(vector, 0, vector.size() - 1);
    }

    /*
     * Unable to fully structure code
     */
    private void quickSort(Vector var1_1, int var2_2, int var3_3) {
        block5: {
            var4_4 = var2_2;
            var5_5 = var3_3;
            if (var3_3 <= var2_2) break block5;
            var6_6 = (File)var1_1.elementAt((var2_2 + var3_3) / 2);
            ** GOTO lbl16
            {
                ++var4_4;
                do {
                    if (var4_4 < var3_3 && this.lt((File)var1_1.elementAt(var4_4), var6_6)) continue block0;
                    while (var5_5 > var2_2 && this.lt(var6_6, (File)var1_1.elementAt(var5_5))) {
                        --var5_5;
                    }
                    if (var4_4 > var5_5) continue;
                    this.swap(var1_1, var4_4, var5_5);
                    ++var4_4;
                    --var5_5;
lbl16:
                    // 3 sources

                } while (var4_4 <= var5_5);
            }
            if (var2_2 < var5_5) {
                this.quickSort(var1_1, var2_2, var5_5);
            }
            if (var4_4 < var3_3) {
                this.quickSort(var1_1, var4_4, var3_3);
            }
        }
    }

    private void swap(Vector vector, int n, int n2) {
        Object e = vector.elementAt(n);
        vector.setElementAt(vector.elementAt(n2), n);
        vector.setElementAt(e, n2);
    }

    protected boolean lt(File file, File file2) {
        return file.getName().compareTo(file2.getName()) < 0;
    }

    class LoadFilesThread
    extends Thread {
        File currentDirectory;

        public LoadFilesThread(File file) {
            super("Basic L&F File Loading Thread");
            BasicDirectoryModel.this = BasicDirectoryModel.this;
            this.currentDirectory = file;
        }

        public void run() {
            Object object;
            Vector<Object> vector = new Vector<Object>(10);
            FileSystemView fileSystemView = BasicDirectoryModel.this.filechooser.getFileSystemView();
            File[] fileArray = fileSystemView.getFiles(this.currentDirectory, BasicDirectoryModel.this.filechooser.isFileHidingEnabled());
            Vector<File> vector2 = new Vector<File>();
            int n = 0;
            while (n < fileArray.length) {
                if (BasicDirectoryModel.this.filechooser.accept(fileArray[n])) {
                    vector2.addElement(fileArray[n]);
                }
                ++n;
            }
            BasicDirectoryModel.this.sort(vector2);
            Vector<Object> vector3 = new Vector<Object>(10);
            Vector<Object> vector4 = new Vector<Object>();
            int n2 = 0;
            while (n2 < vector2.size()) {
                object = (File)vector2.elementAt(n2);
                boolean bl = BasicDirectoryModel.this.filechooser.isTraversable((File)object);
                if (bl) {
                    vector3.addElement(object);
                } else if (!bl && BasicDirectoryModel.this.filechooser.isFileSelectionEnabled()) {
                    vector4.addElement(object);
                }
                if (vector3.size() == 10 || n2 == vector2.size() - 1) {
                    DoChangeContents doChangeContents = new DoChangeContents(vector3);
                    vector.addElement(doChangeContents);
                    SwingUtilities.invokeLater(doChangeContents);
                    vector3 = new Vector(10);
                }
                if (this.isInterrupted()) {
                    this.cancelRunnables(vector);
                    return;
                }
                ++n2;
            }
            object = new DoChangeContents(vector4);
            vector.addElement(object);
            SwingUtilities.invokeLater((Runnable)object);
            if (this.isInterrupted()) {
                this.cancelRunnables(vector);
                return;
            }
        }

        public void cancelRunnables(Vector vector) {
            int n = 0;
            while (n < vector.size()) {
                ((DoChangeContents)vector.elementAt(n)).cancel();
                ++n;
            }
        }
    }

    class DoChangeContents
    implements Runnable {
        private Vector files;
        private boolean doFire = true;
        private Object lock = new Object();

        public DoChangeContents(Vector vector) {
            BasicDirectoryModel.this = BasicDirectoryModel.this;
            this.files = vector;
        }

        synchronized void cancel() {
            Object object = this.lock;
            synchronized (object) {
                this.doFire = false;
                return;
            }
        }

        public void run() {
            Object object = this.lock;
            synchronized (object) {
                if (this.doFire) {
                    int n = 0;
                    while (n < this.files.size()) {
                        BasicDirectoryModel.this.fileCache.addElement(this.files.elementAt(n));
                        ++n;
                    }
                }
                BasicDirectoryModel.this.fireContentsChanged();
                return;
            }
        }
    }
}

