/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcmerge;

import com.ibm.vatc.tcmerge.DiffInfoComposite;
import com.ibm.vatc.tcmerge.MakeViews;
import com.ibm.vatc.tcmerge.MergeGui;
import com.ibm.vatc.tcmerge.Navigate;
import com.ibm.vatc.tcmerge.NavigatorDialog;
import com.ibm.vatc.tcmerge.Options;
import com.ibm.vatc.tcmerge.OutputView;
import com.ibm.vatc.tcmerge.ScrollPanel;
import com.ibm.vatc.tcmerge.Status;
import com.ibm.vatc.tcmerge.TextComposite;
import com.ibm.vatc.tcmerge.ViewParam;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Scrollbar;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

class CompositeView
extends Canvas
implements MouseListener {
    ScrollPanel scrollPanel;
    Scrollbar hAdj;
    Scrollbar vAdj;
    MergeGui mergeGui;
    OutputView outputView;
    MakeViews makeViews;
    Options options;
    ViewParam viewParam;
    Status status;
    Vector tableComposite;
    Dimension size;
    int firstLineInView;
    Font normalFont;
    private int initialLocX;
    private int initialLocY;
    private int maxWidth;
    private int maxAdvance;
    private int charHeight;
    private int ascent;
    static final short STRING_BUFF_SIZE = 512;

    CompositeView(ScrollPanel scrollPanel, MergeGui mergeGui) {
        this.mergeGui = mergeGui;
        this.outputView = mergeGui.getOutputView();
        this.scrollPanel = scrollPanel;
        this.makeViews = mergeGui.getMakeViews();
        this.options = mergeGui.getOptions();
        this.viewParam = mergeGui.getViewParam();
        this.status = mergeGui.getStatus();
        this.tableComposite = this.makeViews.getTableComposite();
        this.hAdj = this.scrollPanel.getHAdjustable();
        this.vAdj = this.scrollPanel.getVAdjustable();
        this.size = new Dimension();
        this.size.width = 100;
        this.size.height = 100;
        this.setFont();
        this.vAdj.setMaximum(this.tableComposite.size() * this.charHeight - this.charHeight + this.ascent);
        this.addMouseListener(this);
        this.setVScrollToCurrentDiff();
        this.scrollPanel.setPaintArea(this);
    }

    public void setFont() {
        String string = this.options.getEditor().getFontName();
        int n = this.options.getEditor().getFontSize();
        this.normalFont = new Font(string, 0, n);
        this.setFont(this.normalFont);
        FontMetrics fontMetrics = this.getToolkit().getFontMetrics(this.normalFont);
        this.charHeight = fontMetrics.getHeight();
        this.maxAdvance = fontMetrics.getMaxAdvance();
        this.initialLocX = 0;
        this.initialLocY = fontMetrics.getAscent();
        this.ascent = fontMetrics.getAscent();
    }

    public synchronized void paint(Graphics graphics) {
        this.hAdj.setUnitIncrement(this.maxAdvance);
        this.hAdj.setBlockIncrement(this.getSize().width);
        this.vAdj.setUnitIncrement(this.charHeight);
        this.vAdj.setBlockIncrement(this.getSize().height);
        int n = this.hAdj.getValue();
        int n2 = this.vAdj.getValue();
        this.firstLineInView = Math.round(n2 / this.charHeight);
        this.initialLocX = -n;
        int n3 = Math.round(Math.min(this.getSize().height, this.tableComposite.size() * this.charHeight) / this.charHeight);
        while (this.firstLineInView + n3 > this.tableComposite.size()) {
            --this.firstLineInView;
        }
        this.vAdj.setValue(this.firstLineInView * this.charHeight);
        this.maxWidth = Math.max(this.getSize().width, this.hAdj.getMaximum());
        int n4 = 0;
        while (n4 < n3) {
            this.drawString(graphics, this.firstLineInView, n4);
            ++n4;
        }
        graphics.setColor(this.options.getEditor().getMatchedBackground());
        graphics.fillRect(this.initialLocX, this.initialLocY + n3 * this.charHeight - this.ascent, this.maxWidth, this.getSize().height - n3 * this.charHeight);
        this.scrollPanel.doLayout();
        this.validate();
        this.hAdj.setValues(this.hAdj.getValue(), this.scrollPanel.getHVisibleAmount(), 0, 1000);
        this.vAdj.setValues(this.vAdj.getValue(), this.scrollPanel.getVVisibleAmount(), 0, this.tableComposite.size() * this.charHeight + this.charHeight);
    }

    public void drawString(Graphics graphics, int n, int n2) {
        TextComposite textComposite = (TextComposite)this.tableComposite.elementAt(n + n2);
        String string = textComposite.text;
        byte by = textComposite.flag;
        int n3 = textComposite.line;
        if ((by & 1) != 0) {
            if ((by & 2) != 0) {
                String string2;
                if ((by & 0x10) != 0) {
                    graphics.setColor(this.options.getEditor().getZerothDiffColor());
                    graphics.fillRect(this.initialLocX, this.initialLocY + n2 * this.charHeight - this.ascent, this.maxWidth, this.charHeight);
                    graphics.setColor(this.options.getEditor().getZerothCurrentDiffFG());
                    string2 = this.formatString(string);
                    string2 = this.addLineNumber(string2, n3);
                    graphics.drawString(string2, this.initialLocX, this.initialLocY + n2 * this.charHeight);
                } else if ((by & 0x20) != 0) {
                    graphics.setColor(this.options.getEditor().getFirstDiffColor());
                    graphics.fillRect(this.initialLocX, this.initialLocY + n2 * this.charHeight - this.ascent, this.maxWidth, this.charHeight);
                    graphics.setColor(this.options.getEditor().getFirstCurrentDiffFG());
                    string2 = this.formatString(string);
                    string2 = this.addLineNumber(string2, n3);
                    graphics.drawString(string2, this.initialLocX, this.initialLocY + n2 * this.charHeight);
                } else {
                    graphics.setColor(this.options.getEditor().getSecondDiffColor());
                    graphics.fillRect(this.initialLocX, this.initialLocY + n2 * this.charHeight - this.ascent, this.maxWidth, this.charHeight);
                    graphics.setColor(this.options.getEditor().getSecondCurrentDiffFG());
                    string2 = this.formatString(string);
                    string2 = this.addLineNumber(string2, n3);
                    graphics.drawString(string2, this.initialLocX, this.initialLocY + n2 * this.charHeight);
                }
                if ((by & 4) != 0) {
                    int n4 = graphics.getFontMetrics().charWidth('8');
                    if ((by & 8) != 0) {
                        int n5 = string2.indexOf(32);
                        int n6 = ++n5 * n4;
                        graphics.setColor(this.options.getEditor().getFilledDiffMarker());
                        graphics.fillOval(this.initialLocX + n6, Math.round(this.initialLocY / 2) + n2 * this.charHeight, Math.round(this.charHeight / 2), Math.round(this.charHeight / 2));
                        return;
                    }
                    int n7 = string2.indexOf(32);
                    int n8 = ++n7 * n4;
                    graphics.setColor(this.options.getEditor().getNonfilledDiffMarker());
                    graphics.drawOval(this.initialLocX + n8, Math.round(this.initialLocY / 2) + n2 * this.charHeight, Math.round(this.charHeight / 2) - 1, Math.round(this.charHeight / 2) - 1);
                    return;
                }
            } else {
                if ((by & 0x10) != 0) {
                    graphics.setColor(this.options.getEditor().getMatchedBackground());
                    graphics.fillRect(this.initialLocX, this.initialLocY + n2 * this.charHeight - this.ascent, this.maxWidth, this.charHeight);
                    graphics.setColor(this.options.getEditor().getZerothDiffColor());
                    String string3 = this.formatString(string);
                    string3 = this.addLineNumber(string3, n3);
                    graphics.drawString(string3, this.initialLocX, this.initialLocY + n2 * this.charHeight);
                    return;
                }
                if ((by & 0x20) != 0) {
                    graphics.setColor(this.options.getEditor().getMatchedBackground());
                    graphics.fillRect(this.initialLocX, this.initialLocY + n2 * this.charHeight - this.ascent, this.maxWidth, this.charHeight);
                    graphics.setColor(this.options.getEditor().getFirstDiffColor());
                    String string4 = this.formatString(string);
                    string4 = this.addLineNumber(string4, n3);
                    graphics.drawString(string4, this.initialLocX, this.initialLocY + n2 * this.charHeight);
                    return;
                }
                graphics.setColor(this.options.getEditor().getMatchedBackground());
                graphics.fillRect(this.initialLocX, this.initialLocY + n2 * this.charHeight - this.ascent, this.maxWidth, this.charHeight);
                graphics.setColor(this.options.getEditor().getSecondDiffColor());
                String string5 = this.formatString(string);
                string5 = this.addLineNumber(string5, n3);
                graphics.drawString(string5, this.initialLocX, this.initialLocY + n2 * this.charHeight);
            }
            return;
        }
        graphics.setColor(this.options.getEditor().getMatchedBackground());
        graphics.fillRect(this.initialLocX, this.initialLocY + n2 * this.charHeight - this.ascent, this.maxWidth, this.charHeight);
        graphics.setColor(this.options.getEditor().getMatchedForeground());
        String string6 = this.formatString(string);
        string6 = this.addLineNumber(string6, n3);
        graphics.drawString(string6, this.initialLocX, this.initialLocY + n2 * this.charHeight);
    }

    private String formatString(String string) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer(512);
        if (string.equals("^~:ZeroLength:~^")) {
            string2 = "";
        } else if (string.length() == 0) {
            string2 = "";
        } else {
            int n;
            int n2 = this.options.getEditor().getTab();
            stringBuffer.insert(0, string);
            while ((n = (string2 = stringBuffer.toString()).indexOf(9, 0)) != -1) {
                int n3 = n % n2;
                int n4 = 0;
                while (n4 < n2 - n3) {
                    if (n4 == 0) {
                        stringBuffer.setCharAt(n + n4, ' ');
                    } else {
                        stringBuffer.insert(n + n4, ' ');
                    }
                    ++n4;
                }
            }
            string2 = stringBuffer.toString();
            stringBuffer = null;
        }
        return string2;
    }

    private String addLineNumber(String string, int n) {
        int n2;
        String string2;
        Integer n3;
        if (n != -1) {
            n3 = new Integer(n + 1);
            string2 = n3.toString();
            n2 = string2.length();
        } else {
            n2 = 0;
            string2 = "";
        }
        int n4 = 0;
        while (n4 < 8 - n2) {
            string2 = String.valueOf(string2) + " ";
            ++n4;
        }
        String string3 = String.valueOf(string2) + string;
        n3 = null;
        return string3;
    }

    public void setVerticalScrollbar(int n) {
        if (n * this.charHeight > this.vAdj.getMaximum()) {
            this.vAdj.setValue(this.vAdj.getMaximum());
            return;
        }
        this.vAdj.setValue(n * this.charHeight);
    }

    public void setVScrollToCurrentDiff() {
        int n = this.viewParam.getCurrentDiff();
        if (this.makeViews.getDiffTableComposite().size() != 0) {
            DiffInfoComposite diffInfoComposite = (DiffInfoComposite)this.makeViews.getDiffTableComposite().elementAt(n);
            int n2 = diffInfoComposite.getStart(0);
            this.setVerticalScrollbar(n2);
        }
    }

    public void addNotify() {
        super.addNotify();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.status.setMessageFlag(false);
        this.status.repaint();
        if (mouseEvent.getClickCount() == 1) {
            Object object;
            int n = -1;
            int n2 = -1;
            int n3 = mouseEvent.getY();
            int n4 = (int)((float)(n3 += this.vAdj.getValue()) / (float)this.charHeight);
            Vector vector = this.makeViews.getDiffTableComposite();
            int n5 = 0;
            while (n5 < vector.size()) {
                object = (DiffInfoComposite)vector.elementAt(n5);
                int n6 = 0;
                while (n6 < 3) {
                    if (((DiffInfoComposite)object).getStart(n6) <= n4 && n4 <= ((DiffInfoComposite)object).getEnd(n6)) {
                        n = n6;
                        n2 = n5;
                        break;
                    }
                    ++n6;
                }
                ++n5;
            }
            if (n2 != -1 && n2 == this.viewParam.getCurrentDiff()) {
                if (mouseEvent.isShiftDown()) {
                    this.makeViews.insertOneDiff(n, n2);
                } else {
                    this.makeViews.primeOneDiff(n, n2);
                }
                this.outputView.repaint();
                this.viewParam.setOutputSaved(false);
                this.mergeGui.setOutputViewTitle();
                object = this.mergeGui.getNavigatorDialog();
                if (object != null && ((Component)object).isVisible()) {
                    ((NavigatorDialog)object).updateNavigator();
                    return;
                }
            } else if (n2 != -1 && n2 != this.viewParam.getCurrentDiff()) {
                object = new Navigate(this.mergeGui);
                ((Navigate)object).gotoDifference(n2);
            }
        }
    }

    public Dimension getPreferredSize() {
        return this.size;
    }

    public Dimension getMinimumSize() {
        return this.size;
    }
}

