/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.KeyStroke;
import com.sun.java.swing.plaf.TextUI;
import com.sun.java.swing.plaf.UIResource;
import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.Caret;
import com.sun.java.swing.text.DefaultCaret;
import com.sun.java.swing.text.JTextComponent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class MotifTextUI {
    static final JTextComponent.KeyBinding[] defaultBindings = new JTextComponent.KeyBinding[]{new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(155, 2), "copy-to-clipboard"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(155, 1), "paste-from-clipboard"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(127, 1), "cut-to-clipboard"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(37, 1), "selection-backward"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(39, 1), "selection-forward")};

    public static Caret createCaret() {
        return new MotifCaret();
    }

    public static class MotifCaret
    extends DefaultCaret
    implements UIResource {
        static final int IBeamOverhang = 2;

        protected void damage(Rectangle rectangle) {
            if (rectangle != null) {
                JTextComponent jTextComponent = this.getComponent();
                jTextComponent.repaint(rectangle.x - 2 - 1, rectangle.y, rectangle.width + 4 + 3, rectangle.height);
            }
        }

        public void paint(Graphics graphics) {
            if (this.isVisible()) {
                try {
                    JTextComponent jTextComponent = this.getComponent();
                    Color color = jTextComponent.hasFocus() ? jTextComponent.getCaretColor() : jTextComponent.getDisabledTextColor();
                    TextUI textUI = jTextComponent.getUI();
                    int n = this.getDot();
                    Rectangle rectangle = textUI.modelToView(n);
                    int n2 = rectangle.x - 2;
                    int n3 = rectangle.x + 2;
                    int n4 = rectangle.y + 1;
                    int n5 = rectangle.y + rectangle.height - 2;
                    graphics.setColor(color);
                    graphics.drawLine(rectangle.x, n4, rectangle.x, n5);
                    graphics.drawLine(n2, n4, n3, n4);
                    graphics.drawLine(n2, n5, n3, n5);
                    return;
                }
                catch (BadLocationException badLocationException) {
                    return;
                }
            }
        }
    }
}

