/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleAction;
import com.sun.java.accessibility.AccessibleComponent;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleRole;
import com.sun.java.accessibility.AccessibleSelection;
import com.sun.java.accessibility.AccessibleState;
import com.sun.java.accessibility.AccessibleStateSet;
import com.sun.java.accessibility.AccessibleText;
import com.sun.java.accessibility.AccessibleValue;
import com.sun.java.swing.AbstractListModel;
import com.sun.java.swing.DefaultListSelectionModel;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.ListCellRenderer;
import com.sun.java.swing.ListModel;
import com.sun.java.swing.ListSelectionModel;
import com.sun.java.swing.Scrollable;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.event.ListDataEvent;
import com.sun.java.swing.event.ListDataListener;
import com.sun.java.swing.event.ListSelectionEvent;
import com.sun.java.swing.event.ListSelectionListener;
import com.sun.java.swing.plaf.ListUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.Vector;

public class JList
extends JComponent
implements Scrollable,
Accessible {
    private int fixedCellWidth = -1;
    private int fixedCellHeight = -1;
    private Object prototypeCellValue;
    private int visibleRowCount = 8;
    private Color selectionForeground;
    private Color selectionBackground;
    private ListSelectionModel selectionModel;
    private ListModel dataModel;
    private ListCellRenderer cellRenderer;
    private ListSelectionListener selectionListener;
    static /* synthetic */ Class class$com$sun$java$swing$event$ListSelectionListener;

    public JList(ListModel listModel) {
        if (listModel == null) {
            throw new IllegalArgumentException("dataModel must be non null");
        }
        this.dataModel = listModel;
        this.selectionModel = this.createSelectionModel();
        this.setAutoscrolls(true);
        this.updateUI();
    }

    public JList(Object[] objectArray) {
        this(new 1(objectArray));
    }

    public JList(Vector vector) {
        this(new 2(vector));
    }

    public JList() {
        this(new 3());
    }

    public ListUI getUI() {
        return (ListUI)this.ui;
    }

    public void setUI(ListUI listUI) {
        super.setUI(listUI);
    }

    public void updateUI() {
        this.setUI((ListUI)UIManager.getUI(this));
        this.invalidate();
    }

    public String getUIClassID() {
        return "ListUI";
    }

    public boolean isOpaque() {
        return true;
    }

    private void updateFixedCellSize() {
        ListCellRenderer listCellRenderer = this.getCellRenderer();
        Object object = this.getPrototypeCellValue();
        if (listCellRenderer != null && object != null) {
            Component component = listCellRenderer.getListCellRendererComponent(this, object, 0, false, false);
            Font font = component.getFont();
            component.setFont(this.getFont());
            Dimension dimension = component.getPreferredSize();
            this.fixedCellWidth = dimension.width;
            this.fixedCellHeight = dimension.height;
            component.setFont(font);
        }
    }

    public Object getPrototypeCellValue() {
        return this.prototypeCellValue;
    }

    public void setPrototypeCellValue(Object object) {
        Object object2 = this.prototypeCellValue;
        this.prototypeCellValue = object;
        if (object != null && !object.equals(object2)) {
            this.updateFixedCellSize();
        }
        this.firePropertyChange("prototypeCellValue", object2, object);
    }

    public int getFixedCellWidth() {
        return this.fixedCellWidth;
    }

    public void setFixedCellWidth(int n) {
        int n2 = this.fixedCellWidth;
        this.fixedCellWidth = n;
        this.firePropertyChange("fixedCellWidth", n2, this.fixedCellWidth);
    }

    public int getFixedCellHeight() {
        return this.fixedCellHeight;
    }

    public void setFixedCellHeight(int n) {
        int n2 = this.fixedCellHeight;
        this.fixedCellHeight = n;
        this.firePropertyChange("fixedCellHeight", n2, this.fixedCellHeight);
    }

    public ListCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellRenderer(ListCellRenderer listCellRenderer) {
        ListCellRenderer listCellRenderer2 = this.cellRenderer;
        this.cellRenderer = listCellRenderer;
        if (listCellRenderer != null && !listCellRenderer.equals(listCellRenderer2)) {
            this.updateFixedCellSize();
        }
        this.firePropertyChange("cellRenderer", listCellRenderer2, listCellRenderer);
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public void setSelectionForeground(Color color) {
        Color color2 = this.selectionForeground;
        this.selectionForeground = color;
        this.firePropertyChange("selectionForeground", color2, color);
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public void setSelectionBackground(Color color) {
        Color color2 = this.selectionBackground;
        this.selectionBackground = color;
        this.firePropertyChange("selectionBackground", color2, color);
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public void setVisibleRowCount(int n) {
        int n2 = this.visibleRowCount;
        this.visibleRowCount = Math.max(0, n);
        this.firePropertyChange("visibleRowCount", n2, n);
    }

    public int getFirstVisibleIndex() {
        Point point = this.getVisibleRect().getLocation();
        return this.locationToIndex(point);
    }

    public int getLastVisibleIndex() {
        Rectangle rectangle = this.getVisibleRect();
        Point point = new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        return this.locationToIndex(point);
    }

    public void ensureIndexIsVisible(int n) {
        Rectangle rectangle = this.getCellBounds(n, n);
        if (rectangle != null) {
            this.scrollRectToVisible(rectangle);
        }
    }

    public int locationToIndex(Point point) {
        ListUI listUI = this.getUI();
        if (listUI != null) {
            return listUI.locationToIndex(this, point);
        }
        return -1;
    }

    public Point indexToLocation(int n) {
        ListUI listUI = this.getUI();
        if (listUI != null) {
            return listUI.indexToLocation(this, n);
        }
        return null;
    }

    public Rectangle getCellBounds(int n, int n2) {
        ListUI listUI = this.getUI();
        if (listUI != null) {
            return listUI.getCellBounds(this, n, n2);
        }
        return null;
    }

    public ListModel getModel() {
        return this.dataModel;
    }

    public void setModel(ListModel listModel) {
        ListModel listModel2 = this.dataModel;
        this.dataModel = listModel;
        this.firePropertyChange("model", listModel2, this.dataModel);
        this.clearSelection();
    }

    public void setListData(Object[] objectArray) {
        this.setModel(new 4(objectArray));
    }

    public void setListData(Vector vector) {
        this.setModel(new 5(vector));
    }

    protected ListSelectionModel createSelectionModel() {
        return new DefaultListSelectionModel();
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    protected void fireSelectionValueChanged(int n, int n2, boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        ListSelectionEvent listSelectionEvent = null;
        int n3 = objectArray.length - 2;
        while (n3 >= 0) {
            if (objectArray[n3] == (class$com$sun$java$swing$event$ListSelectionListener != null ? class$com$sun$java$swing$event$ListSelectionListener : JComponent.class$("com.sun.java.swing.event.ListSelectionListener"))) {
                if (listSelectionEvent == null) {
                    listSelectionEvent = new ListSelectionEvent(this, n, n2, bl);
                }
                ((ListSelectionListener)objectArray[n3 + 1]).valueChanged(listSelectionEvent);
            }
            n3 -= 2;
        }
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        if (this.selectionListener == null) {
            this.selectionListener = new 6();
            this.getSelectionModel().addListSelectionListener(this.selectionListener);
        }
        this.listenerList.add(class$com$sun$java$swing$event$ListSelectionListener != null ? class$com$sun$java$swing$event$ListSelectionListener : (class$com$sun$java$swing$event$ListSelectionListener = JComponent.class$("com.sun.java.swing.event.ListSelectionListener")), listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.remove(class$com$sun$java$swing$event$ListSelectionListener != null ? class$com$sun$java$swing$event$ListSelectionListener : (class$com$sun$java$swing$event$ListSelectionListener = JComponent.class$("com.sun.java.swing.event.ListSelectionListener")), listSelectionListener);
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        if (listSelectionModel == null) {
            throw new IllegalArgumentException("selectionModel must be non null");
        }
        if (this.selectionListener != null) {
            this.selectionModel.removeListSelectionListener(this.selectionListener);
            listSelectionModel.addListSelectionListener(this.selectionListener);
        }
        ListSelectionModel listSelectionModel2 = this.selectionModel;
        this.selectionModel = listSelectionModel;
        this.firePropertyChange("selectionModel", listSelectionModel2, listSelectionModel);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleSelection", new Boolean(false), new Boolean(true));
        }
    }

    public void setSelectionMode(int n) {
        this.getSelectionModel().setSelectionMode(n);
    }

    public int getSelectionMode() {
        return this.getSelectionModel().getSelectionMode();
    }

    public int getAnchorSelectionIndex() {
        return this.getSelectionModel().getAnchorSelectionIndex();
    }

    public int getLeadSelectionIndex() {
        return this.getSelectionModel().getLeadSelectionIndex();
    }

    public int getMinSelectionIndex() {
        return this.getSelectionModel().getMinSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.getSelectionModel().getMaxSelectionIndex();
    }

    public boolean isSelectedIndex(int n) {
        return this.getSelectionModel().isSelectedIndex(n);
    }

    public boolean isSelectionEmpty() {
        return this.getSelectionModel().isSelectionEmpty();
    }

    public void clearSelection() {
        this.getSelectionModel().clearSelection();
    }

    public void setSelectionInterval(int n, int n2) {
        this.getSelectionModel().setSelectionInterval(n, n2);
    }

    public void addSelectionInterval(int n, int n2) {
        this.getSelectionModel().addSelectionInterval(n, n2);
    }

    public void removeSelectionInterval(int n, int n2) {
        this.getSelectionModel().removeSelectionInterval(n, n2);
    }

    public void setValueIsAdjusting(boolean bl) {
        this.getSelectionModel().setValueIsAdjusting(bl);
    }

    public boolean getValueIsAdjusting() {
        return this.getSelectionModel().getValueIsAdjusting();
    }

    public int[] getSelectedIndices() {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        if (n < 0 || n2 < 0) {
            return new int[0];
        }
        int[] nArray = new int[1 + (n2 - n)];
        int n3 = 0;
        int n4 = n;
        while (n4 <= n2) {
            if (listSelectionModel.isSelectedIndex(n4)) {
                nArray[n3++] = n4;
            }
            ++n4;
        }
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    public void setSelectedIndex(int n) {
        this.getSelectionModel().setSelectionInterval(n, n);
    }

    public void setSelectedIndices(int[] nArray) {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        listSelectionModel.clearSelection();
        int n = 0;
        while (n < nArray.length) {
            listSelectionModel.addSelectionInterval(nArray[n], nArray[n]);
            ++n;
        }
    }

    public Object[] getSelectedValues() {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        ListModel listModel = this.getModel();
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        if (n < 0 || n2 < 0) {
            return new Object[0];
        }
        Object[] objectArray = new Object[1 + (n2 - n)];
        int n3 = 0;
        int n4 = n;
        while (n4 <= n2) {
            if (listSelectionModel.isSelectedIndex(n4)) {
                objectArray[n3++] = listModel.getElementAt(n4);
            }
            ++n4;
        }
        Object[] objectArray2 = new Object[n3];
        System.arraycopy(objectArray, 0, objectArray2, 0, n3);
        return objectArray2;
    }

    public int getSelectedIndex() {
        return this.getMinSelectionIndex();
    }

    public Object getSelectedValue() {
        int n = this.getMinSelectionIndex();
        if (n == -1) {
            return null;
        }
        return this.getModel().getElementAt(n);
    }

    public void setSelectedValue(Object object, boolean bl) {
        if (object == null) {
            this.setSelectedIndex(-1);
        } else if (!object.equals(this.getSelectedValue())) {
            ListModel listModel = this.getModel();
            int n = 0;
            int n2 = listModel.getSize();
            while (n < n2) {
                if (object.equals(listModel.getElementAt(n))) {
                    this.setSelectedIndex(n);
                    if (bl) {
                        this.ensureIndexIsVisible(n);
                    }
                    this.repaint();
                    return;
                }
                ++n;
            }
            this.setSelectedIndex(-1);
        }
        this.repaint();
    }

    public Dimension getPreferredScrollableViewportSize() {
        Insets insets = this.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        int n3 = this.getVisibleRowCount();
        int n4 = this.getFixedCellWidth();
        int n5 = this.getFixedCellHeight();
        if (n4 > 0 && n5 > 0) {
            int n6 = n4 + n;
            int n7 = n3 * n5 + n2;
            return new Dimension(n6, n7);
        }
        if (this.getModel().getSize() > 0) {
            int n8 = this.getPreferredSize().width;
            Rectangle rectangle = this.getCellBounds(0, 0);
            int n9 = n3 * rectangle.height + n2;
            return new Dimension(n8, n9);
        }
        n4 = n4 > 0 ? n4 : 256;
        n5 = n5 > 0 ? n5 : 16;
        return new Dimension(n4, n5 * n3);
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return 1;
        }
        int n3 = this.getFirstVisibleIndex();
        if (n3 == -1) {
            return 0;
        }
        if (n2 > 0) {
            Rectangle rectangle2 = this.getCellBounds(n3, n3);
            if (rectangle2 == null) {
                return 0;
            }
            return rectangle2.height - (rectangle.y - rectangle2.y);
        }
        Rectangle rectangle3 = this.getCellBounds(n3, n3);
        if (rectangle3.y == rectangle.y && n3 == 0) {
            return 0;
        }
        if (rectangle3.y == rectangle.y) {
            Rectangle rectangle4 = this.getCellBounds(n3 - 1, n3 - 1);
            if (rectangle4 == null) {
                return 0;
            }
            return rectangle4.height;
        }
        return rectangle.y - rectangle3.y;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            return rectangle.height;
        }
        return rectangle.width;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJList();
        }
        return this.accessibleContext;
    }

    private static final class 1
    extends AbstractListModel {
        private final /* synthetic */ Object[] val$listData;

        public int getSize() {
            return this.val$listData.length;
        }

        public Object getElementAt(int n) {
            return this.val$listData[n];
        }

        /* synthetic */ 1(Object[] objectArray) {
            this.val$listData = objectArray;
        }
    }

    private static final class 2
    extends AbstractListModel {
        private final /* synthetic */ Vector val$listData;

        public int getSize() {
            return this.val$listData.size();
        }

        public Object getElementAt(int n) {
            return this.val$listData.elementAt(n);
        }

        /* synthetic */ 2(Vector vector) {
            this.val$listData = vector;
        }
    }

    private final class 3
    extends AbstractListModel {
        public int getSize() {
            return 0;
        }

        public Object getElementAt(int n) {
            return "No Data Model";
        }

        /* synthetic */ 3() {
        }
    }

    private static final class 4
    extends AbstractListModel {
        private final /* synthetic */ Object[] val$listData;

        public int getSize() {
            return this.val$listData.length;
        }

        public Object getElementAt(int n) {
            return this.val$listData[n];
        }

        /* synthetic */ 4(Object[] objectArray) {
            this.val$listData = objectArray;
        }
    }

    private static final class 5
    extends AbstractListModel {
        private final /* synthetic */ Vector val$listData;

        public int getSize() {
            return this.val$listData.size();
        }

        public Object getElementAt(int n) {
            return this.val$listData.elementAt(n);
        }

        /* synthetic */ 5(Vector vector) {
            this.val$listData = vector;
        }
    }

    private final class 6
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            JList.this.fireSelectionValueChanged(listSelectionEvent.getFirstIndex(), listSelectionEvent.getLastIndex(), listSelectionEvent.getValueIsAdjusting());
        }

        /* synthetic */ 6() {
        }
    }

    protected class AccessibleJList
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    ListSelectionListener,
    ListDataListener {
        AccessibleJList() {
            super(JList.this);
            JList.this = JList.this;
            JList.this.getSelectionModel().addListSelectionListener(this);
            JList.this.getModel().addListDataListener(this);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.firePropertyChange("AccessibleVisibleData", new Boolean(false), new Boolean(true));
            this.firePropertyChange("AccessibleSelection", new Boolean(false), new Boolean(true));
            AccessibleStateSet accessibleStateSet = this.getAccessibleStateSet();
            ListSelectionModel listSelectionModel = JList.this.getSelectionModel();
            if (listSelectionModel.getSelectionMode() != 0) {
                if (!accessibleStateSet.contains(AccessibleState.MULTISELECTABLE)) {
                    accessibleStateSet.add(AccessibleState.MULTISELECTABLE);
                    this.firePropertyChange("AccessibleState", null, AccessibleState.MULTISELECTABLE);
                    return;
                }
            } else if (accessibleStateSet.contains(AccessibleState.MULTISELECTABLE)) {
                accessibleStateSet.remove(AccessibleState.MULTISELECTABLE);
                this.firePropertyChange("AccessibleState", AccessibleState.MULTISELECTABLE, null);
            }
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.firePropertyChange("AccessibleVisibleData", new Boolean(false), new Boolean(true));
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.firePropertyChange("AccessibleVisibleData", new Boolean(false), new Boolean(true));
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.firePropertyChange("AccessibleVisibleData", new Boolean(false), new Boolean(true));
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JList.this.selectionModel.getSelectionMode() != 0) {
                accessibleStateSet.add(AccessibleState.MULTISELECTABLE);
            }
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        public Accessible getAccessibleAt(Point point) {
            int n = JList.this.locationToIndex(point);
            if (n >= 0) {
                return new AccessibleJListChild(JList.this, n);
            }
            return null;
        }

        public int getAccessibleChildrenCount() {
            return JList.this.getModel().getSize();
        }

        public Accessible getAccessibleChild(int n) {
            if (n >= JList.this.getModel().getSize()) {
                return null;
            }
            return new AccessibleJListChild(JList.this, n);
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public int getAccessibleSelectionCount() {
            return JList.this.getSelectedIndices().length;
        }

        public Accessible getAccessibleSelection(int n) {
            int n2 = this.getAccessibleSelectionCount();
            if (n < 0 || n >= n2) {
                return null;
            }
            return this.getAccessibleChild(JList.this.getSelectedIndices()[n]);
        }

        public boolean isAccessibleChildSelected(int n) {
            return JList.this.isSelectedIndex(n);
        }

        public void addAccessibleSelection(int n) {
            JList.this.addSelectionInterval(n, n);
        }

        public void removeAccessibleSelection(int n) {
            JList.this.removeSelectionInterval(n, n);
        }

        public void clearAccessibleSelection() {
            JList.this.clearSelection();
        }

        public void selectAllAccessibleSelection() {
            JList.this.addSelectionInterval(0, this.getAccessibleChildrenCount() - 1);
        }

        protected class AccessibleJListChild
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private JList parent;
            private int indexInParent;
            private Component component;
            private AccessibleContext accessibleContext;
            private ListModel listModel;
            private ListCellRenderer cellRenderer;

            public AccessibleJListChild(JList jList, int n) {
                AccessibleJList.this = AccessibleJList.this;
                this.parent = jList;
                this.setAccessibleParent(jList);
                this.indexInParent = n;
                if (jList != null) {
                    this.listModel = jList.getModel();
                    this.cellRenderer = jList.getCellRenderer();
                }
            }

            private Component getCurrentComponent() {
                return this.getComponentAtIndex(this.indexInParent);
            }

            private AccessibleContext getCurrentAccessibleContext() {
                Component component = this.getComponentAtIndex(this.indexInParent);
                if (component instanceof Accessible) {
                    return ((Accessible)((Object)component)).getAccessibleContext();
                }
                return null;
            }

            private Component getComponentAtIndex(int n) {
                if (n < 0 || n >= this.listModel.getSize()) {
                    return null;
                }
                if (this.parent != null && this.listModel != null && this.cellRenderer != null) {
                    Object object = this.listModel.getElementAt(n);
                    boolean bl = this.parent.isSelectedIndex(n);
                    boolean bl2 = this.parent.hasFocus() && n == this.parent.getLeadSelectionIndex();
                    return this.cellRenderer.getListCellRendererComponent(this.parent, object, n, bl, bl2);
                }
                return null;
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            public String getAccessibleName() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleName();
                }
                return null;
            }

            public void setAccessibleName(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleName(string);
                }
            }

            public String getAccessibleDescription() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleDescription();
                }
                return null;
            }

            public void setAccessibleDescription(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleDescription(string);
                }
            }

            public AccessibleRole getAccessibleRole() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleRole();
                }
                return null;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                AccessibleStateSet accessibleStateSet = accessibleContext != null ? accessibleContext.getAccessibleStateSet() : new AccessibleStateSet();
                accessibleStateSet = accessibleContext.getAccessibleStateSet();
                accessibleStateSet.add(AccessibleState.SELECTABLE);
                if (this.parent.isSelectedIndex(this.indexInParent)) {
                    accessibleStateSet.add(AccessibleState.SELECTED);
                }
                if (this.isShowing()) {
                    accessibleStateSet.add(AccessibleState.SHOWING);
                } else if (accessibleStateSet.contains(AccessibleState.SHOWING)) {
                    accessibleStateSet.remove(AccessibleState.SHOWING);
                }
                if (this.isVisible()) {
                    accessibleStateSet.add(AccessibleState.VISIBLE);
                } else if (accessibleStateSet.contains(AccessibleState.VISIBLE)) {
                    accessibleStateSet.remove(AccessibleState.VISIBLE);
                }
                return accessibleStateSet;
            }

            public int getAccessibleIndexInParent() {
                return this.indexInParent;
            }

            public int getAccessibleChildrenCount() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleChildrenCount();
                }
                return 0;
            }

            public Accessible getAccessibleChild(int n) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    Accessible accessible = accessibleContext.getAccessibleChild(n);
                    accessibleContext.setAccessibleParent(this);
                    return accessible;
                }
                return null;
            }

            public Locale getLocale() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getLocale();
                }
                return null;
            }

            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.addPropertyChangeListener(propertyChangeListener);
                }
            }

            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.removePropertyChangeListener(propertyChangeListener);
                }
            }

            public AccessibleAction getAccessibleAction() {
                return this.getCurrentAccessibleContext().getAccessibleAction();
            }

            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            public AccessibleSelection getAccessibleSelection() {
                return this.getCurrentAccessibleContext().getAccessibleSelection();
            }

            public AccessibleText getAccessibleText() {
                return this.getCurrentAccessibleContext().getAccessibleText();
            }

            public AccessibleValue getAccessibleValue() {
                return this.getCurrentAccessibleContext().getAccessibleValue();
            }

            public Color getBackground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getBackground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getBackground();
                }
                return null;
            }

            public void setBackground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBackground(color);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setBackground(color);
                }
            }

            public Color getForeground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getForeground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getForeground();
                }
                return null;
            }

            public void setForeground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setForeground(color);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setForeground(color);
                }
            }

            public Cursor getCursor() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getCursor();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getCursor();
                }
                Accessible accessible = this.getAccessibleParent();
                if (accessible instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessible)).getCursor();
                }
                return null;
            }

            public void setCursor(Cursor cursor) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setCursor(cursor);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setCursor(cursor);
                }
            }

            public Font getFont() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFont();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFont();
                }
                return null;
            }

            public void setFont(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setFont(font);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setFont(font);
                }
            }

            public FontMetrics getFontMetrics(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFontMetrics(font);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFontMetrics(font);
                }
                return null;
            }

            public boolean isEnabled() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isEnabled();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isEnabled();
                }
                return false;
            }

            public void setEnabled(boolean bl) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setEnabled(bl);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setEnabled(bl);
                }
            }

            public boolean isVisible() {
                int n = this.parent.getFirstVisibleIndex();
                int n2 = this.parent.getLastVisibleIndex();
                if (n2 == -1) {
                    n2 = this.parent.getModel().getSize() - 1;
                }
                return this.indexInParent >= n && this.indexInParent <= n2;
            }

            public void setVisible(boolean bl) {
            }

            public boolean isShowing() {
                return this.parent.isShowing() && this.isVisible();
            }

            public boolean contains(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    Rectangle rectangle = ((AccessibleComponent)((Object)accessibleContext)).getBounds();
                    return rectangle.contains(point);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    Rectangle rectangle = component.getBounds();
                    return rectangle.contains(point);
                }
                return this.getBounds().contains(point);
            }

            public Point getLocationOnScreen() {
                if (this.parent != null) {
                    Point point = this.parent.getLocationOnScreen();
                    Point point2 = this.parent.indexToLocation(this.indexInParent);
                    point2.translate(point.x, point.y);
                    return point2;
                }
                return null;
            }

            public Point getLocation() {
                if (this.parent != null) {
                    return this.parent.indexToLocation(this.indexInParent);
                }
                return null;
            }

            public void setLocation(Point point) {
                if (this.parent != null && this.parent.contains(point)) {
                    JList.this.ensureIndexIsVisible(this.indexInParent);
                }
            }

            public Rectangle getBounds() {
                if (this.parent != null) {
                    return this.parent.getCellBounds(this.indexInParent, this.indexInParent);
                }
                return null;
            }

            public void setBounds(Rectangle rectangle) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBounds(rectangle);
                }
            }

            public Dimension getSize() {
                Rectangle rectangle = this.getBounds();
                if (rectangle != null) {
                    return rectangle.getSize();
                }
                return null;
            }

            public void setSize(Dimension dimension) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setSize(dimension);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setSize(dimension);
                }
            }

            public Accessible getAccessibleAt(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getAccessibleAt(point);
                }
                return null;
            }

            public boolean isFocusTraversable() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isFocusTraversable();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isFocusTraversable();
                }
                return false;
            }

            public void requestFocus() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).requestFocus();
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.requestFocus();
                }
            }

            public void addFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).addFocusListener(focusListener);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.addFocusListener(focusListener);
                }
            }

            public void removeFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).removeFocusListener(focusListener);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.removeFocusListener(focusListener);
                }
            }
        }
    }
}

