import java.awt.*;
import java.awt.event.*;
import java.lang.*;
import java.util.*;

/* Simple Java programs that calls PL/I program for wine info */

/* Main class definition */

public class wineSamp  extends java.applet.Applet
                       implements ActionListener
  {

    private DetailFrame myFrame = null;
    Cellar myCellar = new Cellar();

    private Button DoitButton;
    private Button DetButton;
    private Button QuitButton;
    private Choice myChoice;
    private int flag;
    private Label strlabel;
    private List myList;
    private String string1;


    /* wineSamp.init() method */

    public void init()
      {
       /* Creates a GridBagLayout for setting objects pos. on the panel */

       GridBagLayout gridbag = new GridBagLayout();
       GridBagConstraints c =  new GridBagConstraints();
       setLayout( gridbag );
       c.fill = GridBagConstraints.HORIZONTAL;
       c.insets = new Insets( 10,20,10,20 );
       c.weightx = 100;
       c.weighty = 100;

       /* Please choose a wine type */
       strlabel = new Label( "Please choose a wine type: " );
       c.gridx = 0;
       c.gridy = 0;
       c.gridwidth = 2;
       c.gridheight = 1;
       gridbag.setConstraints( strlabel,c );
       add(strlabel);


       /* drop down listbox */
       c.gridx = 0;
       c.gridy = 1;
       c.gridwidth = 1;
       c.gridheight = 1;
       myChoice = new Choice();
       gridbag.setConstraints( myChoice,c );
       add( myChoice );

       /* Select Wine */
       c.gridx = 1;
       c.gridy = 1;
       c.gridwidth = 1;
       c.gridheight = 1;
       DoitButton = new Button( "Select Wine" );
       gridbag.setConstraints( DoitButton,c );
       add( DoitButton );
       DoitButton.addActionListener( this );

       /* List box */
       c.gridx = 0;
       c.gridy = 2;
       c.gridwidth = 1;
       c.gridheight = 3;
       myList = new List( 5, false );
       gridbag.setConstraints( myList,c );
       add( myList );

       /* Get Details */
       c.gridx = 1;
       c.gridy = 2;
       c.gridwidth = 1;
       c.gridheight = 1;
       DetButton = new Button( "Get Details" );
       gridbag.setConstraints( DetButton,c );
       add( DetButton );
       DetButton.addActionListener( this );

       /* Quit button */
       c.gridx = 0;
       c.gridy = 5;
       c.gridwidth = 3;
       c.gridheight = 1;
       c.gridwidth=GridBagConstraints.REMAINDER;
       QuitButton = new Button( "Quit" );
       gridbag.setConstraints( QuitButton,c );
       add( QuitButton );
       QuitButton.addActionListener( this );

       /* add items to choice component */
       myChoice.addItem( "Cabernet"     );
       myChoice.addItem( "Champagne"    );
       myChoice.addItem( "Chardonnay"   );
       myChoice.addItem( "Merlot"       );
       myChoice.addItem( "Petite Syrah" );
       myChoice.addItem( "Pinot Noir"   );
       myChoice.addItem( "Zinfandel"    );
       myChoice.select( 0 );

       /* misc initilizations */
       DetButton.setEnabled( false );
       flag = 0;

  }



  /* wineSamp.actionPerformed() method */

  public void actionPerformed( ActionEvent evt )
    {
      int   pli_result;
      if ( evt.getSource() == DoitButton )
          getVariety();
      else if ( evt.getSource() == DetButton )
          getDetails();
      else if ( evt.getSource() == QuitButton ) {
          System.exit( 0 );
    }

            } /*end method*/

  public void getVariety()
    {

     int   pli_result;
     String string2 = new String(" ");
     String delim = new String("?");

     /* get winetype from choice */
     string1 = myChoice.getSelectedItem();
     myList.removeAll();

     /* Call the PL/I Native Method */
     string2 = myCellar.GetWine( string1, flag );

     /* tokenize the string */
     StringTokenizer st = new StringTokenizer( string2,delim );
     while ( st.hasMoreTokens() ) {
        myList.addItem( st.nextToken() );
     }

     myList.select( 0 );
     DetButton.setEnabled( true );
   } /*end method*/

   public void getDetails()
     {
      String string1 = new String("");

      string1 = myList.getSelectedItem();

      /* create and show the frame */
      myFrame = new DetailFrame( this, string1 );
      myFrame.setBounds( 40,20,450,350 );
      myFrame.show();

     } /*end method*/

   public void closeFrame()
     {
      myFrame.dispose();
     } /*end method*/

  /* wineSamp.main() method */

   public static void main( String args[])
     {
      Frame myFrame = new Frame( "Manipulate a String Using Native PL/I" );
      wineSamp myApp = new wineSamp();

      // run the app
      myApp.init();
      myApp.start();

      //  add app to frame
      myFrame.add( "Center", myApp );

      //  resize and make it visible
      myFrame.setSize( 600, 400 );
      myFrame.show();
     }


} /*end class */

class DetailFrame extends java.awt.Frame
                  implements ActionListener
  {

    private wineSamp myApplet = null;

    private Button fQuitButton = new Button( "Close" );
    private Label pLabel = new Label( "Date purchased:" );
    private Label mLabel = new Label( "Date to be consumed:" );
    private String wString;
    private TextArea myComments = new TextArea( 12,40 );
    private TextField mdText = new TextField( "",8 );
    private TextField pdText = new TextField( "",8 );

    public DetailFrame( wineSamp anApplet, String aString )
      {

       myApplet = anApplet;
       wString = aString;
       setTitle( wString.trim() );
       String string2 = new String("");
       String delim = new String("?");

       Cellar cellarDet = new Cellar();

       Panel p1 = new Panel();
       p1.add( pLabel );
       p1.add( pdText );
       p1.add( mLabel );
       p1.add( mdText );
       add( p1,"North" );

       Panel p2 = new Panel();
       p2.add( myComments );
       add( p2,"Center" );

       Panel p3 = new Panel();
       p3.add( fQuitButton );
       fQuitButton.addActionListener( this );
       add( p3,"South" );

       string2 = cellarDet.GetDet( wString  );

       /* tokenize the string */
       StringTokenizer st = new StringTokenizer( string2,delim );
       pdText.setText( st.nextToken() );
       mdText.setText( st.nextToken() );
       while ( st.hasMoreTokens() ) {
         myComments.append( st.nextToken()+"\n" );
       }

      }  /* end constructor */


  public void actionPerformed( ActionEvent evt )
    {
      if ( evt.getSource() == fQuitButton ) {
        myApplet.closeFrame();
      }
    } /* end method */


}  /* end class */

