 /*********************************************************/
 /*  CREATED BY C2PLI CONVERSION UTILITY                  */
 /*********************************************************/
 /********************************************************************/
 /*                                                                  */
 /*  PL/I Include file: SQLUDF.CPY                                   */
 /*                                                                  */
 /*    This file is installed in the \IBMPLI\INCLUDE\ directory.     */
 /*                                                                  */
 /*                                                                  */
 /*  NAME - SQLUDF.CPY                                               */
 /*                                                                  */
 /*  DESCRIPTION                                                     */
 /*                                                                  */
 /*    This include file is translated into a PL/I include file,     */
 /*    from the C header files supplied with the                     */
 /*    IBM DATABASE 2 SOFTWARE DEVELOPERS KIT/2  product.            */
 /*    This include file is intended for use with the                */
 /*    IBM DATABASE 2 SOFTWARE DEVELOPERS KIT/2 product.             */
 /*                                                                  */
 /*                                                                  */
 /*    (C) Copyright IBM Corp. 1994, 1996. All Rights Reserved.      */
 /*    US Government Users Restricted Rights-- Use, duplication or   */
 /*    disclosure restricted by GSA ADP Schedule Contract with       */
 /*    IBM Corp.                                                     */
 /*    Licensed Materials - Property of IBM                          */
 /*                                                                  */
 /*Function = Include File for use in compiling User Defined Function*/
 /*          Intended to help writers of UDFs deal with the interface*/
 /*             between DBMS and UDF.  Contains:                     */
 /*               common structures                                  */
 /*               "language types" for the SQL types                 */
 /*                                                                  */
 /*  Operating System = OS/2                                         */
 /*                                                                  */
 /*                                                                  */
 /*  DISCLAIMER OF WARRANTIES                                        */
 /*    The following enclosed code is sample code created by IBM   */
 /*    Corporation. This sample code is not part of any standard     */
 /*    IBM product and is provided to you solely for the purpose of  */
 /*    assisting you in the development of your applications.  The   */
 /*    code is provided "AS IS", without warranty of any kind.       */
 /*    IBM shall not be liable for any damages arising out of your   */
 /*    use of the sample code, even if IBM has been advised of the   */
 /*    possibility of such damages.                                  */
 /*                                                                  */
 /********************************************************************/

 %dcl SQL_H_SQLUDF char ext;
 %if SQL_H_SQLUDF = '' %then
  %do;
 /* Permit duplicate Includes */
    %dcl SQL_H_SQLUDF char ext;
    %SQL_H_SQLUDF = 'Y';



 /* System-Specific Include   */
    %include sqlsystm;


 /*==============================================*/
 /*==============================================*/
 /*== Common #defines, used in this file.      ==*/
 /*==============================================*/
 /*==============================================*/
                                             /* length of SQLSTATE   */
    dcl SQLUDF_SQLSTATE_LEN fixed bin(31) value(5);
                                             /* length of scratchpad */
    dcl SQLUDF_SCRATCHPAD_LEN fixed bin(31) value(100);
                                   /* length of fully-qualified name */
    dcl SQLUDF_FQNAME_LEN fixed bin(31) value(27);
                                 /* length of function specific name */
    dcl SQLUDF_SPECNAME_LEN fixed bin(31) value(18);
                                      /* length of message text area */
    dcl SQLUDF_MSGTEXT_LEN fixed bin(31) value(70);


 /*==============================================*/
 /*==============================================*/
 /*== Common structures.                       ==*/
 /*== Note:  these are used in the C "language ==*/
 /*==        type" definitions which follow.   ==*/
 /*==============================================*/
 /*==============================================*/

 /*------------------------------------------------------------------*/
 /* NOTE: The following defined structures are models for the user.  */
 /*       The user must replace the '???' with lengths that are      */
 /*       meaningful to their applications, then un-comment the      */
 /*       defined structures and other related defines before they   */
 /*       can be used.                                               */
 /*------------------------------------------------------------------*/
 /* Structure used for  VARCHAR FOR BIT DATA, LONG VARCHAR           */
 /*------------------------------------------------------------------*/
 /*define structure                         */
 /*  1 sqludf_vc_fbd,                       */
 /*       2 length unsigned fixed bin(16) , */     /* length of data */
 /*       2 data char(???);                 */


 /*-------------------------------------------------*/
 /* Structure used for: LONG VARGRAPHIC             */
 /*-------------------------------------------------*/
 /*define structure                         */
 /*  1 sqludf_vg,                           */
 /*       2 length unsigned fixed bin(16) , */     /* length of data */
 /*       2 data(???) type wchar_t;         */


 /*---------------------------------*/
 /* Structure used for: BLOB, CLOB  */
 /*---------------------------------*/
 /*define structure                         */
 /*  1 sqludf_lob,                          */
 /*       2 length unsigned fixed bin(31) , */     /* length of data */
 /*       2 data(???) char(1);              */


 /*----------------------------*/
 /* Structure used for: DBCLOB */
 /*----------------------------*/
 /*define structure                         */
 /*  1 sqludf_lobg,                         */
 /*       2 length unsigned fixed bin(31) , */     /* length of data */
 /*       2 data(???) type wchar_t;         */


 /*------------------------------------------------------------*/
 /* Structure used for: the scratchpad.                        */
 /* Note: This structure as provided by DB2/CS gives the       */
 /*       overall size/structure of the scratchpad argument.   */
 /*       Individual UDFs which use a scratchpad may wish to   */
 /*       override the "data" variable of this scratchpad      */
 /*       with variables that make sense for the particular    */
 /*       UDF.                                                 */
 /* Note: Remember that the "data" variable is initialized     */
 /*       by DB2/CS to all \0 before the first call.           */
 /*------------------------------------------------------------*/
 define structure
   1 sqludf_scratchpad,
       2 length unsigned fixed bin(31) ,/* length of scratchpad data */
                                 /* scratchpad data, init. to all \0 */
       2 data char(SQLUDF_SCRATCHPAD_LEN);



 /*===============================================================*/
 /*===============================================================*/
 /*== "Language type" definitions, for argument/result values.  ==*/
 /*== Usage note: define input and output SQL arguments as      ==*/
 /*==             pointers to these types.                      ==*/
 /*===============================================================*/
 /*===============================================================*/

    define alias SQLUDF_SMALLINT fixed bin(15);

    define alias SQLUDF_INTEGER fixed bin(31);

    define alias SQLUDF_DOUBLE  float bin(53);

    /* declare a SQL CHAR(n) item as CHAR(n) VARYINGZ            */
    /* declare a SQL CHARVAR(n) item as CHAR(n) VARYING          */
    /* declare a SQL VARCHAR_FBD(n) item as CHAR(n) VARYING      */
    /* declare a SQL LONG(n) item as CHAR(n) VARYING             */

    /* declare a SQL GRAPH(n) item as GRAPHIC(n) VARYINGZ        */
    /* declare a SQL VARGRAPH(n) item as GRAPHIC(n) VARYING      */
    /* declare a SQL LONGVARG(n) item as GRAPHIC(n) VARYING      */

    define alias SQLUDF_DATE char(10) varz;
    define alias SQLUDF_TIME char(8) varz;
    define alias SQLUDF_STAMP char(26) varz;

 /*------------------------------------------------------------------*/
 /* NOTE: The following declares are based on the previously defined */
 /*       structures.  Once the '???' are replaced with meaningful   */
 /*       lengths, the following declares may be used.               */
 /*------------------------------------------------------------------*/
 /* for CLOB           */
 /* Dcl SQLUDF_CLOB type sqludf_lob;         */
 /* for BLOB           */
 /* Dcl SQLUDF_BLOB type sqludf_lob;         */
 /* for DBCLOB         */
 /* Dcl SQLUDF_DBCLOB type sqludf_lobg;      */

 /* for null indicators     */
    define alias SQLUDF_NULLIND fixed bin(15);


 /*===============================================================*/
 /*===============================================================*/
 /*== "Language type" definitions, for scratchpad and call type ==*/
 /*== arguments to a UDF.                                       ==*/
 /*== Usage note: define arguments as pointers                  ==*/
 /*==             to these types.                               ==*/
 /*===============================================================*/
 /*===============================================================*/
                                                   /* for scratchpad */
  Dcl SQLUDF_SCRATCHPAD type sqludf_scratchpad;
                                                    /* for call type */

 define ordinal SQLUDF_CALL_TYPE (
    SQLUDF_FIRST_CALL   value(-1),
    SQLUDF_NORMAL_CALL  value( 0),
    SQLUDF_FINAL_CALL   value(+1) );


 /*==============================================================*/
 /*==============================================================*/
 /*== Special sqlstate (SQLUDF_STATE) values that UDF can set. ==*/
 /*== Usage note: the values "38xxx" and "01Hxx" are included  ==*/
 /*==             for completeness and for their educational   ==*/
 /*==             value.  You will want to define and use your ==*/
 /*==             won constants with your own values           ==*/
 /*==             substituted for the generic "x"s.            ==*/
 /*==============================================================*/
 /*==============================================================*/
                                /* good return, no problem -         */
                                /* SQLUDF_STATE is init'd to this    */
                                /* value by DB2 before calling UDF.  */
    dcl SQLUDF_STATE_OK char value("00000");
                                /* error- UDF issued SQL call,       */
                                /* DB2 returned error (-487) to UDF. */
    dcl SQLUDF_STATE_SQLCALL char value("38502");
                                /* error- xxx is UDF-defined, UDF    */
                                /* should overwrite, but NOT USE     */
                                /* values 0xx thru 5xx, as these are */
                                /* reserved by IBM.                  */
    dcl SQLUDF_STATE_ERR char value("38xxx");
                                /* warning - xx is UDF-defined, UDF  */
                                /* should overwrite, any values OK.  */
    dcl SQLUDF_STATE_WARN char value("01Hxx");


 /*================================================*/
 /*================================================*/
 /*== Macros, for testing for argument nullness: ==*/
 /*================================================*/
 /*================================================*/


   SQLUDF_NULL:
     proc( nullind ) internal
     returns( bit(1) )
     options( inline );

     dcl nullind  type(SQLUDF_NULLIND) byaddr;

     return( nullind < 0 );
   end;


   SQLUDF_NOTNULL:
     proc( nullind ) internal
     returns( bit(1) )
     options( inline );

     dcl nullind  type(SQLUDF_NULLIND) byaddr;

     return( nullind >= 0 );
   end;


  %end;
 /* SQL_H_SQLUDF */
