 /********************************************************************/
 /*                                                                  */
 /*  PL/I Include file: PMSTDDLG.CPY                                 */
 /*                                                                  */
 /*  NAME - PMSTDDLG.CPY                                             */
 /*                                                                  */
 /*  DESCRIPTION                                                     */
 /*    Presentation Manager PL/I include file.                       */
 /*                                                                  */
 /*    (C) Copyright IBM Corp. 1992. All Rights Reserved.            */
 /*    US Government Users Restricted Rights-- Use, duplication or   */
 /*    disclosure restricted by GSA ADP Schedule Contract with       */
 /*    IBM Corp.                                                     */
 /*                                                                  */
 /*  DISCLAIMER OF WARRANTIES                                        */
 /*    The following enclosed code is sample code created by IBM   */
 /*    Corporation. This sample code is not part of any standard     */
 /*    IBM product and is provided to you solely for the purpose of  */
 /*    assisting you in the development of your applications.  The   */
 /*    code is provided "AS IS", without warranty of any kind.       */
 /*    IBM shall not be liable for any damages arising out of your   */
 /*    use of the sample code, even if IBM has been advised of the   */
 /*    possibility of such damages.                                  */
 /*                                                                  */
 /********************************************************************/
 /*==================================================================*/
 /*                                                                  */
 /* The folowing symbols are used in this file for conditional       */
 /* sections.                                                        */
 /*                                                                  */
 /*   #define:                To include:                            */
 /*                                                                  */
 /*   INCL_WINSTDDLGS         include all dialogs/controls           */
 /*   INCL_WINSTDBOOK         book control class                     */
 /*   INCL_WINSTDCNR          container control class                */
 /*   INCL_WINSTDDRAG         standard drag dll                      */
 /*   INCL_WINSTDFILE         standard file dialog                   */
 /*   INCL_WINSTDFONT         standard font dialog                   */
 /*   INCL_WINSTDSLIDER       slider control class                   */
 /*   INCL_WINSTDSPIN         spin button control class              */
 /*   INCL_WINSTDVALSET       value set control class                */
 /*                                                                  */
 /*==================================================================*/
 %if IBMC__='Y' %then %do;
   %if CHKHDR__='Y' %then %do;
   %end;
 %end;
 %STDDLG_INCLUDED='Y';
 %if INCL_WINSTDDLGS='Y' %then %do;
   %INCL_WINSTDFILE='Y';
   %INCL_WINSTDFONT='Y';
   %INCL_WINSTDSPIN='Y';
   %INCL_WINSTDDRAG='Y';
   %INCL_WINSTDCNR='Y';
   %INCL_WINSTDSLIDER='Y';
   %INCL_WINSTDVALSET='Y';
   %INCL_WINSTDBOOK='Y';
 %end;
 %if INCL_WINSTDCNR='Y' | INCL_WINSTDVALSET='Y' %then %do;
   %INCL_WINSTDDRAG='Y';
 %end;
 %if INCL_WINSTDFILE_INCLUDED='Y' & INCL_WINSTDFILE='Y' %then %do;
   %INCL_WINSTDFILE_INCLUDED='Y';
   declare FDS_CENTER fixed bin(31) value('00_00_00_01'xn);
   declare FDS_CUSTOM fixed bin(31) value('00_00_00_02'xn);
   declare FDS_FILTERUNION fixed bin(31) value('00_00_00_04'xn);
   declare FDS_HELPBUTTON fixed bin(31) value('00_00_00_08'xn);
   declare FDS_APPLYBUTTON fixed bin(31) value('00_00_00_10'xn);
   declare FDS_PRELOAD_VOLINFO fixed bin(31) value('00_00_00_20'xn);
   declare FDS_MODELESS fixed bin(31) value('00_00_00_40'xn);
   declare FDS_INCLUDE_EAS fixed bin(31) value('00_00_00_80'xn);
   declare FDS_OPEN_DIALOG fixed bin(31) value('00_00_01_00'xn);
   declare FDS_SAVEAS_DIALOG fixed bin(31) value('00_00_02_00'xn);
   declare FDS_MULTIPLESEL fixed bin(31) value('00_00_04_00'xn);
   declare FDS_ENABLEFILELB fixed bin(31) value('00_00_08_00'xn);
   %declare FDS_EFSELECTION char;
   %FDS_EFSELECTION=0;
   %declare FDS_LBSELECTION char;
   %FDS_LBSELECTION=1;
   %declare FDS_SUCCESSFUL char;
   %FDS_SUCCESSFUL=0;
   %declare FDS_ERR_DEALLOCATE_MEMORY char;
   %FDS_ERR_DEALLOCATE_MEMORY=1;
   %declare FDS_ERR_FILTER_TRUNC char;
   %FDS_ERR_FILTER_TRUNC=2;
   %declare FDS_ERR_INVALID_DIALOG char;
   %FDS_ERR_INVALID_DIALOG=3;
   %declare FDS_ERR_INVALID_DRIVE char;
   %FDS_ERR_INVALID_DRIVE=4;
   %declare FDS_ERR_INVALID_FILTER char;
   %FDS_ERR_INVALID_FILTER=5;
   %declare FDS_ERR_INVALID_PATHFILE char;
   %FDS_ERR_INVALID_PATHFILE=6;
   %declare FDS_ERR_OUT_OF_MEMORY char;
   %FDS_ERR_OUT_OF_MEMORY=7;
   %declare FDS_ERR_PATH_TOO_LONG char;
   %FDS_ERR_PATH_TOO_LONG=8;
   %declare FDS_ERR_TOO_MANY_FILE_TYPES char;
   %FDS_ERR_TOO_MANY_FILE_TYPES=9;
   %declare FDS_ERR_INVALID_VERSION char;
   %FDS_ERR_INVALID_VERSION=10;
   %declare FDS_ERR_INVALID_CUSTOM_HANDLE char;
   %FDS_ERR_INVALID_CUSTOM_HANDLE=11;
   %declare FDS_ERR_DIALOG_LOAD_ERROR char;
   %FDS_ERR_DIALOG_LOAD_ERROR=12;
   %declare FDS_ERR_DRIVE_ERROR char;
   %FDS_ERR_DRIVE_ERROR=13;
   declare FDM_FILTER fixed bin(16) value('10_28'xn);
   declare FDM_VALIDATE fixed bin(16) value('10_29'xn);
   declare FDM_ERROR fixed bin(16) value('10_2A'xn);
   %declare APSZ(1) char;
   %APSZ(1)=PSZ;
   %declare PAPSZ char;
   %PAPSZ='pointer';
   %declare FILEDLG char;
   %FILEDLG='char(stg(#FILEDLG))';
   dcl 1 #FILEDLG based(null()) unaligned,
         2 cbSize ULONG,
         2 fl ULONG,
         2 ulUser ULONG,
         2 lReturn LONG,
         2 lSRC LONG,
         2 pszTitle PSZ,
         2 pszOKButton PSZ,
         2 pfnDlgProc PFNWP,
         2 pszIType PSZ,
         2 papszITypeList PAPSZ,
         2 pszIDrive PSZ,
         2 papszIDriveList PAPSZ,
         2 hMod HMODULE,
         2 szFullFile char(CCHMAXPATH-1) varz,
         2 papszFQFilename PAPSZ,
         2 ulFQFCount ULONG,
         2 usDlgId USHORT,
         2 x SHORT,
         2 y SHORT,
         2 sEAType SHORT;
   %declare PFILEDLG char;
   %PFILEDLG='pointer';
   dcl WinFileDlg entry (
          HWND,
          HWND,
          PFILEDLG)
          returns(optional byvalue HWND)
          APIENTRY;
   dcl WinDefFileDlgProc entry (
          HWND,
          ULONG,
          MPARAM,
          MPARAM)
          returns(optional byvalue MRESULT)
          APIENTRY;
   dcl WinFreeFileDlgList entry (
          PAPSZ)
          returns(optional byvalue BOOL)
          APIENTRY;
   %declare DID_FILE_DIALOG char;
   %DID_FILE_DIALOG=256;
   %declare DID_FILENAME_TXT char;
   %DID_FILENAME_TXT=257;
   %declare DID_FILENAME_ED char;
   %DID_FILENAME_ED=258;
   %declare DID_DRIVE_TXT char;
   %DID_DRIVE_TXT=259;
   %declare DID_DRIVE_CB char;
   %DID_DRIVE_CB=260;
   %declare DID_FILTER_TXT char;
   %DID_FILTER_TXT=261;
   %declare DID_FILTER_CB char;
   %DID_FILTER_CB=262;
   %declare DID_DIRECTORY_TXT char;
   %DID_DIRECTORY_TXT=263;
   %declare DID_DIRECTORY_LB char;
   %DID_DIRECTORY_LB=264;
   %declare DID_FILES_TXT char;
   %DID_FILES_TXT=265;
   %declare DID_FILES_LB char;
   %DID_FILES_LB=266;
   %declare DID_HELP_PB char;
   %DID_HELP_PB=267;
   %declare DID_APPLY_PB char;
   %DID_APPLY_PB=268;
   %declare DID_OK_PB char;
   %DID_OK_PB=DID_OK;
   %declare DID_CANCEL_PB char;
   %DID_CANCEL_PB=DID_CANCEL;
   %declare IDS_FILE_ALL_FILES_SELECTOR char;
   %IDS_FILE_ALL_FILES_SELECTOR=1000;
   %declare IDS_FILE_BACK_CUR_PATH char;
   %IDS_FILE_BACK_CUR_PATH=1001;
   %declare IDS_FILE_BACK_PREV_PATH char;
   %IDS_FILE_BACK_PREV_PATH=1002;
   %declare IDS_FILE_BACK_SLASH char;
   %IDS_FILE_BACK_SLASH=1003;
   %declare IDS_FILE_BASE_FILTER char;
   %IDS_FILE_BASE_FILTER=1004;
   %declare IDS_FILE_BLANK char;
   %IDS_FILE_BLANK=1005;
   %declare IDS_FILE_COLON char;
   %IDS_FILE_COLON=1006;
   %declare IDS_FILE_DOT char;
   %IDS_FILE_DOT=1007;
   %declare IDS_FILE_DRIVE_LETTERS char;
   %IDS_FILE_DRIVE_LETTERS=1008;
   %declare IDS_FILE_FWD_CUR_PATH char;
   %IDS_FILE_FWD_CUR_PATH=1009;
   %declare IDS_FILE_FWD_PREV_PATH char;
   %IDS_FILE_FWD_PREV_PATH=1010;
   %declare IDS_FILE_FORWARD_SLASH char;
   %IDS_FILE_FORWARD_SLASH=1011;
   %declare IDS_FILE_PARENT_DIR char;
   %IDS_FILE_PARENT_DIR=1012;
   %declare IDS_FILE_Q_MARK char;
   %IDS_FILE_Q_MARK=1013;
   %declare IDS_FILE_SPLAT char;
   %IDS_FILE_SPLAT=1014;
   %declare IDS_FILE_SPLAT_DOT char;
   %IDS_FILE_SPLAT_DOT=1015;
   %declare IDS_FILE_SAVEAS_TITLE char;
   %IDS_FILE_SAVEAS_TITLE=1016;
   %declare IDS_FILE_SAVEAS_FILTER_TXT char;
   %IDS_FILE_SAVEAS_FILTER_TXT=1017;
   %declare IDS_FILE_SAVEAS_FILENM_TXT char;
   %IDS_FILE_SAVEAS_FILENM_TXT=1018;
   %declare IDS_FILE_DUMMY_FILE_NAME char;
   %IDS_FILE_DUMMY_FILE_NAME=1019;
   %declare IDS_FILE_DUMMY_FILE_EXT char;
   %IDS_FILE_DUMMY_FILE_EXT=1020;
   %declare IDS_FILE_DUMMY_DRIVE char;
   %IDS_FILE_DUMMY_DRIVE=1021;
   %declare IDS_FILE_DUMMY_ROOT_DIR char;
   %IDS_FILE_DUMMY_ROOT_DIR=1022;
   %declare IDS_FILE_PATH_PTR char;
   %IDS_FILE_PATH_PTR=1023;
   %declare IDS_FILE_VOLUME_PREFIX char;
   %IDS_FILE_VOLUME_PREFIX=1024;
   %declare IDS_FILE_VOLUME_SUFFIX char;
   %IDS_FILE_VOLUME_SUFFIX=1025;
   %declare IDS_FILE_PATH_PTR2 char;
   %IDS_FILE_PATH_PTR2=1026;
   %declare IDS_FILE_INVALID_CHARS char;
   %IDS_FILE_INVALID_CHARS=1027;
   %declare IDS_FILE_BAD_DRIVE_NAME char;
   %IDS_FILE_BAD_DRIVE_NAME=1100;
   %declare IDS_FILE_BAD_DRIVE_OR_PATH_NAME char;
   %IDS_FILE_BAD_DRIVE_OR_PATH_NAME=1101;
   %declare IDS_FILE_BAD_FILE_NAME char;
   %IDS_FILE_BAD_FILE_NAME=1102;
   %declare IDS_FILE_BAD_FQF char;
   %IDS_FILE_BAD_FQF=1103;
   %declare IDS_FILE_BAD_NETWORK_NAME char;
   %IDS_FILE_BAD_NETWORK_NAME=1104;
   %declare IDS_FILE_BAD_SUB_DIR_NAME char;
   %IDS_FILE_BAD_SUB_DIR_NAME=1105;
   %declare IDS_FILE_DRIVE_NOT_AVAILABLE char;
   %IDS_FILE_DRIVE_NOT_AVAILABLE=1106;
   %declare IDS_FILE_FQFNAME_TOO_LONG char;
   %IDS_FILE_FQFNAME_TOO_LONG=1107;
   %declare IDS_FILE_OPEN_DIALOG_NOTE char;
   %IDS_FILE_OPEN_DIALOG_NOTE=1108;
   %declare IDS_FILE_PATH_TOO_LONG char;
   %IDS_FILE_PATH_TOO_LONG=1109;
   %declare IDS_FILE_SAVEAS_DIALOG_NOTE char;
   %IDS_FILE_SAVEAS_DIALOG_NOTE=1110;
   %declare IDS_FILE_DRIVE_DISK_CHANGE char;
   %IDS_FILE_DRIVE_DISK_CHANGE=1120;
   %declare IDS_FILE_DRIVE_NOT_READY char;
   %IDS_FILE_DRIVE_NOT_READY=1122;
   %declare IDS_FILE_DRIVE_LOCKED char;
   %IDS_FILE_DRIVE_LOCKED=1123;
   %declare IDS_FILE_DRIVE_NO_SECTOR char;
   %IDS_FILE_DRIVE_NO_SECTOR=1124;
   %declare IDS_FILE_DRIVE_SOME_ERROR char;
   %IDS_FILE_DRIVE_SOME_ERROR=1125;
   %declare IDS_FILE_DRIVE_INVALID char;
   %IDS_FILE_DRIVE_INVALID=1126;
   %declare IDS_FILE_INSERT_DISK_NOTE char;
   %IDS_FILE_INSERT_DISK_NOTE=1127;
   %declare IDS_FILE_OK_WHEN_READY char;
   %IDS_FILE_OK_WHEN_READY=1128;
 %end;
 %if INCL_WINSTDFONT_INCLUDED='Y' & INCL_WINSTDFONT='Y' %then %do;
   %INCL_WINSTDFONT_INCLUDED='Y';
   %declare FONTDLG char;
   %FONTDLG='char(stg(#FONTDLG))';
   dcl 1 #FONTDLG based(null()) unaligned,
         2 cbSize ULONG,
         2 hpsScreen HPS,
         2 hpsPrinter HPS,
         2 pszTitle PSZ,
         2 pszPreview PSZ,
         2 pszPtSizeList PSZ,
         2 pfnDlgProc PFNWP,
         2 pszFamilyname PSZ,
         2 fxPointSize FIXED bin(31,16),
         2 fl ULONG,
         2 flFlags ULONG,
         2 flType ULONG,
         2 flTypeMask ULONG,
         2 flStyle ULONG,
         2 flStyleMask ULONG,
         2 clrFore LONG,
         2 clrBack LONG,
         2 ulUser ULONG,
         2 lReturn LONG,
         2 lSRC LONG,
         2 lEmHeight LONG,
         2 lXHeight LONG,
         2 lExternalLeading LONG,
         2 hMod HMODULE,
         2 fAttrs FATTRIBS,
         2 sNominalPointSize SHORT,
         2 usWeight USHORT,
         2 usWidth USHORT,
         2 x SHORT,
         2 y SHORT,
         2 usDlgId USHORT,
         2 usFamilyBufLen USHORT,
         2 usReserved USHORT;
   %declare PFONTDLG char;
   %PFONTDLG='pointer';
   declare FNTS_CENTER fixed bin(31) value('00_00_00_01'xn);
   declare FNTS_CUSTOM fixed bin(31) value('00_00_00_02'xn);
   declare FNTS_OWNERDRAWPREVIEW fixed bin(31) value('00_00_00_04'xn);
   declare FNTS_HELPBUTTON fixed bin(31) value('00_00_00_08'xn);
   declare FNTS_APPLYBUTTON fixed bin(31) value('00_00_00_10'xn);
   declare FNTS_RESETBUTTON fixed bin(31) value('00_00_00_20'xn);
   declare FNTS_MODELESS fixed bin(31) value('00_00_00_40'xn);
   declare FNTS_INITFROMFATTRS fixed bin(31) value('00_00_00_80'xn);
   declare FNTS_BITMAPONLY fixed bin(31) value('00_00_01_00'xn);
   declare FNTS_VECTORONLY fixed bin(31) value('00_00_02_00'xn);
   declare FNTS_FIXEDWIDTHONLY fixed bin(31) value('00_00_04_00'xn);
   declare FNTS_PROPORTIONALONLY fixed bin(31) value('00_00_08_00'xn);
   declare FNTS_NOSYNTHESIZEDFONTS fixed bin(31) value('00_00_10_00'xn);
   %declare FNTF_NOVIEWSCREENFONTS char;
   %FNTF_NOVIEWSCREENFONTS=1;
   %declare FNTF_NOVIEWPRINTERFONTS char;
   %FNTF_NOVIEWPRINTERFONTS=2;
   %declare FNTF_SCREENFONTSELECTED char;
   %FNTF_SCREENFONTSELECTED=4;
   %declare FNTF_PRINTERFONTSELECTED char;
   %FNTF_PRINTERFONTSELECTED=8;
   %declare CLRC_FOREGROUND char;
   %CLRC_FOREGROUND=1;
   %declare CLRC_BACKGROUND char;
   %CLRC_BACKGROUND=2;
   declare FNTI_BITMAPFONT fixed bin(16) value('00_01'xn);
   declare FNTI_VECTORFONT fixed bin(16) value('00_02'xn);
   declare FNTI_FIXEDWIDTHFONT fixed bin(16) value('00_04'xn);
   declare FNTI_PROPORTIONALFONT fixed bin(16) value('00_08'xn);
   declare FNTI_SYNTHESIZED fixed bin(16) value('00_10'xn);
   declare FNTI_DEFAULTLIST fixed bin(16) value('00_20'xn);
   declare FNTI_FAMILYNAME fixed bin(16) value('01_00'xn);
   declare FNTI_STYLENAME fixed bin(16) value('02_00'xn);
   declare FNTI_POINTSIZE fixed bin(16) value('04_00'xn);
   %declare FNTS_SUCCESSFUL char;
   %FNTS_SUCCESSFUL=0;
   %declare FNTS_ERR_INVALID_DIALOG char;
   %FNTS_ERR_INVALID_DIALOG=3;
   %declare FNTS_ERR_ALLOC_SHARED_MEM char;
   %FNTS_ERR_ALLOC_SHARED_MEM=4;
   %declare FNTS_ERR_INVALID_PARM char;
   %FNTS_ERR_INVALID_PARM=5;
   %declare FNTS_ERR_OUT_OF_MEMORY char;
   %FNTS_ERR_OUT_OF_MEMORY=7;
   %declare FNTS_ERR_INVALID_VERSION char;
   %FNTS_ERR_INVALID_VERSION=10;
   %declare FNTS_ERR_DIALOG_LOAD_ERROR char;
   %FNTS_ERR_DIALOG_LOAD_ERROR=12;
   declare FNTM_FACENAMECHANGED fixed bin(16) value('10_32'xn);
   declare FNTM_POINTSIZECHANGED fixed bin(16) value('10_33'xn);
   declare FNTM_STYLECHANGED fixed bin(16) value('10_34'xn);
   declare FNTM_COLORCHANGED fixed bin(16) value('10_35'xn);
   declare FNTM_UPDATEPREVIEW fixed bin(16) value('10_36'xn);
   declare FNTM_FILTERLIST fixed bin(16) value('10_37'xn);
   %declare STYLECHANGE char;
   %STYLECHANGE='char(stg(#STYLECHANGE))';
   dcl 1 #STYLECHANGE based(null()) unaligned,
         2 usWeight USHORT,
         2 usWeightOld USHORT,
         2 usWidth USHORT,
         2 usWidthOld USHORT,
         2 flType ULONG,
         2 flTypeOld ULONG,
         2 flTypeMask ULONG,
         2 flTypeMaskOld ULONG,
         2 flStyle ULONG,
         2 flStyleOld ULONG,
         2 flStyleMask ULONG,
         2 flStyleMaskOld ULONG;
   %declare PSTYLECHANGE char;
   %PSTYLECHANGE='pointer';
   dcl WinFontDlg entry (
          HWND,
          HWND,
          PFONTDLG)
          returns(optional byvalue HWND)
          APIENTRY;
   dcl WinDefFontDlgProc entry (
          HWND,
          ULONG,
          MPARAM,
          MPARAM)
          returns(optional byvalue MRESULT)
          APIENTRY;
   %declare DID_FONT_DIALOG char;
   %DID_FONT_DIALOG=300;
   %declare DID_NAME char;
   %DID_NAME=301;
   %declare DID_STYLE char;
   %DID_STYLE=302;
   %declare DID_DISPLAY_FILTER char;
   %DID_DISPLAY_FILTER=303;
   %declare DID_PRINTER_FILTER char;
   %DID_PRINTER_FILTER=304;
   %declare DID_SIZE char;
   %DID_SIZE=305;
   %declare DID_SAMPLE char;
   %DID_SAMPLE=306;
   %declare DID_OUTLINE char;
   %DID_OUTLINE=307;
   %declare DID_UNDERSCORE char;
   %DID_UNDERSCORE=308;
   %declare DID_STRIKEOUT char;
   %DID_STRIKEOUT=309;
   %declare DID_HELP_BUTTON char;
   %DID_HELP_BUTTON=310;
   %declare DID_APPLY_BUTTON char;
   %DID_APPLY_BUTTON=311;
   %declare DID_RESET_BUTTON char;
   %DID_RESET_BUTTON=312;
   %declare DID_OK_BUTTON char;
   %DID_OK_BUTTON=DID_OK;
   %declare DID_CANCEL_BUTTON char;
   %DID_CANCEL_BUTTON=DID_CANCEL;
   %declare DID_NAME_PREFIX char;
   %DID_NAME_PREFIX=313;
   %declare DID_STYLE_PREFIX char;
   %DID_STYLE_PREFIX=314;
   %declare DID_SIZE_PREFIX char;
   %DID_SIZE_PREFIX=315;
   %declare DID_SAMPLE_GROUPBOX char;
   %DID_SAMPLE_GROUPBOX=316;
   %declare DID_EMPHASIS_GROUPBOX char;
   %DID_EMPHASIS_GROUPBOX=317;
   %declare DID_FONT_ISO_SUPPORT char;
   %DID_FONT_ISO_SUPPORT=318;
   %declare DID_FONT_ISO_UNTESTED char;
   %DID_FONT_ISO_UNTESTED=319;
   %declare IDS_FONT_SAMPLE char;
   %IDS_FONT_SAMPLE=350;
   %declare IDS_FONT_BLANK char;
   %IDS_FONT_BLANK=351;
   %declare IDS_FONT_KEY_0 char;
   %IDS_FONT_KEY_0=352;
   %declare IDS_FONT_KEY_9 char;
   %IDS_FONT_KEY_9=353;
   %declare IDS_FONT_KEY_SEP char;
   %IDS_FONT_KEY_SEP=354;
   %declare IDS_FONT_DISP_ONLY char;
   %IDS_FONT_DISP_ONLY=355;
   %declare IDS_FONT_PRINTER_ONLY char;
   %IDS_FONT_PRINTER_ONLY=356;
   %declare IDS_FONT_COMBINED char;
   %IDS_FONT_COMBINED=357;
   %declare IDS_FONT_WEIGHT1 char;
   %IDS_FONT_WEIGHT1=358;
   %declare IDS_FONT_WEIGHT2 char;
   %IDS_FONT_WEIGHT2=359;
   %declare IDS_FONT_WEIGHT3 char;
   %IDS_FONT_WEIGHT3=360;
   %declare IDS_FONT_WEIGHT4 char;
   %IDS_FONT_WEIGHT4=361;
   %declare IDS_FONT_WEIGHT5 char;
   %IDS_FONT_WEIGHT5=362;
   %declare IDS_FONT_WEIGHT6 char;
   %IDS_FONT_WEIGHT6=363;
   %declare IDS_FONT_WEIGHT7 char;
   %IDS_FONT_WEIGHT7=364;
   %declare IDS_FONT_WEIGHT8 char;
   %IDS_FONT_WEIGHT8=365;
   %declare IDS_FONT_WEIGHT9 char;
   %IDS_FONT_WEIGHT9=366;
   %declare IDS_FONT_WIDTH1 char;
   %IDS_FONT_WIDTH1=367;
   %declare IDS_FONT_WIDTH2 char;
   %IDS_FONT_WIDTH2=368;
   %declare IDS_FONT_WIDTH3 char;
   %IDS_FONT_WIDTH3=369;
   %declare IDS_FONT_WIDTH4 char;
   %IDS_FONT_WIDTH4=370;
   %declare IDS_FONT_WIDTH5 char;
   %IDS_FONT_WIDTH5=371;
   %declare IDS_FONT_WIDTH6 char;
   %IDS_FONT_WIDTH6=372;
   %declare IDS_FONT_WIDTH7 char;
   %IDS_FONT_WIDTH7=373;
   %declare IDS_FONT_WIDTH8 char;
   %IDS_FONT_WIDTH8=374;
   %declare IDS_FONT_WIDTH9 char;
   %IDS_FONT_WIDTH9=375;
   %declare IDS_FONT_OPTION0 char;
   %IDS_FONT_OPTION0=376;
   %declare IDS_FONT_OPTION1 char;
   %IDS_FONT_OPTION1=377;
   %declare IDS_FONT_OPTION2 char;
   %IDS_FONT_OPTION2=378;
   %declare IDS_FONT_OPTION3 char;
   %IDS_FONT_OPTION3=379;
   %declare IDS_FONT_POINT_SIZE_LIST char;
   %IDS_FONT_POINT_SIZE_LIST=380;
 %end;
 %if INCL_WINSTDSPIN_INCLUDED='Y' & INCL_WINSTDSPIN='Y' %then %do;
   %INCL_WINSTDSPIN_INCLUDED='Y';
   declare SPBS_ALLCHARACTERS fixed bin(31) value('00_00_00_00'xn);
   declare SPBS_NUMERICONLY fixed bin(31) value('00_00_00_01'xn);
   declare SPBS_READONLY fixed bin(31) value('00_00_00_02'xn);
   declare SPBS_MASTER fixed bin(31) value('00_00_00_10'xn);
   declare SPBS_SERVANT fixed bin(31) value('00_00_00_00'xn);
   declare SPBS_JUSTDEFAULT fixed bin(31) value('00_00_00_00'xn);
   declare SPBS_JUSTLEFT fixed bin(31) value('00_00_00_08'xn);
   declare SPBS_JUSTRIGHT fixed bin(31) value('00_00_00_04'xn);
   declare SPBS_JUSTCENTER fixed bin(31) value('00_00_00_0C'xn);
   declare SPBS_NOBORDER fixed bin(31) value('00_00_00_20'xn);
   declare SPBS_FASTSPIN fixed bin(31) value('00_00_01_00'xn);
   declare SPBS_PADWITHZEROS fixed bin(31) value('00_00_00_80'xn);
   declare SPBN_UPARROW fixed bin(16) value('02_0A'xn);
   declare SPBN_DOWNARROW fixed bin(16) value('02_0B'xn);
   declare SPBN_ENDSPIN fixed bin(16) value('02_0C'xn);
   declare SPBN_CHANGE fixed bin(16) value('02_0D'xn);
   declare SPBN_SETFOCUS fixed bin(16) value('02_0E'xn);
   declare SPBN_KILLFOCUS fixed bin(16) value('02_0F'xn);
   declare SPBM_OVERRIDESETLIMITS fixed bin(16) value('02_00'xn);
   declare SPBM_QUERYLIMITS fixed bin(16) value('02_01'xn);
   declare SPBM_SETTEXTLIMIT fixed bin(16) value('02_02'xn);
   declare SPBM_SPINUP fixed bin(16) value('02_03'xn);
   declare SPBM_SPINDOWN fixed bin(16) value('02_04'xn);
   declare SPBM_QUERYVALUE fixed bin(16) value('02_05'xn);
   %declare SPBQ_UPDATEIFVALID char;
   %SPBQ_UPDATEIFVALID=0;
   %declare SPBQ_ALWAYSUPDATE char;
   %SPBQ_ALWAYSUPDATE=1;
   %declare SPBQ_DONOTUPDATE char;
   %SPBQ_DONOTUPDATE=3;
   declare SPBM_SETARRAY fixed bin(16) value('02_06'xn);
   declare SPBM_SETLIMITS fixed bin(16) value('02_07'xn);
   declare SPBM_SETCURRENTVALUE fixed bin(16) value('02_08'xn);
   declare SPBM_SETMASTER fixed bin(16) value('02_09'xn);
 %end;
 %if INCL_WINSTDDRAG_INCLUDED='Y' & INCL_WINSTDDRAG='Y' %then %do;
   %INCL_WINSTDDRAG_INCLUDED='Y';
   declare PMERR_NOT_DRAGGING fixed bin(16) value('01_F0'xn);
   declare PMERR_ALREADY_DRAGGING fixed bin(16) value('01_F1'xn);
   declare MSGF_DRAG fixed bin(16) value('00_10'xn);
   declare WM_DRAGFIRST fixed bin(16) value('03_10'xn);
   declare WM_DRAGLAST fixed bin(16) value('03_2F'xn);
   declare DM_DROP fixed bin(16) value('03_2F'xn);
   declare DM_DRAGOVER fixed bin(16) value('03_2E'xn);
   declare DM_DRAGLEAVE fixed bin(16) value('03_2D'xn);
   declare DM_DROPHELP fixed bin(16) value('03_2C'xn);
   declare DM_ENDCONVERSATION fixed bin(16) value('03_2B'xn);
   declare DM_PRINT fixed bin(16) value('03_2A'xn);
   declare DM_RENDER fixed bin(16) value('03_29'xn);
   declare DM_RENDERCOMPLETE fixed bin(16) value('03_28'xn);
   declare DM_RENDERPREPARE fixed bin(16) value('03_27'xn);
   declare DM_DRAGFILECOMPLETE fixed bin(16) value('03_26'xn);
   declare DM_EMPHASIZETARGET fixed bin(16) value('03_25'xn);
   declare DM_DRAGERROR fixed bin(16) value('03_24'xn);
   declare DM_FILERENDERED fixed bin(16) value('03_23'xn);
   declare DM_RENDERFILE fixed bin(16) value('03_22'xn);
   declare DM_DRAGOVERNOTIFY fixed bin(16) value('03_21'xn);
   declare DM_PRINTOBJECT fixed bin(16) value('03_20'xn);
   declare DM_DISCARDOBJECT fixed bin(16) value('03_1F'xn);
   %declare DRT_ASM char;
   %DRT_ASM='''Assembler Code''';
   %declare DRT_BASIC char;
   %DRT_BASIC='''BASIC Code''';
   %declare DRT_BINDATA char;
   %DRT_BINDATA='''Binary Data''';
   %declare DRT_BITMAP char;
   %DRT_BITMAP='''Bitmap''';
   %declare DRT_C char;
   %DRT_C='''C Code''';
   %declare DRT_COBOL char;
   %DRT_COBOL='''COBOL Code''';
   %declare DRT_DLL char;
   %DRT_DLL='''Dynamic Link Library''';
   %declare DRT_DOSCMD char;
   %DRT_DOSCMD='''DOS Command File''';
   %declare DRT_EXE char;
   %DRT_EXE='''Executable''';
   %declare DRT_FORTRAN char;
   %DRT_FORTRAN='''FORTRAN Code''';
   %declare DRT_ICON char;
   %DRT_ICON='''Icon''';
   %declare DRT_LIB char;
   %DRT_LIB='''Library''';
   %declare DRT_METAFILE char;
   %DRT_METAFILE='''Metafile''';
   %declare DRT_OS2CMD char;
   %DRT_OS2CMD='''OS/2 Command File''';
   %declare DRT_PASCAL char;
   %DRT_PASCAL='''Pascal Code''';
   %declare DRT_RESOURCE char;
   %DRT_RESOURCE='''Resource File''';
   %declare DRT_TEXT char;
   %DRT_TEXT='''Plain Text''';
   %declare DRT_UNKNOWN char;
   %DRT_UNKNOWN='''Unknown''';
   declare DOR_NODROP fixed bin(16) value('00_00'xn);
   declare DOR_DROP fixed bin(16) value('00_01'xn);
   declare DOR_NODROPOP fixed bin(16) value('00_02'xn);
   declare DOR_NEVERDROP fixed bin(16) value('00_03'xn);
   declare DO_COPYABLE fixed bin(16) value('00_01'xn);
   declare DO_MOVEABLE fixed bin(16) value('00_02'xn);
   declare DO_LINKABLE fixed bin(16) value('00_04'xn);
   declare DC_OPEN fixed bin(16) value('00_01'xn);
   declare DC_REF fixed bin(16) value('00_02'xn);
   declare DC_GROUP fixed bin(16) value('00_04'xn);
   declare DC_CONTAINER fixed bin(16) value('00_08'xn);
   declare DC_PREPARE fixed bin(16) value('00_10'xn);
   declare DC_REMOVEABLEMEDIA fixed bin(16) value('00_20'xn);
   declare DO_DEFAULT fixed bin(16) value('BF_FE'xn);
   declare DO_UNKNOWN fixed bin(16) value('BF_FF'xn);
   declare DO_COPY fixed bin(16) value('00_10'xn);
   declare DO_MOVE fixed bin(16) value('00_20'xn);
   declare DO_LINK fixed bin(16) value('00_18'xn);
   declare DO_CREATE fixed bin(16) value('00_40'xn);
   declare DMFL_TARGETSUCCESSFUL fixed bin(16) value('00_01'xn);
   declare DMFL_TARGETFAIL fixed bin(16) value('00_02'xn);
   declare DMFL_NATIVERENDER fixed bin(16) value('00_04'xn);
   declare DMFL_RENDERRETRY fixed bin(16) value('00_08'xn);
   declare DMFL_RENDEROK fixed bin(16) value('00_10'xn);
   declare DMFL_RENDERFAIL fixed bin(16) value('00_20'xn);
   declare DRG_ICON fixed bin(31) value('00_00_00_01'xn);
   declare DRG_BITMAP bin(31) value('00_00_00_02'xn);
   declare DRG_POLYGON bin(31) value('00_00_00_04'xn);
   declare DRG_STRETCH bin(31) value('00_00_00_08'xn);
   declare DRG_TRANSPARENT bin(31) value('00_00_00_10'xn);
   declare DRG_CLOSED bin(31) value('00_00_00_20'xn);
   %declare DME_IGNOREABORT char;
   %DME_IGNOREABORT=1;
   %declare DME_IGNORECONTINUE char;
   %DME_IGNORECONTINUE=2;
   %declare DME_REPLACE char;
   %DME_REPLACE=3;
   %declare DME_RETRY char;
   %DME_RETRY=4;
   declare DF_MOVE bin(16) value('00_01'xn);
   declare DF_SOURCE bin(16) value('00_02'xn);
   declare DF_SUCCESSFUL bin(16) value('00_04'xn);
   %declare DRR_SOURCE char;
   %DRR_SOURCE=1;
   %declare DRR_TARGET char;
   %DRR_TARGET=2;
   %declare DRR_ABORT char;
   %DRR_ABORT=3;
   %declare DFF_MOVE char;
   %DFF_MOVE=1;
   %declare DFF_COPY char;
   %DFF_COPY=2;
   %declare DFF_DELETE char;
   %DFF_DELETE=3;
   %declare HSTR char;
   %HSTR=LHANDLE;
   %declare DRAGITEM char;
   %DRAGITEM='char(stg(#DRAGITEM))';
   dcl 1 #DRAGITEM based(null()) unaligned,
         2 hwndItem HWND,
         2 ulItemID ULONG,
         2 hstrType HSTR,
         2 hstrRMF HSTR,
         2 hstrContainerName HSTR,
         2 hstrSourceName HSTR,
         2 hstrTargetName HSTR,
         2 cxOffset SHORT,
         2 cyOffset SHORT,
         2 fsControl USHORT,
         2 fsSupportedOps USHORT;
   %declare PDRAGITEM char;
   %PDRAGITEM='pointer';
   %declare DRAGINFO char;
   %DRAGINFO='char(stg(#DRAGINFO))';
   dcl 1 #DRAGINFO based(null()) unaligned,
         2 cbDraginfo ULONG,
         2 cbDragitem USHORT,
         2 usOperation USHORT,
         2 hwndSource HWND,
         2 xDrop SHORT,
         2 yDrop SHORT,
         2 cditem USHORT,
         2 usReserved USHORT;
   %declare PDRAGINFO char;
   %PDRAGINFO='pointer';
   %declare DRAGIMAGE char;
   %DRAGIMAGE='char(stg(#DRAGIMAGE))';
   dcl 1 #DRAGIMAGE based(null()) unaligned,
         2 cb USHORT,
         2 cptl USHORT,
         2 hImage LHANDLE,
         2 sizlStretch SIZEL,
         2 fl ULONG,
         2 cxOffset SHORT,
         2 cyOffset SHORT;
   %declare PDRAGIMAGE char;
   %PDRAGIMAGE='pointer';
   %declare DRAGTRANSFER char;
   %DRAGTRANSFER='char(stg(#DRAGTRANSFER))';
   dcl 1 #DRAGTRANSFER based(null()) unaligned,
         2 cb ULONG,
         2 hwndClient HWND,
         2 pditem PDRAGITEM,
         2 hstrSelectedRMF HSTR,
         2 hstrRenderToName HSTR,
         2 ulTargetInfo ULONG,
         2 usOperation USHORT,
         2 fsReply USHORT;
   %declare PDRAGTRANSFER char;
   %PDRAGTRANSFER='pointer';
   %declare RENDERFILE char;
   %RENDERFILE='char(stg(#RENDERFILE))';
   dcl 1 #RENDERFILE based(null()) unaligned,
         2 hwndDragFiles HWND,
         2 hstrSource HSTR,
         2 hstrTarget HSTR,
         2 fMove USHORT,
         2 usRsvd USHORT;
   %declare PRENDERFILE char;
   %PRENDERFILE='pointer';
   dcl DrgAcceptDroppedFiles entry (
          HWND,
          PSZ,
          PSZ,
          ULONG,
          ULONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl DrgAllocDraginfo entry (
          ULONG)
          returns(optional byvalue PDRAGINFO)
          APIENTRY;
   dcl DrgAllocDragtransfer entry (
          ULONG)
          returns(optional byvalue PDRAGTRANSFER)
          APIENTRY;
   dcl DrgDrag entry (
          HWND,
          PDRAGINFO,
          PDRAGIMAGE,
          ULONG,
          LONG,
          PVOID)
          returns(optional byvalue HWND)
          APIENTRY;
   dcl DrgDragFiles entry (
          HWND,
          PSZ,
          PSZ,
          PSZ,
          ULONG,
          HPOINTER,
          ULONG,
          BOOL,
          ULONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl DrgPostTransferMsg entry (
          HWND,
          ULONG,
          PDRAGTRANSFER,
          ULONG,
          ULONG,
          BOOL)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl DrgQueryDragitem entry (
          PDRAGINFO,
          ULONG,
          PDRAGITEM,
          ULONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl DrgQueryDragitemCount entry (
          PDRAGINFO)
          returns(optional byvalue ULONG)
          APIENTRY;
   dcl DrgQueryDragitemPtr entry (
          PDRAGINFO,
          ULONG)
          returns(optional byvalue PDRAGITEM)
          APIENTRY;
   dcl DrgQueryNativeRMF entry (
          PDRAGITEM,
          ULONG,
          PCHAR)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl DrgQueryNativeRMFLen entry (
          PDRAGITEM)
          returns(optional byvalue ULONG)
          APIENTRY;
   dcl DrgQueryStrName entry (
          HSTR,
          ULONG,
          PSZ)
          returns(optional byvalue ULONG)
          APIENTRY;
   dcl DrgQueryStrNameLen entry (
          HSTR)
          returns(optional byvalue ULONG)
          APIENTRY;
   dcl DrgQueryTrueType entry (
          PDRAGITEM,
          ULONG,
          PSZ)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl DrgQueryTrueTypeLen entry (
          PDRAGITEM)
          returns(optional byvalue ULONG)
          APIENTRY;
   dcl DrgSendTransferMsg entry (
          HWND,
          ULONG,
          MPARAM,
          MPARAM)
          returns(optional byvalue MRESULT)
          APIENTRY;
   dcl DrgSetDragitem entry (
          PDRAGINFO,
          PDRAGITEM,
          ULONG,
          ULONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl DrgSetDragImage entry (
          PDRAGINFO,
          PDRAGIMAGE,
          ULONG,
          PVOID)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl DrgVerifyTypeSet entry (
          PDRAGITEM,
          PSZ,
          ULONG,
          PSZ)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl DrgAccessDraginfo entry (
          PDRAGINFO)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl DrgAddStrHandle entry (
          PSZ)
          returns(optional byvalue HSTR)
          APIENTRY;
   dcl DrgDeleteDraginfoStrHandles entry (
          PDRAGINFO)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl DrgDeleteStrHandle entry (
          HSTR)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl DrgFreeDraginfo entry (
          PDRAGINFO)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl DrgFreeDragtransfer entry (
          PDRAGTRANSFER)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl DrgGetPS entry (
          HWND)
          returns(optional byvalue HPS)
          APIENTRY;
   dcl DrgPushDraginfo entry (
          PDRAGINFO,
          HWND)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl DrgReleasePS entry (
          HPS)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl DrgSetDragPointer entry (
          PDRAGINFO,
          HPOINTER)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl DrgVerifyNativeRMF entry (
          PDRAGITEM,
          PSZ)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl DrgVerifyRMF entry (
          PDRAGITEM,
          PSZ,
          PSZ)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl DrgVerifyTrueType entry (
          PDRAGITEM,
          PSZ)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl DrgVerifyType entry (
          PDRAGITEM,
          PSZ)
          returns(optional byvalue BOOL)
          APIENTRY;
 %end;
 %if INCL_WINSTDCNR_INCLUDED='Y' & INCL_WINSTDCNR='Y' %then %do;
 %INCL_WINSTDCNR_INCLUDED='Y';

   /*******************************************************************/
   /*                                                                 */
   /*                         C O N T A I N E R                       */
   /*                                                                 */
   /*******************************************************************/

   declare PMERR_NOFILTERED_ITEMS fixed bin(16) value('1F_02'xn);
   declare PMERR_COMPARISON_FAILED fixed bin(16) value('1F_03'xn);
   declare PMERR_RECORD_CURRENTLY_INSERTED fixed bin(16)
                                           value('1F_04'xn);
   declare PMERR_FI_CURRENTLY_INSERTED fixed bin(16) value('1F_05'xn);
   declare CCS_EXTENDSEL fixed bin(31) value('00_00_00_01'xn);
   declare CCS_MULTIPLESEL fixed bin(31) value('00_00_00_02'xn);
   declare CCS_SINGLESEL fixed bin(31) value('00_00_00_04'xn);
   declare CCS_AUTOPOSITION fixed bin(31) value('00_00_00_08'xn);
   declare CCS_VERIFYPOINTERS fixed bin(31) value('00_00_00_10'xn);
   declare CCS_READONLY fixed bin(31) value('00_00_00_20'xn);
   declare CCS_MINIRECORDCORE fixed bin(31) value('00_00_00_40'xn);
   declare CV_TEXT fixed bin(31) value('00_00_00_01'xn);
   declare CV_NAME fixed bin(31) value('00_00_00_02'xn);
   declare CV_ICON fixed bin(31) value('00_00_00_04'xn);
   declare CV_DETAIL fixed bin(31) value('00_00_00_08'xn);
   declare CV_FLOW fixed bin(31) value('00_00_00_10'xn);
   declare CV_MINI fixed bin(31) value('00_00_00_20'xn);
   declare CV_TREE fixed bin(31) value('00_00_00_40'xn);
   declare CA_CONTAINERTITLE fixed bin(31) value('00_00_02_00'xn);
   declare CA_TITLESEPARATOR fixed bin(31) value('00_00_04_00'xn);
   declare CA_TITLELEFT fixed bin(31) value('00_00_08_00'xn);
   declare CA_TITLERIGHT fixed bin(31) value('00_00_10_00'xn);
   declare CA_TITLECENTER fixed bin(31) value('00_00_20_00'xn);
   declare CA_OWNERDRAW fixed bin(31) value('00_00_40_00'xn);
   declare CA_DETAILSVIEWTITLES fixed bin(31) value('00_00_80_00'xn);
   declare CA_ORDEREDTARGETEMPH fixed bin(31) value('00_01_00_00'xn);
   declare CA_DRAWBITMAP fixed bin(31) value('00_02_00_00'xn);
   declare CA_DRAWICON fixed bin(31) value('00_04_00_00'xn);
   declare CA_TITLEREADONLY fixed bin(31) value('00_08_00_00'xn);
   declare CA_OWNERPAINTBACKGROUND fixed bin(31) value('00_10_00_00'xn);
   declare CA_MIXEDTARGETEMPH fixed bin(31) value('00_20_00_00'xn);
   declare CA_TREELINE fixed bin(31) value('00_40_00_00'xn);
   declare CID_LEFTCOLTITLEWND fixed bin(16) value('7F_F0'xn);
   declare CID_RIGHTCOLTITLEWND fixed bin(16) value('7F_F1'xn);
   declare CID_BLANKBOX fixed bin(16) value('7F_F2'xn);
   declare CID_HSCROLL fixed bin(16) value('7F_F3'xn);
   declare CID_RIGHTHSCROLL fixed bin(16) value('7F_F4'xn);
   declare CID_CNRTITLEWND fixed bin(16) value('7F_F5'xn);
   declare CID_LEFTDVWND fixed bin(16) value('7F_F7'xn);
   declare CID_RIGHTDVWND fixed bin(16) value('7F_F8'xn);
   declare CID_VSCROLL fixed bin(16) value('7F_F9'xn);
   declare CID_MLE fixed bin(16) value('7F_FA'xn);
   %declare TREEITEMDESC char;
   %TREEITEMDESC='char(stg(#TREEITEMDESC))';
   dcl 1 #TREEITEMDESC based(null()) unaligned,
         2 hbmExpanded HBITMAP,
         2 hbmCollapsed HBITMAP,
         2 hptrExpanded HPOINTER,
         2 hptrCollapsed HPOINTER;
   %declare PTREEITEMDESC char;
   %PTREEITEMDESC='pointer';
   %declare FIELDINFO char;
   %FIELDINFO='char(stg(#FIELDINFO))';
   dcl 1 #FIELDINFO based(null()) unaligned,
         2 cb ULONG,
         2 flData ULONG,
         2 flTitle ULONG,
         2 pTitleData PVOID,
         2 offStruct ULONG,
         2 pUserData PVOID,
         2 pNextFieldInfo pointer,
         2 cxWidth ULONG;
   %declare PFIELDINFO char;
   %PFIELDINFO='pointer';
   %declare RECORDCORE char;
   %RECORDCORE='char(stg(#RECORDCORE))';
   dcl 1 #RECORDCORE based(null()) unaligned,
         2 cb ULONG,
         2 flRecordAttr ULONG,
         2 ptlIcon POINTL,
         2 preccNextRecord pointer,
         2 pszIcon PSZ,
         2 hptrIcon HPOINTER,
         2 hptrMiniIcon HPOINTER,
         2 hbmBitmap HBITMAP,
         2 hbmMiniBitmap HBITMAP,
         2 pTreeItemDesc PTREEITEMDESC,
         2 pszText PSZ,
         2 pszName PSZ,
         2 pszTree PSZ;
   %declare PRECORDCORE char;
   %PRECORDCORE='pointer';
   %declare MINIRECORDCORE char;
   %MINIRECORDCORE='char(stg(#MINIRECORDCORE))';
   dcl 1 #MINIRECORDCORE based(null()) unaligned,
         2 cb ULONG,
         2 flRecordAttr ULONG,
         2 ptlIcon POINTL,
         2 preccNextRecord pointer,
         2 pszIcon PSZ,
         2 hptrIcon HPOINTER;
   %declare PMINIRECORDCORE char;
   %PMINIRECORDCORE='pointer';
   %declare CNRINFO char;
   %CNRINFO='char(stg(#CNRINFO))';
   dcl 1 #CNRINFO based(null()) unaligned,
         2 cb ULONG,
         2 pSortRecord PVOID,
         2 pFieldInfoLast PFIELDINFO,
         2 pFieldInfoObject PFIELDINFO,
         2 pszCnrTitle PSZ,
         2 flWindowAttr ULONG,
         2 ptlOrigin POINTL,
         2 cDelta ULONG,
         2 cRecords ULONG,
         2 slBitmapOrIcon SIZEL,
         2 slTreeBitmapOrIcon SIZEL,
         2 hbmExpanded HBITMAP,
         2 hbmCollapsed HBITMAP,
         2 hptrExpanded HPOINTER,
         2 hptrCollapsed HPOINTER,
         2 cyLineSpacing LONG,
         2 cxTreeIndent LONG,
         2 cxTreeLine LONG,
         2 cFields ULONG,
         2 xVertSplitbar LONG;
   %declare PCNRINFO char;
   %PCNRINFO='pointer';
   %declare CDATE char;
   %CDATE='char(stg(#CDATE))';
   dcl 1 #CDATE based(null()) unaligned,
         2 day UCHAR,
         2 month UCHAR,
         2 year USHORT;
   %declare PCDATE char;
   %PCDATE='pointer';
   %declare CTIME char;
   %CTIME='char(stg(#CTIME))';
   dcl 1 #CTIME based(null()) unaligned,
         2 hours UCHAR,
         2 minutes UCHAR,
         2 seconds UCHAR,
         2 ucReserved UCHAR;
   %declare PCTIME char;
   %PCTIME='pointer';
   declare CFA_LEFT fixed bin(31) value('00_00_00_01'xn);
   declare CFA_RIGHT fixed bin(31) value('00_00_00_02'xn);
   declare CFA_CENTER fixed bin(31) value('00_00_00_04'xn);
   declare CFA_TOP fixed bin(31) value('00_00_00_08'xn);
   declare CFA_VCENTER fixed bin(31) value('00_00_00_10'xn);
   declare CFA_BOTTOM fixed bin(31) value('00_00_00_20'xn);
   declare CFA_INVISIBLE fixed bin(31) value('00_00_00_40'xn);
   declare CFA_BITMAPORICON fixed bin(31) value('00_00_01_00'xn);
   declare CFA_SEPARATOR fixed bin(31) value('00_00_02_00'xn);
   declare CFA_HORZSEPARATOR fixed bin(31) value('00_00_04_00'xn);
   declare CFA_STRING fixed bin(31) value('00_00_08_00'xn);
   declare CFA_OWNER fixed bin(31) value('00_00_10_00'xn);
   declare CFA_DATE fixed bin(31) value('00_00_20_00'xn);
   declare CFA_TIME fixed bin(31) value('00_00_40_00'xn);
   declare CFA_FIREADONLY fixed bin(31) value('00_00_80_00'xn);
   declare CFA_FITITLEREADONLY fixed bin(31) value('00_01_00_00'xn);
   declare CFA_ULONG fixed bin(31) value('00_02_00_00'xn);
   declare CRA_SELECTED fixed bin(31) value('00_00_00_01'xn);
   declare CRA_TARGET fixed bin(31) value('00_00_00_02'xn);
   declare CRA_CURSORED fixed bin(31) value('00_00_00_04'xn);
   declare CRA_INUSE fixed bin(31) value('00_00_00_08'xn);
   declare CRA_FILTERED fixed bin(31) value('00_00_00_10'xn);
   declare CRA_DROPONABLE fixed bin(31) value('00_00_00_20'xn);
   declare CRA_RECORDREADONLY fixed bin(31) value('00_00_00_40'xn);
   declare CRA_EXPANDED fixed bin(31) value('00_00_00_80'xn);
   declare CRA_COLLAPSED fixed bin(31) value('00_00_01_00'xn);
   declare CM_ALLOCDETAILFIELDINFO fixed bin(16) value('03_30'xn);
   declare CM_ALLOCRECORD fixed bin(16) value('03_31'xn);
   declare CM_ARRANGE fixed bin(16) value('03_32'xn);
   declare CM_ERASERECORD fixed bin(16) value('03_33'xn);
   declare CM_FILTER fixed bin(16) value('03_34'xn);
   declare CM_FREEDETAILFIELDINFO fixed bin(16) value('03_35'xn);
   declare CM_FREERECORD fixed bin(16) value('03_36'xn);
   declare CM_HORZSCROLLSPLITWINDOW fixed bin(16) value('03_37'xn);
   declare CM_INSERTDETAILFIELDINFO fixed bin(16) value('03_38'xn);
   declare CM_INSERTRECORD fixed bin(16) value('03_39'xn);
   declare CM_INVALIDATEDETAILFIELDINFO fixed bin(16) value('03_3A'xn);
   declare CM_INVALIDATERECORD fixed bin(16) value('03_3B'xn);
   declare CM_PAINTBACKGROUND fixed bin(16) value('03_3C'xn);
   declare CM_QUERYCNRINFO fixed bin(16) value('03_3D'xn);
   declare CM_QUERYDETAILFIELDINFO fixed bin(16) value('03_3E'xn);
   declare CM_QUERYDRAGIMAGE fixed bin(16) value('03_3F'xn);
   declare CM_QUERYRECORD fixed bin(16) value('03_40'xn);
   declare CM_QUERYRECORDEMPHASIS fixed bin(16) value('03_41'xn);
   declare CM_QUERYRECORDFROMRECT fixed bin(16) value('03_42'xn);
   declare CM_QUERYRECORDRECT fixed bin(16) value('03_43'xn);
   declare CM_QUERYVIEWPORTRECT fixed bin(16) value('03_44'xn);
   declare CM_REMOVEDETAILFIELDINFO fixed bin(16) value('03_45'xn);
   declare CM_REMOVERECORD fixed bin(16) value('03_46'xn);
   declare CM_SCROLLWINDOW fixed bin(16) value('03_47'xn);
   declare CM_SEARCHSTRING fixed bin(16) value('03_48'xn);
   declare CM_SETCNRINFO fixed bin(16) value('03_49'xn);
   declare CM_SETRECORDEMPHASIS fixed bin(16) value('03_4A'xn);
   declare CM_SORTRECORD fixed bin(16) value('03_4B'xn);
   declare CM_OPENEDIT fixed bin(16) value('03_4C'xn);
   declare CM_CLOSEEDIT fixed bin(16) value('03_4D'xn);
   declare CM_COLLAPSETREE fixed bin(16) value('03_4E'xn);
   declare CM_EXPANDTREE fixed bin(16) value('03_4F'xn);
   declare CM_QUERYRECORDINFO fixed bin(16) value('03_50'xn);
   %declare CN_DRAGAFTER char;
   %CN_DRAGAFTER=101;
   %declare CN_DRAGLEAVE char;
   %CN_DRAGLEAVE=102;
   %declare CN_DRAGOVER char;
   %CN_DRAGOVER=103;
   %declare CN_DROP char;
   %CN_DROP=104;
   %declare CN_DROPHELP char;
   %CN_DROPHELP=105;
   %declare CN_ENTER char;
   %CN_ENTER=106;
   %declare CN_INITDRAG char;
   %CN_INITDRAG=107;
   %declare CN_EMPHASIS char;
   %CN_EMPHASIS=108;
   %declare CN_KILLFOCUS char;
   %CN_KILLFOCUS=109;
   %declare CN_SCROLL char;
   %CN_SCROLL=110;
   %declare CN_QUERYDELTA char;
   %CN_QUERYDELTA=111;
   %declare CN_SETFOCUS char;
   %CN_SETFOCUS=112;
   %declare CN_REALLOCPSZ char;
   %CN_REALLOCPSZ=113;
   %declare CN_BEGINEDIT char;
   %CN_BEGINEDIT=114;
   %declare CN_ENDEDIT char;
   %CN_ENDEDIT=115;
   %declare CN_COLLAPSETREE char;
   %CN_COLLAPSETREE=116;
   %declare CN_EXPANDTREE char;
   %CN_EXPANDTREE=117;
   %declare CN_HELP char;
   %CN_HELP=118;
   %declare CN_CONTEXTMENU char;
   %CN_CONTEXTMENU=119;
   %declare CNRDRAGINIT char;
   %CNRDRAGINIT='char(stg(#CNRDRAGINIT))';
   dcl 1 #CNRDRAGINIT based(null()) unaligned,
         2 hwndCnr HWND,
         2 pRecord PRECORDCORE,
         2 x LONG,
         2 y LONG,
         2 cx LONG,
         2 cy LONG;
   %declare PCNRDRAGINIT char;
   %PCNRDRAGINIT='pointer';
   %declare FIELDINFOINSERT char;
   %FIELDINFOINSERT='char(stg(#FIELDINFOINSERT))';
   dcl 1 #FIELDINFOINSERT based(null()) unaligned,
         2 cb ULONG,
         2 pFieldInfoOrder PFIELDINFO,
         2 fInvalidateFieldInfo ULONG,
         2 cFieldInfoInsert ULONG;
   %declare PFIELDINFOINSERT char;
   %PFIELDINFOINSERT='pointer';
   %declare RECORDINSERT char;
   %RECORDINSERT='char(stg(#RECORDINSERT))';
   dcl 1 #RECORDINSERT based(null()) unaligned,
         2 cb ULONG,
         2 pRecordOrder PRECORDCORE,
         2 pRecordParent PRECORDCORE,
         2 fInvalidateRecord ULONG,
         2 zOrder ULONG,
         2 cRecordsInsert ULONG;
   %declare PRECORDINSERT char;
   %PRECORDINSERT='pointer';
   %declare QUERYRECFROMRECT char;
   %QUERYRECFROMRECT='char(stg(#QUERYRECFROMRECT))';
   dcl 1 #QUERYRECFROMRECT based(null()) unaligned,
         2 cb ULONG,
         2 rect RECTL,
         2 fsSearch ULONG;
   %declare PQUERYRECFROMRECT char;
   %PQUERYRECFROMRECT='pointer';
   %declare QUERYRECORDRECT char;
   %QUERYRECORDRECT='char(stg(#QUERYRECORDRECT))';
   dcl 1 #QUERYRECORDRECT based(null()) unaligned,
         2 cb ULONG,
         2 pRecord PRECORDCORE,
         2 fRightSplitWindow ULONG,
         2 fsExtent ULONG;
   %declare PQUERYRECORDRECT char;
   %PQUERYRECORDRECT='pointer';
   %declare SEARCHSTRING char;
   %SEARCHSTRING='char(stg(#SEARCHSTRING))';
   dcl 1 #SEARCHSTRING based(null()) unaligned,
         2 cb ULONG,
         2 pszSearch PSZ,
         2 fsPrefix ULONG,
         2 fsCaseSensitive ULONG,
         2 usView ULONG;
   %declare PSEARCHSTRING char;
   %PSEARCHSTRING='pointer';
   %if INCL_WINSTDDRAG='Y' %then %do;
     %declare CNRDRAGINFO char;
     %CNRDRAGINFO='char(stg(#CNRDRAGINFO))';
     dcl 1 #CNRDRAGINFO based(null()) unaligned,
           2 pDragInfo PDRAGINFO,
           2 pRecord PRECORDCORE;
     %declare PCNRDRAGINFO char;
     %PCNRDRAGINFO='pointer';
   %end;
   %declare NOTIFYRECORDEMPHASIS char;
   %NOTIFYRECORDEMPHASIS='char(stg(#NOTIFYRECORDEMPHASIS))';
   dcl 1 #NOTIFYRECORDEMPHASIS based(null()) unaligned,
         2 hwndCnr HWND,
         2 pRecord PRECORDCORE,
         2 fEmphasisMask ULONG;
   %declare PNOTIFYRECORDEMPHASIS char;
   %PNOTIFYRECORDEMPHASIS='pointer';
   %declare NOTIFYRECORDENTER char;
   %NOTIFYRECORDENTER='char(stg(#NOTIFYRECORDENTER))';
   dcl 1 #NOTIFYRECORDENTER based(null()) unaligned,
         2 hwndCnr HWND,
         2 fKey ULONG,
         2 pRecord PRECORDCORE;
   %declare PNOTIFYRECORDENTER char;
   %PNOTIFYRECORDENTER='pointer';
   %declare NOTIFYDELTA char;
   %NOTIFYDELTA='char(stg(#NOTIFYDELTA))';
   dcl 1 #NOTIFYDELTA based(null()) unaligned,
         2 hwndCnr HWND,
         2 fDelta ULONG;
   %declare PNOTIFYDELTA char;
   %PNOTIFYDELTA='pointer';
   %declare NOTIFYSCROLL char;
   %NOTIFYSCROLL='char(stg(#NOTIFYSCROLL))';
   dcl 1 #NOTIFYSCROLL based(null()) unaligned,
         2 hwndCnr HWND,
         2 lScrollInc LONG,
         2 fScroll ULONG;
   %declare PNOTIFYSCROLL char;
   %PNOTIFYSCROLL='pointer';
   %declare CNREDITDATA char;
   %CNREDITDATA='char(stg(#CNREDITDATA))';
   dcl 1 #CNREDITDATA based(null()) unaligned,
         2 cb ULONG,
         2 hwndCnr HWND,
         2 pRecord PRECORDCORE,
         2 pFieldInfo PFIELDINFO,
         2 ppszText PSZ,
         2 cbText ULONG,
         2 id ULONG;
   %declare PCNREDITDATA char;
   %PCNREDITDATA='pointer';
   %declare OWNERBACKGROUND char;
   %OWNERBACKGROUND='char(stg(#OWNERBACKGROUND))';
   dcl 1 #OWNERBACKGROUND based(null()) unaligned,
         2 OWNERBACKGROUND_hwnd HWND,
         2 OWNERBACKGROUND_hps HPS,
         2 rclBackground RECTL,
         2 idWindow LONG;
   %declare POWNERBACKGROUND char;
   %POWNERBACKGROUND='pointer';
   %declare CNRDRAWITEMINFO char;
   %CNRDRAWITEMINFO='char(stg(#CNRDRAWITEMINFO))';
   dcl 1 #CNRDRAWITEMINFO based(null()) unaligned,
         2 pRecord PRECORDCORE,
         2 pFieldInfo PFIELDINFO;
   %declare PCNRDRAWITEMINFO char;
   %PCNRDRAWITEMINFO='pointer';

   /*****************************************************************/
   /* Message parameter flags                                       */
   /*****************************************************************/

   declare CMA_TOP fixed bin(16) value('00_01'xn);
   declare CMA_BOTTOM fixed bin(16) value('00_02'xn);
   declare CMA_LEFT fixed bin(16) value('00_04'xn);
   declare CMA_RIGHT fixed bin(16) value('00_08'xn);
   declare CMA_FIRST fixed bin(16) value('00_10'xn);
   declare CMA_LAST fixed bin(16) value('00_20'xn);
   declare CMA_END fixed bin(16) value('00_40'xn);
   declare CMA_PREV fixed bin(16) value('00_80'xn);
   declare CMA_NEXT fixed bin(16) value('01_00'xn);
   declare CMA_HORIZONTAL fixed bin(16) value('02_00'xn);
   declare CMA_VERTICAL fixed bin(16) value('04_00'xn);
   declare CMA_ICON fixed bin(16) value('08_00'xn);
   declare CMA_TEXT fixed bin(16) value('10_00'xn);
   declare CMA_PARTIAL fixed bin(16) value('20_00'xn);
   declare CMA_COMPLETE fixed bin(16) value('40_00'xn);
   declare CMA_PARENT fixed bin(16) value('00_01'xn);
   declare CMA_FIRSTCHILD fixed bin(16) value('00_02'xn);
   declare CMA_LASTCHILD fixed bin(16) value('00_04'xn);
   declare CMA_CNRTITLE fixed bin(16) value('00_01'xn);
   declare CMA_DELTA fixed bin(16) value('00_02'xn);
   declare CMA_FLWINDOWATTR fixed bin(16) value('00_04'xn);
   declare CMA_LINESPACING fixed bin(16) value('00_08'xn);
   declare CMA_PFIELDINFOLAST fixed bin(16) value('00_10'xn);
   declare CMA_PSORTRECORD fixed bin(16) value('00_20'xn);
   declare CMA_PTLORIGIN fixed bin(16) value('00_40'xn);
   declare CMA_SLBITMAPORICON fixed bin(16) value('00_80'xn);
   declare CMA_XVERTSPLITBAR fixed bin(16) value('01_00'xn);
   declare CMA_PFIELDINFOOBJECT fixed bin(16) value('02_00'xn);
   declare CMA_TREEICON fixed bin(16) value('04_00'xn);
   declare CMA_TREEBITMAP fixed bin(16) value('08_00'xn);
   declare CMA_CXTREEINDENT fixed bin(16) value('10_00'xn);
   declare CMA_CXTREELINE fixed bin(16) value('20_00'xn);
   declare CMA_SLTREEBITMAPORICON fixed bin(16) value('40_00'xn);
   declare CMA_ITEMORDER fixed bin(16) value('00_01'xn);
   declare CMA_WINDOW fixed bin(16) value('00_02'xn);
   declare CMA_WORKSPACE fixed bin(16) value('00_04'xn);
   declare CMA_ZORDER fixed bin(16) value('00_08'xn);
   declare CMA_DELTATOP fixed bin(16) value('00_01'xn);
   declare CMA_DELTABOT fixed bin(16) value('00_02'xn);
   declare CMA_DELTAHOME fixed bin(16) value('00_04'xn);
   declare CMA_DELTAEND fixed bin(16) value('00_08'xn);
   declare CMA_NOREPOSITION fixed bin(16) value('00_01'xn);
   declare CMA_REPOSITION fixed bin(16) value('00_02'xn);
   declare CMA_TEXTCHANGED fixed bin(16) value('00_04'xn);
   declare CMA_ERASE fixed bin(16) value('00_08'xn);
   declare CMA_FREE fixed bin(16) value('00_01'xn);
   declare CMA_INVALIDATE fixed bin(16) value('00_02'xn);
 %end;
 %if INCL_WINSTDSLIDER_INCLUDED='Y' & INCL_WINSTDSLIDER='Y' %then %do;
   %INCL_WINSTDSLIDER_INCLUDED='Y';
   /*******************************************************************/
   /*                                                                 */
   /*                            S L I D E R                          */
   /*                                                                 */
   /*******************************************************************/

   /*******************************************************************/
   /* Define messages for the slider control                          */
   /*******************************************************************/

   declare SLM_ADDDETENT fixed bin(16) value('03_69'xn);
   declare SLM_QUERYDETENTPOS fixed bin(16) value('03_6A'xn);
   declare SLM_QUERYSCALETEXT fixed bin(16) value('03_6B'xn);
   declare SLM_QUERYSLIDERINFO fixed bin(16) value('03_6C'xn);
   declare SLM_QUERYTICKPOS fixed bin(16) value('03_6D'xn);
   declare SLM_QUERYTICKSIZE fixed bin(16) value('03_6E'xn);
   declare SLM_REMOVEDETENT fixed bin(16) value('03_6F'xn);
   declare SLM_SETSCALETEXT fixed bin(16) value('03_70'xn);
   declare SLM_SETSLIDERINFO fixed bin(16) value('03_71'xn);
   declare SLM_SETTICKSIZE fixed bin(16) value('03_72'xn);
   %declare SLN_CHANGE char;
   %SLN_CHANGE=1;
   %declare SLN_SLIDERTRACK char;
   %SLN_SLIDERTRACK=2;
   %declare SLN_SETFOCUS char;
   %SLN_SETFOCUS=3;
   %declare SLN_KILLFOCUS char;
   %SLN_KILLFOCUS=4;
   %declare SLDCDATA char;
   %SLDCDATA='char(stg(#SLDCDATA))';
   dcl 1 #SLDCDATA based(null()) unaligned,
         2 cbSize ULONG,
         2 usScale1Increments USHORT,
         2 usScale1Spacing USHORT,
         2 usScale2Increments USHORT,
         2 usScale2Spacing USHORT;
   %declare PSLDCDATA char;
   %PSLDCDATA='pointer';
   declare SLS_HORIZONTAL fixed bin(31) value('00_00_00_00'xn);
   declare SLS_VERTICAL fixed bin(31) value('00_00_00_01'xn);
   declare SLS_CENTER fixed bin(31) value('00_00_00_00'xn);
   declare SLS_BOTTOM fixed bin(31) value('00_00_00_02'xn);
   declare SLS_TOP fixed bin(31) value('00_00_00_04'xn);
   declare SLS_LEFT fixed bin(31) value('00_00_00_02'xn);
   declare SLS_RIGHT fixed bin(31) value('00_00_00_04'xn);
   declare SLS_SNAPTOINCREMENT fixed bin(31) value('00_00_00_08'xn);
   declare SLS_BUTTONSBOTTOM fixed bin(31) value('00_00_00_10'xn);
   declare SLS_BUTTONSTOP fixed bin(31) value('00_00_00_20'xn);
   declare SLS_BUTTONSLEFT fixed bin(31) value('00_00_00_10'xn);
   declare SLS_BUTTONSRIGHT fixed bin(31) value('00_00_00_20'xn);
   declare SLS_OWNERDRAW fixed bin(31) value('00_00_00_40'xn);
   declare SLS_READONLY fixed bin(31) value('00_00_00_80'xn);
   declare SLS_RIBBONSTRIP fixed bin(31) value('00_00_01_00'xn);
   declare SLS_HOMEBOTTOM fixed bin(31) value('00_00_00_00'xn);
   declare SLS_HOMETOP fixed bin(31) value('00_00_02_00'xn);
   declare SLS_HOMELEFT fixed bin(31) value('00_00_00_00'xn);
   declare SLS_HOMERIGHT fixed bin(31) value('00_00_02_00'xn);
   declare SLS_PRIMARYSCALE1 fixed bin(31) value('00_00_00_00'xn);
   declare SLS_PRIMARYSCALE2 fixed bin(31) value('00_00_04_00'xn);
   declare SMA_SCALE1 fixed bin(16) value('00_01'xn);
   declare SMA_SCALE2 fixed bin(16) value('00_02'xn);
   declare SMA_SHAFTDIMENSIONS fixed bin(16) value('00_00'xn);
   declare SMA_SHAFTPOSITION fixed bin(16) value('00_01'xn);
   declare SMA_SLIDERARMDIMENSIONS fixed bin(16) value('00_02'xn);
   declare SMA_SLIDERARMPOSITION fixed bin(16) value('00_03'xn);
   declare SMA_RANGEVALUE fixed bin(16) value('00_00'xn);
   declare SMA_INCREMENTVALUE fixed bin(16) value('00_01'xn);
   declare SMA_SETALLTICKS fixed bin(16) value('FF_FF'xn);
   declare SDA_RIBBONSTRIP fixed bin(16) value('00_01'xn);
   declare SDA_SLIDERSHAFT fixed bin(16) value('00_02'xn);
   declare SDA_BACKGROUND fixed bin(16) value('00_03'xn);
   declare SDA_SLIDERARM fixed bin(16) value('00_04'xn);
   declare PMERR_UPDATE_IN_PROGRESS fixed bin(16) value('1F_06'xn);
   %declare SLDERR_INVALID_PARAMETERS char;
   %SLDERR_INVALID_PARAMETERS=-1;
 %end;
 %if INCL_WINSTDVALSET_INCLUDED='Y' & INCL_WINSTDVALSET='Y' %then %do;
   %INCL_WINSTDVALSET_INCLUDED='Y';
   /*******************************************************************/
   /*                                                                 */
   /*                         V A L U E   S E T                       */
   /*                                                                 */
   /*******************************************************************/

   /*******************************************************************/
   /* Define messages for the value set control                       */
   /*******************************************************************/

   declare VM_QUERYITEM fixed bin(16) value('03_75'xn);
   declare VM_QUERYITEMATTR fixed bin(16) value('03_76'xn);
   declare VM_QUERYMETRICS fixed bin(16) value('03_77'xn);
   declare VM_QUERYSELECTEDITEM fixed bin(16) value('03_78'xn);
   declare VM_SELECTITEM fixed bin(16) value('03_79'xn);
   declare VM_SETITEM fixed bin(16) value('03_7A'xn);
   declare VM_SETITEMATTR fixed bin(16) value('03_7B'xn);
   declare VM_SETMETRICS fixed bin(16) value('03_7C'xn);
   %declare VN_SELECT char;
   %VN_SELECT=120;
   %declare VN_ENTER char;
   %VN_ENTER=121;
   %declare VN_DRAGLEAVE char;
   %VN_DRAGLEAVE=122;
   %declare VN_DRAGOVER char;
   %VN_DRAGOVER=123;
   %declare VN_DROP char;
   %VN_DROP=124;
   %declare VN_DROPHELP char;
   %VN_DROPHELP=125;
   %declare VN_INITDRAG char;
   %VN_INITDRAG=126;
   %declare VN_SETFOCUS char;
   %VN_SETFOCUS=127;
   %declare VN_KILLFOCUS char;
   %VN_KILLFOCUS=128;
   %declare VN_HELP char;
   %VN_HELP=129;
   %declare VSCDATA char;
   %VSCDATA='char(stg(#VSCDATA))';
   dcl 1 #VSCDATA based(null()) unaligned,
         2 cbSize ULONG,
         2 usRowCount USHORT,
         2 usColumnCount USHORT;
   %declare PVSCDATA char;
   %PVSCDATA='pointer';
   %declare VSDRAGINIT char;
   %VSDRAGINIT='char(stg(#VSDRAGINIT))';
   dcl 1 #VSDRAGINIT based(null()) unaligned,
         2 VSDRAGINIT_hwnd HWND,
         2 x LONG,
         2 y LONG,
         2 cx LONG,
         2 cy LONG,
         2 usRow USHORT,
         2 usColumn USHORT;
   %declare PVSDRAGINIT char;
   %PVSDRAGINIT='pointer';
   %if INCL_WINSTDDRAG='Y' %then %do;
     %declare VSDRAGINFO char;
     %VSDRAGINFO='char(stg(#VSDRAGINFO))';
     dcl 1 #VSDRAGINFO based(null()) unaligned,
           2 pDragInfo PDRAGINFO,
           2 usRow USHORT,
           2 usColumn USHORT;
     %declare PVSDRAGINFO char;
     %PVSDRAGINFO='pointer';
   %end;
   %declare VSTEXT char;
   %VSTEXT='char(stg(#VSTEXT))';
   dcl 1 #VSTEXT based(null()) unaligned,
         2 pszItemText PSZ,
         2 ulBufLen ULONG;
   %declare PVSTEXT char;
   %PVSTEXT='pointer';

   /*******************************************************************/
   /* Value set control style flag definition                         */
   /*******************************************************************/

   declare VS_BITMAP fixed bin(16) value('00_01'xn);
   declare VS_ICON fixed bin(16) value('00_02'xn);
   declare VS_TEXT fixed bin(16) value('00_04'xn);
   declare VS_RGB fixed bin(16) value('00_08'xn);
   declare VS_COLORINDEX fixed bin(16) value('00_10'xn);
   declare VS_BORDER fixed bin(16) value('00_20'xn);
   declare VS_ITEMBORDER fixed bin(16) value('00_40'xn);
   declare VS_SCALEBITMAPS fixed bin(16) value('00_80'xn);
   declare VS_RIGHTTOLEFT fixed bin(16) value('01_00'xn);
   declare VS_OWNERDRAW fixed bin(16) value('02_00'xn);
   declare VIA_BITMAP fixed bin(16) value('00_01'xn);
   declare VIA_ICON fixed bin(16) value('00_02'xn);
   declare VIA_TEXT fixed bin(16) value('00_04'xn);
   declare VIA_RGB fixed bin(16) value('00_08'xn);
   declare VIA_COLORINDEX fixed bin(16) value('00_10'xn);
   declare VIA_OWNERDRAW fixed bin(16) value('00_20'xn);
   declare VIA_DISABLED fixed bin(16) value('00_40'xn);
   declare VIA_DRAGGABLE fixed bin(16) value('00_80'xn);
   declare VIA_DROPONABLE fixed bin(16) value('01_00'xn);
   declare VMA_ITEMSIZE fixed bin(16) value('00_01'xn);
   declare VMA_ITEMSPACING fixed bin(16) value('00_02'xn);
   declare VDA_ITEM fixed bin(16) value('00_01'xn);
   declare VDA_ITEMBACKGROUND fixed bin(16) value('00_02'xn);
   declare VDA_SURROUNDING fixed bin(16) value('00_03'xn);
   declare VDA_BACKGROUND fixed bin(16) value('00_04'xn);
   %declare VSERR_INVALID_PARAMETERS char;
   %VSERR_INVALID_PARAMETERS=-1;
 %end;
 %if INCL_WINSTDBOOK_INCLUDED='Y' & INCL_WINSTDBOOK='Y' %then %do;
   %INCL_WINSTDBOOK_INCLUDED='Y';
   /*******************************************************************/
   /*                                                                 */
   /*                          N O T E B O O K                        */
   /*                                                                 */
   /*******************************************************************/

   /*******************************************************************/
   /* Message ids                                                     */
   /*******************************************************************/

   declare BKM_CALCPAGERECT fixed bin(16) value('03_53'xn);
   declare BKM_DELETEPAGE fixed bin(16) value('03_54'xn);
   declare BKM_INSERTPAGE fixed bin(16) value('03_55'xn);
   declare BKM_INVALIDATETABS fixed bin(16) value('03_56'xn);
   declare BKM_TURNTOPAGE fixed bin(16) value('03_57'xn);
   declare BKM_QUERYPAGECOUNT fixed bin(16) value('03_58'xn);
   declare BKM_QUERYPAGEID fixed bin(16) value('03_59'xn);
   declare BKM_QUERYPAGEDATA fixed bin(16) value('03_5A'xn);
   declare BKM_QUERYPAGEWINDOWHWND fixed bin(16) value('03_5B'xn);
   declare BKM_QUERYTABBITMAP fixed bin(16) value('03_5C'xn);
   declare BKM_QUERYTABTEXT fixed bin(16) value('03_5D'xn);
   declare BKM_SETDIMENSIONS fixed bin(16) value('03_5E'xn);
   declare BKM_SETPAGEDATA fixed bin(16) value('03_5F'xn);
   declare BKM_SETPAGEWINDOWHWND fixed bin(16) value('03_60'xn);
   declare BKM_SETSTATUSLINETEXT fixed bin(16) value('03_61'xn);
   declare BKM_SETTABBITMAP fixed bin(16) value('03_62'xn);
   declare BKM_SETTABTEXT fixed bin(16) value('03_63'xn);
   declare BKM_SETNOTEBOOKCOLORS fixed bin(16) value('03_64'xn);
   declare BKM_QUERYPAGESTYLE fixed bin(16) value('03_65'xn);
   declare BKM_QUERYSTATUSLINETEXT fixed bin(16) value('03_66'xn);
   %declare BKN_PAGESELECTED char;
   %BKN_PAGESELECTED=130;
   %declare BKN_NEWPAGESIZE char;
   %BKN_NEWPAGESIZE=131;
   %declare BKN_HELP char;
   %BKN_HELP=132;
   %declare BKN_PAGEDELETED char;
   %BKN_PAGEDELETED=133;
   /*******************************************************************/
   /* Page deletion flags (usDeleteFlag)                              */
   /*******************************************************************/

   declare BKA_ALL fixed bin(16) value('00_01'xn);
   declare BKA_SINGLE fixed bin(16) value('00_02'xn);
   declare BKA_TAB fixed bin(16) value('00_04'xn);
   /*******************************************************************/
   /* Page insertion/query order (usPageOrder, usQueryOrder)          */
   /*******************************************************************/

   declare BKA_LAST fixed bin(16) value('00_02'xn);
   declare BKA_FIRST fixed bin(16) value('00_04'xn);
   declare BKA_NEXT fixed bin(16) value('00_08'xn);
   declare BKA_PREV fixed bin(16) value('00_10'xn);
   declare BKA_TOP fixed bin(16) value('00_20'xn);
   declare BKA_MAJORTAB fixed bin(16) value('00_01'xn);
   declare BKA_MINORTAB fixed bin(16) value('00_02'xn);
   declare BKA_PAGEBUTTON fixed bin(16) value('01_00'xn);
   declare BKA_STATUSTEXTON fixed bin(16) value('00_01'xn);
   declare BKA_MAJOR fixed bin(16) value('00_40'xn);
   declare BKA_MINOR fixed bin(16) value('00_80'xn);
   declare BKA_AUTOPAGESIZE fixed bin(16) value('01_00'xn);
   declare BKA_END fixed bin(16) value('02_00'xn);
   declare BKA_TEXT fixed bin(16) value('04_00'xn);
   declare BKA_BITMAP fixed bin(16) value('08_00'xn);
   declare BKS_BACKPAGESBR fixed bin(31) value('00_00_00_01'xn);
   declare BKS_BACKPAGESBL fixed bin(31) value('00_00_00_02'xn);
   declare BKS_BACKPAGESTR fixed bin(31) value('00_00_00_04'xn);
   declare BKS_BACKPAGESTL fixed bin(31) value('00_00_00_08'xn);
   declare BKS_MAJORTABRIGHT fixed bin(31) value('00_00_00_10'xn);
   declare BKS_MAJORTABLEFT fixed bin(31) value('00_00_00_20'xn);
   declare BKS_MAJORTABTOP fixed bin(31) value('00_00_00_40'xn);
   declare BKS_MAJORTABBOTTOM fixed bin(31) value('00_00_80_00'xn);
   declare BKS_SQUARETABS fixed bin(31) value('00_00_00_00'xn);
   declare BKS_ROUNDEDTABS fixed bin(31) value('00_00_01_00'xn);
   declare BKS_POLYGONTABS fixed bin(31) value('00_00_02_00'xn);
   declare BKS_SOLIDBIND fixed bin(31) value('00_00_00_00'xn);
   declare BKS_SPIRALBIND fixed bin(31) value('00_00_04_00'xn);
   declare BKS_STATUSTEXTLEFT fixed bin(31) value('00_00_00_00'xn);
   declare BKS_STATUSTEXTRIGHT fixed bin(31) value('00_00_10_00'xn);
   declare BKS_STATUSTEXTCENTER fixed bin(31) value('00_00_20_00'xn);
   declare BKS_TABTEXTLEFT fixed bin(31) value('00_00_00_00'xn);
   declare BKS_TABTEXTRIGHT fixed bin(31) value('00_00_40_00'xn);
   declare BKS_TABTEXTCENTER fixed bin(31) value('00_00_80_00'xn);
   declare BKA_BACKGROUNDPAGECOLORINDEX fixed bin(16) value('00_01'xn);
   declare BKA_BACKGROUNDPAGECOLOR fixed bin(16) value('00_02'xn);
   declare BKA_BACKGROUNDMAJORCOLORINDEX fixed bin(16) value('00_03'xn);
   declare BKA_BACKGROUNDMAJORCOLOR fixed bin(16) value('00_04'xn);
   declare BKA_BACKGROUNDMINORCOLORINDEX fixed bin(16) value('00_05'xn);
   declare BKA_BACKGROUNDMINORCOLOR fixed bin(16) value('00_06'xn);
   declare BKA_FOREGROUNDMAJORCOLORINDEX fixed bin(16) value('00_07'xn);
   declare BKA_FOREGROUNDMAJORCOLOR fixed bin(16) value('00_08'xn);
   declare BKA_FOREGROUNDMINORCOLORINDEX fixed bin(16) value('00_09'xn);
   declare BKA_FOREGROUNDMINORCOLOR fixed bin(16) value('00_0A'xn);
   %declare BOOKERR_INVALID_PARAMETERS char;
   %BOOKERR_INVALID_PARAMETERS=-1;
   %declare BOOKTEXT char;
   %BOOKTEXT='char(stg(#BOOKTEXT))';
   dcl 1 #BOOKTEXT based(null()) unaligned,
         2 pString PSZ,
         2 textLen ULONG;
   %declare PBOOKTEXT char;
   %PBOOKTEXT='pointer';
   %declare DELETENOTIFY char;
   %DELETENOTIFY='char(stg(#DELETENOTIFY))';
   dcl 1 #DELETENOTIFY based(null()) unaligned,
         2 hwndBook HWND,
         2 hwndPage HWND,
         2 ulAppPageData ULONG,
         2 hbmTab HBITMAP;
   %declare PDELETENOTIFY char;
   %PDELETENOTIFY='pointer';
   %declare PAGESELECTNOTIFY char;
   %PAGESELECTNOTIFY='char(stg(#PAGESELECTNOTIFY))';
   dcl 1 #PAGESELECTNOTIFY based(null()) unaligned,
         2 hwndBook HWND,
         2 ulPageIdCur ULONG,
         2 ulPageIdNew ULONG;
   %declare PPAGESELECTNOTIFY char;
   %PPAGESELECTNOTIFY='pointer';
 %end;
 %if IBMC__='Y' %then %do;
   %if CHKHDR__='Y' %then %do;
   %end;
 %end;
