 /********************************************************************/
 /*                                                                  */
 /*  PL/I Include file: PMSHL.CPY                                    */
 /*                                                                  */
 /*  NAME - PMSHL.CPY                                                */
 /*                                                                  */
 /*  DESCRIPTION                                                     */
 /*    Presentation Manager PL/I include file.                       */
 /*                                                                  */
 /*    (C) Copyright IBM Corp. 1992. All Rights Reserved.            */
 /*    US Government Users Restricted Rights-- Use, duplication or   */
 /*    disclosure restricted by GSA ADP Schedule Contract with       */
 /*    IBM Corp.                                                     */
 /*                                                                  */
 /*  DISCLAIMER OF WARRANTIES                                        */
 /*    The following enclosed code is sample code created by IBM   */
 /*    Corporation. This sample code is not part of any standard     */
 /*    IBM product and is provided to you solely for the purpose of  */
 /*    assisting you in the development of your applications.  The   */
 /*    code is provided "AS IS", without warranty of any kind.       */
 /*    IBM shall not be liable for any damages arising out of your   */
 /*    use of the sample code, even if IBM has been advised of the   */
 /*    possibility of such damages.                                  */
 /*                                                                  */
 /********************************************************************/
 /*==================================================================*/
 /*                                                                  */
 /* The following symbols are used in this file for conditional      */
 /* sections.                                                        */
 /*                                                                  */
 /*   INCL_SHLERRORS       defined if INCL_ERRORS is defined         */
 /*   INCL_WINPROGRAMLIST  Include Program List Calls                */
 /*   INCL_WINSHELLDATA    Include Presentation Manager profile calls*/
 /*   INCL_WINSWITCHLIST   Include Switch List Calls                 */
 /*                                                                  */
 /*==================================================================*/
 %if IBMC__='Y' %then %do;
   %if CHKHDR__='Y' %then %do;
   %end;
 %end;
 %SHL_INCLUDED='Y';
 %if INCL_ERRORS='Y' %then %do;
   %INCL_SHLERRORS='Y';
 %end;
 %if SESMGR='Y' %then %do;
   %declare MAXNAMEL char;
   %MAXNAMEL=60;
   %declare HPROGRAM char;
   %HPROGRAM=LHANDLE;
   %declare PHPROGRAM char;
   %PHPROGRAM='pointer';
   %declare HAPP char;
   %HAPP=LHANDLE;
   %declare HINI char;
   %HINI=LHANDLE;
   %declare PHINI char;
   %PHINI='pointer';
   %declare HINI_PROFILE char;
   %HINI_PROFILE='sysnull()';
   %declare HINI_USERPROFILE char;
   %HINI_USERPROFILE='-1';
   %declare HINI_SYSTEMPROFILE char;
   %HINI_SYSTEMPROFILE='-2';
   %declare HINI_USER char;
   %HINI_USER=HINI_USERPROFILE;
   %declare HINI_SYSTEM char;
   %HINI_SYSTEM=HINI_SYSTEMPROFILE;
   %declare PRFPROFILE char;
   %PRFPROFILE='char(stg(#PRFPROFILE))';
   dcl 1 #PRFPROFILE based(null()) unaligned,
         2 cchUserName ULONG,
         2 pszUserName PSZ,
         2 cchSysName ULONG,
         2 pszSysName PSZ;
   %declare PPRFPROFILE char;
   %PPRFPROFILE='pointer';
 %end;
 %if INCL_WINPROGRAMLIST='Y' %then %do;
   %if SESMGR='Y' %then %do;
     %declare MAXPATHL char;
     %MAXPATHL=128;
     %declare SGH_ROOT char;
     %SGH_ROOT=HPROGRAM;
     %declare HPROGARRAY char;
     %HPROGARRAY='char(stg(#HPROGARRAY))';
     dcl 1 #HPROGARRAY based(null()) unaligned,
           2 ahprog(1) HPROGRAM;
     %declare PHPROGARRAY char;
     %PHPROGARRAY='pointer';
   %end;
   %declare PROGCATEGORY char;
   %PROGCATEGORY=ULONG;
   %declare PPROGCATEGORY char;
   %PPROGCATEGORY='pointer';
   %declare PROG_DEFAULT char;
   %PROG_DEFAULT=PROGCATEGORY;
   %declare PROG_FULLSCREEN char;
   %PROG_FULLSCREEN=PROGCATEGORY;
   %declare PROG_WINDOWABLEVIO char;
   %PROG_WINDOWABLEVIO=PROGCATEGORY;
   %declare PROG_PM char;
   %PROG_PM=PROGCATEGORY;
   %declare PROG_GROUP char;
   %PROG_GROUP=PROGCATEGORY;
   %declare PROG_REAL char;
   %PROG_REAL=PROGCATEGORY;
   %declare PROG_VDM char;
   %PROG_VDM=PROGCATEGORY;
   %declare PROG_WINDOWEDVDM char;
   %PROG_WINDOWEDVDM=PROGCATEGORY;
   %declare PROG_DLL char;
   %PROG_DLL=PROGCATEGORY;
   %declare PROG_PDD char;
   %PROG_PDD=PROGCATEGORY;
   %declare PROG_VDD char;
   %PROG_VDD=PROGCATEGORY;
   %declare PROG_WINDOW_REAL char;
   %PROG_WINDOW_REAL=PROGCATEGORY;
   %declare PROG_WINDOW_PROT char;
   %PROG_WINDOW_PROT=PROGCATEGORY;
   %declare PROG_30_STD char;
   %PROG_30_STD=PROGCATEGORY;
   %declare PROG_WINDOW_AUTO char;
   %PROG_WINDOW_AUTO=PROGCATEGORY;
   %declare PROG_SEAMLESSVDM char;
   %PROG_SEAMLESSVDM=PROGCATEGORY;
   %declare PROG_30_STDSEAMLESSVDM char;
   %PROG_30_STDSEAMLESSVDM=PROGCATEGORY;
   %declare PROG_SEAMLESSCOMMON char;
   %PROG_SEAMLESSCOMMON=PROGCATEGORY;
   %declare PROG_30_STDSEAMLESSCOMMON char;
   %PROG_30_STDSEAMLESSCOMMON=PROGCATEGORY;
   %declare PROG_31_STDSEAMLESSVDM char;
   %PROG_31_STDSEAMLESSVDM=PROGCATEGORY;
   %declare PROG_31_STDSEAMLESSCOMMON char;
   %PROG_31_STDSEAMLESSCOMMON=PROGCATEGORY;
   %declare PROG_31_ENHSEAMLESSVDM char;
   %PROG_31_ENHSEAMLESSVDM=PROGCATEGORY;
   %declare PROG_31_ENHSEAMLESSCOMMON char;
   %PROG_31_ENHSEAMLESSCOMMON=PROGCATEGORY;
   %declare PROG_31_ENH char;
   %PROG_31_ENH=PROGCATEGORY;
   %declare PROG_31_STD char;
   %PROG_31_STD=PROGCATEGORY;
   %declare PROG_RESERVED char;
   %PROG_RESERVED=PROGCATEGORY;
   %if SESMGR='Y' %then %do;
     %declare PROGTYPE char;
     %PROGTYPE='char(stg(#PROGTYPE))';
     dcl 1 #PROGTYPE based(null()) unaligned,
           2 progc PROGCATEGORY,
           2 fbVisible ULONG;
     %declare PPROGTYPE char;
     %PPROGTYPE='pointer';

     declare SHE_VISIBLE bit(8) value('00_00_00_00'b);
     declare SHE_INVISIBLE bit(8) value('00_00_00_01'b);
     declare SHE_RESERVED bit(8) value('11_11_11_11'b);
     declare SHE_UNPROTECTED bit(8) value('00_00_00_00'b);
     declare SHE_PROTECTED bit(8) value('00_00_00_10'b);
     %declare PROGDETAILS char;
     %PROGDETAILS='char(stg(#PROGDETAILS))';
     dcl 1 #PROGDETAILS based(null()) unaligned,
           2 uLength ULONG,
           2 progt PROGTYPE,
           2 pszTitle PSZ,
           2 pszExecutable PSZ,
           2 pszParameters PSZ,
           2 pszStartupDir PSZ,
           2 pszIcon PSZ,
           2 pszEnvironment PSZ,
           2 swpInitial SWP;
     %declare PPROGDETAILS char;
     %PPROGDETAILS='pointer';
     %declare PROGTITLE char;
     %PROGTITLE='char(stg(#PROGTITLE))';
     dcl 1 #PROGTITLE based(null()) unaligned,
           2 hprog HPROGRAM,
           2 progt PROGTYPE,
           2 pszTitle PSZ;
     %declare PPROGTITLE char;
     %PPROGTITLE='pointer';
     dcl PrfQueryProgramTitles entry (
            HINI,
            HPROGRAM,
            PPROGTITLE,
            ULONG,
            PULONG)
            returns(optional byvalue ULONG)
            APIENTRY;
     dcl PrfAddProgram entry (
            HINI,
            PPROGDETAILS,
            HPROGRAM)
            returns(optional byvalue HPROGRAM)
            APIENTRY;
     dcl PrfChangeProgram entry (
            HINI,
            HPROGRAM,
            PPROGDETAILS)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl PrfQueryDefinition entry (
            HINI,
            HPROGRAM,
            PPROGDETAILS,
            ULONG)
            returns(optional byvalue ULONG)
            APIENTRY;
     dcl PrfRemoveProgram entry (
            HINI,
            HPROGRAM)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl PrfQueryProgramHandle entry (
            HINI,
            PSZ,
            PHPROGARRAY,
            ULONG,
            PULONG)
            returns(optional byvalue ULONG)
            APIENTRY;
     dcl PrfCreateGroup entry (
            HINI,
            PSZ,
            UCHAR)
            returns(optional byvalue HPROGRAM)
            APIENTRY;
     dcl PrfDestroyGroup entry (
            HINI,
            HPROGRAM)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl PrfQueryProgramCategory entry (
            HINI,
            PSZ)
            returns(optional byvalue PROGCATEGORY)
            APIENTRY;
     dcl WinStartApp entry (
            HWND,
            PPROGDETAILS,
            PSZ,
            PVOID,
            ULONG)
            returns(optional byvalue HAPP)
            APIENTRY;

     declare SAF_VALIDFLAGS fixed bin(16) value('00_1F'xn);
     declare SAF_INSTALLEDCMDLINE  fixed bin(16) value('00_01'xn);
     declare SAF_STARTCHILDAPP fixed bin(16) value('00_02'xn);
     declare SAF_MAXIMIZED  fixed bin(16) value('00_04'xn);
     declare SAF_MINIMIZED  fixed bin(16) value('00_08'xn);
     declare SAF_BACKGROUND  fixed bin(16) value('00_10'xn);
     dcl WinTerminateApp entry (
            HAPP)
            returns(optional byvalue BOOL)
            APIENTRY;
   %end;
 %end;
 %declare HSWITCH char;
 %HSWITCH=LHANDLE;
 %declare PHSWITCH char;
 %PHSWITCH='pointer';
 %if SESMGR='Y' %then %do;
   %if INCL_WINSWITCHLIST='Y' | INCL_NOCOMMON='Y' %then %do;
     %declare SWCNTRL char;
     %SWCNTRL='char(stg(#SWCNTRL))';
     dcl 1 #SWCNTRL based(null()) unaligned,
           2 SWCNTRL_hwnd HWND,
           2 hwndIcon HWND,
           2 hprog HPROGRAM,
           2 idProcess PID,
           2 idSession ULONG,
           2 uchVisibility ULONG,
           2 fbJump ULONG,
           2 szSwtitle char(MAXNAMEL+3) varz,
           2 bProgType ULONG;
     %declare PSWCNTRL char;
     %PSWCNTRL='pointer';

     declare SWL_VISIBLE bit(8) value('00_00_01_00'b);
     declare SWL_INVISIBLE bit(8) value('00_00_00_01'b);
     declare SWL_GRAYED bit(8) value('00_00_00_10'b);
     declare SWL_JUMPABLE bit(8) value('00_00_00_10'b);
     declare SWL_NOTJUMPABLE bit(8) value('00_00_00_01'b);
     dcl WinAddSwitchEntry entry (
            PSWCNTRL)
            returns(optional byvalue HSWITCH)
            APIENTRY;
     dcl WinRemoveSwitchEntry entry (
            HSWITCH)
            returns(optional byvalue ULONG)
            APIENTRY;
   %end;
   %if INCL_WINSWITCHLIST='Y' %then %do;
     %declare SWENTRY char;
     %SWENTRY='char(stg(#SWENTRY))';
     dcl 1 #SWENTRY based(null()) unaligned,
           2 SWENTRY_hswitch HSWITCH,
           2 swctl SWCNTRL;
     %declare PSWENTRY char;
     %PSWENTRY='pointer';
     %declare SWBLOCK char;
     %SWBLOCK='char(stg(#SWBLOCK))';
     dcl 1 #SWBLOCK based(null()) unaligned,
           2 cswentry ULONG,
           2 aswentry(1) SWENTRY;
     %declare PSWBLOCK char;
     %PSWBLOCK='pointer';
     dcl WinChangeSwitchEntry entry (
            HSWITCH,
            PSWCNTRL)
            returns(optional byvalue ULONG)
            APIENTRY;
     dcl WinCreateSwitchEntry entry (
            HAB,
            PSWCNTRL)
            returns(optional byvalue HSWITCH)
            APIENTRY;
     dcl WinQuerySessionTitle entry (
            HAB,
            ULONG,
            PSZ,
            ULONG)
            returns(optional byvalue ULONG)
            APIENTRY;
     dcl WinQuerySwitchEntry entry (
            HSWITCH,
            PSWCNTRL)
            returns(optional byvalue ULONG)
            APIENTRY;
     dcl WinQuerySwitchHandle entry (
            HWND,
            PID)
            returns(optional byvalue HSWITCH)
            APIENTRY;
     dcl WinQuerySwitchList entry (
            HAB,
            PSWBLOCK,
            ULONG)
            returns(optional byvalue ULONG)
            APIENTRY;
     dcl WinQueryTaskSizePos entry (
            HAB,
            ULONG,
            PSWP)
            returns(optional byvalue ULONG)
            APIENTRY;
     dcl WinQueryTaskTitle entry (
            ULONG,
            PSZ,
            ULONG)
            returns(optional byvalue ULONG)
            APIENTRY;
     dcl WinSwitchToProgram entry (
            HSWITCH)
            returns(optional byvalue ULONG)
            APIENTRY;
   %end;
   %if INCL_WINSHELLDATA='Y' %then %do;
     dcl PrfQueryProfileInt entry (
            HINI,
            PSZ,
            PSZ,
            LONG)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl PrfQueryProfileString entry (
            HINI,
            PSZ,
            PSZ,
            PSZ,
            PVOID,
            ULONG)
            returns(optional byvalue ULONG)
            APIENTRY;
     dcl PrfWriteProfileString entry (
            HINI,
            PSZ,
            PSZ,
            PSZ)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl PrfQueryProfileSize entry (
            HINI,
            PSZ,
            PSZ,
            PULONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl PrfQueryProfileData entry (
            HINI,
            PSZ,
            PSZ,
            PVOID,
            PULONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl PrfWriteProfileData entry (
            HINI,
            PSZ,
            PSZ,
            PVOID,
            ULONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl PrfOpenProfile entry (
            HAB,
            PSZ)
            returns(optional byvalue HINI)
            APIENTRY;
     dcl PrfCloseProfile entry (
            HINI)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl PrfReset entry (
            HAB,
            PPRFPROFILE)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl PrfQueryProfile entry (
            HAB,
            PPRFPROFILE)
            returns(optional byvalue BOOL)
            APIENTRY;
     %declare PL_ALTERED char;
     %PL_ALTERED=142;
   %end;
   %if INCL_SHLERRORS='Y' %then %do;
     %include pmerr;
   %end;
 %end;
 %if IBMC__='Y' %then %do;
   %if CHKHDR__='Y' %then %do;
   %end;
 %end;
