/******************************************************************/
/*                                                                */
/*    Licensed Materials - Property of IBM                        */
/*    5639-A83, 5639-A24 (C) Copyright IBM Corp. 1992,1996.       */
/*    All Rights Reserved.                                        */
/*    US Government Users Restricted Rights-- Use, duplication or */
/*    disclosure restricted by GSA ADP Schedule Contract with     */
/*    IBM Corp.                                                   */
/*                                                                */
/*  DISCLAIMER OF WARRANTIES                                      */
/*    The following enclosed code is sample code created by IBM */
/*    Corporation. This sample code is not part of any standard   */
/*    IBM product and is provided to you solely for the purpose of*/
/*    assisting you in the development of your applications.  The */
/*    code is provided "AS IS", without warranty of any kind.     */
/*    IBM shall not be liable for any damages arising out of your */
/*    use of the sample code, even if IBM has been advised of the */
/*    possibility of such damages.                                */
/*                                                                */
/*                                                                */
/* This is the VisualAge C++ function to be compiled and linked   */
/* into a DLL and to be called by the PL/I procedure, the caller, */
/* which has been compiled as object and packaged into an EXE.    */
/* The C function is passed a structure object (Typedef ExStr)    */
/* of common data types.  This C function then prints out the     */
/* contents of the structure for visual verification.             */
/* The pointer field is assumed to be the address of a            */
/* null-terminated string.                                        */
/*                                                                */
/*    Note:                                                       */
/*            This PLICS2D.C should be compiled with the compiler */
/*            option /Sp1 to force single byte allignment for     */
/*            VisualAge C++.                                      */
/*                                                                */
/******************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

/*  Globals                                                          */

typedef struct
{
     short         s1 ;         /* Half-Word Fixed Binary            */
     float         f2 ;         /* Whole-Word Float Decimal          */
     char          c3 ;         /* Single Byte Character             */
     double        d4 ;         /* Double-Word Float Decimal         */
     char*         p5 ;         /* Pointer to Null-Terminated String */
     long double  ld6 ;         /* 10 Byte Float Decimal             */
     long          l7 ;         /* Whole-Word Fixed Binary           */
     int           i8 ;         /* Whole-Word Fixed Binary           */
}
  ExStr ;

void PLICS2D ( ExStr* st1 )
{                                           /* Display the object    */

  fprintf(stderr,"\nPrinting the structure content inside C.\n");

  fprintf(stderr,"\nStructure element #1 (Short):    %d.",st1->s1) ;
  fprintf(stderr,"\nStructure element #2 (Float):    %f.",st1->f2) ;
  fprintf(stderr,"\nStructure element #3 (Char):     %c.",st1->c3) ;
  fprintf(stderr,"\nStructure element #4 (Double):   %f.",st1->d4) ;
  fprintf(stderr,"\nStructure element #5 (Pointer):  %s.",st1->p5) ;
  fprintf(stderr,"\nStructure element #6 (Long Dbl): %Lf.",st1->ld6) ;
  fprintf(stderr,"\nStructure element #7 (Long):     %ld.",st1->l7) ;
  fprintf(stderr,"\nStructure element #8 (Int):      %ld.",st1->i8) ;
  fprintf(stderr,"\n") ;
  fflush(stderr) ;

  fprintf(stderr,"\nEnd of the C callee.\n");
}
