 /********************************************************************/
 /*                                                                  */
 /*  PL/I Include file: OS2NLS.CPY                                   */
 /*                                                                  */
 /*  NAME - OS2NLS.CPY                                               */
 /*                                                                  */
 /*  DESCRIPTION                                                     */
 /*    OS/2 base PL/I include file.                                  */
 /*                                                                  */
 /*    (C) Copyright IBM Corp. 1992. All Rights Reserved.            */
 /*    US Government Users Restricted Rights-- Use, duplication or   */
 /*    disclosure restricted by GSA ADP Schedule Contract with       */
 /*    IBM Corp.                                                     */
 /*                                                                  */
 /*  DISCLAIMER OF WARRANTIES                                        */
 /*    The following enclosed code is sample code created by IBM   */
 /*    Corporation. This sample code is not part of any standard     */
 /*    IBM product and is provided to you solely for the purpose of  */
 /*    assisting you in the development of your applications.  The   */
 /*    code is provided "AS IS", without warranty of any kind.       */
 /*    IBM shall not be liable for any damages arising out of your   */
 /*    use of the sample code, even if IBM has been advised of the   */
 /*    possibility of such damages.                                  */
 /*                                                                  */
 /********************************************************************/
 /*==================================================================*/
 /*                                                                  */
 /* The definitions in this file are for use on Double Byte Character*/
 /* Set (DBCS) versions of OS/2 only. They may not be used on SBCS   */
 /* versions.                                                        */
 /*                                                                  */
 /* This is included from PMWIN.H when INCL_NLS symbol is defined    */
 /*                                                                  */
 /*==================================================================*/
 %if IBMC__='Y' %then %do;
   %if CHKHDR__='Y' %then %do;
   %end;
 %end;
 %if OS2NLS__='Y' %then %do;
   %OS2NLS__='Y';
   dcl RID_DBE_OFFSET fixed bin(16) value('10_00'xn);
   dcl STR_DBE_OFFSET fixed bin(16) value('10_00'xn);
   dcl VK_DBE_FIRST bit(8) value('10_00_00_00'b);
   dcl VK_DBE_LAST bit(8) value('11_11_11_11'b);
   dcl VK_DBE_IMEFIRST bit(8) value('10_10_00_00'b);
   dcl VK_DBE_IMELAST bit(8) value('11_11_11_11'b);
   dcl VK_DBE_OEMFIRST bit(8) value('11_00_00_00'b);
   dcl VK_DBE_OEMLAST bit(8) value('11_00_11_11'b);
   dcl VK_DBE_ALPHANUMERIC bit(8) value('10_00_00_00'b);
   dcl VK_DBE_KATAKANA bit(8) value('10_00_00_01'b);
   dcl VK_DBE_HIRAGANA bit(8) value('10_00_00_10'b);
   dcl VK_DBE_SBCSCHAR bit(8) value('10_00_00_11'b);
   dcl VK_DBE_DBCSCHAR bit(8) value('10_00_01_00'b);
   dcl VK_DBE_SBCSDBCSCHAR bit(8) value('10_00_01_01'b);
   dcl VK_DBE_ROMAN bit(8) value('10_00_01_10'b);
   dcl VK_DBE_HANJA bit(8) value('10_00_01_11'b);
   dcl VK_DBE_HANGEUL bit(8) value('10_00_10_00'b);
   dcl VK_DBE_JAMO bit(8) value('10_00_10_01'b);
   dcl VK_DBE_HANZI bit(8) value('10_00_10_10'b);
   dcl VK_DBE_TSANGJYE bit(8) value('10_00_11_00'b);
   dcl VK_DBE_PHONETIC bit(8) value('10_00_11_01'b);
   dcl VK_DBE_KANJI bit(8) value('10_10_00_00'b);
   dcl VK_DBE_IMEACTIVATE bit(8) value('10_10_00_00'b);
   dcl VK_DBE_CONV bit(8) value('10_10_00_01'b);
   dcl VK_DBE_NOCONV bit(8) value('10_10_00_10'b);
   dcl VK_DBE_TANGO bit(8) value('10_10_00_11'b);
   dcl VK_DBE_WORDREGISTER bit(8) value('10_10_00_11'b);
   dcl VK_DBE_IMEDIALOG bit(8) value('10_10_01_00'b);
   dcl VK_DBE_IME_MBSELECTED bit(8) value('10_10_01_01'b);
   dcl VK_DBE_IME_LBSELECTED bit(8) value('10_10_01_10'b);
   dcl VK_DBE_CODEINPUT bit(8) value('10_10_01_11'b);
   dcl VK_DBE_ALLCANDIDATE bit(8) value('10_10_10_00'b);
   dcl VK_DBE_PREVCANDIDATE bit(8) value('10_10_10_01'b);
   dcl VK_DBE_IMEDEACTIVATE bit(8) value('10_10_10_10'b);
   dcl VK_DBE_IME_WORDREGISTED bit(8) value('10_10_10_11'b);
   dcl VK_DBE_IMECONTROL bit(8) value('10_10_11_00'b);
   dcl VK_DBE_IME_FREEPS bit(8) value('10_10_11_01'b);
   dcl VK_DBE_IMEMODEEXIT bit(8) value('10_10_11_10'b);
   dcl WC_DBE_APPSTAT pointer value(ptrvalue('FF_FF_00_10'xn));
   dcl WC_DBE_KBDSTAT pointer value(ptrvalue('FF_FF_00_11'xn));
   dcl WC_DBE_PECIC pointer value(ptrvalue('FF_FF_00_12'xn));
   dcl WM_DBE_SETAPPLSTAT fixed bin(16) value('00_B6'xn);
   dcl WM_DBE_KKCPARAMS fixed bin(16) value('00_BC'xn);
   dcl FCF_DBE_STATAREA fixed bin(31) value('80_00_00_00'xn);
   %dcl KEYSTSDATA char;
   %KEYSTSDATA='char(stg(#KEYSTSDATA))';
   dcl 1 #KEYSTSDATA based(null()) unaligned,
         2 wpmctlflag ULONG,
         2 textlength ULONG,
         2 pTextString PSZ,
         2 pAttrString PSZ,
         2 pRomanString PSZ;
   %dcl PKEYSTSDATA char;
   %PKEYSTSDATA='pointer';
   %dcl WPMCTLPARAMS char;
   %WPMCTLPARAMS='char(stg(#WPMCTLPARAMS))';
   dcl 1 #WPMCTLPARAMS based(null()) unaligned,
         2 wpmctlflag ULONG,
         2 textlength ULONG,
         2 pTextString PSZ,
         2 pAttrString PSZ;
   %dcl PWPMCTLPARAMS char;
   %PWPMCTLPARAMS='pointer';

   dcl DBE_KSF_ALPHANUMERIC fixed bin(16) value('00_01'xn);
   dcl DBE_KSF_KATAKANA fixed bin(16) value('00_02'xn);
   dcl DBE_KSF_HIRAGANA fixed bin(16) value('00_04'xn);
   dcl DBE_KSF_CAPS fixed bin(16) value('00_08'xn);
   dcl DBE_KSF_ROMAN fixed bin(16) value('00_10'xn);
   dcl DBE_KSF_HANKAKU fixed bin(16) value('00_20'xn);
   dcl DBE_KSF_ZENKAKU fixed bin(16) value('00_40'xn);
   dcl DBE_KSF_SBCS fixed bin(16) value('00_20'xn);
   dcl DBE_KSF_DBCS fixed bin(16) value('00_40'xn);
   dcl DBE_KSF_UPPER fixed bin(16) value('00_80'xn);
   dcl DBE_KSF_LOWER fixed bin(16) value('01_00'xn);
   dcl DBE_KSF_TEXT fixed bin(16) value('02_00'xn);
   dcl DBE_KSF_NOROMAN fixed bin(16) value('04_00'xn);
   dcl DBE_KSF_DISABLEONTHESPOT fixed bin(16) value('08_00'xn);
   dcl DBE_KSF_ROMANTEXT fixed bin(16) value('10_00'xn);
   dcl DBE_KSF_JAMO fixed bin(16) value('00_02'xn);
   dcl DBE_KSF_HANGEUL fixed bin(16) value('00_04'xn);
   dcl DBE_KSF_PHONETIC fixed bin(16) value('00_02'xn);
   dcl DBE_KSF_TSANGJYE fixed bin(16) value('00_04'xn);
   %dcl PECICDATA char;
   %PECICDATA='char(stg(#PECICDATA))';
   dcl 1 #PECICDATA based(null()) unaligned,
         2 wpmctlflag ULONG,
         2 textlength ULONG,
         2 pTextString PSZ,
         2 pAttrString PSZ,
         2 CursorPos ULONG,
         2 CursorAttr ULONG;
   %dcl PPECICDATA char;
   %PPECICDATA='pointer';

   dcl DBE_WPM_APPLSTAT_VISIBILITY fixed bin(16) value('00_04'xn);
   dcl DBE_AS_APPLTOP fixed bin(16) value('00_01'xn);
   dcl DBE_AS_KBDTOP fixed bin(16) value('00_02'xn);
   dcl DBE_AS_PECICTOP fixed bin(16) value('00_04'xn);
   dcl DBE_AS_APPLBOTTOM fixed bin(16) value('00_08'xn);

   %dcl KKCPARAMS char;
   %KKCPARAMS='char(stg(#KKCPARAMS))';
   dcl 1 #KKCPARAMS based(null()) unaligned,
         2 lenKKCParams ULONG,
         2 fRequest ULONG,
         2 fKKCParams ULONG,
         2 pKKCData PVOID,
         2 Reserved ULONG;
   %dcl PKKCPARAMS char;
   %PKKCPARAMS='pointer';

   dcl DBE_KKCPARAMS_SET fixed bin(16) value('00_01'xn);
   dcl DBE_KKCPARAMS_QUERY fixed bin(16) value('00_02'xn);
   dcl DBE_KKCPARAMS_PHYSICALATTRIBUTE fixed bin(16) value('00_01'xn);
   dcl DBE_KKCPARAMS_PECICCURSORPOS fixed bin(16) value('00_02'xn);

   %dcl LEVEL char;
   %LEVEL='char(stg(#LEVEL))';
   dcl 1 #LEVEL based(null()) unaligned,
         2 attri1 UCHAR,
         2 attri2 UCHAR;
   %dcl PLEVEL char;
   %PLEVEL='pointer';
   %dcl COLORLOOKUPTBL char;
   %COLORLOOKUPTBL='char(stg(#COLORLOOKUPTBL))';
   dcl 1 #COLORLOOKUPTBL based(null()) unaligned,
         2 nAttr ULONG,
         2 PhysicalLevel(32) LEVEL;
   %dcl PCOLORLOOKUPTBL char;
   %PCOLORLOOKUPTBL='pointer';

   dcl DBE_IMCTL_QUERY fixed bin(16) value('00_01'xn);
   dcl DBE_IMCTL_SET fixed bin(16) value('00_02'xn);

   %dcl IMEMODE char;
   %IMEMODE='char(stg(#IMEMODE))';
   dcl 1 #IMEMODE based(null()) unaligned,
         2 lenIMEMODE ULONG,
         2 fIMEMode ULONG,
         2 hIME ULONG,
         2 hModIME ULONG;
   %dcl PIMEMODE char;
   %PIMEMODE='pointer';

   dcl DBE_IMCTL_IMEENABLE fixed bin(16) value('00_01'xn);
   dcl DBE_IMCTL_IMEDISABLE fixed bin(16) value('00_02'xn);
   dcl DBE_IMCTL_IMEMODE fixed bin(16) value('00_04'xn);
   dcl DBE_IMCTL_NOTIMEMODE fixed bin(16) value('00_08'xn);
   dcl DBE_IMCTL_INHERIT_PFRAME fixed bin(16) value('01_00'xn);
   dcl DBE_IMCTL_INTERIMREQUEST fixed bin(16) value('80_00'xn);

   dcl WinDBCSIMEControl entry (
          HAB,
          HWND,
          ULONG,
          PIMEMODE)
          returns(optional byvalue ULONG)
          APIENTRY;

   dcl DBE_MCTL_QUERY fixed bin(16) value('00_01'xn);
   dcl DBE_MCTL_SET fixed bin(16) value('00_02'xn);
   dcl DBE_MCTL_INPUTMODEREQUEST fixed bin(16) value('00_01'xn);
   dcl DBE_MCTL_JAPANREQ fixed bin(16) value('00_01'xn);
   dcl DBE_MCTL_ALPHANUMERIC fixed bin(16) value('00_01'xn);
   dcl DBE_MCTL_KATAKANA fixed bin(16) value('00_02'xn);
   dcl DBE_MCTL_HIRAGANA fixed bin(16) value('00_04'xn);
   dcl DBE_MCTL_SBCSCHAR fixed bin(16) value('00_08'xn);
   dcl DBE_MCTL_DBCSCHAR fixed bin(16) value('00_10'xn);
   dcl DBE_MCTL_ROMAN fixed bin(16) value('00_20'xn);
   dcl DBE_MCTL_NOROMAN fixed bin(16) value('00_40'xn);
   dcl DBE_MCTL_KKCREQ fixed bin(16) value('10_00'xn);
   dcl DBE_MCTL_CP932REQ fixed bin(16) value('00_01'xn);
   dcl DBE_MCTL_KKCENABLE fixed bin(16) value('10_00'xn);
   dcl DBE_MCTL_KKCDISABLE fixed bin(16) value('20_00'xn);
   dcl DBE_MCTL_HANKAKU fixed bin(16) value('00_08'xn);
   dcl DBE_MCTL_ZENKAKU fixed bin(16) value('00_10'xn);
   dcl DBE_MCTL_JAMO fixed bin(16) value('00_02'xn);
   dcl DBE_MCTL_HANGEUL fixed bin(16) value('00_04'xn);
   dcl DBE_MCTL_INTERIMREQUEST fixed bin(16) value('00_80'xn);
   dcl DBE_MCTL_PHONETIC fixed bin(16) value('00_02'xn);
   dcl DBE_MCTL_TSANGJYE fixed bin(16) value('00_04'xn);
   dcl DBE_MCTL_INHERIT_PFRAME fixed bin(16) value('01_00'xn);

   dcl WinDBCSModeControl entry (
          HAB,
          HWND,
          ULONG,
          ULONG,
          PULONG)
          returns(optional byvalue ULONG)
          APIENTRY;
   %dcl FD_DESC char;
   %FD_DESC='char(stg(#FD_DESC))';
   dcl 1 #FD_DESC based(null()) unaligned,
         2 flType ULONG,
         2 str64Desc(64) CHAR;
   %dcl PFD_DESC char;
   %PFD_DESC='pointer';
   dcl WinDBCSLoadFontDriver entry (
          HAB,
          PSZ)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinDBCSUnloadFontDriver entry (
          HAB,
          PSZ)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinDBCSQueryFDDescription entry (
          HAB,
          PSZ,
          PFD_DESC)
          returns(optional byvalue BOOL)
          APIENTRY;

   dcl DBE_FD_DESC_SYSTEM fixed bin(16) value('00_01'xn);
   dcl DBE_FD_DESC_PUBLIC fixed bin(16) value('00_02'xn);
   dcl DBE_FD_DESC_PRIVATE fixed bin(16) value('00_04'xn);
   dcl SC_DBE_IME fixed bin(16) value('80_18'xn);
   dcl SC_DBE_IMESEPARATOR fixed bin(16) value('80_19'xn);

 %end;
 %if IBMC__='Y' %then %do;
   %if CHKHDR__='Y' %then %do;
   %end;
 %end;
