 /********************************************************************/
 /*  NAME - LODVSAM.INC                                              */
 /*                                                                  */
 /*  DESCRIPTION                                                     */
 /*  This file is INCLUDEd in the sample program LODVSAM.PLI. It     */
 /*  is used to describe the attributes of the VSAM dataset.         */
 /*------------------------------------------------------------------*/
 /*    (C) Copyright IBM Corp. 1992. All Rights Reserved.            */
 /*    US Government Users Restricted Rights-- Use, duplication or   */
 /*    disclosure restricted by GSA ADP Schedule Contract with       */
 /*    IBM Corp.                                                     */
 /*                                                                  */
 /*  DISCLAIMER OF WARRANTIES                                        */
 /*    The following enclosed  code is sample code created by IBM   */
 /*    Corporation. This sample code is not part of any standard     */
 /*    IBM product and is provided to you solely for the purpose of  */
 /*    assisting you in the development of your applications.  The   */
 /*    code is provided "AS IS", without warranty of any kind.       */
 /*    IBM shall not be liable for any damages arising out of your   */
 /*    use of the sample code, even if IBM has been advised of the   */
 /*    possibility of such damages.                                  */
 /*                                                                  */
 /*------------------------------------------------------------------*/
 /*  USAGE:                                                          */
 /*    Update the values of the preprocessor variables:              */
 /*      %DS_recfm      : The record format of your VSAM data,       */
 /*                       V for varying F for fixed.                 */
 /*      %DS_recsize    : The maximum record length                  */
 /*      %DS_org        : E for ESDS, K for KSDS, R for RRDS.        */
 /*      %KSDS_keylength: For KSDS the length of key.                */
 /*      %KSDS_keyloc   : The physical location of the primary key.  */
 /*------------------------------------------------------------------*/

   %DS_recfm         = 'F';            /* record format (V/F),       */
   %DS_organization  = 'K';            /* organization (E/K/R)       */
   %DS_recsize       = '30 ';          /* maximum record length      */
   %DS_indexed       = 'Y';            /* is it indexed? (Y/N)       */
   %KSDS_keylength   = '4 ';           /* length of key              */
   %KSDS_keyloc      = '4 ';           /* physical location of key   */
                                       /* in the record.             */
