#---------------------------------------------------------------------------
#
#   Copyright 1996 IBM Corporation
#
#===================================================================

#===================================================================
#This include file is included by the various sample makefiles.
#Define the macros depending on the target specified.
#
# The only valid targets are the following :-
#
#===================================================================

OBJDIR = .
EXEDIR = .

#===================================================================
# First we handle the case where the TARGET_PROC might be defined in a
# mixed case fashion. We convert any case to the PPC so that we can deal
# with just one case (PPC)
#===================================================================

.SUFFIXES:
.SUFFIXES: .rc .res .obj .lst .c .asm .hlp .itl .ipf .idl .ih .h .xih .xh

CFLAGS          =      -Gd- -Se -Re -Ss -Ms -Gm+
CC              =      icc $(CFLAGS)
ODICC           =      icc
DLLCFLAGS       =      -Ge-
AS              =      ml /c /Zm
AFLAGS          =      /Mx -t -z
LFLAGS          =      /NOE /NOD /ALIGN:16 /EXEPACK
LINK            =      icc /B"$(LFLAGS)" $(CFLAGS) -Fe
RC              =      rc
RCFLAGS         =      -r
SOMCOMPILER     =      sc
MSGBIND         =      msgbind
MAPSYM          =      mapsym
OS2LIB          =      os2386.lib
IMPLIB          =      implib
IPF             =      ipfc
LIBS            =      CPPOM30.LIB + OS2386.LIB
STLIBS          =      CPPOS30.LIB + OS2386.LIB
MTLIBS          =      CPPOM30.LIB + OS2386.LIB
DLLLIBS         =      CPPON30.LIB + OS2386.LIB
REXXLIBS        =      REXX.LIB
DMILIBS         =      DMIAPI.LIB
TRACELIBS       =      TRACE.LIB
LFLIBS          =      LFAPI.LIB
FFSTLIBS        =      FFST.LIB
MMLIBS          =      MMPM2.LIB
SOMLIBS         =      SOMTK.LIB
VLIBS           =      CPPON30.LIB + VDH + OS2386
ODLIBS          =      OPENDOC.LIB + OS2CMBSI.LIB
ULSLIBS         =      LIBULS.LIB
LANLIBS         =      NETAPI32.LIB
UPMLIBS         =      UPM32.LIB
DAPIELIBS       =      PMWINX.LIB
ODPUBLIC_LIB    =      ..\PUBLIC
CNTNR_HDRPATH   =      ..\PUBLIC
CNTNR_LIBPATH   =      ..\PUBLIC
OPENDOCIDL      =      .

.c{$(O)}.lst:
    $(CC) -Fc"$(OBJDIR)\$(@B).lst -Fo"$(OBJDIR)\$(@B).obj" $(@B).c

.c{$(O)}.obj :
        $(CC) -c -Fo"$(OBJDIR)\$(@B).obj" $(@B).c

.itl.hlp :
        cc -P $*.itl
        ipfc $*.i
        del $*.i

.ipf{$(REL)}.hlp :
        $(IPF) $(@B).ipf $(EXEDIR)\$(@B).hlp /W3

.rc{$(O)}.res :
        $(RC) $(RCFLAGS) $*.rc $(OBJDIR)\$(@B).res

.idl.h:
        sc -p -mnotc -maddstar -mnoint -S128000 -C128000 -s"h"   $(SCFLAGS) $*.idl

.idl.xh:
        sc -p -mnotc -maddstar -mnoint -S128000 -C128000 -s"xh"  $(SCFLAGS) $*.idl

.idl.ih:
        sc -p -mnotc -maddstar -mnoint -S128000 -C128000 -s"ih"  $(SCFLAGS) $*.idl

.idl.xih:
        sc -p -mnotc -maddstar -mnoint -S128000 -C128000 -s"xih" $(SCFLAGS) $*.idl

.idl.def:
        sc -p -mnotc -maddstar -mnoint -S128000 -C128000 -s"def" $(SCFLAGS) $*.idl

.idl.c:
        sc -p -mnotc -maddstar -mnoint -S128000 -C128000 -s"c"   $(SCFLAGS) $*.idl
