/******************************************************************/
/*                                                                */
/*    Licensed Materials - Property of IBM                        */
/*    5639-A83, 5639-A24 (C) Copyright IBM Corp. 1992,1996.       */
/*    All Rights Reserved.                                        */
/*    US Government Users Restricted Rights-- Use, duplication or */
/*    disclosure restricted by GSA ADP Schedule Contract with     */
/*    IBM Corp.                                                   */
/*                                                                */
/*  DISCLAIMER OF WARRANTIES                                      */
/*    The following enclosed code is sample code created by IBM */
/*    Corporation. This sample code is not part of any standard   */
/*    IBM product and is provided to you solely for the purpose of*/
/*    assisting you in the development of your applications.  The */
/*    code is provided "AS IS", without warranty of any kind.     */
/*    IBM shall not be liable for any damages arising out of your */
/*    use of the sample code, even if IBM has been advised of the */
/*    possibility of such damages.                                */
/*                                                                */
/*                                                                */
/* This is the VisualAge C++ program used to call PL/I procedure  */
/* which has been compiled as object and packaged into a DLL.     */
/* This is to demonstrates C calling PL/I which calls another C.  */
/* The C program will first load the PL/I DLL, query its first    */
/* entry point, then call it.                                     */
/* It will also use printf function to print out message to       */
/* show the progress of each major step during execution.         */
/* At the end, the PL/I DLL will be freed explicitly to ensure    */
/* proper program termination.                                    */
/*                                                                */
/* Syntax:  CSPLICS                                               */
/*                                                                */
/* The PL/I entry name to be called must be CSPLICSP in the DLL.  */
/*                                                                */
/******************************************************************/

#define INCL_DOSMODULEMGR
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>

void (* pa1)();

main()
{
  HMODULE    mh;                     /* DOSLOADMODULE and           */
  PFN        pa;                     /* DOSQUERYPROCADDR service    */
  APIRET     rc;
  char       objnamebuf[100];

  fprintf(stderr,"\nCSPLICS: Started.\n");
  fprintf(stderr, "\nDOSLOADMODULE:  CSPLICSP.\n" );
  rc = DosLoadModule( objnamebuf,          /* Failure object's name */
                      sizeof(objnamebuf),  /* Object names length   */
                      "CSPLICSP",          /* DLL module name       */
                      &mh                  /* DLL handle            */
                    );
  if (rc != 0)
    fprintf(stderr, "\nDOSLOADMODULE: Failure: RC = %ld, Name = %s\n",
            rc,objnamebuf);
  else
  {
    fprintf(stderr, "\nDOSQUERYPROCADDR:  CSPLICSP\n\n" ) ;
    fprintf(stderr, "        Module Handle = %ld \n", mh);
    rc = DosQueryProcAddr( mh,             /* DLL handle            */
                           0,              /* Procedure ordinal #   */
                           "CSPLICSP",     /* Procedure name        */
                           &pa             /* Procedure address     */
                         );
    if (rc != 0)
      fprintf(stderr, "\nDOSQUERYPROCADDR: Failure: RC = %ld\n", rc );
    else
    {
      pa1 = ( void (*)() )pa;
      fprintf(stderr,"\nCSPLICS: Calling PL/I CSPLICSP.\n");
      fflush (stderr);
      pa1();
      fprintf(stderr,"\nCSPLICS: Returning from PL/I CSPLICSP.\n");
      fprintf(stderr,"\nCSPLICS: Releasing CSPLICSP.\n");
      rc = DosFreeModule( mh );               /* DLL handle      */
      if (rc != 0)
        fprintf(stderr, "\nDOSFREEMODULER: Failure: RC = %ld\n", rc );
    }                                  /*  DOSQUERYPROCADDR: rc = 0 */
  }                                    /*  DOSLOADMODULER: rc = 0 */
  fprintf(stderr,"\nCSPLICS: Ended.\n");
} /* main */
