/********************************************************************/
/*                                                                  */
/*    (C) Copyright IBM Corp. 1993. All Rights Reserved.            */
/*    US Government Users Restricted Rights-- Use, duplication or   */
/*    disclosure restricted by GSA ADP Schedule Contract with       */
/*    IBM Corp.                                                     */
/*                                                                  */
/*  DISCLAIMER OF WARRANTIES                                        */
/*    The following enclosed code is sample code created by IBM   */
/*    Corporation. This sample code is not part of any standard     */
/*    IBM product and is provided to you solely for the purpose of  */
/*    assisting you in the development of your applications.  The   */
/*    code is provided "AS IS", without warranty of any kind.       */
/*    IBM shall not be liable for any damages arising out of your   */
/*    use of the sample code, even if IBM has been advised of the   */
/*    possibility of such damages.                                  */
/*                                                                  */
/*                                                                  */
/* Build the testcase for ILC between PL/I and REXX and run it.     */
/*  - The PLIREXX.PLI procedure is compiled and linked into an EXE. */
/*  - The REXXUTIL.DLL is fetched and invoked by the PL/I procedure.*/
/*  - The result of the run is directed to a standard output file.  */
/*                                                                  */
/* Syntax:   BLDPLIRX [p]                                           */
/*             where p is for compiling the PL/I procedure before   */
/*             running PLIREXX.EXE program if necessary.            */
/*                                                                  */
/********************************************************************/

parse upper arg type

 if ( type = 'P' ) then    /* Compile PL/I procedure before running.*/
  do
    ' PLI PLIREXX '
    if rc \= 0 then
      exit(1)
    'ilink PLIREXX  /DOSSEG /pm:vio /packd /packc /se:200 /co /noe,PLIREXX.EXE,load.map,ibmos20i+hepos20i,nul.def'
    if rc \= 0 then
      exit(1)
  end

  'PLIREXX'
exit
