/*************************************************************
*                                                            *
*  lpexapi.h: include file for external C/C++ LPEX commands. *
*                                                            *
**************************************************************
*                                                            *
*         (C) Copyright IBM Corporation 1993, 1996           *
*                                                            *
*************************************************************/

#ifndef LPEXAPI_H
#define LPEXAPI_H

#ifdef __cplusplus
   extern "C" {
#endif

/*-----------------------------------------------------------------*/
#include "lpexcpat.h"

#define _cinit
#define _cterm
/*-----------------------------------------------------------------*/

#define MAXLEN   2500                            /* maximum element text size */
#define MAXQUERY 2800                      /* maximum length for query result */


/* LPEX uses unsigned char throughout */
#ifndef uchr
   #ifdef __cplusplus
   #define uchr char
   #else
   #define uchr unsigned char
   #endif
#endif


/* LP_COMMAND - execute an LPEX command.  mp2 is MPFROM2SHORT(a, b) */
/* where "a" is either LP_COMMAND_INTERNAL or LP_COMMAND_EXTERNAL,  */
/*   and "b" is either LP_COMMAND_WINDOWED or LP_COMMAND_CURRENT.   */
#ifndef LP_COMMAND
#define LP_COMMAND            0x1002       /* note: keep in sync with lxpm.h! */
#define LP_COMMAND_EXTERNAL ((short)0)
#define LP_COMMAND_INTERNAL ((short)1)
#define LP_COMMAND_WINDOWED ((short)0)
#define LP_COMMAND_CURRENT  ((short)1)
#endif /*LP_COMMAND*/

int   __cdecl LpexEntry(uchr*);              /* Command entry point */
int   __cdecl LpexExit(uchr*);               /* Command unlink entry point */
void  __cdecl LpexDocExit(int);              /* Document exit entry point */

char* __cdecl LpexProfile(void);             /* pathname for LPEX.ini */
int   __cdecl LpexCommand(const uchr*);      /* run an LPEX command */
int   __cdecl LpexCall(const uchr*, const uchr*);    /* call an LPEX function */
uchr* __cdecl LpexQuery(const uchr*, uchr*); /* query an LPEX item */

/* storage allocation/freeing done by LPEX */
uchr* __cdecl LpexAlloc(int);                /* allocate LPEX storage */
int   __cdecl LpexFree(uchr*);               /* free LPEX allocated storage */

#define LpexMsg(a)          LpexCall("msg",a)

/* the following functions support the user word */
int   __cdecl LpexQueryUserLink(long int scope, void** pObjectPtr);
int   __cdecl LpexSetUserLink(long int scope, void* object);
int   __cdecl LpexFindUserLink(long int scope, void* object);

/* valid values of scope: */
#define LPEX_DOCUMENT 1
#define LPEX_VIEW     2
#define LPEX_ELEMENT  3

/* the following extend the fonts recognized by GML */
int   __cdecl LpexQueryGMLFonts(uchr*);      /* query special GML fonts  */
int   __cdecl LpexAddGMLFonts(uchr*);        /* add to special GML fonts */

/* the following are fast path entry to some common functions */
int   __cdecl LpexNext(const uchr*);         /* NEXT                     */
int   __cdecl LpexPrev(const uchr*);         /* PREV                     */
int   __cdecl LpexInsert(const uchr*);       /* INSERT text              */
int   __cdecl LpexQueryRawText(uchr*);       /* query RAWTEXT            */
int   __cdecl LpexQueryText(uchr*);          /* query CONTENT            */
int   __cdecl LpexSetText(const uchr*);      /* set   CONTENT            */
int   __cdecl LpexQueryFonts(uchr*);         /* query FONTS              */
int   __cdecl LpexSetFonts(const uchr*);     /* set   FONTS              */
int   __cdecl LpexQueryCharModes(uchr*);     /* query MODES              */
int   __cdecl LpexQueryClass(unsigned long*);/* query CLASS              */
int   __cdecl LpexSetClass(unsigned long);   /* set   CLASS              */

int   __cdecl LpexQueryElementState(unsigned long*); /* query ELESTATE:          */
#define LPEX_ELE_VISIBLE   (0x80000000)        /*   visible element        */
#define LPEX_ELE_SHOW      (0x40000000)        /*   show element           */
#define LPEX_ELE_PROTECTED (0x20000000)        /*   protected element      */

/* The following should be called before and after a modal dialog or */
/* message box is presented to the user.  Pass in TRUE before the    */
/* dialog is brought up and FALSE after the dialog is dismissed.     */
void __cdecl LpexDialogUp(unsigned long);

/* Note:  The following is provided *for compatibility */
/* only*.  It may not be available in future releases! */
unsigned long /*HAB*/__cdecl LpexHab(void);  /* obtain the hab           */
void*                __cdecl LpexRock(void); /* obtain the rock pointer  */

#ifdef __cplusplus
   }
#endif

#endif /* LPEXAPI_H */
