
/*
 * This file was generated by the SOM Compiler.
 * FileName: eman.h.
 * Generated using:
 *     SOM Precompiler somipc: 2.29.1.17
 *     SOM Emitter emith: 2.47
 */

/*
 *    COMPONENT_NAME: somu
 * 
 *    ORIGINS: 27
 * 
 * 
 *    10H9767, 10H9769  (C) COPYRIGHT International Business Machines Corp. 1992,1994
 *    All Rights Reserved
 *    Licensed Materials - Property of IBM
 *    US Government Users Restricted Rights - Use, duplication or
 *    disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 * 
 */


#ifndef SOM_SOMEEMan_h
#define SOM_SOMEEMan_h


#include <som.h>

/*
 * -- This emitter treats Method Tokens as Thunks by default.
 * -- Use the sc modifier "nothunks" to change this default
 */
#undef somresolve_
#define somresolve_(obj,mToken) ((somMethodProc*)((void)obj, mToken))

/*
 * Define the class name as an object type
 */
#ifndef SOMEEMan
#define SOMEEMan SOMObject
#endif
/*
 *  The Event Manager class (EMan for short) is used to handle several input
 *  events. The main purpose of this class is to provide a service that can do
 *  a blocked (or timed) wait on several event sources concurrently.  Typically,
 *  in a main program,  one registers an interest in an event type with EMan and
 *  specifies a callback (a procedure or a method) to be invoked when the event
 *  of interest occurs. After all the necessary registrations are done, the main
 *  program is ended by a call to process events in EMan. This call is non-returning.
 *  Eman then waits on multiple registered sources of events. The application is then
 *  completely event driven. I.E., it does something only when an event occurs.
 *  The control returns to EMan after processing each event. Further registrations
 *  can be done inside of callback routines. So also unregistrations.
 * 
 *  AIX Specifics:
 *  On AIX this event manager supports Timer, Sink (any file, pipe,
 *  socket and Message Queue), Client and WorkProc events.
 * 
 *  OS/2 Specifics:
 *  On OS/2 this event manager supports Timer, Sink(sockets only). Client and
 *  WorkProc events.
 *  To cope with multi-threaded applications on OS/2, the event manager
 *  methods are mutually exclusive (i.e., at any time only one thread can be
 *  executing inside of EMan).
 *  If an application thread needs to stop EMan from running (i.e., achieve
 *  mutual exclusion with EMan), it can use the two methods someGetEmanSem
 *  and someReleaseEManSem to acquire and release EMan semaphore(s).
 *  On AIX, at present, since AIX does not support threads calling these two methods
 *  has no effect.
 */
#include <somobj.h>

/*
 * Start of bindings for IDL types
 */

#ifndef SOMClass
    #define SOMClass SOMObject
#endif /* SOMClass */
#ifndef SOMEEvent
    #define SOMEEvent SOMObject
#endif /* SOMEEvent */
#ifndef SOMEClientEvent
    #define SOMEClientEvent SOMObject
#endif /* SOMEClientEvent */
#ifndef SOMEEMRegisterData
    #define SOMEEMRegisterData SOMObject
#endif /* SOMEEMRegisterData */

/*
 * End of bindings for IDL types.
 */

/*
 * Passthru lines: File: "C.h", "after"
 */
#include <emtypes.h>

#define SOMEEMan_MajorVersion 2
#define SOMEEMan_MinorVersion 1

/*
 * External name shortening if required
 */
#ifdef SOM_USE_SHORT_EXTERNAL_NAMES
#define SOMEEManNewClass c
#pragma linkage(c, system)
#define SOMEEManClassData d
#define SOMEEManCClassData x
#endif /* SOM_USE_SHORT_EXTERNAL_NAMES */

/*
 * Include the metaclass file
 */
#ifndef SOM_SOMMSingleInstance_h
#include <snglicls.h>
#endif
/*--------------Migration------------*/
#define SOMEEMan_classObj SOMEEManClassData.classObject
#define _SOMEEMan SOMEEMan_classObj

/*
 * Declare the class creation procedure
 */
SOMEXTERN SOMClass * SOMLINK SOMEEManNewClass(integer4 somtmajorVersion,
		integer4 somtminorVersion);
#pragma linkage(SOMEEManNewClass, system)

/*
 * Declare the class data structure
 */
SOMEXTERN struct SOMEEManClassDataStructure {
	SOMClass *classObject;
	somMToken someGetEManSem;
	somMToken someReleaseEManSem;
	somMToken someChangeRegData;
	somMToken someProcessEvent;
	somMToken someProcessEvents;
	somMToken someQueueEvent;
	somMToken someRegister;
	somMToken someRegisterEv;
	somMToken someRegisterProc;
	somMToken someShutdown;
	somMToken someUnRegister;
} SOMDLINK SOMEEManClassData;

/*
 * Declare the C specific class data structure
 */
SOMEXTERN struct SOMEEManCClassDataStructure {
	somMethodTabs parentMtab;
	somDToken instanceDataToken;
} SOMDLINK SOMEEManCClassData;

/*
 * New and Renew macros for SOMEEMan
 */
#define SOMEEManNew() \
   ( _SOMEEMan ? \
	_somNew(_SOMEEMan) \
	: ( SOMEEManNewClass(\
		SOMEEMan_MajorVersion, \
		SOMEEMan_MinorVersion),\
	   _somNew(_SOMEEMan)))
#define SOMEEManRenew(buf) \
   ( _SOMEEMan ? \
	_somRenew(_SOMEEMan, buf) \
	: ( SOMEEManNewClass(\
		SOMEEMan_MajorVersion, \
		SOMEEMan_MinorVersion),\
	   _somRenew(_SOMEEMan, buf)))

/*
 * Override method: somInit
 */
#define SOMEEMan_somInit(somSelf) \
	SOMObject_somInit(somSelf)

/*
 * Override method: somUninit
 */
#define SOMEEMan_somUninit(somSelf) \
	SOMObject_somUninit(somSelf)

/*
 * New Method: someGetEManSem
 */
typedef void   SOMLINK somTP_SOMEEMan_someGetEManSem(SOMEEMan *somSelf, Environment *ev);
#pragma linkage(somTP_SOMEEMan_someGetEManSem, system)
typedef somTP_SOMEEMan_someGetEManSem *somTD_SOMEEMan_someGetEManSem;
/*
 *  Gets a semaphore to achieve mutual exclusion with EMan's activity.
 *  Callers should not hold this semaphore for too long since it essentially
 *  stops EMan activity for that duration.
 */
#define somMD_SOMEEMan_someGetEManSem "::SOMEEMan::someGetEManSem"
#define SOMEEMan_someGetEManSem(somSelf,ev) \
    (SOM_Resolve(somSelf, SOMEEMan, someGetEManSem) \
	(somSelf,ev))
#ifndef SOMGD_someGetEManSem
    #if (defined(_someGetEManSem) || defined(__someGetEManSem))
        #undef _someGetEManSem
        #undef __someGetEManSem
        #define SOMGD_someGetEManSem 1
    #else
        #define _someGetEManSem SOMEEMan_someGetEManSem
    #endif /* _someGetEManSem */
#endif /* SOMGD_someGetEManSem */

/*
 * New Method: someReleaseEManSem
 */
typedef void   SOMLINK somTP_SOMEEMan_someReleaseEManSem(SOMEEMan *somSelf, Environment *ev);
#pragma linkage(somTP_SOMEEMan_someReleaseEManSem, system)
typedef somTP_SOMEEMan_someReleaseEManSem *somTD_SOMEEMan_someReleaseEManSem;
/*
 *  Release the semaphore obtained by someGetEManSem.
 */
#define somMD_SOMEEMan_someReleaseEManSem "::SOMEEMan::someReleaseEManSem"
#define SOMEEMan_someReleaseEManSem(somSelf,ev) \
    (SOM_Resolve(somSelf, SOMEEMan, someReleaseEManSem) \
	(somSelf,ev))
#ifndef SOMGD_someReleaseEManSem
    #if (defined(_someReleaseEManSem) || defined(__someReleaseEManSem))
        #undef _someReleaseEManSem
        #undef __someReleaseEManSem
        #define SOMGD_someReleaseEManSem 1
    #else
        #define _someReleaseEManSem SOMEEMan_someReleaseEManSem
    #endif /* _someReleaseEManSem */
#endif /* SOMGD_someReleaseEManSem */

/*
 * New Method: someChangeRegData
 */
typedef void   SOMLINK somTP_SOMEEMan_someChangeRegData(SOMEEMan *somSelf, Environment *ev, 
		long registrationId, 
		SOMEEMRegisterData* registerData);
#pragma linkage(somTP_SOMEEMan_someChangeRegData, system)
typedef somTP_SOMEEMan_someChangeRegData *somTD_SOMEEMan_someChangeRegData;
/*
 *  Change the registration data associated with the specified id.
 *  This id must have been returned by EMan in a previous Register call.
 */
#define somMD_SOMEEMan_someChangeRegData "::SOMEEMan::someChangeRegData"
#define SOMEEMan_someChangeRegData(somSelf,ev,registrationId,registerData) \
    (SOM_Resolve(somSelf, SOMEEMan, someChangeRegData) \
	(somSelf,ev,registrationId,registerData))
#ifndef SOMGD_someChangeRegData
    #if (defined(_someChangeRegData) || defined(__someChangeRegData))
        #undef _someChangeRegData
        #undef __someChangeRegData
        #define SOMGD_someChangeRegData 1
    #else
        #define _someChangeRegData SOMEEMan_someChangeRegData
    #endif /* _someChangeRegData */
#endif /* SOMGD_someChangeRegData */

/*
 * New Method: someProcessEvent
 */
typedef void   SOMLINK somTP_SOMEEMan_someProcessEvent(SOMEEMan *somSelf, Environment *ev, 
		unsigned long mask);
#pragma linkage(somTP_SOMEEMan_someProcessEvent, system)
typedef somTP_SOMEEMan_someProcessEvent *somTD_SOMEEMan_someProcessEvent;
/*
 *  Process one event. This call is non-blocking. If there are no events to
 *  process it returns immediately. The mask specifies what events to process.
 *  The mask is formed by ORing the bit constants specified in eventmsk.h
 *  For example, to processs Timer and Sink events only one would specify
 *  the mask as:  EMProcessTimerEvent | EMProcessSinkEvent
 */
#define somMD_SOMEEMan_someProcessEvent "::SOMEEMan::someProcessEvent"
#define SOMEEMan_someProcessEvent(somSelf,ev,mask) \
    (SOM_Resolve(somSelf, SOMEEMan, someProcessEvent) \
	(somSelf,ev,mask))
#ifndef SOMGD_someProcessEvent
    #if (defined(_someProcessEvent) || defined(__someProcessEvent))
        #undef _someProcessEvent
        #undef __someProcessEvent
        #define SOMGD_someProcessEvent 1
    #else
        #define _someProcessEvent SOMEEMan_someProcessEvent
    #endif /* _someProcessEvent */
#endif /* SOMGD_someProcessEvent */

/*
 * New Method: someProcessEvents
 */
typedef void   SOMLINK somTP_SOMEEMan_someProcessEvents(SOMEEMan *somSelf, Environment *ev);
#pragma linkage(somTP_SOMEEMan_someProcessEvents, system)
typedef somTP_SOMEEMan_someProcessEvents *somTD_SOMEEMan_someProcessEvents;
/*
 *  Process infinite events. Does not return. Loops forever waiting for events
 *  and dispatching events. The only way this can be broken is by calling
 *  someShutdown in a callback.
 */
#define somMD_SOMEEMan_someProcessEvents "::SOMEEMan::someProcessEvents"
#define SOMEEMan_someProcessEvents(somSelf,ev) \
    (SOM_Resolve(somSelf, SOMEEMan, someProcessEvents) \
	(somSelf,ev))
#ifndef SOMGD_someProcessEvents
    #if (defined(_someProcessEvents) || defined(__someProcessEvents))
        #undef _someProcessEvents
        #undef __someProcessEvents
        #define SOMGD_someProcessEvents 1
    #else
        #define _someProcessEvents SOMEEMan_someProcessEvents
    #endif /* _someProcessEvents */
#endif /* SOMGD_someProcessEvents */

/*
 * New Method: someQueueEvent
 */
typedef void   SOMLINK somTP_SOMEEMan_someQueueEvent(SOMEEMan *somSelf, Environment *ev, 
		SOMEClientEvent* event);
#pragma linkage(somTP_SOMEEMan_someQueueEvent, system)
typedef somTP_SOMEEMan_someQueueEvent *somTD_SOMEEMan_someQueueEvent;
/*
 *  Used to be: void someQueueEvent(inout SOMEClientEvent event);
 *  Enqueue the specified client event
 */
#define somMD_SOMEEMan_someQueueEvent "::SOMEEMan::someQueueEvent"
#define SOMEEMan_someQueueEvent(somSelf,ev,event) \
    (SOM_Resolve(somSelf, SOMEEMan, someQueueEvent) \
	(somSelf,ev,event))
#ifndef SOMGD_someQueueEvent
    #if (defined(_someQueueEvent) || defined(__someQueueEvent))
        #undef _someQueueEvent
        #undef __someQueueEvent
        #define SOMGD_someQueueEvent 1
    #else
        #define _someQueueEvent SOMEEMan_someQueueEvent
    #endif /* _someQueueEvent */
#endif /* SOMGD_someQueueEvent */

/*
 * New Method: someRegister
 */
typedef long   SOMLINK somTP_SOMEEMan_someRegister(SOMEEMan *somSelf, Environment *ev, 
		SOMEEMRegisterData* registerData, 
		SOMObject* targetObject, 
		string targetMethod, 
		void* targetData);
#pragma linkage(somTP_SOMEEMan_someRegister, system)
typedef somTP_SOMEEMan_someRegister *somTD_SOMEEMan_someRegister;
/*
 *  Register the object/method pair with EMan given the specified 'registerData'.
 */
#define somMD_SOMEEMan_someRegister "::SOMEEMan::someRegister"
#define SOMEEMan_someRegister(somSelf,ev,registerData,targetObject,targetMethod,targetData) \
    (SOM_Resolve(somSelf, SOMEEMan, someRegister) \
	(somSelf,ev,registerData,targetObject,targetMethod,targetData))
#ifndef SOMGD_someRegister
    #if (defined(_someRegister) || defined(__someRegister))
        #undef _someRegister
        #undef __someRegister
        #define SOMGD_someRegister 1
    #else
        #define _someRegister SOMEEMan_someRegister
    #endif /* _someRegister */
#endif /* SOMGD_someRegister */

/*
 * New Method: someRegisterEv
 */
typedef long   SOMLINK somTP_SOMEEMan_someRegisterEv(SOMEEMan *somSelf, Environment *ev, 
		SOMEEMRegisterData* registerData, 
		SOMObject* targetObject, 
		Environment* callbackEv, 
		string targetMethod, 
		void* targetData);
#pragma linkage(somTP_SOMEEMan_someRegisterEv, system)
typedef somTP_SOMEEMan_someRegisterEv *somTD_SOMEEMan_someRegisterEv;
/*
 *  Register the object/method pair together with the callback Environment parameter
 *  with EMan given the specified 'registerData'.
 */
#define somMD_SOMEEMan_someRegisterEv "::SOMEEMan::someRegisterEv"
#define SOMEEMan_someRegisterEv(somSelf,ev,registerData,targetObject,callbackEv,targetMethod,targetData) \
    (SOM_Resolve(somSelf, SOMEEMan, someRegisterEv) \
	(somSelf,ev,registerData,targetObject,callbackEv,targetMethod,targetData))
#ifndef SOMGD_someRegisterEv
    #if (defined(_someRegisterEv) || defined(__someRegisterEv))
        #undef _someRegisterEv
        #undef __someRegisterEv
        #define SOMGD_someRegisterEv 1
    #else
        #define _someRegisterEv SOMEEMan_someRegisterEv
    #endif /* _someRegisterEv */
#endif /* SOMGD_someRegisterEv */

/*
 * New Method: someRegisterProc
 */
typedef long   SOMLINK somTP_SOMEEMan_someRegisterProc(SOMEEMan *somSelf, Environment *ev, 
		SOMEEMRegisterData* registerData, 
		EMRegProc* targetProcedure, 
		void* targetData);
#pragma linkage(somTP_SOMEEMan_someRegisterProc, system)
typedef somTP_SOMEEMan_someRegisterProc *somTD_SOMEEMan_someRegisterProc;
/*
 *  Register the procedure with EMan given the specified 'registerData'.
 */
#define somMD_SOMEEMan_someRegisterProc "::SOMEEMan::someRegisterProc"
#define SOMEEMan_someRegisterProc(somSelf,ev,registerData,targetProcedure,targetData) \
    (SOM_Resolve(somSelf, SOMEEMan, someRegisterProc) \
	(somSelf,ev,registerData,targetProcedure,targetData))
#ifndef SOMGD_someRegisterProc
    #if (defined(_someRegisterProc) || defined(__someRegisterProc))
        #undef _someRegisterProc
        #undef __someRegisterProc
        #define SOMGD_someRegisterProc 1
    #else
        #define _someRegisterProc SOMEEMan_someRegisterProc
    #endif /* _someRegisterProc */
#endif /* SOMGD_someRegisterProc */

/*
 * New Method: someShutdown
 */
typedef void   SOMLINK somTP_SOMEEMan_someShutdown(SOMEEMan *somSelf, Environment *ev);
#pragma linkage(somTP_SOMEEMan_someShutdown, system)
typedef somTP_SOMEEMan_someShutdown *somTD_SOMEEMan_someShutdown;
/*
 *  Shutdown EMan event loop. (i.e., makes the someProcessEvents return!)
 */
#define somMD_SOMEEMan_someShutdown "::SOMEEMan::someShutdown"
#define SOMEEMan_someShutdown(somSelf,ev) \
    (SOM_Resolve(somSelf, SOMEEMan, someShutdown) \
	(somSelf,ev))
#ifndef SOMGD_someShutdown
    #if (defined(_someShutdown) || defined(__someShutdown))
        #undef _someShutdown
        #undef __someShutdown
        #define SOMGD_someShutdown 1
    #else
        #define _someShutdown SOMEEMan_someShutdown
    #endif /* _someShutdown */
#endif /* SOMGD_someShutdown */

/*
 * New Method: someUnRegister
 */
typedef void   SOMLINK somTP_SOMEEMan_someUnRegister(SOMEEMan *somSelf, Environment *ev, 
		long registrationId);
#pragma linkage(somTP_SOMEEMan_someUnRegister, system)
typedef somTP_SOMEEMan_someUnRegister *somTD_SOMEEMan_someUnRegister;
/*
 *  Unregister the data associated with the specified 'registrationId' within EMan
 */
#define somMD_SOMEEMan_someUnRegister "::SOMEEMan::someUnRegister"
#define SOMEEMan_someUnRegister(somSelf,ev,registrationId) \
    (SOM_Resolve(somSelf, SOMEEMan, someUnRegister) \
	(somSelf,ev,registrationId))
#ifndef SOMGD_someUnRegister
    #if (defined(_someUnRegister) || defined(__someUnRegister))
        #undef _someUnRegister
        #undef __someUnRegister
        #define SOMGD_someUnRegister 1
    #else
        #define _someUnRegister SOMEEMan_someUnRegister
    #endif /* _someUnRegister */
#endif /* SOMGD_someUnRegister */
#ifndef SOM_DONT_USE_INHERITED_MACROS
#define SOMEEMan_somDefaultInit SOMObject_somDefaultInit
#define SOMEEMan_somDestruct SOMObject_somDestruct
#define SOMEEMan_somDefaultCopyInit SOMObject_somDefaultCopyInit
#define SOMEEMan_somDefaultAssign SOMObject_somDefaultAssign
#define SOMEEMan_somDefaultConstCopyInit SOMObject_somDefaultConstCopyInit
#define SOMEEMan_somDefaultVCopyInit SOMObject_somDefaultVCopyInit
#define SOMEEMan_somDefaultConstVCopyInit SOMObject_somDefaultConstVCopyInit
#define SOMEEMan_somDefaultConstAssign SOMObject_somDefaultConstAssign
#define SOMEEMan_somDefaultVAssign SOMObject_somDefaultVAssign
#define SOMEEMan_somDefaultConstVAssign SOMObject_somDefaultConstVAssign
#define SOMEEMan_somFree SOMObject_somFree
#define SOMEEMan_somGetClass SOMObject_somGetClass
#define SOMEEMan_somGetClassName SOMObject_somGetClassName
#define SOMEEMan_somGetSize SOMObject_somGetSize
#define SOMEEMan_somIsA SOMObject_somIsA
#define SOMEEMan_somIsInstanceOf SOMObject_somIsInstanceOf
#define SOMEEMan_somRespondsTo SOMObject_somRespondsTo
#define SOMEEMan_somDispatch SOMObject_somDispatch
#define SOMEEMan_somClassDispatch SOMObject_somClassDispatch
#define SOMEEMan_somCastObj SOMObject_somCastObj
#define SOMEEMan_somResetObj SOMObject_somResetObj
#define SOMEEMan_somDispatchV SOMObject_somDispatchV
#define SOMEEMan_somDispatchL SOMObject_somDispatchL
#define SOMEEMan_somDispatchA SOMObject_somDispatchA
#define SOMEEMan_somDispatchD SOMObject_somDispatchD
#define SOMEEMan_somPrintSelf SOMObject_somPrintSelf
#define SOMEEMan_somDumpSelf SOMObject_somDumpSelf
#define SOMEEMan_somDumpSelfInt SOMObject_somDumpSelfInt
#endif /* SOM_DONT_USE_INHERITED_MACROS */

#endif       /* SOM_SOMEEMan_h */
