/*-------------------------------------------------------------------------*/
/* OS2APARS.CMD                                                            */
/* Searches current or working directory for available OS2APARS INF files. */
/* The names of the files that are found will be combined to form the      */
/* parameter to be passed to the OS/2 View command.                        */
/*                                                                         */
/* Brent Allen - IBM Personal Systems Competency Center    Southlake, TX   */
/* (c) Copyright International Business Machines Corp., 1994-95            */
/*-------------------------------------------------------------------------*/
If RxFuncQuery('SysFileTree') Then
  Call RxFuncAdd 'SysFileTree','RexxUtil','SysFileTree'

aparinf. = ''
Call SysFileTree 'OS2APARS.INF','APARINF','FO'
If aparinf.0 > 0 Then
  inf_list = 'OS2APARS'
Else
  inf_list = ''

Call SysFileTree '??AP*R?.INF','APARINF','FO'
If aparinf.0 > 0 Then Do
  Do loop = 1 to aparinf.0
    aparinf.loop = FILESPEC('N',aparinf.loop)
    End

  /* Sort the filenames to keep the files in the right sequence */
  Do loop1 = 1 to aparinf.0 - 1
    Do loop2 = loop1+1 to aparinf.0
      If aparinf.loop1 > aparinf.loop2 Then Do
        temp = aparinf.loop1
        aparinf.loop1 = aparinf.loop2
        aparinf.loop2 = temp
        End
      End
    End

  Do loop = 1 to aparinf.0
    inf_list = inf_list'+'aparinf.loop
    End
  inf_list = STRIP(inf_list,'L','+')   /* Remove any leading '+' */
  '@VIEW' inf_list
  End
Else
  Say 'No OS2APAR INF files were found in the current directory.'
Exit
