/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* Format a PM32-bit WND */
/* 9/5/97 fixed possible acidental exponential comparison */
signal on halt name haltexit
numeric digits 18

arg wnd .

if wnd='' then do
   say 'WND <pwnd>|<hwnd>'
   exit 0
end /* do */

if left(wnd,1)=8  then do
   address df 'cmd output dd %(dw(phandletable))+20+'substr(wnd,2)'*8 L1'
   o=output.0-1
   pwnd=word(output.o,2)
end /* do */
else pwnd=wnd

pmver=pmver()
if '#'pmver='#00000084' then call fmtwnd(pwnd)
else if '#'pmver='#00000080' then call fmtwnd1(pwnd)
else say 'PM version not supported'

haltexit: exit 0


pmver: procedure
magic_offset=value('DF_PMVER',,'OS2ENVIRONMENT')
say 'Warning: PMMERGE symbols assumed and current slot is a PM thread/app.'
say ''
if magic_offset='' then do
   address df "cmd output s %(dw(pmqshell)) l100 'S' 'T' "
   o=output.0-1
   magic=word(output.o,1)
   address df 'cmd output ?' magic '- %(dw(pmqshell))'
   o=output.0-1
   magic_offset=substr(output.o,2)
   x=value('DF_PMVER',magic_offset,'OS2ENVIRONMENT')
end
return magic_offset


fmtwnd: procedure
arg pwnd

say ' '
address df 'cmd output dd' pwnd 'L18'
o=output.0-6
parse var output.o addr d0 d1 d2 d3 .
say '+00 Next                        ' d0
say '+04 Parent                      ' d1
say '+08 Child                       ' d2
say '+0c Owner                       ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
w0=right(d0,4)
w1=left(d0,4)
w2=right(d1,4)
w3=left(d1,4)
say '+10 Window Rectangle            ' '('w0','w1') ('w2','w3')'
say '+18 Style                       ' d2
say '+1c id                          ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+20 pCLS                        ' d0
b0=right(d1,2)
b1=substr(d1,5,2)
w2=left(d1,4)
say '+24 fs                          ' b0
say '+25 region destroy count        ' b1
say '+26 Update Region               ' w2
say '+28 pMQ                         ' d2
say '+2c hWND                        ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+30 16-bit window proc?         ' d0
if '#'d0='#00000000' then wp=left(d1,4)':'right(d1,4)
else wp=d1
say '+34 Window Procedure            ' wp
say '+38 Thunk Procedure             ' d2
say '+3c reserved for porthole       ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+40 pPresentation Parameters    ' d0
say '+44 pWND Current Focus Frame    ' d1
say '+48 reserved for Shell          ' d2
say '+4c reserved for Pen            ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+50 Control Instance Data       ' d0
say '+54 BIDI attributes             ' d1
say '+58 BIDI status                 ' d2
say '+5c keyboard layer              ' d3
return


fmtwnd1: procedure
arg pwnd

say ' '
address df 'cmd output dd' pwnd 'L1f'
o=output.0-8
parse var output.o addr d0 d1 d2 d3 .
say '+00 Next                        ' d0
say '+04 Parent                      ' d1
say '+08 Child                       ' d2
say '+0c Owner                       ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
w0=right(d0,4)
w1=left(d0,4)
w2=right(d1,4)
w3=left(d1,4)
say '+10 Window Rectangle            ' '('w0','w1') ('w2','w3')'
say '+18 Style                       ' d2
say '+1c id                          ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+20 pCLS                        ' d0
b0=right(d1,2)
b1=substr(d1,5,2)
w2=left(d1,4)
say '+24 fs                          ' b0
say '+25 region destroy count        ' b1
say '+26 Update Region               ' w2
say '+28 pMQ                         ' d2
say '+2c hWND                        ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+30 16-bit window proc?         ' d0
if d0='00000000' then wp=left(d1,4)':'right(d1,4)
else wp=d1
say '+34 Window Procedure            ' wp
say '+38 Thunk Procedure             ' d2
say '+3c reserved for porthole       ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+40 pPresentation Parameters    ' d0
say '+44 pWND Current Focus Frame    ' d1
say '+48 reserved for Shell          ' d2
say '+4c reserved for Pen            ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+50 Control Instance Data       ' d0
say '+54 Prop Data pointer           ' d1
say '+58 DAX data pointer            ' d2
say '+5c BIDI attributes             ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+60 BIDI status                 ' d0
say '+64 keyboard layer              ' d1
say '+68 Frame KBD Status            ' d2
say '+6c IM window handle            ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+70 IM private data             ' d0
say '+74 Open Doc VisClip SRGN       ' right(d1,4)
say '+76 State                       ' right(d2,4) || left(d1,4)
return
