/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* Format a PM32 SQMSG structure */
signal on halt name haltexit

arg psqmsg .

if psqmsg='' then do
   say 'SQMSG <psqmsg>'
   exit 0
end /* do */

call fmtsqmsg(psqmsg)

haltexit: exit 0


fmtsqmsg: procedure
arg psqmsg .

say ' '
address df 'cmd output dd' psqmsg 'L8'

o=output.0-2
parse var output.o addr d0 d1 d2 d3 .
say '+00 msg                         ' d0
say '+04 mp1                         ' d1
say '+08 mp2                         ' d2
say '+0c time                        ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+10 monitor flags               ' right(d0,2)
say '+11 scan code                   ' substr(d0,5,2)
say '+12 xlated char                 ' substr(d0,3,2)
say '+14 xlated scan code            ' left(d0,2)
say '+14 DBCS shift state            ' right(d1,4)
say '+16 current shift state         ' left(d1,4)
say '+18 time                        ' d2
say '+1c kbd dd flags                ' right(d3,4)

return
