/*.im seciuo*/
/* IBM Internal Use Only.                                            */
/*.im coibm*/
/* (C) Copyright IBM Corp. 1993                                      */
/* (C) Copyright IBM Information Solutions 1993                      */
/*                                                                   */
/*rexx*/
/*Author: Richard Moore / Dieter Damm                Version: 1.0    */
/* format Record Lock Record                                         */
/* 1 required parameter: adr (sel:offs)                              */
/*                                                                   */
/* 10/01/97 if user types ?, spit out help                           */
/*                                                                   */

trace 'o'
numeric digits 12 

arg adr

if (adr='?' |,
   adr='/?' |,
   adr=' '  |,
   adr='/h' |,
   adr='/H') then do
   say "Format Record Lock Record (RLR)"
   say " "
   say 'Syntax: %RLR sel:offs '
   say ' '
   exit 0
end  /* Do */

if adr = '' then exit
position=pos(':',adr)
if position=0 then do
  say' Invalid sel:ofs given'
  exit 0
end
sel=substr(adr,1,position-1)
ofs=substr(adr,position+1,length(adr)-position)
address df 'cmd output ln 'gdt_rlr
o=output.0-1
rlrsel=right(word(output.o,1),8)
if rlrsel='Expression' then do
  say 'OS2KRNL symbols not loaded !'
  exit
end

address df 'cmd output dl 'rlrsel
o=output.0-1
rlrlim=right(word(output.o,4),8)
linaddr=substr(word(output.o,3),5,8)

say (ofs)
say x2d(linaddr)
linaddr=x2d(linaddr)+x2d(ofs)
linaddr='%'d2x(linaddr)

if x2d(sel) <> x2d(rlrsel) then do
  say 'Selector ' sel  'is not a RLR selector !'
  exit
end

if x2d(ofs) > x2d(rlrlim) then do
  say ' offset of RLR segment exceeds limit !'
  exit
end

say ' '
say ' --------- Formatting Record Lock Record (RLR) at ' adr ' ----------------'
say ' '

address df 'cmd output db 'linaddr '+16'
o=output.0-1
flags=word(output.o,2)
if BITAND(flags,'01') = '00' then str=' -> RLR_EXCLUSIVE'
if BITAND(flags,'01') = '01' then str=' -> RLR_SHARED'
if BITAND(flags,'02') = '02' then str=' -> RLR_WAITING'
if BITAND(flags,'04') = '04' then str=' -> RLR_CANCELPLOCK'


call format "rlr_next","+00",linaddr,"W", '16 bit offset to next rlr'
call format "rlr_prev ","+02",linaddr,"W","16 bit offset to previous rlr "
call format "rlr_fba","+04",linaddr,"D","offset of first byte of locked record"
call format "rlr_lba","+08",linaddr,"D","offset of last byte of locked record "
call format "rlr_sptr ","+0c",linaddr,"D","16:16 far pointer to SFT"
call format "rlr_UID","+10",linaddr,"W","lock issuer's user id"
call format "rlr_PID","+12",linaddr,"W","lock issuer's process id "
call format "rlr_PDB","+14",linaddr,"W","lock issuer's PDB "
call format "rlr_flags","+16",linaddr,"B","flags" || str
exit



/*.im getstor*/
/*.ifdef gblgetstor*/
/*.endif*/
/*.se gblgetstor=1*/
getstor: procedure
arg address,size,format
select
   when size='B' then cmd="DB" address "L1"
   when size='W' then cmd="DW" address "L1"
   when size="D" then cmd="DD" address "L1"

otherwise cmd="DB" address "L1"
end  /* select */
address df "cmd output" cmd
if rc<>0 then return 'df error' rc
else do
    if substr(output.3,1,1)='#' then do
       parse var output.2 . stor .
       select
          when format="C" then return x2c(stor)
          when format="N" then return x2d(stor)
          when format="X" then return stor
       otherwise return stor
       end  /* select */
    end  /* Do */
    else return output.3
end


format: procedure
parse arg name,offset,base,type,desc

value=getstor(base||offset,type)
desc=strip(desc,"B"," ")
name=strip(name,"B"," ")
if length(name) > 20 then name=substr(name,1,20)
if length(name) < 20 then name=left(name,20,' ')
text=offset ' | '  name" | "
tl=length(text)
vl=length(value)
pad=40-tl-vl
if pad>0 then text=left(text,pad+tl," ")
say text value ' | ' desc
return value


