/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* Per-Slot EXEC. Extract data from TCB, PTDA or TSD on a per-slot   */
/* basis.                                                            */
/*                                                                   */
/* Syntax:   %PS <s1> <s2> <cmd parms>                               */
/*                                                                   */
/*           <s1>          starting slot number                      */
/*           <s2>          ending slot number. * signifies           */
/*                         last possible slot                        */
/*           <cmd>         is any string of DF commands separated by */
/*                         ; or a REXX exec prefixed by %            */
/*           <parms>       are any valid parms where @TCB, @PTDA     */
/*                         and @TSD are substituted with their       */
/*                         corresponding linear addresses. @disp is  */
/*                         the scheduler's ESP relative to the TSD.  */
/*                                                                   */
/* Change Log:                                                       */
/* 10/09/93 Version 1 created.                                       */
/*                                                                   */

signal on halt name haltexit
trace 'o'
numeric digits 12

arg s1 s2 commands
if s1='?' | s1='' then do
   say "Per-Slot EXEC"
   say " "
   say "Syntax: %PS <s1> <s2> <cmds>"
   say " "
   say "        s1      starting slot"
   say " "
   say "        s2      ending slot or * for all slots"
   say " "
   say "        cmds    a DF command string or a REXX exec"
   say "                prefixed by %. Multipe DF commands"
   say "                may be specified by separating them"
   say "                with semi-colons. The following placeholders"
   say "                may be specified:"
   say "                @TCB, @TSD, @PTDA, @Disp"
   say "                Where @TCB, @TSD and @PTDA represent the "
   say "                linear addresses of slot's TCB, TSD and PTDA."
   say "                @Disp will be substituted with the Scheduler's"
   say "                ESP displacement relative to the TSD (when available)."
   say " "
   exit 0
end

commands=strip(commands,"B"," ")
if s2='*' then do
   address df 'cmd output .p'
   i=output.0 - 1
   c1=substr(output.i,1,1)
   if c1=" " & c1="*" then i=i-2
   s2 = substr(output.i,2,4)
end
address df 'cmd output .p#'
o=output.0-2
if word(output.o,1)="Slot" then do
   say 'Unable to determine current slot number'
   exit 8
end  /* Do */
o=o+1
curslot=substr(output.o,2,4)
d_sl1=x2d(s1)
d_sl2=x2d(s2)
if d_sl2<d_sl1 then do
   say 'Starting slot number is greater then the ending slot number'
   exit 8
end

do d_sl=d_sl1 to d_sl2
   sl=d2x(d_sl)
   say " "
   say "Slot" sl
   address df 'cmd output .s' sl
   o=output.0-1
   if word(output.o,1)='Current' then do
      say output.o
      iterate
   end  /* Do */
   address df 'cmd output .p#'
   o=output.0-2
   if word(output.o,1)="Slot" then do
      say output.o
      say 'Unable to select slot number' sl
     /* exit 8 */
     iterate
   end  /* Do */
   o=o+1

   tsd=word(output.o,8)
   ptda=word(output.o,9)
   tcb=word(output.o,10)
   disp=substr(output.o,64,4)

   /* process each command specified for this slot */
   /* substitue the ptda, tsb and tsd linear addresses into commands */
   cmd=commands
   p=pos('@TCB',cmd)
   do while p > 0 then do
      cmdl=left(cmd,p-1)
      cmdr=right(cmd,length(cmd)-p-3)
      cmd=cmdl || '%'tcb || cmdr
      p=pos('@TCB',cmd,p)
   end /* do */

   p=pos('@PTDA',cmd)
   do while p > 0 then do
      cmdl=left(cmd,p-1)
      cmdr=right(cmd,length(cmd)-p-4)
      cmd=cmdl || '%'ptda || cmdr
      p=pos('@PTDA',cmd,p)
   end /* do */

   p=pos('@TSD',cmd)
   do while p > 0 then do
      cmdl=left(cmd,p-1)
      cmdr=right(cmd,length(cmd)-p-3)
      cmd=cmdl || '%'tsd || cmdr
      p=pos('@TSD',cmd,p)
   end /* do */

   p=pos('@DISP',cmd)
   do while p > 0 then do
      cmdl=left(cmd,p-1)
      cmdr=right(cmd,length(cmd)-p-4)
      cmd=cmdl || disp || cmdr
      p=pos('@DISP',cmd,p)
   end /* do */
   say cmd

   /* execute the command for the current slot */
   select
      when substr(cmd,1,1)='%' then do
         parse value substr(cmd,2) with execname execparms
         interpret 'call' execname 'execparms'
         if result=0 & result="RESULT" then do
            say execname 'exited rc:' result
            if print='' then address df 'OUTPUT NOECHO'
            say 'PS terminating'
            exit result
         end  /* Do */
      end  /* Do */
      when substr(cmd,1,1)='#' then do
         parse value substr(cmd,2) with os2cmd cmdparms
         address 'CMD' os2cmd cmdparms
         if rc=0 then do
            say 'command completed rc:' rc
            say 'PS terminating'
            if print='' then address df 'OUTPUT NOECHO'
            exit result
         end  /* Do */
      end  /* Do */
   otherwise do /* assume df command */
      address df 'CMD output' cmd
      if rc=0 then do
         if rc=0 then say 'DFREXX returned rc: rc'
         say 'PS terminating'
         if print='' then address df 'OUTPUT NOECHO'
         exit result
      end  /* Do */
      else do i=1 to (output.0) -1
         say output.i
      end  /* Do */
   end  /* Do */
   end  /* select */
end


address df 'cmd output .s' curslot
haltexit: say'#'
exit 0

