/*.im seciuo*/
/* IBM Internal Use Only.                                            */
/*.im coibm*/
/* (C) Copyright IBM Corp. 1993                                      */
/* (C) Copyright IBM Information Solutions 1993                      */
/*                                                                   */
/*rexx*/
/*Author: Richard Moore / Dieter Damm                Version: 1.0    */
/* format named pipe data structure                                  */
/* 1 required parameter: adr (sel:offs)                              */
/*                                                                   */
/* 10/01/97 if user types ?, spit out help                           */
/*                                                                   */

trace 'o'
numeric digits 12

arg adr

if (adr='?' |,
    adr='/?' |,
    adr=' '  |,
    adr=''   |,
    adr='/h' |,
    adr='/H') then do
   say "Format Named Pipe data structure (NP)"
   say " "
   say 'Syntax: %NP sel:offs '
   say ' '
   exit 0
end  /* Do */

position=pos(':',adr)
if pos=0 then do
  say' Invalid sel:ofs given'
  exit 0
end
say ' '
sel=substr(adr,1,position-1)
ofs=right(adr,length(adr)-position)
address df 'cmd output dl 'sel
o=output.0-1
linaddr=substr(word(output.o,3),5,8)
linaddr=x2d(linaddr)+x2d(ofs)
linaddr='%'d2x(linaddr)
say linaddr

call format "np_state_size     ","+00",linaddr,"B","state of pipe                       "
call format "np_refcnt         ","+01",linaddr,"B","SFT reference count for pipe        "
call format "np_next           ","+02",linaddr,"W","ptr to next in active list          "
call format "np_flink          ","+04",linaddr,"W","ptr to next instance of pipe        "
call format "np_blink          ","+06",linaddr,"W","ptr to previous instance of pipe    "
call format "np_namkey         ","+08",linaddr,"W","RMP key value for npn structure     "
call format "np_scnt           ","+0a",linaddr,"B","count of servers                    "
call format "np_ccnt           ","+0b",linaddr,"B","count of clients                    "
call format "np_selector1      ","+0c",linaddr,"W","selector for outgoing data buffer   "
call format "np_selector2      ","+0e",linaddr,"W","selector for incoming data buffer   "
call format "np_pipmod         ","+10",linaddr,"W","pipe mode specified at creation time"
call format "np_flags          ","+12",linaddr,"W","pipe flags                          "
call format "np_ssft           ","+14",linaddr,"D","back ptr to server SFT              "
call format "np_csft           ","+18",linaddr,"D","back ptr to client SFT              "
call format "np_ssem           ","+20",linaddr,"D","server and system semaphore         "
call format "np_ssemkey        ","+24",linaddr,"W","server'S semaphore key              "
call format "np_csem           ","+26",linaddr,"D","client end system semaphore         "
call format "np_csemkey        ","+2a",linaddr,"W","client's semaphore key              "
exit



/*.im getstor*/
/*.ifdef gblgetstor*/
/*.endif*/
/*.se gblgetstor=1*/
getstor: procedure
arg address,size,format
select
   when size='B' then cmd="DB" address "L1"
   when size='W' then cmd="DW" address "L1"
   when size="D" then cmd="DD" address "L1"

otherwise cmd="DB" address "L1"
end  /* select */
address df "cmd output" cmd
if rc<>0 then return 'df error' rc
else do
    if substr(output.3,1,1)='#' then do
       parse var output.2 . stor .
       select
          when format="C" then return x2c(stor)
          when format="N" then return x2d(stor)
          when format="X" then return stor
       otherwise return stor
       end  /* select */
    end  /* Do */
    else return output.3
end


format: procedure
parse arg name,offset,base,type,desc
value=getstor(base||offset,type)
desc=strip(desc,"B"," ")
name=strip(name,"B"," ")
if desc='' then text=offset name":"
else text=offset name"," desc":"
tl=length(text)
vl=length(value)
pad=80-tl-vl
if pad>0 then text=left(text,pad+tl," ")
say text value
return value
