/******************************************************************************/
/* (C) Copyright IBM Corp 1997                                                */
/* Author: Denis Tonn  DTONN@VNET.IBM.COM     TORVM3(DENIS)                   */
/* DF rexx extension to remove/restore trace points in dump memory            */
/* See bottom of file for logic flow                                          */ 
/*                                                                            */
/* Version 1.0 - 06/23/97 Initial beta Test                                   */
/* Version 1.1 - 06/24/97 Obtain correct context                              */
/* Version 1.2 - 06/26/97 Exceeded capability of OS/2 PATCH utility           */
/* Version 1.3 - 06/27/97 Corrected a bug. Missed some tracepoints            */
/* Version 1.5 - 07/03/97 Removed requirement for PATCH facility              */ 
/*               Major revisions and cleanup.                                 */         
/*               Create standalone REXX program to remove/restore             */ 
/*                tracepoints from dumpfile.                                  */
/*               Create/Recreate patch program regardless of patch            */
/*                status of dump file                                         */
/*               Dumpfile name is now required                                */
/*               User selectable patchfile name                               */
/*               Automaticly run patching program                             */
/*                                                                            */
/******************************************************************************/

say 
say '(C) Copyright IBM Corp 1997'
say 'DF rexx extension to remove/restore trace points in dump memory.'
say 'Version 1.5 - July 03, 1997'
say 

 Signal on halt name Haltroutine /* Ctl-C exit */
 numeric digits 18

 parse source . . myfilespec
 myname=translate(filespec('N',myfilespec))
arg dumpfile patchfile OnOff
/* user passed dumpfile name                          */
/* name of patchfile to be created                    */ 
/* remove (On) or restore (Off) CC opcodes            */

 Call Test_for_DF /* make sure we are running under Dump formatter */

  if (RxFuncQuery('sysloadfuncs') \=0) then
   do
    Call RxFuncAdd 'SysLoadFuncs','REXXUTIL','SysLoadFuncs';
    Call SysLoadFuncs;
   end /* do */

 if ((strip(translate(patchfile))='ON') | (strip(translate(patchfile))='OFF')) & (length(OnOff)=0) then
  do /* patchfile names ON and OFF are reserved unless automatic run specified */
     OnOff=strip(patchfile)
     patchfile=''
     say 'Automatic install selected. Using internally generated patch program name.'
  end /* do */

 select 
    when length(dumpfile)<1 then call help
    when pos('?',dumpfile)>1 then call help
    when (length(dumpfile)>0 & (\exist(dumpfile))) then
     do 
       say 'Could not locate 'dumpfile
       call help
     end /* do */
    when length(OnOff)>0 then 
     do 
       if (left(OnOff,2)<>'ON' & left(OnOff,3)<>'OFF') then call help
     end /* do */
 otherwise NOP
 end  /* select */

 if isnull(getmem(DD,_pdtoheadscan,L1)) then /* any active tracepoints? */
  do 
  say 'No active dynamic trace objects found' 
  exit 0
  end /* do */

 Call OpenPatchFile   /* determine valid name for patch routine */
 call GetSystemAddress /* get system arena address - required for context switch */

 say 'Found Dynamic trace objects for:'
 DTOlist=''
 DTO=getmem(DD,'_pdtoheadscan',L1)
  do until isnull(DTO)
   DTOlist=DTOlist DTO
   DTOnameadd=getmem(DD,d2x(x2d(DTO)+x2d(24),8),L1)
   say getmem(DA,DTOnameadd)
   DTO=getmem(DD,DTO,L1)
  end /* do */

 /* generate dump signatures for crosscheck */
 Dumpsig1add=d2x(x2d(VirtToPhys(sym2add('DAY')))+512,8)
 Dumpsig1data=space(getmem(DB,'DAY',L4),0)
 Dumpsig2add=d2x(x2d(VirtToPhys(sym2add('TASKNUMBER')))+512,8)
 Dumpsig2data=space(getmem(DB,'TASKNUMBER',L4),0)
 Dumpsig3add=d2x(x2d(VirtToPhys(sym2add('_CPUSTEPPING')))+512,8)
 Dumpsig3data=space(getmem(DB,'_CPUSTEPPING',L4),0)

 say '** Analyzing trace objects **'

    tracepoints=0 /* count tracepoints for dump */
    tracepatch=0  /* count patches created for dump */

 do DTOnum=1 to words(DTOlist) /* process each DTO hash list entry */
    ModuleName=getmem(DA,getmem(DD,d2x(x2d(word(DTOlist,DTOnum))+x2d(24),8),L1))
    say 'Processing Trace points for 'ModuleName
    DTRhashALL=getmem(DD,d2x(x2d(word(DTOlist,DTOnum))+x2d(28)),L100)

    DTRhash=''
    do I=1 to words(DTRhashALL) /* strip null entries in hash list */
       if isnull(word(DTRhashALL,I)) then NOP
       else DTRhash=DTRhash word(DTRhashALL,I)
    end /* do */

    DTOflags=getmem(DD,d2x(x2d(word(DTOlist,DTOnum))+8),L1)
    if (b2x(bitand(x2b(DTOflags),x2b('00000F04')))='00000F00') then
    do /* DTO is not detached and can be trusted */
           /* supply DTO address and first tracepoint for context switch */
      call SwitchContext(strip(word(DTOlist,DTOnum)) getmem(DD,d2x(x2d(word(DTRhash,1))+4),L1))
      DTOpoints=0 /* count tracepoints for module */
      DTOpatch=0  /* count patchpoints created for module */
      do I=1 to words(DTRhash) /* follow the hash for a single DTO object */
         DTRnext=strip(word(dtrhash,I)) /* ready for next DTR */
         do until isnull(DTRnext) /* process all DTR records from each hash entry */
           DTR=getmem(DD,DTRnext,L4) /* get first DTR from hash address */
           phyadd=VirtToPhys(word(DTR,2)) /* get physical address of tracepoint */
           if length(phyadd)>0 then /* only create patch if the address is paged in */
            do /* create patch file entry */
              fileadd=d2x(x2d(phyadd)+512,8) /* dumpfile offset */
              opcode=substr(word(DTR,4),3,2) /* original opcode */
              dump_opcode=getmem(DB,'%%'phyadd,L1) /* opcode now at instruction address */
              select 
                 when (dump_opcode='CC') then /* must be removing CC opcodes */
                  do  /* default operation. Create patch file anyway */
                     call BuildPatchPoint
                  end /* do when dump_opcode='CC' */
                 when (dump_opcode=opcode) then /* must be restoring original trace points */
                  do /* reverse action. Create patch file anyway */
                     call BuildPatchPoint
                  end /* do when dump_opcode=opcode */
              otherwise /* bad dump file */
                  do 
                     say 'Inconsistent data found in dumpfile for module' ModuleName
                     say 'Virtual address='word(DTR,2) 'Physical address='phyadd 'Expected='opcode 'or CC. Found='dump_opcode
                     exit
                  end /* do */
              end  /* select */
            end /* do */
           DTOpoints=DTOpoints+1
           if (DTOpoints//50)=0 then say 'Processed' right(DTOpoints,4) 'entries for module.'
           DTRnext=strip(word(DTR,1))
         end /* do */
      end /* do */
    end /* do */
    say 'Found 'DTOpoints' tracepoints. 'DTOpatch' addresses in memory for 'ModuleName
    say
    tracepoints=tracepoints+DTOpoints
 end /* do */

 say 
 say 'Total 'tracepoints' active trace points and 'tracepatch' addresses found in dump memory.'
 say tracepoints-tracepatch 'instruction addresses not in dump.'
 say 

 Call BuildPatchFile  /* generate patching routine with data */

 if length(OnOff)>0 then
 do 
   patchcmd=left(filespec('N',patchfile),pos('.',filespec('N',patchfile))-1)
   here=directory()
   patchdir=filespec('P',patchfile)
   if (length(patchdir)>1) & (right(patchdir,1)='\') then patchdir=left(patchdir,length(patchdir)-1)
   patchdir=filespec('D',patchfile) || patchdir
   call directory patchdir
   if translate(OnOFF)='ON' then /* automatic selected */
     do 
        say 'Running automatic removal of tracepoints from 'dumpfile
        interpret 'call ' || patchcmd || ' ON'
     end /* do */
    else
     do   
        say 'Running automatic restore of tracepoints to 'dumpfile
        interpret 'call ' || patchcmd || ' OFF'
     end /* do */
   call directory here
 end /* do */

    say 'To remove tracepoints from' dumpfile', run 'left(patchfile,pos('.',patchfile)-1)' ON'
    say 'To restore tracepoints to' dumpfile', run 'left(patchfile,pos('.',patchfile)-1)' OFF'

exit 0 /* all done */ 


help:
 do 
   say 
   say 'This routine enables replacement of the CC opcodes placed in memory by the OS/2'
   say 'Dynamic Trace facility with the original opcodes used by the instructions. This'
   say 'facilitates correct unassembly of instructions.'
   say
   say 'Format:'
   say '%'left(myname,pos('.',myname)-1) '[dumpfilespec] <patchfile> <On|Off>'
   say 'Where: [dumpfilespec]= pathfilename of the dump loaded into the dump formatter.'
   say '       <patchfile>   = optional pathname of file to remove/restore CC opcodes.'
   say '                       Default is TRACEnnn.CMD in path where dump is located.'
   say '       <On|Off>      = automaticly remove CC opcodes (On) or restore them'
   say '                     = to the dump. Dump must be reloaded to activate changes.'                           
   say 
   exit 0
 end /* do */
return

isnull: procedure /* test if a hex address is all zeros */ 
arg add
 add=strip(translate(add,' ',':')) /* eliminate colon for 16 bit values */
 if datatype(add,'X') then return(x2d(add)=0) 
  else return 0

GetSystemAddress: /* get system arena address for context check */
 address df 'cmd output .MA 4' /* obtain system arena sentinal */
 do A=1 to output.0
   output.A=translate(output.A,' ','#') /* eliminate prompt */
   if word(output.A,1)='0004' then system_arena=x2d(strip(translate(word(output.A,4),' ','%')))
 end /* do */
return 

SwitchContext: procedure expose system_arena /* switch to an appropriate process context for this DTO */
 arg DTOadd tracepoint
 foundhPTDA=0
 if x2d(tracepoint)>system_arena then /* global context */ 
  do 
    say 'System arena, global context.'
    return
  end /* do */
 hMTE=getmem(DW,d2x(x2d(DTOadd)+x2d(434)),L1) /* 16 bit hMTE value */
 address df 'cmd output .MAA %'tracepoint /* list contexts for this address */
 do A=1 to output.0
   output.A=translate(output.A,' ','#') /* eliminate prompt */
   output.A=strip(translate(output.A))  /* uppercase and no lead/trail blanks */
    select 
       when pos('HCO=',output.A,)>0 then
       do /* must be in the shared arena */
         hCO=substr(output.A,pos('HCO=',output.A)+length('HCO='),6)
         address df 'cmd outputX .MC' hCO /* obtain hPTDA from .MC output */
         do Y=1 to outputX.0
           outputX.Y=translate(outputX.Y,' ','#') /* eliminate prompt */
           outputX.Y=strip(translate(outputX.Y))  /* uppercase and no lead/trail blanks */
           if pos('HPTDA=',outputX.Y)>0 then
           do 
            hPTDA=substr(outputX.Y,pos('HPTDA=',outputX.Y)+length('HPTDA='),4)
            foundhPTDA=1
            signal found 
           end /* do */
         end /* do */
       end /* do when pos('HCO=',output.A)>0 */
       when pos('HPTDA=',output.A)>0 then
       do /* must be in the private arena */
         hPTDA=substr(output.A,pos('HPTDA=',output.A)+length('HPTDA='),4) /* save for later */
         hOB=strip(word(output.A,10)) /* need the hOB to match against the hMTE */
         address df 'cmd outputX .MO' hOB 
         do Y=1 to outputX.0
           outputX.Y=translate(outputX.Y,' ','#') /* eliminate prompt */
           outputX.Y=strip(translate(outputX.Y))  /* uppercase and no lead/trail blanks */
           if strip(word(outputX.Y,1))=hOB then
            do 
              if (strip(word(outputX.Y,5))=hMTE) & (strip(word(outputX.Y,6))=hMTE) then /* found it! */
              do                              
               foundhPTDA=1
               signal found
              end /* do */
            end /* do */
         end /* do */
       end /* do when pos('HPTDA=',output.A)>0 */
    otherwise NOP
    end  /* select */
 end /* do */

found: /* found a hPTDA for the context */
 if \foundhPTDA then 
 do 
  Say 'Internal error doing context switch!'
  exit
 end /* do */
 address df 'cmd output .mo' hPTDA /* get info about the PTDA */ 
 do A=1 to output.0
   output.A=translate(output.A,' ','#') /* eliminate prompt */
   output.A=translate(output.A)  /* uppercase */
   if strip(word(output.A,1))=hPTDA then
      pPTDA=strip(translate(word(output.A,2),' ','%')) /* now have PTDA address */
 end /* do */
 pTCB=getmem(DD,d2x(x2d(pPTDA)+x2d(20)),L1) /* pointer to first TCB for this process */
 slot=getmem(DW,d2x(x2d(pTCB)+2),L1) /* system slot number for TCB/thread */
 address df 'cmd junk .s 'slot';.r' /* get addressability */
 drop junk
 address df 'cmd output .p#'
 do A=1 to output.0
   if pos('#',strip(word(output.A,1)))>4 then
   say 'Switched to context of slot' word(output.A,1)
 end /* do */
return

VirtToPhys: procedure /* translate virtual address to physical address */
 arg add
 add=strip(add)
 phyadd=''
  address df 'cmd output DP' add 'L1'
 do A=1 to output.0
   output.A=translate(output.A,' ','#') /* eliminate prompt */
   output.A=strip(translate(output.A))  /* uppercase and no lead/trail blanks */
   if length(output.A)>0 then
    do 
     if pos('FRAME=',output.A)>0 then
     do 
      phypage=substr(output.A,pos('FRAME=',output.A)+length('FRAME='),5)
      phyadd=phypage || right(add,3)
      return(strip(phyadd))
     end /* do */
    end /* do */
 end /* do */
 return(strip(phyadd))

Sym2Add: /* convert a symbol to an address */
 arg sym
 address df 'cmd output ?' sym 
 do A=1 to output.0
  output.A=translate(output.A,' ','#') /* eliminate prompt */
  output.A=strip(translate(output.A))  /* uppercase and no lead/trail blanks */
  if length(output.A)>0 then
    do 
     if left(strip(word(output.A,1)),length('EXPRESSION ERROR'))='EXPRESSION ERROR'
      then return ''
      else return(strip(word(output.A,1)))
    end /* do */
 end /* do */
 return ''

getmem: procedure /* Obtain data at a memory location */
arg type,add,len
 add=strip(translate(add)); type=strip(translate(type)); len=strip(translate(len)); data=''
 if (pos(':',add)>0)  & (pos('#',add)<>0) then add='#0'add /* force selector and ignore symbols */
 if datatype(add,'X') then add='%'add  /* flat address */
 if (length(len)>0) & (pos('L',len)=0) then len='L'len
 if length(len)>0 then DBL=x2d(right(len,length(len)-1)) /* get number of bytes */
 address df 'cmd output' type add len
 do A=1 to output.0
   output.A=translate(output.A,' ','#') /* eliminate prompt */
   output.A=translate(output.A,' ','-') /* eliminate dashes for DB */
   output.A=strip(translate(output.A))  /* uppercase and no lead/trail blanks */
   if length(output.A)>0 then
    select 
       when type='DA' then /* just capture the text line */
        do W=2 to words(output.A) /* capture text */ 
           data=data word(output.A,W)
        end /* do */
       when type='DB' then /* don't return ascii from end of line */
        do 
           if \(DBL<16) then /* capture bytes on total line */
              do W=2 to 17 /* capture each byte */ 
                if datatype(word(output.A,W),'X') then data=data word(output.A,W)
                DBL=DBL-1
              end /* do */
           if (DBL<16) & (DBL>0) then /* capture remaining bytes */
              do W=2 to DBL+1 /* capture each byte */ 
                if datatype(word(output.A,W),'X') then data=data word(output.A,W)
              end /* do */
        end /* do */
    otherwise /* DD or DW */
        do W=2 to words(output.A) /* capture each word/double */ 
           if datatype(word(output.A,W),'X') then data=data word(output.A,W)
        end /* do */
    end  /* select */
 end /* do */
return strip(data)

exist: procedure 
  arg file
   if length(file)<1 then return(0)
   Call SysFileTree file,FileStem,'FO'
 return (FileStem.0>0)

close: procedure 
  arg file
   if length(file)<1 then return(0)
    call stream file,'C','CLOSE'
 return

open: procedure 
  arg file
   if length(file)<1 then return(0)
    call stream file,'C','OPEN'
 return

ToF: procedure 
  arg file
   if length(file)<1 then return(0)
    call stream file,'C','seek =1'
 return

 haltroutine:
 say 'Procedure halted by user.'
 exit

 test_for_DF:
 Signal on failure name noDF
 address DF 'cmd output .p#'
 Signal off failure
 return

 noDF:
 say 
 say 'This routine must be run from within the OS/2 Dump Formatter.'
 say
 signal help
 exit

OpenPatchFile:  
 defaultdir=filespec('D',dumpfile) || filespec('P',dumpfile)
 if length(patchfile)>0 then  /* use user supplied patchfile name */
   do /* test user supplied name and modify if needed */
     if (pos('.',patchfile)>0) then 
      patchfile=Left(patchfile,pos('.',patchfile)-1) || '.CMD'
     else
      patchfile=patchfile || '.CMD'
   end /* do */
 else
   do FI=1 to 999  /* determine a unique filename for the patch files */
      FI=right(FI,'3','0')
      patchfile=defaultdir ||'trace'FI'.CMD'
      if exist(patchfile) then NOP
       else leave
   end /* do */
 if exist(patchfile) then /* save a temp copy */
  do 
     say 'Will replace current ' patchfile ' Hit CTL-C to interrupt.'
     TempName=SysTempFileName(Left(patchfile,pos('.',patchfile)-1) || '.???')
     Address cmd '@RENAME' patchfile filespec('N',tempname)
  end /* do */
 call open(patchfile)
 if exist(patchfile) then 
  do  /* created just fine. Delete it until later */
     call close(patchfile)
     call SysFileDelete(patchfile)
     if exist(tempname) then Address cmd '@RENAME' tempname filespec('N',patchfile)
  end /* do */
 else
  do 
     if exist(tempname) then Address cmd '@RENAME' tempname filespec('N',patchfile)
     say 'Could not create required file' patchfile
     say 'Verify above file can be created in directory specified.'
     exit
  end /* do */
return

BuildPatchPoint: /* builds the patch point for the patch file */
 if symbol('pcnt')='VAR'
    then pcnt=pcnt+1
    else pcnt=1 /* init if first time through */
  pdata.pcnt=fileadd opcode
  DTOpatch=DTOpatch+1
  tracepatch=tracepatch+1
return

 GenPatchData: /* generate patch data */
  call lineout patchfile,'/* BEGIN LOCATE DUMPFILENAME */'
  call lineout patchfile,'FILE' dumpfile
  call lineout patchfile,'/* END LOCATE DUMPFILENAME */'
  call lineout patchfile,'/* BEGIN PATCH VERIFY */'
  call lineout patchfile,'VER' Dumpsig1add Dumpsig1data
  call lineout patchfile,'VER' Dumpsig2add Dumpsig2data
  call lineout patchfile,'VER' Dumpsig3add Dumpsig3data
  call lineout patchfile,'/* END PATCH VERIFY */'
  call lineout patchfile,'/* BEGIN PATCH DATA */'
  do a=1 to pcnt
     call lineout patchfile,'CHA' pdata.a
  end /* do */
  call lineout patchfile,'/* END PATCH DATA */' 
  call close(patchfile)
 return 

 GetGenCode: /* obtains the line numbers to scan to create embedded code in patch file */
   signal StartRexxCode /* will return to next line with sigl before code */
  GenRexxStart:
   GenStart=sigl+1
   signal EndRexxCode   /* will return to next line with sigl 2 lines after code */
  GenRexxEnd:
   GenEnd=sigl-2
 return
               
 BuildPatchFile:  /* builds an external REXX file to do the patching */
 Call GetGenCode
 if exist(patchfile) then /* replacing an existing file? */
  if SysFileDelete(patchfile)<>0 then  /* trash it before we build the new one */
   do 
      say 'Could not replace' patchfile 'Is it in use or marked readonly?'
   end /* do */
  do gen=Genstart to GenEnd 
   RxLine=sourceline(gen)
   do while pos('|||',RxLine)>0
     parse var RxLine Lead '|||' replace '|||' follow /* find vars that need translating */
     RxLine= Lead || value(replace) || follow /* translate vars for embeded code */
   end /* do */
   call lineout patchfile,RxLine
  end /* do */
 Call GenPatchData    /* place required patch data in patch routine */
 return

/*************************************************************/
/* generated patch file source. Not executed in this program */
/* The following lines are sequence dependent.               */
/* DO NOT MODIFY THIS BLOCK OF LINES!!                       */
/*************************************************************/
startrexxcode: /* this lable is required to be 2 lines before "gen" code */
signal GenRexxStart /* must immediately preceed imbedded "gen" code */
/* (C) Copyright IBM Corp 1997 */
/************************************************************************/
/* patch program for |||dumpfile||| to remove or restore trace points.  */        
/* Automaticly generated by |||myname||| under OS/2 dump formatter.     */
/* Do not modify this file! Create a new one with |||myname||| instead. */
/************************************************************************/

parse source . . myfilespec ; myname=filespec('n',myfilespec)
arg OnOff dumpfile 
 select 
    when strip(translate(OnOff))='ON' then NOP
    when strip(translate(OnOff))='OFF' then NOP
 otherwise
  do 
    say ; say 'Removes or Restores tracepoints for preprocessed OS/2 Dump File.'
    say 'This program generated by |||myname||| for use against |||dumpfile|||'
    say ; say 'Use:  ' left(myname,pos('.',myname)-1) '[On|Off]' '<dumpfile>'
    say 'On removes tracepoints. Off restores dumpfile to original condition.'
    say '<dumpfile> is optional. Default is |||dumpfile||| '
    exit ; end /* do */
 end  /* select */
call stream myfilespec,'C','open read'
call stream myfilespec,'C','seek =1'
 if length(dumpfile)>0 then NOP
 else do 
  do until strip(linein(myfilespec))='/* BEGIN LOCATE DUMPFILENAME */' ; end /* do */
  if lines(myfilespec)<1 then do 
     say 'Internal Error. Could not locate dumpfile name.'
     exit(x2d('FFFF')) ; end /* do */
  do until patchline='/* END LOCATE DUMPFILENAME */'
     patchline=strip(linein(myfilespec))
     if strip(word(patchline,1))='FILE' then dumpfile=strip(word(patchline,2))
  end /* do */
 end /* do */
if length(dumpfile)<1 then do 
    say 'Internal Error. Could not locate dumpfile name.'
    exit(x2d('FFFF')) ; end /* do */
if stream(dumpfile,'C','Query Exists')='' then do 
    say 'Cannot locate' dumpfile'. Cannot patch.'
    exit(x2d('FFFF')) ; end /* do */
call stream dumpfile,'C','open'
call stream myfilespec,'C','seek =1'
do until strip(linein(myfilespec))='/* BEGIN PATCH VERIFY */' ; end /* do */
if lines(myfilespec)<1 then do 
    say 'Internal Error. Could not locate verify data.'
    exit(x2d('FFFF')) ; end /* do */
do until patchline='/* END PATCH VERIFY */'
   patchline=strip(linein(myfilespec))
   if strip(word(patchline,1))='VER' then call verify
end /* do */
call stream myfilespec,'C','seek =1'
do until strip(linein(myfilespec))='/* BEGIN PATCH DATA */' ; end /* do */
if lines(myfilespec)<1 then do 
    say 'Internal Error. Could not locate patch data.'
    exit(x2d('FFFF')) ; end /* do */
say 'Checking patch data for dump file' dumpfile ;
do until patchline='/* END PATCH DATA */'
   patchline=strip(linein(myfilespec))
   if strip(word(patchline,1))='CHA' then call Checkdump
end /* do */
call stream myfilespec,'C','seek =1'
do until strip(linein(myfilespec))='/* BEGIN PATCH DATA */' ; end /* do */
if lines(myfilespec)<1 then do 
    say 'Internal Error. Could not locate patch data.'
    exit(x2d('FFFF')) ; end /* do */
say 'Applying patches to dump file' dumpfile ; patchcount=0
do until patchline='/* END PATCH DATA */'
   patchline=strip(linein(myfilespec))
   if strip(word(patchline,1))='CHA' then call patchdump
end /* do */
call stream dumpfile,'C','close'
if translate(OnOFF)='ON' then 
   say patchcount 'locations have been changed to valid opcodes.'
else
   say patchcount 'locations have been restored to CC opcodes.'
say 'Reload dump to activate changes.'
exit(0)

Checkdump:
 patchadd=x2d(strip(word(patchline,2)))+1
 opcode=strip(word(patchline,3))
 if translate(OnOFF)='ON' then do
    if c2x(charin(dumpfile,patchadd))='CC' then NOP
    else do
      say 'Cannot remove tracepoint. Previously processed or invalid dumpfile.'
      say 'File Address:' d2x(patchadd,8) 'Expected=CC' 'Found='c2x(charin(dumpfile,patchadd))
      say 'Dump has not been processed.'
      exit(x2d('FFFE')) ; end /* do */
  end /* do */
 else do
    if c2x(charin(dumpfile,patchadd))=opcode then NOP
    else do
      say 'Cannot restore tracepoint. Not yet processed or invalid dumpfile.'
      say 'File Address:' d2x(patchadd,8) 'Expected='opcode 'Found='c2x(charin(dumpfile,patchadd))
      say 'Dump has not been processed.'
      exit(x2d('FFFE')) ; end /* do */
  end /* do */
return

patchdump:
 patchadd=x2d(strip(word(patchline,2)))+1
 opcode=strip(word(patchline,3))
 if translate(OnOFF)='ON' then do
     call charout dumpfile,x2c(opcode),patchadd 
     patchcount=patchcount+1
  end /* do */
 else do
     call charout dumpfile,x2c('CC'),patchadd 
     patchcount=patchcount+1
  end /* do */
return

verify:
 veradd=x2d(strip(word(patchline,2)))+1
 opcode=strip(word(patchline,3)) 
 if c2x(charin(dumpfile,veradd,length(x2c(opcode))))=opcode then return
 else do 
  say 'Basic dumpfile validity check failed.'
  exit(x2d('FFFE')) ; end /* do */
return

/* -------------------Required Patch data DO NOT MODIFY-------------------------*/

endrexxcode: /* this lable is required to be immediately following "gen" code */
signal GenRexxEnd /* must immediately follow above label */
/*************************************************************/
/* end of sequence sensitive lines                           */
/* Do not modify this block of lines!                        */
/*************************************************************/

/* assumptions and logic flow */

/* 
 Label _pDTOHeadScan addresses a pointer to the beginning of the Dynamic Trace
Object (DTO) linked list.  There is one DTO per module.

 Each DTO consists of a x'28' byte header, followed by a x'100' doubleword
hashtable of addresses to Dynamic Trace Records (DTR), followed by 7 doublewords
of DTO object information, and finally followed by the DTRs for the DTO
(imbedded in the DTO).

 DTO +  0h L4    : DW pointer to the next DTO in the active list. A null pointer
                   signifies end of the active DTO chain.
 DTO +  8h L4    : DW DTO status flags 
                   0x00000004 : Tracepoints are detached - no tracepoints are set.           
                   0x00000100 : All DTR linkages will stay within the dto object              
                   0x00000200 : All tracepoints are fixed up.                                 
                   0x00000400 : Some tracepoints may be set - hash table is valid.            
                   0x00000800 : All tracepoints valid and set.                                 
                   0x00002000 : Tracepoint object for program module (private arena)          
                   0x00004000 : Tracepoint object for library module (shared arena)              
 DTO + 24h  L4   : DW pointer to full pathname of module.   
 DTO + 28h  L400 : x'100' DW hash table of DTR records. Each pointer points to the  
                   first DTR in a chain of DTRs for a hash value. 
 DTO +434h  L2   : W value of hMTE for module

 DTRs are pointed to from the DTO hash table, and chained together when multiple
DTR hash values resolve to the same table position.

 DTR +  0h  L4   : DW pointer to next DTR with same hash resolution value. A  
                   null pointer signifies the end of the DTR chain for the 
                   hash value.
 DTR +  4h  L4   : DW pointer to flat virtual address for tracepoint. Context  
                   sensitive. 
 DTR + 0Eh  L1   : Byte value of original opcode of instruction. 

 The logic of this routine is to locate all the DTO's, then for each DTO it 
finds all valid (non-zero) hash pointers to DTR records.  It then does a context
switch to a slot in which the addresses of the module are valid (see below).
For each hash pointer it will walk the chain of DTR's, extract the opcode,
extract the virtual address, convert the virtual address to a physical address,
add 512 (x'200') to the physical address (to account for the 512 byte header of
a dump file).  It then tests the virtual address for either the opcode from the
tracepoint or for a CC value to verify it's logic.  It also tests to verify that
the instruction address is in the dump (not paged out).  If these tests are ok,
it builds an entry for a patch file to patch the address back to it's original
opcode in the dump.
 It then repeats this logic for each DTR chained from a hash pointer, obtains 
the next valid hash for a DTO and repeats again.  It does this for all DTO's
found.
 
 Once all tracepoints have been processed, all available addresses/opcodes are
placed in a "patchfile".  This patchfile is headed by generated REXX code
(imbedded in this routine) that will process the patch data against the
dumpfile. The generated patch file can be used standalone or called externally
from within this routine (user choice). 

 Context switch:
 For the first tracepoint found in each DTO, it locates an appropriate context
thread for the address.  It does this using the tracepoint address, and the hMTE
found at x'434' into the DTO.  It first uses .MAA against the tracepoint
address.  This gives the first hCO for objects in the shared arena, and a list
of processes for addresses in the private arena.  If in the shared arena, .MC is
then used against the hCO to locate a hPTDA in which the address exists.  If in
the private arena, each process is checked for a match to the hMTE found in the
DTO.  It is a simple matter to use the hPTDA to locate the pPTDA and from there
to locate the slot number of the first TCB in the process (pPTDA+x'20'->1st TCB,
TCB+2=slot#)
 Caution:  Dump Formatter versions earlier than Warp 3 FP30 and Warp 4 FP3 may
not always update the page tables in the shared region on a context switch.
Since these addresses appear swapped out during normal debugging it was not
deemed worthwhile to include logic to locate these physical addreses.

*/

                                                                         