/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* Dump the kernel heap                                             */
/* %mh <hkh>                                                        */
/* What we need to know:                                            */
/* _hkhcurrmax dw max no heap handles                               */
/* _apkh table of heap header pointers                              */
/* head header ptr 2 DD. +0 =flags, +4 =ptr to header               */
/*                                                                  */
/* PG_CONTIG    0x00000001  contiguous physical memory              */
/* PG_W         0x00000002  Writable - value from pte               */
/* PG_U         0x00000004  user mode accessible - from pte         */
/* PG_X         0x00000008  eXecutable                              */
/* PG_R         0x00000010  Readable                                */
/* PG_1M        0x00000020  must reside below 1 meg physical        */
/* PG_16M       0x00000040  must reside below 16 meg physical       */
/* PG_ZEROFILL  0x00000080  zero initialize pages                   */
/* PG_RESIDENT  0x00000400  value from pte                          */
/* PG_NOBLOCK   0x00080000  don't block or yield                    */
/*                                                                  */
/* VMKRH: resident heap block                                       */
/*  +0    dd count                                                  */
/*  +4    dd free                                                   */
/*  +8    dd pbFirst                                                */
/*  +c    dd pbLast                                                 */
/*  +10   dd pbEndRes                                               */
/*  +14   dd pbEndCom                                               */
/*  +b4   hob                                                       */
/*  +b6   ksem                                                      */
/* resident heap block header vmkrhb 4 bytes                        */
/* bit 0 =1 => attributed block                                     */
/*       =0 => regular block                                        */
/* RB:                                                              */
/* bit 1 =1 => yield                                                */
/*     2-14 = length in dwords                                      */
/*     15=1 => prev free                                            */
/*     16-31 = hob owner                                            */
/*     <data>                                                       */
/* RF: own=vmkrhf                                                   */
/*     <pNext> <pPrev> <pBlock>                                     */
/* AB:                                                              */
/* bit 31 = 1 => free                                               */
/*     30 = 1 => prev free                                          */
/*     24-2      size in dwords                                     */
/*     1 = 1  => yield                                              */
/*     <data>                                                       */
/* VMKRHA:                                                          */
/*     <sel> <own> <hmte> <pad>                                     */
/*                                                                  */
/* VMKSH: swappable heap block                                      */
/*  +4 dd first VMKSHD                                              */
/*  +18 dd pbEndRes                                                 */
/*  +1c dd pbEndCom                                                 */
/*  +24 dw hob                                                      */
/*  +26 dd pbStart                                                  */
/*  +2a ksem                                                        */
/*                                                                  */
/* VMKSHD: Free swappable heap block descriptor                     */
/*  +0 dd size (bytes)                                              */
/*  +4 dd next VMKSHD                                               */
/*  +8 dd pbFree                                                    */
/*                                                                  */
/* VMKSHB: Allocated swappable heap block header                    */
/*  +0 dd size || 0x'52000000'                                      */
/*  +4 dw hob                                                       */
/*  +6 dw sel                                                       */
/*                                                                  */
/*                                                                  */
/* 10/09/96 updated for new Merlin PMDF                             */

signal on halt name haltexit

numeric digits 18
parse arg hkh t .

trace '0'
say ''
if t='' then x=trace(t)

papkh=''
maxh=8
address df "cmd output dw #70:c l1"
o=output.0-1
vmoff=word(output.o,2)
address df "cmd output dd #70:"vmoff"+28 l1"
o=output.0-1
papkh=word(output.o,2)

/* old method - needs .a which is not in the kdb
address df "cmd output .a"
do i=1 to output.0
   if word(output.i,4)='Heap' then do
      papkh=word(output.i,6)
      leave
   end  /* Do */
end /* do */
*/

if hkh='' then do
   allhkh=0=1
   base=right(hkh,1)
   base=translate(base)
   if base='T' then hkh=left(hkh,length(hkh)-1)
   else do
      hkh=x2d(hkh)
   end  /* Do */
end  /* Do */
else allhkh=0=0

if maxh='' then do
   maxh=getwords('_hkhcurrmax',1)
   maxh=x2d(maxh)
end  /* Do */
if papkh='' then papkh='_apkh'
else papkh="%"strip(papkh,'L','%')
apkh=getdwords(papkh,(maxh+1)*2)

say 'hkh  flags    pHead'
do h=1 to maxh
   pkh=word(apkh,(h+1)*2)
   fkh=word(apkh,(h*2)+1)
   say right(d2x(h),4,'0') fkh pkh
end  /* Do */
say ' '

/*say 'Maximum heap handles:' maxh*/
if allhkh then do
   if hkh>maxh then do
      say 'Invalid heap handle'
      say '#'
      exit 8
   end  /* Do */
   if hkh<1 then do
      say 'Invalid heap handle'
      say '#'
      exit 8
   end  /* Do */
   pkh=word(apkh,(hkh+1)*2)
   if x2d(pkh)=0 then do
      say 'Invalid heap handle'
      say '#'
      exit 8
   end  /* Do */
   fkh=word(apkh,(hkh*2)+1)
   call fmthb hkh,pkh,fkh
end  /* Do */
else do h=1 to maxh
   pkh=word(apkh,(h+1)*2)
   fkh=word(apkh,(h*2)+1)
   if x2d(pkh)=0 then iterate
   call fmthb h,pkh,fkh
   say ' '
end  /* Do */
haltexit:
say '#'
exit 0

fmthb: procedure expose nothing
parse arg hkh,pkh,fkh
flags=x2c(fkh)
fl_contig=bitand('00000001'x,flags)='00000001'x
fl_write=bitand('00000002'x,flags)='00000002'x
fl_user=bitand('00000004'x,flags)='00000004'x
fl_exec=bitand('00000008'x,flags)='00000008'x
fl_read=bitand('00000010'x,flags)='00000010'x
fl_1m  =bitand('00000020'x,flags)='00000020'x
fl_16m =bitand('00000040'x,flags)='00000030'x
fl_zero=bitand('00000080'x,flags)='00000080'x
fl_res =bitand('00000400'x,flags)='00000400'x
fl_nobl=bitand('00080000'x,flags)='00080000'x
fl=''
if fl_read  then fl=fl'r'
else fl=fl'-'
if fl_write then fl=fl'w'
else fl=fl'-'
if fl_exec  then fl=fl'x'
else fl=fl'-'
if fl_res    then fl=fl 'Res'
else fl=fl 'Swp'
if fl_contig then fl=fl 'contig'
else fl=fl 'No-contig'
if fl_1m then fl=fl '1M'
if fl_zero then fl=fl 'zero-fill'
if fl_nobl then fl=fl 'no-block'
/*say 'hkh='hkh 'pHead='pkh fl*/
/*say 'Hkh  pHead    Flags'*/
/*say right(hkh,4,'0') pkh fl*/
hkh=right(hkh,4,'0')
if fl_res then call fmtkrh hkh,pkh,fl
else call fmtksh hkh,pkh,fl
return

fmtkrh: procedure expose hfree
parse arg hkh,pkh,fl

/*  +0    dd count                                                  */
/*  +4    dd free                                                   */
/*  +8    dd pbFirst                                                */
/*  +c    dd pbLast                                                 */
/*  +10   dd pbEndRes                                               */
/*  +14   dd pbEndCom                                               */
/*  +b4   hob                                                       */
/*  +b6   ksem                                                      */

bcount=getdwords('%'pkh,1)
fbcount=getdwords('%'pkh'+4',1)
pbFirst=getdwords('%'pkh'+8',1)
pbLast=getdwords('%'pkh'+c',1)
pbEndRes=getdwords('%'pkh'+10',1)
pbEndCom=getdwords('%'pkh'+14',1)
khhob=getwords('%'pkh'+b4',1)

htotal=d2x(x2d(pbEndRes)-x2d(pbFirst))
hfree=0
owns=vmowner(khhob)
say 'hkh  pHead    hob  cBlocks  cFree    pbFirst  pbLast   pbEndRes pbEndCom'
say  hkh  pkh      khhob bcount fbcount pbfirst pblast pbendres pbendcom owns fl
address df "cmd output .d ksem %"pkh"+b6"
say 'Heap ksem:'
do i=1 to output.0-1
   say output.i
end  /* Do */
say ''
pb=pbFirst
do until pb=pbLast
   pb=fmtkrhb(pb)
end /* do */

say ''
say 'Heap size:' lower(htotal) 'Total free space:' lower(d2x(hfree))
return

fmtkrhb: procedure expose hfree
/*trace 'i'*/
parse arg pb
bh=getdwords('%'pb,1)
xbh=x2c(bh)
ar=bitand('00000001'X,xbh)='00000001'x
pdata=d2x(x2d(pb)+4)
if ar then do
   blen=bitand('3ffffffc'x,xbh)
   ff=bitand('80000000'x,xbh)='80000000'x
   pf=bitand('40000000'x,xbh)='40000000'x
   yf=bitand('00000002'x,xbh)='00000002'x
   xblen=right(c2x(blen),6)
   bha=getwords('%'pb'+'xblen'-8',3)
   sel=word(bha,1)
   own=word(bha,2)
   hmte=word(bha,3)
   f='RA'
   if ff then f=f'F'
   else f=f'.'
   if pf then f=f'P'
   else f=f'.'
   if yf then f=f'Y'
   else f=f'.'
   owns=vmowner(own)

   /* hmte is garbage, always was so don't do this ..

   howns=vmowner(hmte)

   */

   if own='ffe9' then ff=0=0
   if ff then do
      hfree=hfree+x2d(xblen)
      fptrs=getdwords('%'pb'+4',3)
      if x2d(xblen)>12 then do
         pBlock=getdwords('%'pb'+'xblen'-c',1)
         fpmsg='pNext='word(fptrs,1) 'pPrev='word(fptrs,2) 'pBlock='pBlock
      end /* do */
      else ,
         fpmsg='pNext='word(fptrs,1) 'pPrev='word(fptrs,2)
   end  /* Do */
   else fpmsg=''
   /*say lower('%'pb f 'len='xblen 'pData=%'pdata 'own='own owns 'sel='sel 'hmte='hmte howns) fpmsg*/
   /* hmte is garbage - never used */
   say lower('%'pb f 'len='xblen 'pData=%'pdata 'own='own owns 'sel='sel) fpmsg
end  /* Do */
else do
   blen=bitand('00007ffc'x,xbh)
   pf=bitand('00008000'x,xbh)='00008000'x
   yf=bitand('00000002'x,xbh)='00000002'x
   xblen=right(c2x(blen),6)
   own=left(bh,4)
   f='RR'
   if own='ffe9' then f=f'F'
   else f=f'.'
   if pf then f=f'P'
   else f=f'.'
   if yf then f=f'Y'
   else f=f'.'
   owns=vmowner(own)
   if own='ffe9' then do
      hfree=hfree+x2d(xblen)
      fptrs=getdwords('%'pb'+4',3)
      if x2d(xblen)>12 then do
         pBlock=getdwords('%'pb'+'xblen'-4',1)
         fpmsg='pNext='word(fptrs,1) 'pPrev='word(fptrs,2) 'pBlock='pBlock
      end /*do*/
      else ,
         fpmsg='pNext='word(fptrs,1) 'pPrev='word(fptrs,2)
   end  /* Do */
   else fpmsg=''
   say lower('%'pb f 'len='xblen 'pData=%'pdata 'own='own owns) fpmsg
end  /* Do */
pb=d2x(x2d(pb)+x2d(xblen))
return lower(pb)

fmtksh: procedure expose hfree
/* VMKSH: swappable heap block                                      */
/*  +4 dd first VMKSHD                                              */
/*  +18 dd pbEndRes                                                 */
/*  +1c dd pbEndCom                                                 */
/*  +24 dw hob                                                      */
/*  +26 dd pbStart                                                  */
/*  +2a ksem                                                        */
/*                                                                  */
/* VMKSHD: Free swappable heap block descriptor                     */
/*  +0 dd size (bytes)                                              */
/*  +4 dd next VMKSHD                                               */
/*  +8 dd pbFree                                                    */
/*                                                                  */
/* VMKSHB: Allocated swappable heap block header                    */
/*  +0 dd size || 0x'52000000'                                      */
/*  +4 dw hob                                                       */
/*  +6 dw sel                                                       */
parse arg hkh,pkh,fl
pd=getdwords('%'pkh'+4',1)
pbEndRes=getdwords('%'pkh'+18',1)
pbEndCom=getdwords('%'pkh'+1c',1)
khhob=getwords('%'pkh'+24',1)
pbStart=getdwords('%'pkh'+26',1)

htotal=d2x(x2d(pbEndRes)-x2d(pbStart))
hfree=0
owns=vmowner(khhob)
say 'hkh  pHead    hob  pbFirst  pbEndRes pbEndCom'
say  hkh  pkh      khhob pbstart pbendres pbendcom owns fl
address df "cmd output .d ksem %"pkh"+2a"
say 'Heap ksem:'
do i=1 to output.0-1
   say output.i
end  /* Do */
say ''
shd=getdwords('%'pd,3)
pb=pbStart

do while x2d(pb)<x2d(pbEndRes)
   ret=fmtkshb(pb,pd,shd)
   parse var ret pb pshd .
   if x2d(pb)=0 then leave
   if x2d(pshd)=x2d(pd) then do
      pd=pshd
      if x2d(pd)=0 then shd=getdwords('%'pd,3)
      else shd='0 0 0'
   end  /* Do */
end /* do */
say ''
say 'Heap size:' lower(htotal) 'Total free space:' lower(d2x(hfree))
return


fmtkshb: procedure expose hfree
trace 'o'
parse arg pb,pd,shd
pNextFree=word(shd,3)
pNextShd=word(shd,2)
cFree=word(shd,1)
if x2d(pb)=x2d(pNextFree) then do
   pbn=d2x(x2d(cFree)+x2d(pb))
   hfree=hfree+x2d(cFree)
   say lower('%'pb 'sf len='cFree) 'pNextSHD=%'lower(pNextShd) 'pbNext=%'lower(pbn)
   return pbn pNextShd
end  /* Do */
else do
   bh=getdwords('%'pb,2)
   if bh='' then do
      say '%'lower(pb) 'swapped. Skipping to next free block'
      pNextFree=word(shd,3)
      return pNextFree pd
   end  /* Do */
   size=substr(word(bh,1),3)
   sel=left(word(bh,2),4)
   hob=right(word(bh,2),4)
   owns=vmowner(hob)
   pdata=d2x(x2d(pb)+8)
   say lower('%'pb 'sa len=00'size 'pData=%'pdata 'sel='sel 'own='hob owns)
   pb=d2x(x2d(pb)+x2d(size))
   return pb pd
end  /* Do */


vmowner: procedure expose vmsysownr.
arg hob
if vmsysownr.ff00<>'UNKNOWN' then do
   vmsysownr.='UNKNOWN'
   vmsysownr.ff2d='lielist'
   vmsysownr.ff2e='demversion'
   vmsysownr.ff2f='vmbmapd'
   vmsysownr.ff30='npipenpn'
   vmsysownr.ff31='npipenp'
   vmsysownr.ff32='reqpkttcb'
   vmsysownr.ff33='reqpkt2'
   vmsysownr.ff34='spldevrmp'
   vmsysownr.ff35='chardevrmp'
   vmsysownr.ff36='syssemrmp'
   vmsysownr.ff37='romdata'
   vmsysownr.ff38='libpath'
   vmsysownr.ff39='jfnflags'
   vmsysownr.ff3a='jfntable'
   vmsysownr.ff3b='ptouvirt'
   vmsysownr.ff3c='tkr3stack'
   vmsysownr.ff3d='tkr2stack'
   vmsysownr.ff3e='tkenv'
   vmsysownr.ff3f='tktib'
   vmsysownr.ff40='reqpkt1'
   vmsysownr.ff41='allocphys'
   vmsysownr.ff42='khbdon'
   vmsysownr.ff43='krhrw1m'
   vmsysownr.ff44='krhro1m'
   vmsysownr.ff45='mmph'
   vmsysownr.ff46='pageio'
   vmsysownr.ff47='fsreclok'
   vmsysownr.ff48='fsd1'
   vmsysownr.ff49='fsd2'
   vmsysownr.ff4a='fsd3'
   vmsysownr.ff4b='fsd4'
   vmsysownr.ff4c='fsd5'
   vmsysownr.ff4d='fsd6'
   vmsysownr.ff4e='fsd7'
   vmsysownr.ff4f='fsd8'
   vmsysownr.ff50='dd1'
   vmsysownr.ff51='dd2'
   vmsysownr.ff52='dd3'
   vmsysownr.ff53='dd4'
   vmsysownr.ff54='dd5'
   vmsysownr.ff55='dd6'
   vmsysownr.ff56='dd7'
   vmsysownr.ff57='dd8'
   vmsysownr.ff58='dd9'
   vmsysownr.ff59='dd10'
   vmsysownr.ff5a='dd11'
   vmsysownr.ff5b='dd12'
   vmsysownr.ff5c='dd13'
   vmsysownr.ff5d='dd14'
   vmsysownr.ff5e='dd15'
   vmsysownr.ff5f='dd16'
   vmsysownr.ff60='fsclmap'
   vmsysownr.ff61='cdsrmp'
   vmsysownr.ff62='tom'
   vmsysownr.ff63='abios'
   vmsysownr.ff64='cache'
   vmsysownr.ff65='dbgdcb'
   vmsysownr.ff66='dbgkdb'
   vmsysownr.ff67='dbgwpcb'
   vmsysownr.ff68='demsft'
   vmsysownr.ff69='demfonto'
   vmsysownr.ff6a='demfont'
   vmsysownr.ff6b='devhlp'
   vmsysownr.ff6c='discard'
   vmsysownr.ff6d='doshlp'
   vmsysownr.ff6e='dyndtgp'
   vmsysownr.ff6f='dyndto'
   vmsysownr.ff70='dyndtot'
   vmsysownr.ff71='dynmtel'
   vmsysownr.ff72='emalloc'
   vmsysownr.ff73='emtss'
   vmsysownr.ff74='device'
   vmsysownr.ff75='infoseg'
   vmsysownr.ff76='initmsg'
   vmsysownr.ff77='init'
   vmsysownr.ff78='intdirq'
   vmsysownr.ff79='intstack'
   vmsysownr.ff7a='iopllist'
   vmsysownr.ff7b='kdbalias'
   vmsysownr.ff7c='kdbsym'
   vmsysownr.ff7d='kmhook'
   vmsysownr.ff7e='ksem'
   vmsysownr.ff7f='lbdd'
   vmsysownr.ff80='lid'
   vmsysownr.ff81='monitor'
   vmsysownr.ff82='mshare'
   vmsysownr.ff83='mshrmp'
   vmsysownr.ff84='nmi'
   vmsysownr.ff85='npx'
   vmsysownr.ff86='orphan'
   vmsysownr.ff87='prof'
   vmsysownr.ff88='ptogdt'
   vmsysownr.ff89='ptovirt'
   vmsysownr.ff8a='puse'
   vmsysownr.ff8b='pusetmp'
   vmsysownr.ff8c='perfview'
   vmsysownr.ff8d='qscache'
   vmsysownr.ff8e='ras'
   vmsysownr.ff8f='resource'
   vmsysownr.ff90='sysserv'
   vmsysownr.ff91='timer'
   vmsysownr.ff92='traphe'
   vmsysownr.ff93='fsbuf'
   vmsysownr.ff94='cdevtmp'
   vmsysownr.ff95='fsc'
   vmsysownr.ff96='dpb'
   vmsysownr.ff97='eatmp'
   vmsysownr.ff98='fatsrch'
   vmsysownr.ff99='gnotify'
   vmsysownr.ff9a='pnotify'
   vmsysownr.ff9b='fsh'
   vmsysownr.ff9c='ifs'
   vmsysownr.ff9d='mfsd'
   vmsysownr.ff9e='mft'
   vmsysownr.ff9f='npipebuf'
   vmsysownr.ffa0='pipe'
   vmsysownr.ffa1='sft'
   vmsysownr.ffa2='vpb'
   vmsysownr.ffa3='ldcache'
   vmsysownr.ffa4='ldrdld'
   vmsysownr.ffa5='invalid'
   vmsysownr.ffa6='ldrmte'
   vmsysownr.ffa7='ldrpath'
   vmsysownr.ffa8='ldrnres'
   vmsysownr.ffa9='prot16'
   vmsysownr.ffaa='os2krnl'
   vmsysownr.ffab='os2ldr'
   vmsysownr.ffac='ripl'
   vmsysownr.ffad='pgalias'
   vmsysownr.ffae='pgbuf'
   vmsysownr.ffaf='pgcrpte'
   vmsysownr.ffb0='dbgalias'
   vmsysownr.ffb1='pgdir'
   vmsysownr.ffb2='pgkstack'
   vmsysownr.ffb3='pgvp'
   vmsysownr.ffb4='pgpf'
   vmsysownr.ffb5='pgprt'
   vmsysownr.ffb6='pgsyspte'
   vmsysownr.ffb7='gdt'
   vmsysownr.ffb8='selheap'
   vmsysownr.ffb9='ldt'
   vmsysownr.ffba='lock'
   vmsysownr.ffbb='selnop'
   vmsysownr.ffbc='seluvirt'
   vmsysownr.ffbd='semmisc'
   vmsysownr.ffbe='semmuxq'
   vmsysownr.ffbf='semopenq'
   vmsysownr.ffc0='semrec'
   vmsysownr.ffc1='semstr'
   vmsysownr.ffc2='semstruc'
   vmsysownr.ffc3='semtable'
   vmsysownr.ffc4='smdfh'
   vmsysownr.ffc5='smsfn'
   vmsysownr.ffc6='smsf'
   vmsysownr.ffc7='tkextlst'
   vmsysownr.ffc8='tkkmreg'
   vmsysownr.ffc9='tklibif'
   vmsysownr.ffca='tklibi'
   vmsysownr.ffcb='ptda'
   vmsysownr.ffcc='tcb'
   vmsysownr.ffcd='tsd'
   vmsysownr.ffce='vddblkh'
   vmsysownr.ffcf='vddblk'
   vmsysownr.ffd0='vddcfstr'
   vmsysownr.ffd1='vddctmp'
   vmsysownr.ffd2='vddep'
   vmsysownr.ffd3='vddheaph'
   vmsysownr.ffd4='vddheap'
   vmsysownr.ffd5='vddhook'
   vmsysownr.ffd6='vddla'
   vmsysownr.ffd7='vddlr'
   vmsysownr.ffd8='vddmod'
   vmsysownr.ffd9='vddopen'
   vmsysownr.ffda='vddpddep'
   vmsysownr.ffdb='vddproc'
   vmsysownr.ffdc='vddstr'
   vmsysownr.ffdd='vdhfhook'
   vmsysownr.ffde='vdhalloc'
   vmsysownr.ffdf='vdhswap'
   vmsysownr.ffe0='vdmalias'
   vmsysownr.ffe1='vmah'
   vmsysownr.ffe2='vmal'
   vmsysownr.ffe3='vmar'
   vmsysownr.ffe4='vmbmap'
   vmsysownr.ffe5='vmco'
   vmsysownr.ffe6='vmdead'
   vmsysownr.ffe7='vmhsh'
   vmsysownr.ffe8='vmkrhb'
   vmsysownr.ffe9='vmkrhf'
   vmsysownr.ffea='vmkrhl'
   vmsysownr.ffeb='vmkrhro'
   vmsysownr.ffec='vmkrhrw'
   vmsysownr.ffed='vmkshd'
   vmsysownr.ffee='vmkshro'
   vmsysownr.ffef='vmkshrw'
   vmsysownr.fff0='vmllock'
   vmsysownr.fff1='vmob'
   vmsysownr.fff2='vmsgs'
   vmsysownr.fff3='vmbmp16'
   vmsysownr.fff4='shrind'
   vmsysownr.fff5='give'
   vmsysownr.fff6='get'
   vmsysownr.fff7='giveget'
   vmsysownr.fff8='preload'
end /* do */
if x2d(hob)>=x2d(ff00) then return vmsysownr.hob
else do
   address df "cmd output .mo" hob
   if output.0>1 then do
      o=output.0-1
      if words(output.o)>1 then owns=substr(output.o,53)
      else owns=word(output.0,2)
   end  /* Do */
   else owns=''
end  /* Do */
return owns

getdwords: procedure
arg address,length
address df "cmd output DD" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DD "address"+"i*4"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor

getwords: procedure
arg address,length
address df "cmd output DW" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DW "address"+"i*2"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor

lower: procedure expose nothing
parse arg str
return translate(str,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')
