/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* format an OS/2 2.1 The Local  InfoSeg from the current PTDA or    */
/* explicitely a supplied linear or selector:offset address.         */
/*                                                                   */
/* Change Log:                                                       */
/* 15/09/93 Version 1 created.                                       */
/* 10/09/96 Version 1.2 updated for Merlin new PMDF                  */
/*                                                                   */

signal on halt name haltexit
trace 'o'
numeric digits 12

arg iseg t
if t='' then t='o'
trace(t)
if iseg='' then do
   address df 'cmd output .p#'
   o=output.0-1
   parse var output.o . . . . . . . . ptda .
 /*  iseg="%"ptda"+205a"*/
   address df 'cmd output s %'ptda 'l700 "TD"'
   o=output.0-1
   if words(output.o)>0 then ,
      iseg = word(output.o,1)"-34"
   else do
      address df 'cmd ouptput ? ptda_infoseg - ptda_start'
      o=output.0-1
      parse var output.o s':'off .
      if off <>'' then iseg="%"ptda"+off"
      else iseg="%"ptda"+56e"
   end  /* Do */
end  /* Do */
say ' '
say 'Formatting Local InfoSeg at' iseg
say ' '
call format "LIS_CurProcID","+00",iseg,"w","Current process ID"
call format "LIS_ParProcID","+02",iseg,"w","Process ID of Parent"
call format "LIS_CurThrdPri","+04",iseg,"w","Current thread priority"
call format "LIS_CurThrdID","+06",iseg,"w","Current thread ID"
call format "LIS_CurScrnGrp","+08",iseg,"w","Screengroup"
call format "LIS_ProcStatus","+0a",iseg,"b","Processor status bits"
if result='00' then say '    In exitlist handler'
else say '    Not in exitlist handler'
call format "LIS_fillbyte1","+0b",iseg,"b","filler byte"
call format "LIS_Fgnd","+0c",iseg,"w","Current process is in foreground"
call format "LIS_ProcType","+0e",iseg,"b","Current process type"
select
   when result='00' then say '    Full screen application'
   when result='01' then say '    Real mode process'
   when result='02' then say '    VIO windowable application'
   when result='03' then say '    Presentation Manager application'
   when result='04' then say '    Detached application'
otherwise say '    Unknown process type'
end
call format "LIS_fillbyte2","+0f",iseg,"b","filler byte"
call format "LIS_AX","+10",iseg,"w","@ Environment selector"
call format "LIS_BX","+12",iseg,"w","@ Offset of command line start"
call format "LIS_CX","+14",iseg,"w","@ Length of Data Segment"
call format "LIS_DX","+14",iseg,"w","@ STACKSIZE from the .EXE file"
call format "LIS_SI","+16",iseg,"w","@ HEAPSIZE from the .EXE file"
call format "LIS_DI","+18",iseg,"w","@ Module handle of the application"
call format "LIS_DS","+1a",iseg,"w","@ Date Segment handle of the application"
call format "LIS_PackSel","+1c",iseg,"w","First tiled selector in this EXE"
call format "LIS_PackShrSel","+1e",iseg,"w","First selector above shared arena"
call format "LIS_PackPckSel","+1e",iseg,"w","First selector above packed arena"
say ' '

haltexit: say '#'

exit 0

format: procedure
parse arg name,offset,base,type,desc,linesz .
value=getstor(base||offset,type)
desc=strip(desc,"B"," ")
name=strip(name,"B"," ")
if desc='' then text=offset name":"
else text=offset name"," desc":"
tl=length(text)
vl=length(value)
if linesz='' then linesz=70
pad=linesz-tl-vl
if pad>0 then text=left(text,pad+tl," ")
say text value
return value

getstor: procedure
arg address,size,format
select
   when size='B' then cmd="DB" address "L1"
   when size='W' then cmd="DW" address "L1"
   when size="D" then cmd="DD" address "L1"
otherwise cmd="DB" address "L1"
end  /* select */
address df "cmd output" cmd
o=output.0-1
if rc<>0 then return 'df error' rc
else do
    parse var output.o . stor .
    select
       when format="C" then return x2c(stor)
       when format="N" then return x2d(stor)
       when format="X" then return stor
    otherwise return stor
    end  /* select */
end

