/* IBM Internal Use Only.                                            */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                      */
/* (C) Copyright IBM Information Solutions 1993                      */
/*                                                                   */
/*rexx*/
/*Author: Dieter Damm                                  Version: 1.0  */
/* format an exception report record                                 */
/*                                                                   */
/* Syntax: ERR <addr>                                                */
/*                                                                   */
/* where:      <addr>     is a valid DF address expression for the   */
/*                        beginning of the report record             */
/*                                                                   */
/* Change Log:                                                       */
/* 17/12/96 Version 1 created.                                       */

trace 'o'
numeric digits 12
signal on halt name term

arg adr

if (adr='?' |,
   adr='/?' |,
   adr=''   |,
   adr=' '  |,
   adr='/h' |,
   adr='/H') then do
   say "Format Exception Report Record"
   say " "
   say 'Syntax: %ERR linaddr'
   say ' '
   exit 0
end  /* Do */

adr=strip(adr,'b')
position=pos('%',adr)
if position=0 then adr = '%'adr

say ' '
say ' ------------ Formatting Exception Report Record ------------------'


address df 'cmd output dd 'adr '+10 l1'
o=output.0-1
paramcnt=x2d(word(output.o,2))

address df 'cmd output dd 'adr '+04 L1'
o=output.0-1
flags=word(output.o,2)
if BITAND(x2c(flags),'00000001'x) = '00000000'x then str=' -> none'
if BITAND(x2c(flags),'00000001'x) = '00000001'x then str=' -> EH_NONCONTINUABLE'
if BITAND(x2c(flags),'00000002'x) = '00000002'x then str=' -> EH_UNWINDING'
if BITAND(x2c(flags),'00000004'x) = '00000004'x then str=' -> EH_EXIT_UNWIND'
if BITAND(x2c(flags),'00000008'x) = '00000008'x then str=' -> EH_STACK_INVALID'
if BITAND(x2c(flags),'00000010'x) = '00000010'x then str=' -> EH_NESTED_CALL'


call format "ExceptionNum","+00",adr,"D", 'Exception Number'
call format "fHandlerFlags ","+04",adr,"D","Exception Attributes"|| str
call format "NestedExceptionReportRecord","+08",adr,"D","Preceding exception's"
call format "ExceptionAddress","+0C",adr,"D","Exception address"
call format "cParameters","+10",adr,"D","Size of exception specific info"
if paramcnt < 5 then do
  do i= 1 to paramcnt
    temp=16+i*4
    tempstr="+"d2x(temp)
    call format "P"i,tempstr,adr,"D","Parameter " || i
  end
end

excpstr=''
P1Str=''
P2Str=''
P3Str=''

excptcode=getstor(adr,'D','X')
p1=getstor(adr'+14','D','X')
p2=getstor(adr'+18','D','X')
p3=getstor(adr'+1c','D','X')

/* Exception values are 32-bit values laid out as follows:               */
/*                                                                       */
/*                                                                       */
/*    3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1                        */
/*    1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0    */
/*    Ŀ  */
/*    SevC       Facility                         Code              */
/*      */
/*                                                                       */
/*    where                                                              */
/*                                                                       */
/*        Sev - is the severity code                                     */
/*            00 - Success                                               */
/*            01 - Informational                                         */
/*            10 - Warning                                               */
/*            11 - Error                                                 */
/*                                                                       */
/*        C - is the Customer code flag                                  */
/*                                                                       */
/*        Facility - is the facility code                                */
/*                                                                       */
/*        Code - is the facility's status code                           */
/*                                                                       */
/*    Exceptions specific to OS/2 2.0 (e.g. XCPT_SIGNAL) will be marked  */
/*    with a facility code of 1.                                         */

bincode=x2b(excptcode)
sev=left(bincode,2)
c=b2x(substr(bincode,3,1))
facility=b2x(substr(bincode,4,13))
code=b2x(right(bincode,16))
if sev='00' then sevstr=sev ' -> Success'
if sev='01' then sevstr=sev ' -> Informational'
if sev='10' then sevstr=sev ' -> Warning'
if sev='11' then sevstr=sev ' -> Error'


if excptcode='80000001' then do
  excptstr= 'XCPT_GUARD_PAGE_VIOLATION '
  if p1= '00000001' then P1Str='P1 Access Code: XCPT_READ_ACCESS '
  if p1= '00000002' then P1Str='P1 Access Code: XCPT_WRITE_ACCESS '
  P2Str='P2 FaultAddr  : %'p2
end
if excptcode='80010001' then excptstr= 'XCPT_UNABLE_TO_GROW_STACK '
if excptcode='c0010001' then excptstr='XCPT_PROCESS_TERMINATE'
if excptcode='c0010002' then do
  excptstr='XCPT_ASYNC_PROCESS_TERMINATE '
  P1Str='P1 TID of terminator thread :'p1
end
if excptcode='c0010003' then do
  excptstr='XCPT_SIGNAL '
  if x2d(P1)=1 then P1Str='P1 Signal Number: XCPT_SIGNAL_INTR '
  if x2d(P1)=3 then P1Str='P1 Signal Number: XCPT_SIGNAL_KILLPROC '
  if x2d(P1)=4 then P1Str='P1 Signal Number:  XCPT_SIGNAL_BREAK'
end
if excptcode='c0010004' then excptstr='XCPT_B1NPX_ERRATA_02'
if excptcode='c0000005' then do
  excptstr='XCPT_ACCESS_VIOLATION'
  if P1='00000000' then P1Str='P1 Access Code: XCPT_UNKNOWN_ACCESS '
  if P1='00000001' then do
    P1Str='P1 Access Code: XCPT_READ_ACCESS '
    P2Str='P2 FaultAddr  :%'P2
  end
  if P1='00000002' then do
     P1Str='P1 Access Code: XCPT_WRITE_ACCESS '
     P2Str='P2 FaultAddr  :%'P2
  end
  if P1='00000004' then P1Str='P1 Access Code: XCPT_EXECUTE_ACCESS '
  if P1='00000008' then do
    P1Str='P1 Access Code: XCPT_SPACE_ACCESS '
    P2Str='P2 Selector   : 'right(P2,4)
  end
  if P1='00000010' then P1Str='P1 Access Code: XCPT_LIMIT_ACCESS '
end
if excptcode='c0000006' then excptstr='XCPT_IN_PAGE_ERROR -> Trap000E'
if excptcode='c000001c' then excptstr='XCPT_ILLEGAL_INSTRUCTION -> Trap0006'
if excptcode='c000001d' then excptstr='XCPT_INVALID_LOCK_SEQUENCE'
if excptcode='c0000024' then excptstr='XCPT_NONCONTINUABLE_EXCEPTION'
if excptcode='c0000025' then excptstr='XCPT_INVALID_DISPOSITION'
if excptcode='c0000026' then excptstr='XCPT_UNWIND'
if excptcode='c0000027' then excptstr='XCPT_BAD_STACK'
if excptcode='c0000028' then excptstr='XCPT_INVALID_UNWIND_TARGET'
if excptcode='c0000093' then excptstr='XCPT_ARRAY_BOUNDS_EXCEEDED -> Trap0005'
if excptcode='c0000094' then excptstr='XCPT_FLOAT_DENORMAL_OPERAND -> Trap0010'
if excptcode='c0000095' then excptstr='XCPT_FLOAT_DIVIDE_BY_ZERO -> Trap0010'
if excptcode='c0000096' then excptstr='XCPT_FLOAT_INEXACT_RESULT -> Trap0010'
if excptcode='c0000097' then excptstr='XCPT_FLOAT_INVALID_OPERATION -> Trap0010'
if excptcode='c0000098' then excptstr='XCPT_FLOAT_OVERFLOW -> Trap0010'
if excptcode='c0000099' then excptstr='XCPT_FLOAT_STACK_CHECK -> Trap0010'
if excptcode='c000009a' then excptstr='XCPT_FLOAT_UNDERFLOW -> Trap0010'
if excptcode='c000009b' then excptstr='XCPT_INTEGER_DIVIDE_BY_ZERO -> Trap0000'
if excptcode='c000009c' then excptstr='XCPT_INTEGER_OVERFLOW -> Trap0004'
if excptcode='c000009d' then excptstr='XCPT_PRIVILEGED_INSTRUCTION -> Trap000D'
if excptcode='c000009e' then do
   excptstr='XCPT_DATATYPE_MISALIGNMENT -> Trap0011'
   if P1='00000001' then P1Str='P1 Access Code: XCPT_READ_ACCESS '
   if P1='00000002' then P1Str='P1 Access Code: XCPT_WRITE_ACCESS '
   P2Str='P2 Alignment  : 'P2
   P3Str='P3 FaultAddr  : %'P3
end
if excptcode='c000009f' then excptstr='XCPT_BREAKPOINT -> Trap0003'
if excptcode='c00000a0' then excptstr='XCPT_SINGLE_STEP ->Trap0001'

say
say 'Exception type: 'excptstr
say 'Excpt severity: 'sevstr
say 'Customer flag : 'c
say 'Facility code : 'facility
say 'Exception code: 'code
say P1Str
say P2Str
say P3Str

return



/*.im getstor*/
/*.ifdef gblgetstor*/
/*.endif*/
/*.se gblgetstor=1*/
getstor: procedure
arg address,size,format
select
   when size='B' then cmd="DB" address "L1"
   when size='W' then cmd="DW" address "L1"
   when size="D" then cmd="DD" address "L1"

otherwise cmd="DB" address "L1"
end  /* select */
address df "cmd output" cmd
if rc<>0 then return 'df error' rc
else do
    if substr(output.3,1,1)='#' then do
       parse var output.2 . stor .
       select
          when format="C" then return x2c(stor)
          when format="N" then return x2d(stor)
          when format="X" then return stor
       otherwise return stor
       end  /* select */
    end  /* Do */
    else return output.3
end


format: procedure
parse arg name,offset,base,type,desc

value=getstor(base||offset,type)
desc=strip(desc,"B"," ")
name=strip(name,"B"," ")
if length(name) > 20 then name=substr(name,1,20)
if length(name) < 20 then name=left(name,20,' ')
text=offset ' | '  name" | "
tl=length(text)
vl=length(value)
pad=40-tl-vl
if pad>0 then text=left(text,pad+tl," ")
say text value ' | ' desc
return value


term:
exit 0
end

