/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* Obtain the system version from storage                            */
/* Change Log:                                                       */
/* 28/10/96 Version 1 created.                                       */
/*                                                                   */

signal on halt name haltexit
trace 'o'
numeric digits 12

dver=sysver()
parse var dver major minor rev kver krnl
say 'System version' major'.'minor'.'rev
if krnl='KNLR' then ktype='Retail'
else if krnl='KNLD' then ktype='ALLSTRICT'
else if krnl='KNLB' then ktype='HSTRICT'
else if kver<>'' then ktype=''
else ktype=''
say ktype 'Kernel Internal Revision' kver

haltexit:

exit 0


sysver: procedure

segoff=getwords("#70:14",1)
iseg=getwords("#70:"segoff,1)
iseg="#"iseg":15"

address df 'cmd output db' iseg 'l10'
o=output.0-1
parse var output.o . major minor revision .
major=x2d(major)
minor=x2d(minor)
revision=x2d(revision)
if x2d(minor)>=40 then do
   address df 'cmd output db #b0:0 l0c'
   o=output.0-1
   parse var output.o . . . . . . . . .'-'h1 h2 h3 h4 . krnl .
   krnl=left(krnl,4)
   hdr=h4||h3':'h2||h1
   address df 'cmd output da #'hdr
   o=output.0-1
   parse var output.o . . krev',' .
end /* do */
else do
   krev=''
   krnl=''
end /* do */

return major minor revision krev krnl
getwords: procedure
arg address,length
address df "cmd output DW" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DW "address"+"i*2"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor

