/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* Format a the Regs saved by dynamic trace after a trap 3            */

signal on halt name haltexit

arg sf .

if sf='' then address df 'cmd output dd (dw(10:8)):(dw(10:4))-(14*4) l14'
else address df 'cmd output dd' sf 'l14'

o=output.0-5
parse var output.o . d0 d1 d2 d3 .
gs=right(d0,4)
fs=right(d1,4)
es=right(d2,4)
edi=d3
o=o+1
parse var output.o . d0 d1 d2 d3 .
esi=d0
ebp=d1
r0esp=d2
ebx=d3
o=o+1
parse var output.o . d0 d1 d2 d3 .
edx=d0
ecx=d1
eax=d2
ds=right(d3,4)
o=o+1
parse var output.o . d0 d1 d2 d3 .
t3ret=d0
trap=d1
errcd=d2
eip=d3
o=o+1
parse var output.o . d0 d1 d2 d3 .
cs=right(d0,4)
eflags=d1
esp=d2
ss=right(d3,4)
say 'Registers at time of tracepoint'
say 'eax='eax 'ebx='ebx 'ecx='ecx 'edx='edx 'esi='esi 'edi='edi
say 'eip='eip 'esp='esp 'ebp='ebp fmtflags(eflags)
say 'cs='cs 'ss='ss 'ds='ds 'es='es 'fs='fs 'gs='gs
address df 'cmd output u' cs':'eip 'l1'
o=output.0-1
say output.o


haltexit: exit 0

fmtflags: procedure
parse arg flags

fl=''
if length(flags)=8 then do
   eflgs=x2c(left(flags,4))
   flags=right(flags,4)
   if bitand(eflgs,'0000'x)='0001'x then fl=fl 'rf'
   else fl=fl '--'
   if bitand(eflgs,'0002'x)='0002'x then fl=fl 'vm'
   else fl=fl '--'
   if bitand(eflgs,'0004'x)='0004'x then fl=fl 'ac'
   else fl=fl '--'
end /* do */
flags=x2c(flags)
if bitand(flags,'4000'x)='4000'x then fl=fl 'nt'
else fl=fl '--'
if bitand(flags,'0800'x)='0800'x then fl=fl 'ov'
else fl=fl 'nv'
if bitand(flags,'0400'x)='0400'x then fl=fl 'dn'
else fl=fl 'up'
if bitand(flags,'0200'x)='0200'x then fl=fl 'ei'
else fl=fl 'di'
if bitand(flags,'0080'x)='0080'x then fl=fl 'ng'
else fl=fl 'pl'
if bitand(flags,'0040'x)='0040'x then fl=fl 'zr'
else fl=fl 'nz'
if bitand(flags,'0010'x)='0010'x then fl=fl 'ac'
else fl=fl 'na'
if bitand(flags,'0004'x)='0004'x then fl=fl 'pe'
else fl=fl 'po'
if bitand(flags,'0001'x)='0001'x then fl=fl 'cy'
else fl=fl 'nc'
iopl='iopl='left(c2x(bitand(flags,'3000'x)),1)
fl=iopl||fl
return fl
