/*rexx                                                               */
/*.im secunc*/
/*                                                                   */
/*.im coibm*/
/* (C) Copyright IBM Corp. 1993                                      */
/* (C) Copyright IBM Information Solutions 1993                      */
/*                                                                   */
/*Author: Richard Moore / Dieter Damm                  Version: 1.0  */
/*                                                                   */
/* shows several settings from CONFIG.SYS                            */
/* 1 required parameter: adr (sel:offs)                              */
/*                                                                   */
/* 10/01/97                                                          */
/*                                                                   */


trace 'o'
numeric digits 12

address df 'cmd output ln header'
o=output.0-1
tempstr=right(word(output.o,1),4)
if tempstr='  No' then do
  say ' OS2KRNL symbols not loaded!'
  say ' '
  exit
end


say
say
say
say '****************** Global Info **************************'
say
segoff=getstor("#70:14","W")
   iseg=getstor("#70:"segoff,"W")
/* say(x2c(gethxstr('header',40))) */
say('Version Number: ' || getstor('#'iseg':15','B','N') || '.' || getstor('#'iseg':16','B','N') || '.' || getstor('#'iseg':17','B','N'))
say('DATE : ' || getstor('#'iseg':10','B','N') || ':' || getstor('#'iseg':11','B','N')|| ':' || getstor('#'iseg':12','W','N'))

say('TIME : ' || getstor('#'iseg':08','B','N') || ':' || getstor('#'iseg':09','B','N')|| ':' || getstor('#'iseg':0a','B','N'))
ram = getstor('_pgphysmax','D','N') * 4096
say 'Installed RAM : ' || ram
say
say '***************** RAS CONFIG Info ***********************'

reiplon=getstor('REIPL_ON',B,X)
sysdata=getstor(SisData,B,X)
ProtOnly=getstor('ProtOnlySystem',B,X)
DiskIO=getstor('FSPrtyIO_Mode',B,X)
MaxThreads=getstor('MaxThreads','W','N')
dump_on =getstor('Dump_On','B','X')
DumpDevice=getstor('DumpDevice','B','C')
vmProtectedMem=getstor('_VMProtectedMem','B','X')
vmPackedMem=getstor('_VMPackedMem','B','X')
SMCommit=getstor('_SMCommit','B','X')
SmSwapping=getstor('_SMSwapping','B','X')
Priority=getstor('DynTimeSlice','B','X')
SwpMinFree=getstor('_SMCFGMinFree','D','N')
SwpSize=getstor('_SMCFGSwapSize','D','N')
VME=getstor('_GlobalVME','B','X')
AutoFail=getstor('GlobalAutoFail','B','X')
DumpProcess=getstor('_DumpProcess','B','C')
Popups=getstor('_SuppressPopUps','B','C')
umb=getstor('_UMB_ON','B','X')
dumpon_Str=''
commitstr=''
protectmemstr=''
packedmemstr=''
commitstr=''
swapstr=''
priorstr=''
vmestr=''
autofailstr=''
if reiplon=0 then Reipl_Str='OFF'
if reiplon=1 then Reipl_str='ON'
if ProtOnly=0 then Prot_Str='NO'
if ProtOnly=1 then Prot_Str='YES'
if DiskIO=0 then IOPL_Str='NO'
if DiskIO=1 then IOPL_Str='YES'
if dump_on=0 then dumpon_str='OFF'
if dump_on=1 then dumpon_str='ON'
if dump_on=2 then dumpon_str='R0'
if vmProtectedMem=0 then ProtMemStr='NOPROTECT'
if vmProtectedMem=1 then ProtMemStr='PROTECT'
if vmPackedMem=0 then PackedMemStr='NOPACK'
if vmPackedMem=1 then PackedMemStr='PACK'
if smCommit=0 then CommitStr='NOCOMMIT'
if smCommit=1 then CommitStr='COMMIT'
if SmSwapping=0 then SwapStr='NOSWAP'
if SmSwapping=1 then SwapStr='SWAP'
if priority=0 then PriorStr='ABSOLUTE'
if priority=1 then PriorStr='DYNAMIC'
if VME=0 then VMEStr='NO'
if VME=1 then VMEStr='YES'
if AutoFail=0 then autofailstr='NO'
if Autofail=1 then autofailstr='YES'

say
say 'Dump device = ' || dumpdevice
say 'TRAPDUMP    = ' || dumpon_str || ',' || dumpdevice
if dumpprocess > '0' then say 'DUMPPROCESS = ' || dumpprocess
if popups > '0' then say 'SUPPRESSPOPUPS = ' || popups
say 'REIPL       = '|| Reipl_str
say 'VME         = ' || VMEStr
say 'AUTOFAIL    = ' || autofailstr
say
say'********** CONFIG  Memory Management *****************'
say
say 'PROTECTONLY = '|| Prot_Str
say 'THREADS     = ' || maxThreads
say 'MEMMAN      = ' || swapstr || ', ' || CommitStr || ', ' || ProtmemStr || ', ' || PackedMemStr
say 'PRIORITY    = ' || PriorStr
say ('MAXWAIT    = ' || getstor('#'iseg':1f','B','N'))
say ('TIMESLICE  = ' || getstor('#'iseg':20','W','N')|| ',' || getstor('#'iseg':22','W','N'))
say
say '*********** SWAP FILE *******************************'
say
say 'Initial Swap File size = '|| swpSize
say 'Minimum free size for Swapper = ' || SwpMinFree
swp = getstor('_smswapspace','D','N')* 4096
say 'Swap File Size : ' || swp
say
say '************** Others *******************************'
say
say 'PRIORITY_DISK_IO = ' || IOPL_Str

exit 0

/*.im gethxstr*/
/*.ifdef gblgethxstr*/
/*.endif*/
/*.se gblgethxstr=1*/
gethxstr: procedure
arg address,length
address df "cmd output DB" address "L1"
if substr(output.3,1,1)='#' then parse var output.2 . stor .
else return ''

do i=1 to length-1
   address df "cmd output DB "address"+"i"t L1"
   if substr(output.3,1,1)='#' then return ''
   else stor=stor || word(output.2,2)
end /* do */
return stor

/*.im format*/
/*.ifdef gblformat*/
/*.endif*/
/*.se gblformat=1*/
format: procedure
parse arg name,offset,base,type,desc
value=getstor(base||offset,type)
desc=strip(desc,"B"," ")
name=strip(name,"B"," ")
if desc='' then text=offset name":"
else text=offset name"," desc":"
tl=length(text)
vl=length(value)
pad=80-tl-vl
if pad>0 then text=left(text,pad+tl," ")
say text value
return value

/*.im getstor*/
/*.ifdef gblgetstor*/
/*.endif*/
/*.se gblgetstor=1*/
getstor: procedure
arg address,size,format
select
   when size='B' then cmd="DB" address "L1"
   when size='W' then cmd="DW" address "L1"
   when size="D" then cmd="DD" address "L1"
otherwise cmd="DB" address "L1"
end  /* select */
address df "cmd output" cmd
if rc<>0 then return 'df error' rc
else do
    if substr(output.3,1,1)='#' then do
       parse var output.2 . stor .
       select
          when format="C" then return x2c(stor)
          when format="N" then return x2d(stor)
          when format="X" then return stor
       otherwise return stor
       end  /* select */
    end  /* Do */
    else return output.3
end

/*.im fmtblock*/
/*.ifdef gblfmtblock*/
/*.endif*/
/*.se gblfmtblock=1*/
fmtblock: procedure
parse arg name,offset,base,type,number,desc
desc=strip(desc,"B"," ")
name=strip(name,"B"," ")
if desc='' then text=offset name"..."
else text=offset name"," desc"..."
say text
parse upper var type type
select
   when type='D' then sz=4
   when type='W' then sz=2
otherwise
sz=1
end  /* select */
perline=16/sz
fulllns=number%perline
lastln=number//perline
i=0
sgn=left(offset,1)
if sgn="+" then sgn=1
else sgn=-1
blkoff=substr(offset,2)
no=length(blkoff)
dblkoff=sgn*(x2d(blkoff))
if fulllns>0 then do i=0 to fulllns-1
   doff=i*16
   dboff=doff+dblkoff
   off=d2x(doff)
   if dboff<0 then boff="-"right(d2x(abs(dboff)),no,0)
   else boff="+"right(d2x(abs(dboff)),no,0)
   offsay=boff" +"right(off,3,0)
   if type='D' then say offsay getdwords(base||offset"+"off,perline)
   else if type='W' then say offsay getwords(base||offset"+"off,perline)
   else say offsay getbytes(base||offset"+"off,perline)
end  /* Do */
if lastln=0 then do
   doff=i*16
   dboff=doff+dblkoff
   off=d2x(doff)
   if dboff<0 then boff="-"right(d2x(abs(dboff)),no,0)
   else boff="+"right(d2x(abs(dboff)),no,0)
   offsay=boff" +"right(off,3,0)
   if type='D' then say offsay getdwords(base||offset"+"off,lastln)
   else if type='W' then say offsay getwords(base||offset"+"off,lastln)
   else say offsay getbytes(base||offset"+"off,lastln)
end  /* Do */
return

/*.im getdwrds*/
/*.ifdef gblgetdwrds*/
/*.endif*/
/*.se gblgetdwrds=1*/
getdwords: procedure
arg address,length
address df "cmd output DD" address "L1"
if substr(output.3,1,1)='#' then parse var output.2 . stor .
else return ''

do i=1 to length-1
   address df "cmd output DD "address"+"i*4"t L1"
   if substr(output.3,1,1)='#' then return ''
   else stor=stor word(output.2,2)
end /* do */
return stor

/*.im getwords*/
/*.ifdef gblgetwords*/
/*.endif*/
/*.se gblgetwords=1*/
getwords: procedure
arg address,length
address df "cmd output DW" address "L1"
if substr(output.3,1,1)='#' then parse var output.2 . stor .
else return ''

do i=1 to length-1
   address df "cmd output DW "address"+"i*2"t L1"
   if substr(output.3,1,1)='#' then return ''
   else stor=stor word(output.2,2)
end /* do */
return stor

/*.im getbytes*/
/*.ifdef gblgetbytes*/
/*.endif*/
/*.se gblgetbytes=1*/
getbytes: procedure
arg address,length
address df "cmd output DB" address "L1"
if substr(output.3,1,1)='#' then parse var output.2 . stor .
else return ''

do i=1 to length-1
   address df "cmd output DB "address"+"i"t L1"
   if substr(output.3,1,1)='#' then return ''
   else stor=stor word(output.2,2)
end /* do */
return stor

/*.im getstor*/
/*.ifdef gblgetstor*/
/*.exit*/

/*.im getbytes*/
/*.ifdef gblgetbytes*/
/*.exit*/

/*.im getwords*/
/*.ifdef gblgetwords*/
/*.exit*/

/*.im getdwrds*/
/*.ifdef gblgetdwrds*/
/*.exit*/

/*.im getqwrds*/
/*.ifdef gblgetqwrds*/
/*.endif*/
/*.se gblgetqwrds=1*/
getqwords: procedure
arg address,length
address df "cmd output DD" address "L2"
if substr(output.3,1,1)='#' then parse var output.2 . stor2 stor1 .
stor = stor1||stor2
else return ''

do i=1 to length-1
   address df "cmd output DD "address"+"i*8"t L2"
   if substr(output.3,1,1)='#' then return ''
   else stor=stor word(output.2,3) || word(output.2,2)
end /* do */
return stor
linaddr: procedure
arg addr
address df 'cmd output dd' addr
parse var output.2 addr  .
if left(addr,1)="%" then nop /* we're done */
else do
   parse var addr seg ':' off
   if datatype(seg,'X') then do
      say 'Unable to convert address'
      return ''
   end  /* Do */
   if bitand(x2c(seg),'0004'x)='0004'x then,
      address df 'cmd output dl' seg
   else address df 'cmd output dg' seg
   parse var output.2 . 'Bas=' addr .
   if datatype(addr,'X') then do
      say 'Unable to convert address'
      return ''
   end  /* Do */
   addrd=x2d(addr)
   offd=x2d(off)
   addrd=addrd+offd
   addr=d2x(addrd)
end  /* Do */
return addr

/*.im linaddr*/
/*.ifdef gbllinaddr*/
/*.endif*/
/*.se gbllinaddr=1*/
linaddr: procedure
arg addr
address df 'cmd output dd' addr
parse var output.2 addr  .
if left(addr,1)="%" then nop /* we're done */
else do
   parse var addr seg ':' off
   if datatype(seg,'X') then do
      say 'Unable to convert address'
      return ''
   end  /* Do */
   if bitand(x2c(seg),'0004'x)='0004'x then,
      address df 'cmd output dl' seg
   else address df 'cmd output dg' seg
   parse var output.2 . 'Bas=' addr .
   if datatype(addr,'X') then do
      say 'Unable to convert address'
      return ''
   end  /* Do */
   addrd=x2d(addr)
   offd=x2d(off)
   addrd=addrd+offd
   addr=d2x(addrd)
end  /* Do */
return addr


