/*.im seciuo*/
/* IBM Internal Use Only.                                            */
/*.im coibm*/
/* (C) Copyright IBM Corp. 1993                                      */
/* (C) Copyright IBM Information Solutions 1993                      */
/*                                                                   */
/*rexx*/
/*Author: Richard Moore  / Dieter Damm               Version: 1.0    */
/* format system buffers                                             */
/*                                                                   */
/* 10/01/74                                                          */
/*                                                                   */

trace 'o'
numeric digits 12


say ' '
address df 'cmd output ln gdt_buffers'
o=output.0-1
buffsel=right(word(output.o,1),4)
if buffsel='  No' then do
  say ' OS2KRNL symbols not loaded!'
  say ' '
  exit
end

address df 'cmd output dl 'buffsel
o=output.0-1
linaddr=right(word(output.o,3),8)
linaddr= '%'linaddr
say '--------- BUFSEG -----------'
say 'Buffer segment : ' buffsel':0000'
say 'linear address : ' linaddr
say ' '
call format "bs_MRUHead","+00",linaddr,"W", 'Head of MRU buffer list'
call format "bs_MRUTail ","+02",linaddr,"W","Tail of MRU buffer list"
call format "bs_FreeHead","+04",linaddr,"W","Head of free buffer list"
call format "bs_handle","+06",linaddr,"W","Handle of virtual memory manager"
call format "bs_nBuffers","+08",linaddr,"W","Number of buffers in segment"
call format "bs_buffsize","+0a",linaddr,"W","Size of buffer + header"
call format "bs_seglimit","+0c",linaddr,"W","Limit for entire buffer segment"
call format "bs_pStats","+0e",linaddr,"W","offset of statistic block"
call format "bs_offRemMed","+10",linaddr,"W","Min. legal offset of buffer for removable media"
call format "bs_MaxSec","+12",linaddr,"W","max. sector size for block device drivers"
call format "bs_BigBufBase","+14",linaddr,"W","Base of big buffers pool"
call format "bs_BigBufMap","+16",linaddr,"W","Big buffers usage bit map"
call format "bs_physBufSeg","+18",linaddr,"D","Buffer segment physical address "
say ' '
say '------- BUFFINFO --------'
say ' next  prev  free  hVPB  sector    wrtcnt  wrtcntinc tid   refcnt flags '
address df 'cmd output dw 'linaddr ' L2'
o=output.0-1
next=word(output.o,2)

do while next <> 'ffff'
   next = getstor(linaddr'+'next,'W','1')
   prev = getstor(linaddr'+'next'+02','W','1')
   free = getstor(linaddr'+'next'+04','W','1')
   vpb  = getstor(linaddr'+'next'+06','W','1')
   sector = getstor(linaddr'+'next'+08','D','1')
   wrtcnt = getstor(linaddr'+'next'+0c','B','1')
   wrtcntinc = getstor(linaddr'+'next'+0d','W','1')
   flags = getstor(linaddr'+'next'+0f','B','1')
   tid = getstor(linaddr'+'next'+10','W','1')
   refcnt = getstor(linaddr'+'next'+12','W','1')
   flagstr=' -> '
   if BITAND(flags,'01')='01' then flagstr=flagstr || ' BUF_ATTEMPTING_READ'
   if BITAND(flags,'02')='02' then flagstr=flagstr || ' BUF_ISFAT'
   if BITAND(flags,'04')='04' then flagstr=flagstr || ' BUF_ISDIR'
   if BITAND(flags,'08')='08' then flagstr=flagstr || ' BUF_ISDATA'
   if BITAND(flags,'10')='10' then flagstr=flagstr || ' BUF_BUSY'
   if BITAND(flags,'20')='20' then flagstr=flagstr || ' BUF_WANT'
   if BITAND(flags,'40')='40' then flagstr=flagstr || ' BUF_VISIT'
   if BITAND(flags,'80')='80' then flagstr=flagstr || ' BUF_DIRTY'

   say next || '   ' || prev ' ' || free || ' ' vpb || ' ' sector || ' ' wrtcnt || '     ' wrtcntinc || '      'tid || ' ' refcnt || '  ' flags || flagstr


END

return

/*.im getstor*/
/*.ifdef gblgetstor*/
/*.endif*/
/*.se gblgetstor=1*/
getstor: procedure
arg address,size,format
select
   when size='B' then cmd="DB" address "L1"
   when size='W' then cmd="DW" address "L1"
   when size="D" then cmd="DD" address "L1"

otherwise cmd="DB" address "L1"
end  /* select */
address df "cmd output" cmd
if rc<>0 then return 'df error' rc
else do
    if substr(output.3,1,1)='#' then do
       parse var output.2 . stor .
       select
          when format="C" then return x2c(stor)
          when format="N" then return x2d(stor)
          when format="X" then return stor
       otherwise return stor
       end  /* select */
    end  /* Do */
    else return output.3
end


format: procedure
parse arg name,offset,base,type,desc

value=getstor(base||offset,type)
desc=strip(desc,"B"," ")
name=strip(name,"B"," ")
if length(name) > 20 then name=substr(name,1,20)
if length(name) < 20 then name=left(name,20,' ')
text=offset ' | '  name" | "
tl=length(text)
vl=length(value)
pad=40-tl-vl
if pad>0 then text=left(text,pad+tl," ")
say text value ' | ' desc
return value


