/*.im seciuo*/
/* IBM Internal Use Only.                                            */
/*.im coibm*/
/* (C) Copyright IBM Corp. 1993                                      */
/* (C) Copyright IBM Information Solutions 1993                      */
/*                                                                   */
/*rexx*/
/*Author: Richard Moore  / Dieter Damm               Version: 1.0    */
/*                                                                   */
/* format anonymous pipe                                             */
/* 1 required parameter: adr (sel:offs)                              */
/*                                                                   */
/* 10/01/97 if user types ?, spit out help                           */
/*                                                                   */

trace 'o'
numeric digits 12

arg adr

if (adr='?' |,
   adr='/?' |,
   adr=''   |,
   adr=' '  |,
   adr='/h' |,
   adr='/H') then do
   say "Format Anonymous Pipe data structure (PIPE)"
   say " "
   say 'Syntax: %AP sel:offs '
   say ' '
   exit 0
end  /* Do */

position=pos(':',adr)
if pos=0 then do
  say' Invalid sel:ofs given'
  exit 0
end

sel=substr(adr,1,position-1)
ofs=right(adr,length(adr)-position)
address df 'cmd output dl 'sel
o=output.0-1
linaddr=substr(word(output.o,3),5,8)
linaddr=x2d(linaddr)+x2d(ofs)
linaddr='%'d2x(linaddr)


  

say ' '
say ' --------- Formatting Anonymous Pipe IOBLOCK at ' adr ' ----------------'
say ' '

call format "io_in_progcnt","+00",linaddr,"B", 'count of read/writes in progress'
call format "io_refcnt ","+01",linaddr,"B","count of references "
call format "io_rdrcnt","+02",linaddr,"B","count of readers"
call format "io_wrtcnt","+03",linaddr,"B","count of writers "
call format "io_selector ","+04",linaddr,"W","selector of buffer"
call format "io_first","+06",linaddr,"W","ptr to base of circular buffer"
call format "io_in ","+08",linaddr,"W","ptr to next free byte "
call format "io_out","+0a",linaddr,"W","ptr to next byte of data "
call format "io_last","+0c",linaddr,"W","ptr to end+1 of buffer "
call format "io_rdlksem","+0e",linaddr,"W","read lock semaphore"
call format "io_wtlksem","+10",linaddr,"W","write lock semaphore"
call format "io_rdsem","+12",linaddr,"W","read sync semaphore "
call format "io_wtsem","+14",linaddr,"W","write sync semaphore"
exit



/*.im getstor*/
/*.ifdef gblgetstor*/
/*.endif*/
/*.se gblgetstor=1*/
getstor: procedure
arg address,size,format
select
   when size='B' then cmd="DB" address "L1"
   when size='W' then cmd="DW" address "L1"
   when size="D" then cmd="DD" address "L1"

otherwise cmd="DB" address "L1"
end  /* select */
address df "cmd output" cmd
if rc<>0 then return 'df error' rc
else do
    if substr(output.3,1,1)='#' then do
       parse var output.2 . stor .
       select
          when format="C" then return x2c(stor)
          when format="N" then return x2d(stor)
          when format="X" then return stor
       otherwise return stor
       end  /* select */
    end  /* Do */
    else return output.3
end


format: procedure
parse arg name,offset,base,type,desc

value=getstor(base||offset,type)
desc=strip(desc,"B"," ")
name=strip(name,"B"," ")
if length(name) > 20 then name=substr(name,1,20)
if length(name) < 20 then name=left(name,20,' ')
text=offset ' | '  name" | "
tl=length(text)
vl=length(value)
pad=40-tl-vl
if pad>0 then text=left(text,pad+tl," ")
say text value ' | ' desc
return value




