package CustomAdvisors;

import com.ibm.internet.nd.advisors.*;
import java.io.*;
import java.util.*;

/**
 * Sample Network Dispatcher Custom Advisor for use with
 * IBM WebSphere Application Server V3.5 and 4.0. It has not been
 * tested with any WAS version higher than 4.0, and will not work
 * with WAS 3.0 and earlier.
 *
 * This class defines a sample custom advisor for IBM Network Dispatcher
 * to be used in conjunction with a sample servlet for IBM WebSphere
 * Application Server.  The servlet code to be implemented as part of
 * this sample is provided as a separate source file called NDAdvisor.java
 *
 * You should modify the list of static strings below to match your
 * environment. SERVLET_LOCATION and HTTP_GOOD are the two that usually
 * require editing (i.e. perhaps 200 OK instead of 200 ok).
 *
 * Consult the documentation for the two products, as well as the basic
 * Dispatcher custom advisor sample for details on how to implement this
 * sample.
 */
public class ADV_was extends ADV_Base implements ADV_MethodInterface {
  static final String ADV_WAS_NAME     = "was";
  static final int    ADV_WAS_PORT     = 80;
  static final int    ADV_INTERVAL     = 7;
  static final String ADV_VERSION      = "2.0";
  static final String HTTP_GOOD        = "HTTP/1.1 200 ok";
  static final String HTTP_ERROR       = "Error 404";
  static final String SERVLET_KEYWORD  = "NDAdvisor/0.92";
  static final String SERVLET_LOCATION = "/servlet/NDAdvisor";

/**
 * Constructor
 */
  public ADV_was() {
        super(ADV_WAS_NAME, ADV_VERSION, ADV_WAS_PORT, ADV_INTERVAL, "", true);
        setAdvisor(this);
  }
/**
 * We don't need to do anything here....
 */
  public void ADV_AdvisorInitialize() {
        return;
  }

/**
 * We have a packet with what we believe is the servlet response so we
 * will parse the packet and try to find that WAS status string
 */
 public int ADV_findStatus(String inline) {
    int rc = ADV_HOST_INACCESSIBLE;

    try {
       BufferedReader reader = new BufferedReader(new StringReader(inline));
       String line = reader.readLine();
       while (null != line) {
          if (-1 < line.indexOf(SERVLET_KEYWORD)) {
             ADVLOG(3, "String content holds string " + SERVLET_KEYWORD + "\n");
             StringTokenizer st = null;
             try {
                st = new StringTokenizer(line, "/ ");
             } catch (NullPointerException e) {
                ADVLOG(1, "ERROR: Java could not create StringTokenizer," +
                          " skipping server");
             }
             if (null != st && st.countTokens() >= 3) {
                st.nextToken(); // throw away the 'NDAdvisor' string
                String version = st.nextToken();
                String status  = st.nextToken();
                ADVLOG(3, "Version = " + version);
                ADVLOG(3, "WAS status = " + status);
                try {
                   rc = Integer.parseInt(status);
                } catch (NumberFormatException ignore) {
                   ADVLOG(1, "ERROR: Status was not integer from WAS\n");
                }
             } // at least 3 tokens
             line = null;
          } // if found NDAdvisor on this line
          // keep reading through the packet lines
          else {
             line = reader.readLine();
          }
       } // search through packet for response
    } catch (IOException ignore) {
       ADVLOG(1, "ERROR: IOException in ADV_findStatus()\n");
    }

    return rc;
 }  // ADV_findStatus()

/**
 * asks WAS servlet for status, return to Network Dispatcher
 */
public int getLoad(int connectTime, ADV_Thread caller) {
   int rc = 0;
   int returnValue = ADV_HOST_INACCESSIBLE;
   String getString = "GET " + SERVLET_LOCATION + " HTTP/1.0\r\n" +
          "Connection: Keep-Alive\r\n" +
          "User-Agent: IBM_Network_Dispatcher_WAS_Advisor\r\n" +
          "Pragma: no-cache\r\n" +
          "Host: " + caller.getCurrentCluster() + "\r\n" +
          "Accept: */*\r\n" +
          "Accept-Encoding: gzip\r\n" +
          "Accept-Language: en\r\n" +
          "Accept-Charset: iso-8859-1,*,utf-8\r\n\r\n";

   rc = caller.send(getString);
   if (0 < rc) { // successfully sent, now get the results
      StringBuffer returnedData = new StringBuffer("");
      rc = caller.receive(returnedData);
      // Look for the error string or the good string
      if (0 < rc && returnedData != null) {
         String line = returnedData.toString();
         if (-1 < line.indexOf(HTTP_ERROR)) {
            ADVLOG(3, "Packet indicates error: " + HTTP_ERROR + "\n");
         } else if (-1 < line.indexOf(HTTP_GOOD)) {

            // We're looking for HTTP/1.1 200 ok in this first packet. If
            // this is here then we should be getting a servlet response
            // That response will either be in this packet or could be in a
            // second TCP packet from the server depending on timing, etc
            ADVLOG(3, "Packet indicates good response\n");
            ADVLOG(4, "Packet was : \n" + line);
            if (-1 == line.indexOf(SERVLET_KEYWORD)) {
               rc = caller.receive(returnedData);
               if (0 < rc && returnedData != null) {
                  line = returnedData.toString();
                  if (-1 == line.indexOf(SERVLET_KEYWORD)) {
                     // Servlet keywords not found in second packet
                     ADVLOG(3, "ERROR: Packet did not contain servlet response\n" +
                               "Packet #2 was :\n" + line);
                     line = null;
                  }
               }
            } // need to check a second packet
            if (null != line) {
               returnValue = ADV_findStatus(line);
            }
         } // if first packet indicates HTTP 200 message
         else {
            ADVLOG(3, "Packet was not HTTP 404 or 200, it was :\n" + line);
         }
      } // if received a packet
   } // endif caller.send

   return returnValue;

} // getLoad()

} // class definitions
